# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev3
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from pydantic import Field, StrictBool, StrictStr, conint, constr, validator

from typing import List, Optional

from synctera_client.models.customer_in_body import CustomerInBody
from synctera_client.models.customer_list import CustomerList
from synctera_client.models.employment import Employment
from synctera_client.models.employment_list import EmploymentList
from synctera_client.models.patch_customer import PatchCustomer
from synctera_client.models.prefill_request import PrefillRequest
from synctera_client.models.risk_rating import RiskRating
from synctera_client.models.risk_rating_list import RiskRatingList

from synctera_client.api_client import ApiClient
from synctera_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class CustomersApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def create_customer(self, customer_in_body : Annotated[CustomerInBody, Field(..., description="Customer to create")], idempotency_key : Annotated[Optional[StrictStr], Field(description="An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.")] = None, **kwargs) -> CustomerInBody:  # noqa: E501
        """Create a Customer  # noqa: E501

        The customer object represents your customer's identity. You can then verify the identity of this customer and associate them with other people and accounts. Note that if no shipping_address attribute is provided in the request, the shipping_address will be set to a copy of the legal_address.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_customer(customer_in_body, idempotency_key, async_req=True)
        >>> result = thread.get()

        :param customer_in_body: Customer to create (required)
        :type customer_in_body: CustomerInBody
        :param idempotency_key: An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.
        :type idempotency_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CustomerInBody
        """
        kwargs['_return_http_data_only'] = True
        return self.create_customer_with_http_info(customer_in_body, idempotency_key, **kwargs)  # noqa: E501

    @validate_arguments
    def create_customer_with_http_info(self, customer_in_body : Annotated[CustomerInBody, Field(..., description="Customer to create")], idempotency_key : Annotated[Optional[StrictStr], Field(description="An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.")] = None, **kwargs):  # noqa: E501
        """Create a Customer  # noqa: E501

        The customer object represents your customer's identity. You can then verify the identity of this customer and associate them with other people and accounts. Note that if no shipping_address attribute is provided in the request, the shipping_address will be set to a copy of the legal_address.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_customer_with_http_info(customer_in_body, idempotency_key, async_req=True)
        >>> result = thread.get()

        :param customer_in_body: Customer to create (required)
        :type customer_in_body: CustomerInBody
        :param idempotency_key: An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.
        :type idempotency_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CustomerInBody, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'customer_in_body',
            'idempotency_key'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_customer" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['idempotency_key']:
            _header_params['Idempotency-Key'] = _params['idempotency_key']

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['customer_in_body']:
            _body_params = _params['customer_in_body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '201': "CustomerInBody",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '409': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/customers', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def create_customer_employment(self, customer_id : Annotated[StrictStr, Field(..., description="The customer's unique identifier")], employment : Annotated[Employment, Field(..., description="Customer employment record to create.")], idempotency_key : Annotated[Optional[StrictStr], Field(description="An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.")] = None, **kwargs) -> Employment:  # noqa: E501
        """Create employment record  # noqa: E501

        Create a customer employment record.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_customer_employment(customer_id, employment, idempotency_key, async_req=True)
        >>> result = thread.get()

        :param customer_id: The customer's unique identifier (required)
        :type customer_id: str
        :param employment: Customer employment record to create. (required)
        :type employment: Employment
        :param idempotency_key: An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.
        :type idempotency_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Employment
        """
        kwargs['_return_http_data_only'] = True
        return self.create_customer_employment_with_http_info(customer_id, employment, idempotency_key, **kwargs)  # noqa: E501

    @validate_arguments
    def create_customer_employment_with_http_info(self, customer_id : Annotated[StrictStr, Field(..., description="The customer's unique identifier")], employment : Annotated[Employment, Field(..., description="Customer employment record to create.")], idempotency_key : Annotated[Optional[StrictStr], Field(description="An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.")] = None, **kwargs):  # noqa: E501
        """Create employment record  # noqa: E501

        Create a customer employment record.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_customer_employment_with_http_info(customer_id, employment, idempotency_key, async_req=True)
        >>> result = thread.get()

        :param customer_id: The customer's unique identifier (required)
        :type customer_id: str
        :param employment: Customer employment record to create. (required)
        :type employment: Employment
        :param idempotency_key: An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.
        :type idempotency_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Employment, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'customer_id',
            'employment',
            'idempotency_key'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_customer_employment" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['customer_id']:
            _path_params['customer_id'] = _params['customer_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['idempotency_key']:
            _header_params['Idempotency-Key'] = _params['idempotency_key']

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['employment']:
            _body_params = _params['employment']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '201': "Employment",
            '400': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/customers/{customer_id}/employment', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def create_customer_risk_rating(self, customer_id : Annotated[StrictStr, Field(..., description="The customer's unique identifier")], idempotency_key : Annotated[Optional[StrictStr], Field(description="An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.")] = None, risk_rating : Annotated[Optional[RiskRating], Field(description="Create a customer risk rating. With a risk rating in request body, Synctera validates the data and saves it. With no request body, Synctera runs an automated risk analysis and saves the result. ")] = None, **kwargs) -> RiskRating:  # noqa: E501
        """Create customer risk rating  # noqa: E501

        Create customer risk rating  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_customer_risk_rating(customer_id, idempotency_key, risk_rating, async_req=True)
        >>> result = thread.get()

        :param customer_id: The customer's unique identifier (required)
        :type customer_id: str
        :param idempotency_key: An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.
        :type idempotency_key: str
        :param risk_rating: Create a customer risk rating. With a risk rating in request body, Synctera validates the data and saves it. With no request body, Synctera runs an automated risk analysis and saves the result. 
        :type risk_rating: RiskRating
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: RiskRating
        """
        kwargs['_return_http_data_only'] = True
        return self.create_customer_risk_rating_with_http_info(customer_id, idempotency_key, risk_rating, **kwargs)  # noqa: E501

    @validate_arguments
    def create_customer_risk_rating_with_http_info(self, customer_id : Annotated[StrictStr, Field(..., description="The customer's unique identifier")], idempotency_key : Annotated[Optional[StrictStr], Field(description="An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.")] = None, risk_rating : Annotated[Optional[RiskRating], Field(description="Create a customer risk rating. With a risk rating in request body, Synctera validates the data and saves it. With no request body, Synctera runs an automated risk analysis and saves the result. ")] = None, **kwargs):  # noqa: E501
        """Create customer risk rating  # noqa: E501

        Create customer risk rating  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_customer_risk_rating_with_http_info(customer_id, idempotency_key, risk_rating, async_req=True)
        >>> result = thread.get()

        :param customer_id: The customer's unique identifier (required)
        :type customer_id: str
        :param idempotency_key: An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.
        :type idempotency_key: str
        :param risk_rating: Create a customer risk rating. With a risk rating in request body, Synctera validates the data and saves it. With no request body, Synctera runs an automated risk analysis and saves the result. 
        :type risk_rating: RiskRating
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(RiskRating, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'customer_id',
            'idempotency_key',
            'risk_rating'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_customer_risk_rating" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['customer_id']:
            _path_params['customer_id'] = _params['customer_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['idempotency_key']:
            _header_params['Idempotency-Key'] = _params['idempotency_key']

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['risk_rating']:
            _body_params = _params['risk_rating']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '201': "RiskRating",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '404': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/customers/{customer_id}/risk_ratings', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_all_customer_employment(self, customer_id : Annotated[StrictStr, Field(..., description="The customer's unique identifier")], include_history : Annotated[Optional[StrictBool], Field(description="If true, include old (inactive) records as well.")] = None, **kwargs) -> EmploymentList:  # noqa: E501
        """List customer employment records  # noqa: E501

        Get a list of customer's current employment records. To see historic employment pass the `include_history` flag.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_customer_employment(customer_id, include_history, async_req=True)
        >>> result = thread.get()

        :param customer_id: The customer's unique identifier (required)
        :type customer_id: str
        :param include_history: If true, include old (inactive) records as well.
        :type include_history: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: EmploymentList
        """
        kwargs['_return_http_data_only'] = True
        return self.get_all_customer_employment_with_http_info(customer_id, include_history, **kwargs)  # noqa: E501

    @validate_arguments
    def get_all_customer_employment_with_http_info(self, customer_id : Annotated[StrictStr, Field(..., description="The customer's unique identifier")], include_history : Annotated[Optional[StrictBool], Field(description="If true, include old (inactive) records as well.")] = None, **kwargs):  # noqa: E501
        """List customer employment records  # noqa: E501

        Get a list of customer's current employment records. To see historic employment pass the `include_history` flag.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_customer_employment_with_http_info(customer_id, include_history, async_req=True)
        >>> result = thread.get()

        :param customer_id: The customer's unique identifier (required)
        :type customer_id: str
        :param include_history: If true, include old (inactive) records as well.
        :type include_history: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(EmploymentList, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'customer_id',
            'include_history'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_customer_employment" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['customer_id']:
            _path_params['customer_id'] = _params['customer_id']

        # process the query parameters
        _query_params = []
        if _params.get('include_history') is not None:  # noqa: E501
            _query_params.append(('include_history', _params['include_history']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "EmploymentList",
            '400': "Error",
            '404': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/customers/{customer_id}/employment', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_all_customer_risk_ratings(self, customer_id : Annotated[StrictStr, Field(..., description="The customer's unique identifier")], include_history : Annotated[Optional[StrictBool], Field(description="If true, include old (inactive) records as well.")] = None, **kwargs) -> RiskRatingList:  # noqa: E501
        """List customer risk ratings  # noqa: E501

        Get list of customer risk ratings  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_customer_risk_ratings(customer_id, include_history, async_req=True)
        >>> result = thread.get()

        :param customer_id: The customer's unique identifier (required)
        :type customer_id: str
        :param include_history: If true, include old (inactive) records as well.
        :type include_history: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: RiskRatingList
        """
        kwargs['_return_http_data_only'] = True
        return self.get_all_customer_risk_ratings_with_http_info(customer_id, include_history, **kwargs)  # noqa: E501

    @validate_arguments
    def get_all_customer_risk_ratings_with_http_info(self, customer_id : Annotated[StrictStr, Field(..., description="The customer's unique identifier")], include_history : Annotated[Optional[StrictBool], Field(description="If true, include old (inactive) records as well.")] = None, **kwargs):  # noqa: E501
        """List customer risk ratings  # noqa: E501

        Get list of customer risk ratings  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_customer_risk_ratings_with_http_info(customer_id, include_history, async_req=True)
        >>> result = thread.get()

        :param customer_id: The customer's unique identifier (required)
        :type customer_id: str
        :param include_history: If true, include old (inactive) records as well.
        :type include_history: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(RiskRatingList, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'customer_id',
            'include_history'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_customer_risk_ratings" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['customer_id']:
            _path_params['customer_id'] = _params['customer_id']

        # process the query parameters
        _query_params = []
        if _params.get('include_history') is not None:  # noqa: E501
            _query_params.append(('include_history', _params['include_history']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "RiskRatingList",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '404': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/customers/{customer_id}/risk_ratings', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_customer(self, customer_id : Annotated[StrictStr, Field(..., description="The customer's unique identifier")], **kwargs) -> CustomerInBody:  # noqa: E501
        """Get Customer  # noqa: E501

        Get Customer based on ID  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_customer(customer_id, async_req=True)
        >>> result = thread.get()

        :param customer_id: The customer's unique identifier (required)
        :type customer_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CustomerInBody
        """
        kwargs['_return_http_data_only'] = True
        return self.get_customer_with_http_info(customer_id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_customer_with_http_info(self, customer_id : Annotated[StrictStr, Field(..., description="The customer's unique identifier")], **kwargs):  # noqa: E501
        """Get Customer  # noqa: E501

        Get Customer based on ID  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_customer_with_http_info(customer_id, async_req=True)
        >>> result = thread.get()

        :param customer_id: The customer's unique identifier (required)
        :type customer_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CustomerInBody, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'customer_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_customer" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['customer_id']:
            _path_params['customer_id'] = _params['customer_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "CustomerInBody",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '404': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/customers/{customer_id}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_customer_risk_rating(self, customer_id : Annotated[StrictStr, Field(..., description="The customer's unique identifier")], risk_rating_id : Annotated[StrictStr, Field(..., description="Risk Rating ID")], **kwargs) -> RiskRating:  # noqa: E501
        """Get customer risk rating  # noqa: E501

        Get a customer risk rating  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_customer_risk_rating(customer_id, risk_rating_id, async_req=True)
        >>> result = thread.get()

        :param customer_id: The customer's unique identifier (required)
        :type customer_id: str
        :param risk_rating_id: Risk Rating ID (required)
        :type risk_rating_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: RiskRating
        """
        kwargs['_return_http_data_only'] = True
        return self.get_customer_risk_rating_with_http_info(customer_id, risk_rating_id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_customer_risk_rating_with_http_info(self, customer_id : Annotated[StrictStr, Field(..., description="The customer's unique identifier")], risk_rating_id : Annotated[StrictStr, Field(..., description="Risk Rating ID")], **kwargs):  # noqa: E501
        """Get customer risk rating  # noqa: E501

        Get a customer risk rating  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_customer_risk_rating_with_http_info(customer_id, risk_rating_id, async_req=True)
        >>> result = thread.get()

        :param customer_id: The customer's unique identifier (required)
        :type customer_id: str
        :param risk_rating_id: Risk Rating ID (required)
        :type risk_rating_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(RiskRating, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'customer_id',
            'risk_rating_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_customer_risk_rating" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['customer_id']:
            _path_params['customer_id'] = _params['customer_id']
        if _params['risk_rating_id']:
            _path_params['risk_rating_id'] = _params['risk_rating_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "RiskRating",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '404': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/customers/{customer_id}/risk_ratings/{risk_rating_id}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_party_employment(self, customer_id : Annotated[StrictStr, Field(..., description="The customer's unique identifier")], employment_id : Annotated[StrictStr, Field(..., description="Unique ID for the employment record.")], **kwargs) -> Employment:  # noqa: E501
        """Get customer employment record  # noqa: E501

        Get a single record of customer employment  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_party_employment(customer_id, employment_id, async_req=True)
        >>> result = thread.get()

        :param customer_id: The customer's unique identifier (required)
        :type customer_id: str
        :param employment_id: Unique ID for the employment record. (required)
        :type employment_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Employment
        """
        kwargs['_return_http_data_only'] = True
        return self.get_party_employment_with_http_info(customer_id, employment_id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_party_employment_with_http_info(self, customer_id : Annotated[StrictStr, Field(..., description="The customer's unique identifier")], employment_id : Annotated[StrictStr, Field(..., description="Unique ID for the employment record.")], **kwargs):  # noqa: E501
        """Get customer employment record  # noqa: E501

        Get a single record of customer employment  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_party_employment_with_http_info(customer_id, employment_id, async_req=True)
        >>> result = thread.get()

        :param customer_id: The customer's unique identifier (required)
        :type customer_id: str
        :param employment_id: Unique ID for the employment record. (required)
        :type employment_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Employment, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'customer_id',
            'employment_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_party_employment" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['customer_id']:
            _path_params['customer_id'] = _params['customer_id']
        if _params['employment_id']:
            _path_params['employment_id'] = _params['employment_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "Employment",
            '400': "Error",
            '404': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/customers/{customer_id}/employment/{employment_id}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_customers(self, id : Annotated[Optional[List[StrictStr]], Field(description="Unique resource identifier")] = None, first_name : Optional[StrictStr] = None, last_name : Optional[StrictStr] = None, phone_number : Optional[StrictStr] = None, email : Optional[StrictStr] = None, ssn_last_4 : Optional[constr(strict=True, max_length=4, min_length=4)] = None, status : Optional[StrictStr] = None, limit : Optional[conint(strict=True, ge=1)] = None, page_token : Optional[StrictStr] = None, sort_by : Annotated[Optional[List[StrictStr]], Field(description="Specifies the sort order for the returned customers. ")] = None, **kwargs) -> CustomerList:  # noqa: E501
        """List Customers  # noqa: E501

        Retrieves paginated list of Customers associated with the authorized requester  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_customers(id, first_name, last_name, phone_number, email, ssn_last_4, status, limit, page_token, sort_by, async_req=True)
        >>> result = thread.get()

        :param id: Unique resource identifier
        :type id: List[str]
        :param first_name:
        :type first_name: str
        :param last_name:
        :type last_name: str
        :param phone_number:
        :type phone_number: str
        :param email:
        :type email: str
        :param ssn_last_4:
        :type ssn_last_4: str
        :param status:
        :type status: str
        :param limit:
        :type limit: int
        :param page_token:
        :type page_token: str
        :param sort_by: Specifies the sort order for the returned customers. 
        :type sort_by: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CustomerList
        """
        kwargs['_return_http_data_only'] = True
        return self.list_customers_with_http_info(id, first_name, last_name, phone_number, email, ssn_last_4, status, limit, page_token, sort_by, **kwargs)  # noqa: E501

    @validate_arguments
    def list_customers_with_http_info(self, id : Annotated[Optional[List[StrictStr]], Field(description="Unique resource identifier")] = None, first_name : Optional[StrictStr] = None, last_name : Optional[StrictStr] = None, phone_number : Optional[StrictStr] = None, email : Optional[StrictStr] = None, ssn_last_4 : Optional[constr(strict=True, max_length=4, min_length=4)] = None, status : Optional[StrictStr] = None, limit : Optional[conint(strict=True, ge=1)] = None, page_token : Optional[StrictStr] = None, sort_by : Annotated[Optional[List[StrictStr]], Field(description="Specifies the sort order for the returned customers. ")] = None, **kwargs):  # noqa: E501
        """List Customers  # noqa: E501

        Retrieves paginated list of Customers associated with the authorized requester  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_customers_with_http_info(id, first_name, last_name, phone_number, email, ssn_last_4, status, limit, page_token, sort_by, async_req=True)
        >>> result = thread.get()

        :param id: Unique resource identifier
        :type id: List[str]
        :param first_name:
        :type first_name: str
        :param last_name:
        :type last_name: str
        :param phone_number:
        :type phone_number: str
        :param email:
        :type email: str
        :param ssn_last_4:
        :type ssn_last_4: str
        :param status:
        :type status: str
        :param limit:
        :type limit: int
        :param page_token:
        :type page_token: str
        :param sort_by: Specifies the sort order for the returned customers. 
        :type sort_by: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CustomerList, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id',
            'first_name',
            'last_name',
            'phone_number',
            'email',
            'ssn_last_4',
            'status',
            'limit',
            'page_token',
            'sort_by'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_customers" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('id') is not None:  # noqa: E501
            _query_params.append(('id', _params['id']))
            _collection_formats['id'] = 'csv'
        if _params.get('first_name') is not None:  # noqa: E501
            _query_params.append(('first_name', _params['first_name']))
        if _params.get('last_name') is not None:  # noqa: E501
            _query_params.append(('last_name', _params['last_name']))
        if _params.get('phone_number') is not None:  # noqa: E501
            _query_params.append(('phone_number', _params['phone_number']))
        if _params.get('email') is not None:  # noqa: E501
            _query_params.append(('email', _params['email']))
        if _params.get('ssn_last_4') is not None:  # noqa: E501
            _query_params.append(('ssn_last_4', _params['ssn_last_4']))
        if _params.get('status') is not None:  # noqa: E501
            _query_params.append(('status', _params['status']))
        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))
        if _params.get('page_token') is not None:  # noqa: E501
            _query_params.append(('page_token', _params['page_token']))
        if _params.get('sort_by') is not None:  # noqa: E501
            _query_params.append(('sort_by', _params['sort_by']))
            _collection_formats['sort_by'] = 'csv'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "CustomerList",
            '401': "Error",
            '403': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/customers', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def patch_customer(self, customer_id : Annotated[StrictStr, Field(..., description="The customer's unique identifier")], patch_customer : Annotated[PatchCustomer, Field(..., description="Customer to be patched")], idempotency_key : Annotated[Optional[StrictStr], Field(description="An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.")] = None, **kwargs) -> CustomerInBody:  # noqa: E501
        """Patch Customer  # noqa: E501

        Patch fields of customer based on ID Note that if:   * legal address is provided in the request, AND   * shipping_address is not provided in the request, AND   * the customer resource does not have shipping_address   then shipping_address will be set to a copy of the legal_address.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.patch_customer(customer_id, patch_customer, idempotency_key, async_req=True)
        >>> result = thread.get()

        :param customer_id: The customer's unique identifier (required)
        :type customer_id: str
        :param patch_customer: Customer to be patched (required)
        :type patch_customer: PatchCustomer
        :param idempotency_key: An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.
        :type idempotency_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CustomerInBody
        """
        kwargs['_return_http_data_only'] = True
        return self.patch_customer_with_http_info(customer_id, patch_customer, idempotency_key, **kwargs)  # noqa: E501

    @validate_arguments
    def patch_customer_with_http_info(self, customer_id : Annotated[StrictStr, Field(..., description="The customer's unique identifier")], patch_customer : Annotated[PatchCustomer, Field(..., description="Customer to be patched")], idempotency_key : Annotated[Optional[StrictStr], Field(description="An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.")] = None, **kwargs):  # noqa: E501
        """Patch Customer  # noqa: E501

        Patch fields of customer based on ID Note that if:   * legal address is provided in the request, AND   * shipping_address is not provided in the request, AND   * the customer resource does not have shipping_address   then shipping_address will be set to a copy of the legal_address.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.patch_customer_with_http_info(customer_id, patch_customer, idempotency_key, async_req=True)
        >>> result = thread.get()

        :param customer_id: The customer's unique identifier (required)
        :type customer_id: str
        :param patch_customer: Customer to be patched (required)
        :type patch_customer: PatchCustomer
        :param idempotency_key: An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.
        :type idempotency_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CustomerInBody, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'customer_id',
            'patch_customer',
            'idempotency_key'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_customer" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['customer_id']:
            _path_params['customer_id'] = _params['customer_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['idempotency_key']:
            _header_params['Idempotency-Key'] = _params['idempotency_key']

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['patch_customer']:
            _body_params = _params['patch_customer']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "CustomerInBody",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '404': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/customers/{customer_id}', 'PATCH',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def prefill_customer(self, customer_id : Annotated[StrictStr, Field(..., description="The customer's unique identifier")], prefill_request : PrefillRequest, idempotency_key : Annotated[Optional[StrictStr], Field(description="An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.")] = None, **kwargs) -> PrefillRequest:  # noqa: E501
        """Prefill customer  # noqa: E501

        Prefill takes a subset of a person's information and automatically fills personally identifiable information (PII) required for know your customer (KYC) verification.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.prefill_customer(customer_id, prefill_request, idempotency_key, async_req=True)
        >>> result = thread.get()

        :param customer_id: The customer's unique identifier (required)
        :type customer_id: str
        :param prefill_request: (required)
        :type prefill_request: PrefillRequest
        :param idempotency_key: An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.
        :type idempotency_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PrefillRequest
        """
        kwargs['_return_http_data_only'] = True
        return self.prefill_customer_with_http_info(customer_id, prefill_request, idempotency_key, **kwargs)  # noqa: E501

    @validate_arguments
    def prefill_customer_with_http_info(self, customer_id : Annotated[StrictStr, Field(..., description="The customer's unique identifier")], prefill_request : PrefillRequest, idempotency_key : Annotated[Optional[StrictStr], Field(description="An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.")] = None, **kwargs):  # noqa: E501
        """Prefill customer  # noqa: E501

        Prefill takes a subset of a person's information and automatically fills personally identifiable information (PII) required for know your customer (KYC) verification.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.prefill_customer_with_http_info(customer_id, prefill_request, idempotency_key, async_req=True)
        >>> result = thread.get()

        :param customer_id: The customer's unique identifier (required)
        :type customer_id: str
        :param prefill_request: (required)
        :type prefill_request: PrefillRequest
        :param idempotency_key: An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.
        :type idempotency_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PrefillRequest, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'customer_id',
            'prefill_request',
            'idempotency_key'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method prefill_customer" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['customer_id']:
            _path_params['customer_id'] = _params['customer_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['idempotency_key']:
            _header_params['Idempotency-Key'] = _params['idempotency_key']

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['prefill_request']:
            _body_params = _params['prefill_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "PrefillRequest",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/customers/{customer_id}/prefill', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def update_customer(self, customer_id : Annotated[StrictStr, Field(..., description="The customer's unique identifier")], customer_in_body : Annotated[CustomerInBody, Field(..., description="Customer to be updated")], **kwargs) -> CustomerInBody:  # noqa: E501
        """Update Customer  # noqa: E501

        Update customer based on ID Note that if no shipping_address attribute is provided in the request, the shipping_address will be set to a copy of the legal_address.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_customer(customer_id, customer_in_body, async_req=True)
        >>> result = thread.get()

        :param customer_id: The customer's unique identifier (required)
        :type customer_id: str
        :param customer_in_body: Customer to be updated (required)
        :type customer_in_body: CustomerInBody
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CustomerInBody
        """
        kwargs['_return_http_data_only'] = True
        return self.update_customer_with_http_info(customer_id, customer_in_body, **kwargs)  # noqa: E501

    @validate_arguments
    def update_customer_with_http_info(self, customer_id : Annotated[StrictStr, Field(..., description="The customer's unique identifier")], customer_in_body : Annotated[CustomerInBody, Field(..., description="Customer to be updated")], **kwargs):  # noqa: E501
        """Update Customer  # noqa: E501

        Update customer based on ID Note that if no shipping_address attribute is provided in the request, the shipping_address will be set to a copy of the legal_address.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_customer_with_http_info(customer_id, customer_in_body, async_req=True)
        >>> result = thread.get()

        :param customer_id: The customer's unique identifier (required)
        :type customer_id: str
        :param customer_in_body: Customer to be updated (required)
        :type customer_in_body: CustomerInBody
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CustomerInBody, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'customer_id',
            'customer_in_body'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_customer" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['customer_id']:
            _path_params['customer_id'] = _params['customer_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['customer_in_body']:
            _body_params = _params['customer_in_body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "CustomerInBody",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '404': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/customers/{customer_id}', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def update_party_employment(self, customer_id : Annotated[StrictStr, Field(..., description="The customer's unique identifier")], employment_id : Annotated[StrictStr, Field(..., description="Unique ID for the employment record.")], employment : Annotated[Employment, Field(..., description="Customer employment to update.")], **kwargs) -> Employment:  # noqa: E501
        """Update customer employment record  # noqa: E501

        Update a single record of customer employment.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_party_employment(customer_id, employment_id, employment, async_req=True)
        >>> result = thread.get()

        :param customer_id: The customer's unique identifier (required)
        :type customer_id: str
        :param employment_id: Unique ID for the employment record. (required)
        :type employment_id: str
        :param employment: Customer employment to update. (required)
        :type employment: Employment
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Employment
        """
        kwargs['_return_http_data_only'] = True
        return self.update_party_employment_with_http_info(customer_id, employment_id, employment, **kwargs)  # noqa: E501

    @validate_arguments
    def update_party_employment_with_http_info(self, customer_id : Annotated[StrictStr, Field(..., description="The customer's unique identifier")], employment_id : Annotated[StrictStr, Field(..., description="Unique ID for the employment record.")], employment : Annotated[Employment, Field(..., description="Customer employment to update.")], **kwargs):  # noqa: E501
        """Update customer employment record  # noqa: E501

        Update a single record of customer employment.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_party_employment_with_http_info(customer_id, employment_id, employment, async_req=True)
        >>> result = thread.get()

        :param customer_id: The customer's unique identifier (required)
        :type customer_id: str
        :param employment_id: Unique ID for the employment record. (required)
        :type employment_id: str
        :param employment: Customer employment to update. (required)
        :type employment: Employment
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Employment, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'customer_id',
            'employment_id',
            'employment'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_party_employment" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['customer_id']:
            _path_params['customer_id'] = _params['customer_id']
        if _params['employment_id']:
            _path_params['employment_id'] = _params['employment_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['employment']:
            _body_params = _params['employment']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "Employment",
            '400': "Error",
            '404': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/customers/{customer_id}/employment/{employment_id}', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
