# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev3
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from datetime import date

from pydantic import Field, StrictStr, conint, constr, validator

from typing import List, Optional

from synctera_client.models.card_activation_request import CardActivationRequest
from synctera_client.models.card_brand import CardBrand
from synctera_client.models.card_changes_list import CardChangesList
from synctera_client.models.card_edit_request import CardEditRequest
from synctera_client.models.card_image_details import CardImageDetails
from synctera_client.models.card_image_details_list import CardImageDetailsList
from synctera_client.models.card_issuance_request import CardIssuanceRequest
from synctera_client.models.card_list_response import CardListResponse
from synctera_client.models.card_product_list_response import CardProductListResponse
from synctera_client.models.card_response import CardResponse
from synctera_client.models.card_status import CardStatus
from synctera_client.models.card_widget_url_response import CardWidgetUrlResponse
from synctera_client.models.client_token import ClientToken
from synctera_client.models.create_card_image_request import CreateCardImageRequest
from synctera_client.models.create_gateway_request import CreateGatewayRequest
from synctera_client.models.form import Form
from synctera_client.models.gateway_list_response import GatewayListResponse
from synctera_client.models.gateway_response import GatewayResponse
from synctera_client.models.get_card_barcode200_response import GetCardBarcode200Response
from synctera_client.models.single_use_token_request import SingleUseTokenRequest
from synctera_client.models.single_use_token_response import SingleUseTokenResponse
from synctera_client.models.update_card_image_request import UpdateCardImageRequest
from synctera_client.models.update_gateway_request import UpdateGatewayRequest
from synctera_client.models.widget_type import WidgetType

from synctera_client.api_client import ApiClient
from synctera_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class CardsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def activate_card(self, card_activation_request : Annotated[CardActivationRequest, Field(..., description="Card activation code")], **kwargs) -> CardResponse:  # noqa: E501
        """Activate a card  # noqa: E501

        Activate a card   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.activate_card(card_activation_request, async_req=True)
        >>> result = thread.get()

        :param card_activation_request: Card activation code (required)
        :type card_activation_request: CardActivationRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CardResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.activate_card_with_http_info(card_activation_request, **kwargs)  # noqa: E501

    @validate_arguments
    def activate_card_with_http_info(self, card_activation_request : Annotated[CardActivationRequest, Field(..., description="Card activation code")], **kwargs):  # noqa: E501
        """Activate a card  # noqa: E501

        Activate a card   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.activate_card_with_http_info(card_activation_request, async_req=True)
        >>> result = thread.get()

        :param card_activation_request: Card activation code (required)
        :type card_activation_request: CardActivationRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CardResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'card_activation_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method activate_card" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['card_activation_request']:
            _body_params = _params['card_activation_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "CardResponse",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '422': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/cards/activate', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def create_card_image(self, create_card_image_request : Annotated[CreateCardImageRequest, Field(..., description="Details of the image to create")], **kwargs) -> CardImageDetails:  # noqa: E501
        """Create Card Image  # noqa: E501

        Create a card image entity. Note that this does not include the image data itself. You can upload the image data via a subsequent uploadCardImageData request using the ID created here.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_card_image(create_card_image_request, async_req=True)
        >>> result = thread.get()

        :param create_card_image_request: Details of the image to create (required)
        :type create_card_image_request: CreateCardImageRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CardImageDetails
        """
        kwargs['_return_http_data_only'] = True
        return self.create_card_image_with_http_info(create_card_image_request, **kwargs)  # noqa: E501

    @validate_arguments
    def create_card_image_with_http_info(self, create_card_image_request : Annotated[CreateCardImageRequest, Field(..., description="Details of the image to create")], **kwargs):  # noqa: E501
        """Create Card Image  # noqa: E501

        Create a card image entity. Note that this does not include the image data itself. You can upload the image data via a subsequent uploadCardImageData request using the ID created here.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_card_image_with_http_info(create_card_image_request, async_req=True)
        >>> result = thread.get()

        :param create_card_image_request: Details of the image to create (required)
        :type create_card_image_request: CreateCardImageRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CardImageDetails, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'create_card_image_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_card_image" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['create_card_image_request']:
            _body_params = _params['create_card_image_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '201': "CardImageDetails",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '422': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/cards/images', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def create_gateway(self, create_gateway_request : Annotated[CreateGatewayRequest, Field(..., description="Create a new Authorization Gateway Configuration")], **kwargs) -> GatewayResponse:  # noqa: E501
        """Create Gateway  # noqa: E501

        Create a new Authorization Gateway Configuration   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_gateway(create_gateway_request, async_req=True)
        >>> result = thread.get()

        :param create_gateway_request: Create a new Authorization Gateway Configuration (required)
        :type create_gateway_request: CreateGatewayRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GatewayResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.create_gateway_with_http_info(create_gateway_request, **kwargs)  # noqa: E501

    @validate_arguments
    def create_gateway_with_http_info(self, create_gateway_request : Annotated[CreateGatewayRequest, Field(..., description="Create a new Authorization Gateway Configuration")], **kwargs):  # noqa: E501
        """Create Gateway  # noqa: E501

        Create a new Authorization Gateway Configuration   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_gateway_with_http_info(create_gateway_request, async_req=True)
        >>> result = thread.get()

        :param create_gateway_request: Create a new Authorization Gateway Configuration (required)
        :type create_gateway_request: CreateGatewayRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GatewayResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'create_gateway_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_gateway" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['create_gateway_request']:
            _body_params = _params['create_gateway_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '201': "GatewayResponse",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '422': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/cards/gateways', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_card(self, card_id : StrictStr, **kwargs) -> CardResponse:  # noqa: E501
        """Get Card  # noqa: E501

        Get the details about a card that has been issued   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_card(card_id, async_req=True)
        >>> result = thread.get()

        :param card_id: (required)
        :type card_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CardResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.get_card_with_http_info(card_id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_card_with_http_info(self, card_id : StrictStr, **kwargs):  # noqa: E501
        """Get Card  # noqa: E501

        Get the details about a card that has been issued   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_card_with_http_info(card_id, async_req=True)
        >>> result = thread.get()

        :param card_id: (required)
        :type card_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CardResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'card_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_card" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['card_id']:
            _path_params['card_id'] = _params['card_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "CardResponse",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '422': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/cards/{card_id}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_card_barcode(self, card_id : StrictStr, **kwargs) -> GetCardBarcode200Response:  # noqa: E501
        """Get Card Barcode  # noqa: E501

        This endpoint is for testing environment only to provide access to barcode of a test card   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_card_barcode(card_id, async_req=True)
        >>> result = thread.get()

        :param card_id: (required)
        :type card_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetCardBarcode200Response
        """
        kwargs['_return_http_data_only'] = True
        return self.get_card_barcode_with_http_info(card_id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_card_barcode_with_http_info(self, card_id : StrictStr, **kwargs):  # noqa: E501
        """Get Card Barcode  # noqa: E501

        This endpoint is for testing environment only to provide access to barcode of a test card   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_card_barcode_with_http_info(card_id, async_req=True)
        >>> result = thread.get()

        :param card_id: (required)
        :type card_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetCardBarcode200Response, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'card_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_card_barcode" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['card_id']:
            _path_params['card_id'] = _params['card_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "GetCardBarcode200Response",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '422': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/cards/{card_id}/barcodes', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_card_image_data(self, card_image_id : StrictStr, **kwargs) -> str:  # noqa: E501
        """Get Card Image Data  # noqa: E501

        Get card image data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_card_image_data(card_image_id, async_req=True)
        >>> result = thread.get()

        :param card_image_id: (required)
        :type card_image_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        return self.get_card_image_data_with_http_info(card_image_id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_card_image_data_with_http_info(self, card_image_id : StrictStr, **kwargs):  # noqa: E501
        """Get Card Image Data  # noqa: E501

        Get card image data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_card_image_data_with_http_info(card_image_id, async_req=True)
        >>> result = thread.get()

        :param card_image_id: (required)
        :type card_image_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'card_image_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_card_image_data" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['card_image_id']:
            _path_params['card_image_id'] = _params['card_image_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['image/jpeg', 'application/problem+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "str",
            '401': "Error",
            '403': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/cards/images/{card_image_id}/data', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_card_image_details(self, card_image_id : StrictStr, **kwargs) -> CardImageDetails:  # noqa: E501
        """Get Card Image Details  # noqa: E501

        Get card image details  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_card_image_details(card_image_id, async_req=True)
        >>> result = thread.get()

        :param card_image_id: (required)
        :type card_image_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CardImageDetails
        """
        kwargs['_return_http_data_only'] = True
        return self.get_card_image_details_with_http_info(card_image_id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_card_image_details_with_http_info(self, card_image_id : StrictStr, **kwargs):  # noqa: E501
        """Get Card Image Details  # noqa: E501

        Get card image details  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_card_image_details_with_http_info(card_image_id, async_req=True)
        >>> result = thread.get()

        :param card_image_id: (required)
        :type card_image_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CardImageDetails, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'card_image_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_card_image_details" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['card_image_id']:
            _path_params['card_image_id'] = _params['card_image_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "CardImageDetails",
            '401': "Error",
            '403': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/cards/images/{card_image_id}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_card_widget_url(self, widget_type : Annotated[WidgetType, Field(..., description="The type of widget for which to construct the URL")], customer_id : StrictStr, account_id : StrictStr, card_id : Annotated[Optional[StrictStr], Field(description="The ID of the card (required for set PIN widget)")] = None, **kwargs) -> CardWidgetUrlResponse:  # noqa: E501
        """Get card widget URL  # noqa: E501

        This endpoint returns a URL address of the specified widget for a given card   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_card_widget_url(widget_type, customer_id, account_id, card_id, async_req=True)
        >>> result = thread.get()

        :param widget_type: The type of widget for which to construct the URL (required)
        :type widget_type: WidgetType
        :param customer_id: (required)
        :type customer_id: str
        :param account_id: (required)
        :type account_id: str
        :param card_id: The ID of the card (required for set PIN widget)
        :type card_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CardWidgetUrlResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.get_card_widget_url_with_http_info(widget_type, customer_id, account_id, card_id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_card_widget_url_with_http_info(self, widget_type : Annotated[WidgetType, Field(..., description="The type of widget for which to construct the URL")], customer_id : StrictStr, account_id : StrictStr, card_id : Annotated[Optional[StrictStr], Field(description="The ID of the card (required for set PIN widget)")] = None, **kwargs):  # noqa: E501
        """Get card widget URL  # noqa: E501

        This endpoint returns a URL address of the specified widget for a given card   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_card_widget_url_with_http_info(widget_type, customer_id, account_id, card_id, async_req=True)
        >>> result = thread.get()

        :param widget_type: The type of widget for which to construct the URL (required)
        :type widget_type: WidgetType
        :param customer_id: (required)
        :type customer_id: str
        :param account_id: (required)
        :type account_id: str
        :param card_id: The ID of the card (required for set PIN widget)
        :type card_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CardWidgetUrlResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'widget_type',
            'customer_id',
            'account_id',
            'card_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_card_widget_url" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('widget_type') is not None:  # noqa: E501
            _query_params.append(('widget_type', _params['widget_type']))
        if _params.get('customer_id') is not None:  # noqa: E501
            _query_params.append(('customer_id', _params['customer_id']))
        if _params.get('account_id') is not None:  # noqa: E501
            _query_params.append(('account_id', _params['account_id']))
        if _params.get('card_id') is not None:  # noqa: E501
            _query_params.append(('card_id', _params['card_id']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "CardWidgetUrlResponse",
        }

        return self.api_client.call_api(
            '/cards/card_widget_url', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_client_access_token(self, card_id : StrictStr, **kwargs) -> ClientToken:  # noqa: E501
        """Get a client token  # noqa: E501

        Create a client access token for interacting with a card.  This token will be used on the client to identify the card for flows like viewing Full PAN or setting the PIN in a PCI compliant manner.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_client_access_token(card_id, async_req=True)
        >>> result = thread.get()

        :param card_id: (required)
        :type card_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ClientToken
        """
        kwargs['_return_http_data_only'] = True
        return self.get_client_access_token_with_http_info(card_id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_client_access_token_with_http_info(self, card_id : StrictStr, **kwargs):  # noqa: E501
        """Get a client token  # noqa: E501

        Create a client access token for interacting with a card.  This token will be used on the client to identify the card for flows like viewing Full PAN or setting the PIN in a PCI compliant manner.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_client_access_token_with_http_info(card_id, async_req=True)
        >>> result = thread.get()

        :param card_id: (required)
        :type card_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ClientToken, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'card_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_client_access_token" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['card_id']:
            _path_params['card_id'] = _params['card_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '201': "ClientToken",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '422': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/cards/{card_id}/client_token', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_client_single_use_token(self, single_use_token_request : Annotated[SingleUseTokenRequest, Field(..., description="User token details")], **kwargs) -> SingleUseTokenResponse:  # noqa: E501
        """Get single-use token  # noqa: E501

        This endpoint returns a single-use access token. This type of token authorizes a single request to access API endpoints and data associated with a particular user   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_client_single_use_token(single_use_token_request, async_req=True)
        >>> result = thread.get()

        :param single_use_token_request: User token details (required)
        :type single_use_token_request: SingleUseTokenRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SingleUseTokenResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.get_client_single_use_token_with_http_info(single_use_token_request, **kwargs)  # noqa: E501

    @validate_arguments
    def get_client_single_use_token_with_http_info(self, single_use_token_request : Annotated[SingleUseTokenRequest, Field(..., description="User token details")], **kwargs):  # noqa: E501
        """Get single-use token  # noqa: E501

        This endpoint returns a single-use access token. This type of token authorizes a single request to access API endpoints and data associated with a particular user   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_client_single_use_token_with_http_info(single_use_token_request, async_req=True)
        >>> result = thread.get()

        :param single_use_token_request: User token details (required)
        :type single_use_token_request: SingleUseTokenRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SingleUseTokenResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'single_use_token_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_client_single_use_token" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['single_use_token_request']:
            _body_params = _params['single_use_token_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '201': "SingleUseTokenResponse",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '422': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/cards/single_use_token', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_gateway(self, gateway_id : StrictStr, **kwargs) -> GatewayResponse:  # noqa: E501
        """Get Gateway  # noqa: E501

        Get the details of an Authorization Gateway that has been configured   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_gateway(gateway_id, async_req=True)
        >>> result = thread.get()

        :param gateway_id: (required)
        :type gateway_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GatewayResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.get_gateway_with_http_info(gateway_id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_gateway_with_http_info(self, gateway_id : StrictStr, **kwargs):  # noqa: E501
        """Get Gateway  # noqa: E501

        Get the details of an Authorization Gateway that has been configured   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_gateway_with_http_info(gateway_id, async_req=True)
        >>> result = thread.get()

        :param gateway_id: (required)
        :type gateway_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GatewayResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'gateway_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_gateway" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['gateway_id']:
            _path_params['gateway_id'] = _params['gateway_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "GatewayResponse",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '422': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/cards/gateways/{gateway_id}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def issue_card(self, card_issuance_request : Annotated[CardIssuanceRequest, Field(..., description="Card to issue")], **kwargs) -> CardResponse:  # noqa: E501
        """Issue a Card  # noqa: E501

        Issue or reissue a new card for a customer   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.issue_card(card_issuance_request, async_req=True)
        >>> result = thread.get()

        :param card_issuance_request: Card to issue (required)
        :type card_issuance_request: CardIssuanceRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CardResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.issue_card_with_http_info(card_issuance_request, **kwargs)  # noqa: E501

    @validate_arguments
    def issue_card_with_http_info(self, card_issuance_request : Annotated[CardIssuanceRequest, Field(..., description="Card to issue")], **kwargs):  # noqa: E501
        """Issue a Card  # noqa: E501

        Issue or reissue a new card for a customer   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.issue_card_with_http_info(card_issuance_request, async_req=True)
        >>> result = thread.get()

        :param card_issuance_request: Card to issue (required)
        :type card_issuance_request: CardIssuanceRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CardResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'card_issuance_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method issue_card" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['card_issuance_request']:
            _body_params = _params['card_issuance_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '201': "CardResponse",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '422': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/cards', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_card_image_details(self, customer_id : StrictStr, **kwargs) -> CardImageDetailsList:  # noqa: E501
        """List Card Image Details  # noqa: E501

        List all card image details   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_card_image_details(customer_id, async_req=True)
        >>> result = thread.get()

        :param customer_id: (required)
        :type customer_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CardImageDetailsList
        """
        kwargs['_return_http_data_only'] = True
        return self.list_card_image_details_with_http_info(customer_id, **kwargs)  # noqa: E501

    @validate_arguments
    def list_card_image_details_with_http_info(self, customer_id : StrictStr, **kwargs):  # noqa: E501
        """List Card Image Details  # noqa: E501

        List all card image details   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_card_image_details_with_http_info(customer_id, async_req=True)
        >>> result = thread.get()

        :param customer_id: (required)
        :type customer_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CardImageDetailsList, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'customer_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_card_image_details" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('customer_id') is not None:  # noqa: E501
            _query_params.append(('customer_id', _params['customer_id']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "CardImageDetailsList",
            '401': "Error",
            '403': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/cards/images', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_card_products(self, limit : Optional[conint(strict=True, ge=1)] = None, page_token : Optional[StrictStr] = None, form : Annotated[Optional[Form], Field(description="The format of the card")] = None, **kwargs) -> CardProductListResponse:  # noqa: E501
        """List Card Products  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_card_products(limit, page_token, form, async_req=True)
        >>> result = thread.get()

        :param limit:
        :type limit: int
        :param page_token:
        :type page_token: str
        :param form: The format of the card
        :type form: Form
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CardProductListResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.list_card_products_with_http_info(limit, page_token, form, **kwargs)  # noqa: E501

    @validate_arguments
    def list_card_products_with_http_info(self, limit : Optional[conint(strict=True, ge=1)] = None, page_token : Optional[StrictStr] = None, form : Annotated[Optional[Form], Field(description="The format of the card")] = None, **kwargs):  # noqa: E501
        """List Card Products  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_card_products_with_http_info(limit, page_token, form, async_req=True)
        >>> result = thread.get()

        :param limit:
        :type limit: int
        :param page_token:
        :type page_token: str
        :param form: The format of the card
        :type form: Form
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CardProductListResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'limit',
            'page_token',
            'form'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_card_products" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))
        if _params.get('page_token') is not None:  # noqa: E501
            _query_params.append(('page_token', _params['page_token']))
        if _params.get('form') is not None:  # noqa: E501
            _query_params.append(('form', _params['form']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "CardProductListResponse",
            '401': "Error",
            '403': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/cards/products', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_cards(self, customer_id : Optional[StrictStr] = None, account_id : Annotated[Optional[List[StrictStr]], Field(description="Account ID(s). Multiple IDs can be provided as a comma-separated list.")] = None, emboss_name : Annotated[Optional[StrictStr], Field(description="emboss name")] = None, last_four : Annotated[Optional[constr(strict=True)], Field(description="The last 4 digits of the card PAN")] = None, expiration_date : Annotated[Optional[date], Field(description="The date representing when the card would expire at")] = None, card_type : Annotated[Optional[StrictStr], Field(description="Indicates the type of card")] = None, card_brand : Annotated[Optional[CardBrand], Field(description="The brand of a card product")] = None, form : Annotated[Optional[Form], Field(description="The format of the card")] = None, card_product_id : Optional[StrictStr] = None, card_status : Annotated[Optional[CardStatus], Field(description="The status of a card")] = None, postal_code : Annotated[Optional[StrictStr], Field(description="The postal code of a card user")] = None, limit : Optional[conint(strict=True, ge=1)] = None, page_token : Optional[StrictStr] = None, sort_by : Annotated[Optional[List[StrictStr]], Field(description="Specifies the sort order for the returned cards. ")] = None, **kwargs) -> CardListResponse:  # noqa: E501
        """List Cards  # noqa: E501

        List of cards matching query parameters   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_cards(customer_id, account_id, emboss_name, last_four, expiration_date, card_type, card_brand, form, card_product_id, card_status, postal_code, limit, page_token, sort_by, async_req=True)
        >>> result = thread.get()

        :param customer_id:
        :type customer_id: str
        :param account_id: Account ID(s). Multiple IDs can be provided as a comma-separated list.
        :type account_id: List[str]
        :param emboss_name: emboss name
        :type emboss_name: str
        :param last_four: The last 4 digits of the card PAN
        :type last_four: str
        :param expiration_date: The date representing when the card would expire at
        :type expiration_date: date
        :param card_type: Indicates the type of card
        :type card_type: str
        :param card_brand: The brand of a card product
        :type card_brand: CardBrand
        :param form: The format of the card
        :type form: Form
        :param card_product_id:
        :type card_product_id: str
        :param card_status: The status of a card
        :type card_status: CardStatus
        :param postal_code: The postal code of a card user
        :type postal_code: str
        :param limit:
        :type limit: int
        :param page_token:
        :type page_token: str
        :param sort_by: Specifies the sort order for the returned cards. 
        :type sort_by: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CardListResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.list_cards_with_http_info(customer_id, account_id, emboss_name, last_four, expiration_date, card_type, card_brand, form, card_product_id, card_status, postal_code, limit, page_token, sort_by, **kwargs)  # noqa: E501

    @validate_arguments
    def list_cards_with_http_info(self, customer_id : Optional[StrictStr] = None, account_id : Annotated[Optional[List[StrictStr]], Field(description="Account ID(s). Multiple IDs can be provided as a comma-separated list.")] = None, emboss_name : Annotated[Optional[StrictStr], Field(description="emboss name")] = None, last_four : Annotated[Optional[constr(strict=True)], Field(description="The last 4 digits of the card PAN")] = None, expiration_date : Annotated[Optional[date], Field(description="The date representing when the card would expire at")] = None, card_type : Annotated[Optional[StrictStr], Field(description="Indicates the type of card")] = None, card_brand : Annotated[Optional[CardBrand], Field(description="The brand of a card product")] = None, form : Annotated[Optional[Form], Field(description="The format of the card")] = None, card_product_id : Optional[StrictStr] = None, card_status : Annotated[Optional[CardStatus], Field(description="The status of a card")] = None, postal_code : Annotated[Optional[StrictStr], Field(description="The postal code of a card user")] = None, limit : Optional[conint(strict=True, ge=1)] = None, page_token : Optional[StrictStr] = None, sort_by : Annotated[Optional[List[StrictStr]], Field(description="Specifies the sort order for the returned cards. ")] = None, **kwargs):  # noqa: E501
        """List Cards  # noqa: E501

        List of cards matching query parameters   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_cards_with_http_info(customer_id, account_id, emboss_name, last_four, expiration_date, card_type, card_brand, form, card_product_id, card_status, postal_code, limit, page_token, sort_by, async_req=True)
        >>> result = thread.get()

        :param customer_id:
        :type customer_id: str
        :param account_id: Account ID(s). Multiple IDs can be provided as a comma-separated list.
        :type account_id: List[str]
        :param emboss_name: emboss name
        :type emboss_name: str
        :param last_four: The last 4 digits of the card PAN
        :type last_four: str
        :param expiration_date: The date representing when the card would expire at
        :type expiration_date: date
        :param card_type: Indicates the type of card
        :type card_type: str
        :param card_brand: The brand of a card product
        :type card_brand: CardBrand
        :param form: The format of the card
        :type form: Form
        :param card_product_id:
        :type card_product_id: str
        :param card_status: The status of a card
        :type card_status: CardStatus
        :param postal_code: The postal code of a card user
        :type postal_code: str
        :param limit:
        :type limit: int
        :param page_token:
        :type page_token: str
        :param sort_by: Specifies the sort order for the returned cards. 
        :type sort_by: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CardListResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'customer_id',
            'account_id',
            'emboss_name',
            'last_four',
            'expiration_date',
            'card_type',
            'card_brand',
            'form',
            'card_product_id',
            'card_status',
            'postal_code',
            'limit',
            'page_token',
            'sort_by'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_cards" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('customer_id') is not None:  # noqa: E501
            _query_params.append(('customer_id', _params['customer_id']))
        if _params.get('account_id') is not None:  # noqa: E501
            _query_params.append(('account_id', _params['account_id']))
            _collection_formats['account_id'] = 'csv'
        if _params.get('emboss_name') is not None:  # noqa: E501
            _query_params.append(('emboss_name', _params['emboss_name']))
        if _params.get('last_four') is not None:  # noqa: E501
            _query_params.append(('last_four', _params['last_four']))
        if _params.get('expiration_date') is not None:  # noqa: E501
            _query_params.append(('expiration_date', _params['expiration_date']))
        if _params.get('card_type') is not None:  # noqa: E501
            _query_params.append(('card_type', _params['card_type']))
        if _params.get('card_brand') is not None:  # noqa: E501
            _query_params.append(('card_brand', _params['card_brand']))
        if _params.get('form') is not None:  # noqa: E501
            _query_params.append(('form', _params['form']))
        if _params.get('card_product_id') is not None:  # noqa: E501
            _query_params.append(('card_product_id', _params['card_product_id']))
        if _params.get('card_status') is not None:  # noqa: E501
            _query_params.append(('card_status', _params['card_status']))
        if _params.get('postal_code') is not None:  # noqa: E501
            _query_params.append(('postal_code', _params['postal_code']))
        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))
        if _params.get('page_token') is not None:  # noqa: E501
            _query_params.append(('page_token', _params['page_token']))
        if _params.get('sort_by') is not None:  # noqa: E501
            _query_params.append(('sort_by', _params['sort_by']))
            _collection_formats['sort_by'] = 'csv'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '201': "CardListResponse",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '422': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/cards', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_changes(self, card_id : StrictStr, **kwargs) -> CardChangesList:  # noqa: E501
        """List Card Changes  # noqa: E501

        List card change history   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_changes(card_id, async_req=True)
        >>> result = thread.get()

        :param card_id: (required)
        :type card_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CardChangesList
        """
        kwargs['_return_http_data_only'] = True
        return self.list_changes_with_http_info(card_id, **kwargs)  # noqa: E501

    @validate_arguments
    def list_changes_with_http_info(self, card_id : StrictStr, **kwargs):  # noqa: E501
        """List Card Changes  # noqa: E501

        List card change history   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_changes_with_http_info(card_id, async_req=True)
        >>> result = thread.get()

        :param card_id: (required)
        :type card_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CardChangesList, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'card_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_changes" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['card_id']:
            _path_params['card_id'] = _params['card_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "CardChangesList",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '422': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/cards/{card_id}/changes', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_gateways(self, limit : Optional[conint(strict=True, ge=1)] = None, page_token : Optional[StrictStr] = None, **kwargs) -> GatewayListResponse:  # noqa: E501
        """List Gateways  # noqa: E501

        List of gateways matching query parameters   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_gateways(limit, page_token, async_req=True)
        >>> result = thread.get()

        :param limit:
        :type limit: int
        :param page_token:
        :type page_token: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GatewayListResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.list_gateways_with_http_info(limit, page_token, **kwargs)  # noqa: E501

    @validate_arguments
    def list_gateways_with_http_info(self, limit : Optional[conint(strict=True, ge=1)] = None, page_token : Optional[StrictStr] = None, **kwargs):  # noqa: E501
        """List Gateways  # noqa: E501

        List of gateways matching query parameters   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_gateways_with_http_info(limit, page_token, async_req=True)
        >>> result = thread.get()

        :param limit:
        :type limit: int
        :param page_token:
        :type page_token: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GatewayListResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'limit',
            'page_token'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_gateways" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))
        if _params.get('page_token') is not None:  # noqa: E501
            _query_params.append(('page_token', _params['page_token']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '201': "GatewayListResponse",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '422': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/cards/gateways', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def update_card(self, card_id : StrictStr, card_edit_request : Annotated[CardEditRequest, Field(..., description="Card edits")], **kwargs) -> CardResponse:  # noqa: E501
        """Update Card  # noqa: E501

        Integrators can update the card resource to change status, update shipping (if the card hasn't been shipped) or edit metadata.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_card(card_id, card_edit_request, async_req=True)
        >>> result = thread.get()

        :param card_id: (required)
        :type card_id: str
        :param card_edit_request: Card edits (required)
        :type card_edit_request: CardEditRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CardResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.update_card_with_http_info(card_id, card_edit_request, **kwargs)  # noqa: E501

    @validate_arguments
    def update_card_with_http_info(self, card_id : StrictStr, card_edit_request : Annotated[CardEditRequest, Field(..., description="Card edits")], **kwargs):  # noqa: E501
        """Update Card  # noqa: E501

        Integrators can update the card resource to change status, update shipping (if the card hasn't been shipped) or edit metadata.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_card_with_http_info(card_id, card_edit_request, async_req=True)
        >>> result = thread.get()

        :param card_id: (required)
        :type card_id: str
        :param card_edit_request: Card edits (required)
        :type card_edit_request: CardEditRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CardResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'card_id',
            'card_edit_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_card" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['card_id']:
            _path_params['card_id'] = _params['card_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['card_edit_request']:
            _body_params = _params['card_edit_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "CardResponse",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '422': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/cards/{card_id}', 'PATCH',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def update_card_image_details(self, card_image_id : StrictStr, update_card_image_request : Annotated[UpdateCardImageRequest, Field(..., description="Details of the image to create")], **kwargs) -> CardImageDetails:  # noqa: E501
        """Update Card Image Details  # noqa: E501

        Update card image details. The only detail that can be updated is the card status as APPROVED or REJECTED.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_card_image_details(card_image_id, update_card_image_request, async_req=True)
        >>> result = thread.get()

        :param card_image_id: (required)
        :type card_image_id: str
        :param update_card_image_request: Details of the image to create (required)
        :type update_card_image_request: UpdateCardImageRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CardImageDetails
        """
        kwargs['_return_http_data_only'] = True
        return self.update_card_image_details_with_http_info(card_image_id, update_card_image_request, **kwargs)  # noqa: E501

    @validate_arguments
    def update_card_image_details_with_http_info(self, card_image_id : StrictStr, update_card_image_request : Annotated[UpdateCardImageRequest, Field(..., description="Details of the image to create")], **kwargs):  # noqa: E501
        """Update Card Image Details  # noqa: E501

        Update card image details. The only detail that can be updated is the card status as APPROVED or REJECTED.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_card_image_details_with_http_info(card_image_id, update_card_image_request, async_req=True)
        >>> result = thread.get()

        :param card_image_id: (required)
        :type card_image_id: str
        :param update_card_image_request: Details of the image to create (required)
        :type update_card_image_request: UpdateCardImageRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CardImageDetails, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'card_image_id',
            'update_card_image_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_card_image_details" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['card_image_id']:
            _path_params['card_image_id'] = _params['card_image_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['update_card_image_request']:
            _body_params = _params['update_card_image_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "CardImageDetails",
            '401': "Error",
            '403': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/cards/images/{card_image_id}', 'PATCH',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def update_gateway(self, gateway_id : StrictStr, update_gateway_request : Annotated[UpdateGatewayRequest, Field(..., description="Gateway edits")], **kwargs) -> GatewayResponse:  # noqa: E501
        """Update Gateway  # noqa: E501

        Update Authorization Gateway configuration   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_gateway(gateway_id, update_gateway_request, async_req=True)
        >>> result = thread.get()

        :param gateway_id: (required)
        :type gateway_id: str
        :param update_gateway_request: Gateway edits (required)
        :type update_gateway_request: UpdateGatewayRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GatewayResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.update_gateway_with_http_info(gateway_id, update_gateway_request, **kwargs)  # noqa: E501

    @validate_arguments
    def update_gateway_with_http_info(self, gateway_id : StrictStr, update_gateway_request : Annotated[UpdateGatewayRequest, Field(..., description="Gateway edits")], **kwargs):  # noqa: E501
        """Update Gateway  # noqa: E501

        Update Authorization Gateway configuration   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_gateway_with_http_info(gateway_id, update_gateway_request, async_req=True)
        >>> result = thread.get()

        :param gateway_id: (required)
        :type gateway_id: str
        :param update_gateway_request: Gateway edits (required)
        :type update_gateway_request: UpdateGatewayRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GatewayResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'gateway_id',
            'update_gateway_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_gateway" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['gateway_id']:
            _path_params['gateway_id'] = _params['gateway_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['update_gateway_request']:
            _body_params = _params['update_gateway_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "GatewayResponse",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '422': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/cards/gateways/{gateway_id}', 'PATCH',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def upload_card_image_data(self, card_image_id : StrictStr, body : Annotated[StrictStr, Field(..., description="Binary image data")], **kwargs) -> CardImageDetails:  # noqa: E501
        """Upload Card Image  # noqa: E501

        Upload card image data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upload_card_image_data(card_image_id, body, async_req=True)
        >>> result = thread.get()

        :param card_image_id: (required)
        :type card_image_id: str
        :param body: Binary image data (required)
        :type body: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CardImageDetails
        """
        kwargs['_return_http_data_only'] = True
        return self.upload_card_image_data_with_http_info(card_image_id, body, **kwargs)  # noqa: E501

    @validate_arguments
    def upload_card_image_data_with_http_info(self, card_image_id : StrictStr, body : Annotated[StrictStr, Field(..., description="Binary image data")], **kwargs):  # noqa: E501
        """Upload Card Image  # noqa: E501

        Upload card image data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upload_card_image_data_with_http_info(card_image_id, body, async_req=True)
        >>> result = thread.get()

        :param card_image_id: (required)
        :type card_image_id: str
        :param body: Binary image data (required)
        :type body: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CardImageDetails, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'card_image_id',
            'body'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upload_card_image_data" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['card_image_id']:
            _path_params['card_image_id'] = _params['card_image_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['body']:
            _body_params = _params['body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['image/jpeg']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "CardImageDetails",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '422': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/cards/images/{card_image_id}/data', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
