# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev3
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from datetime import date

from pydantic import Field, StrictStr, conint, validator

from typing import List, Optional

from synctera_client.models.account import Account
from synctera_client.models.account_creation import AccountCreation
from synctera_client.models.account_generic_response import AccountGenericResponse
from synctera_client.models.account_list import AccountList
from synctera_client.models.account_product import AccountProduct
from synctera_client.models.account_product_list import AccountProductList
from synctera_client.models.account_template import AccountTemplate
from synctera_client.models.account_template_response import AccountTemplateResponse
from synctera_client.models.account_type import AccountType
from synctera_client.models.customer_type import CustomerType
from synctera_client.models.delete_response import DeleteResponse
from synctera_client.models.patch_account_product import PatchAccountProduct
from synctera_client.models.relationship import Relationship
from synctera_client.models.relationship_list import RelationshipList
from synctera_client.models.status import Status
from synctera_client.models.template_list import TemplateList

from synctera_client.api_client import ApiClient
from synctera_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class AccountsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def create_account(self, account_creation : Annotated[AccountCreation, Field(..., description="Account to create")], idempotency_key : Annotated[Optional[StrictStr], Field(description="An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.")] = None, **kwargs) -> AccountGenericResponse:  # noqa: E501
        """Create an account  # noqa: E501

        Create a shadow mode or lead mode account. You need to determine the mode according to integrator configuration, and specify the required fields accordingly.  Shadow mode required fields:   - account_number   - status  Lead mode required fields:   - account_template_id   - relationships   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_account(account_creation, idempotency_key, async_req=True)
        >>> result = thread.get()

        :param account_creation: Account to create (required)
        :type account_creation: AccountCreation
        :param idempotency_key: An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.
        :type idempotency_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AccountGenericResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.create_account_with_http_info(account_creation, idempotency_key, **kwargs)  # noqa: E501

    @validate_arguments
    def create_account_with_http_info(self, account_creation : Annotated[AccountCreation, Field(..., description="Account to create")], idempotency_key : Annotated[Optional[StrictStr], Field(description="An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.")] = None, **kwargs):  # noqa: E501
        """Create an account  # noqa: E501

        Create a shadow mode or lead mode account. You need to determine the mode according to integrator configuration, and specify the required fields accordingly.  Shadow mode required fields:   - account_number   - status  Lead mode required fields:   - account_template_id   - relationships   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_account_with_http_info(account_creation, idempotency_key, async_req=True)
        >>> result = thread.get()

        :param account_creation: Account to create (required)
        :type account_creation: AccountCreation
        :param idempotency_key: An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.
        :type idempotency_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AccountGenericResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'account_creation',
            'idempotency_key'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_account" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['idempotency_key']:
            _header_params['Idempotency-Key'] = _params['idempotency_key']

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['account_creation']:
            _body_params = _params['account_creation']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '201': "AccountGenericResponse",
            '401': "Error",
            '422': "Error",
        }

        return self.api_client.call_api(
            '/accounts', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def create_account_relationship(self, account_id : Annotated[StrictStr, Field(..., description="Unique identifier for the account.")], relationship : Annotated[Relationship, Field(..., description="Account relationship object")], idempotency_key : Annotated[Optional[StrictStr], Field(description="An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.")] = None, **kwargs) -> Relationship:  # noqa: E501
        """Create account relationship  # noqa: E501

        Add a customer to an account  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_account_relationship(account_id, relationship, idempotency_key, async_req=True)
        >>> result = thread.get()

        :param account_id: Unique identifier for the account. (required)
        :type account_id: str
        :param relationship: Account relationship object (required)
        :type relationship: Relationship
        :param idempotency_key: An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.
        :type idempotency_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Relationship
        """
        kwargs['_return_http_data_only'] = True
        return self.create_account_relationship_with_http_info(account_id, relationship, idempotency_key, **kwargs)  # noqa: E501

    @validate_arguments
    def create_account_relationship_with_http_info(self, account_id : Annotated[StrictStr, Field(..., description="Unique identifier for the account.")], relationship : Annotated[Relationship, Field(..., description="Account relationship object")], idempotency_key : Annotated[Optional[StrictStr], Field(description="An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.")] = None, **kwargs):  # noqa: E501
        """Create account relationship  # noqa: E501

        Add a customer to an account  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_account_relationship_with_http_info(account_id, relationship, idempotency_key, async_req=True)
        >>> result = thread.get()

        :param account_id: Unique identifier for the account. (required)
        :type account_id: str
        :param relationship: Account relationship object (required)
        :type relationship: Relationship
        :param idempotency_key: An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.
        :type idempotency_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Relationship, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'account_id',
            'relationship',
            'idempotency_key'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_account_relationship" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['account_id']:
            _path_params['account_id'] = _params['account_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['idempotency_key']:
            _header_params['Idempotency-Key'] = _params['idempotency_key']

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['relationship']:
            _body_params = _params['relationship']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '201': "Relationship",
            '401': "Error",
            '461': "Error",
        }

        return self.api_client.call_api(
            '/accounts/{account_id}/relationships', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def create_account_resource_product(self, account_product : Annotated[AccountProduct, Field(..., description="Account product to create")], idempotency_key : Annotated[Optional[StrictStr], Field(description="An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.")] = None, **kwargs) -> AccountProduct:  # noqa: E501
        """Create an account product  # noqa: E501

        Create an account product. Rates cannot be nil or empty.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_account_resource_product(account_product, idempotency_key, async_req=True)
        >>> result = thread.get()

        :param account_product: Account product to create (required)
        :type account_product: AccountProduct
        :param idempotency_key: An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.
        :type idempotency_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AccountProduct
        """
        kwargs['_return_http_data_only'] = True
        return self.create_account_resource_product_with_http_info(account_product, idempotency_key, **kwargs)  # noqa: E501

    @validate_arguments
    def create_account_resource_product_with_http_info(self, account_product : Annotated[AccountProduct, Field(..., description="Account product to create")], idempotency_key : Annotated[Optional[StrictStr], Field(description="An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.")] = None, **kwargs):  # noqa: E501
        """Create an account product  # noqa: E501

        Create an account product. Rates cannot be nil or empty.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_account_resource_product_with_http_info(account_product, idempotency_key, async_req=True)
        >>> result = thread.get()

        :param account_product: Account product to create (required)
        :type account_product: AccountProduct
        :param idempotency_key: An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.
        :type idempotency_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AccountProduct, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'account_product',
            'idempotency_key'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_account_resource_product" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['idempotency_key']:
            _header_params['Idempotency-Key'] = _params['idempotency_key']

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['account_product']:
            _body_params = _params['account_product']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '201': "AccountProduct",
        }

        return self.api_client.call_api(
            '/accounts/products', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def create_account_template(self, account_template : Annotated[AccountTemplate, Field(..., description="Account template to create")], idempotency_key : Annotated[Optional[StrictStr], Field(description="An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.")] = None, **kwargs) -> AccountTemplateResponse:  # noqa: E501
        """Create an account template  # noqa: E501

        Create an account template. An account template is needed to create an account in a lead mode.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_account_template(account_template, idempotency_key, async_req=True)
        >>> result = thread.get()

        :param account_template: Account template to create (required)
        :type account_template: AccountTemplate
        :param idempotency_key: An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.
        :type idempotency_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AccountTemplateResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.create_account_template_with_http_info(account_template, idempotency_key, **kwargs)  # noqa: E501

    @validate_arguments
    def create_account_template_with_http_info(self, account_template : Annotated[AccountTemplate, Field(..., description="Account template to create")], idempotency_key : Annotated[Optional[StrictStr], Field(description="An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.")] = None, **kwargs):  # noqa: E501
        """Create an account template  # noqa: E501

        Create an account template. An account template is needed to create an account in a lead mode.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_account_template_with_http_info(account_template, idempotency_key, async_req=True)
        >>> result = thread.get()

        :param account_template: Account template to create (required)
        :type account_template: AccountTemplate
        :param idempotency_key: An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.
        :type idempotency_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AccountTemplateResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'account_template',
            'idempotency_key'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_account_template" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['idempotency_key']:
            _header_params['Idempotency-Key'] = _params['idempotency_key']

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['account_template']:
            _body_params = _params['account_template']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '201': "AccountTemplateResponse",
        }

        return self.api_client.call_api(
            '/accounts/templates', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def delete_account_relationship(self, account_id : Annotated[StrictStr, Field(..., description="Unique identifier for the account.")], relationship_id : Annotated[StrictStr, Field(..., description="Relationship ID of the account associate with the account entity")], **kwargs) -> DeleteResponse:  # noqa: E501
        """Delete account relationship  # noqa: E501

        Delete account relationship  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_account_relationship(account_id, relationship_id, async_req=True)
        >>> result = thread.get()

        :param account_id: Unique identifier for the account. (required)
        :type account_id: str
        :param relationship_id: Relationship ID of the account associate with the account entity (required)
        :type relationship_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DeleteResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_account_relationship_with_http_info(account_id, relationship_id, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_account_relationship_with_http_info(self, account_id : Annotated[StrictStr, Field(..., description="Unique identifier for the account.")], relationship_id : Annotated[StrictStr, Field(..., description="Relationship ID of the account associate with the account entity")], **kwargs):  # noqa: E501
        """Delete account relationship  # noqa: E501

        Delete account relationship  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_account_relationship_with_http_info(account_id, relationship_id, async_req=True)
        >>> result = thread.get()

        :param account_id: Unique identifier for the account. (required)
        :type account_id: str
        :param relationship_id: Relationship ID of the account associate with the account entity (required)
        :type relationship_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DeleteResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'account_id',
            'relationship_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_account_relationship" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['account_id']:
            _path_params['account_id'] = _params['account_id']
        if _params['relationship_id']:
            _path_params['relationship_id'] = _params['relationship_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "DeleteResponse",
            '401': "Error",
            '404': "Error",
            '461': "Error",
        }

        return self.api_client.call_api(
            '/accounts/{account_id}/relationships/{relationship_id}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def delete_account_template(self, template_id : Annotated[StrictStr, Field(..., description="Account Template ID")], **kwargs) -> DeleteResponse:  # noqa: E501
        """Delete account template  # noqa: E501

        Delete account template  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_account_template(template_id, async_req=True)
        >>> result = thread.get()

        :param template_id: Account Template ID (required)
        :type template_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DeleteResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_account_template_with_http_info(template_id, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_account_template_with_http_info(self, template_id : Annotated[StrictStr, Field(..., description="Account Template ID")], **kwargs):  # noqa: E501
        """Delete account template  # noqa: E501

        Delete account template  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_account_template_with_http_info(template_id, async_req=True)
        >>> result = thread.get()

        :param template_id: Account Template ID (required)
        :type template_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DeleteResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'template_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_account_template" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['template_id']:
            _path_params['template_id'] = _params['template_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "DeleteResponse",
            '401': "Error",
            '404': "Error",
        }

        return self.api_client.call_api(
            '/accounts/templates/{template_id}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_account(self, account_id : Annotated[StrictStr, Field(..., description="Unique identifier for the account.")], **kwargs) -> AccountGenericResponse:  # noqa: E501
        """Get account  # noqa: E501

        Get an account  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_account(account_id, async_req=True)
        >>> result = thread.get()

        :param account_id: Unique identifier for the account. (required)
        :type account_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AccountGenericResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.get_account_with_http_info(account_id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_account_with_http_info(self, account_id : Annotated[StrictStr, Field(..., description="Unique identifier for the account.")], **kwargs):  # noqa: E501
        """Get account  # noqa: E501

        Get an account  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_account_with_http_info(account_id, async_req=True)
        >>> result = thread.get()

        :param account_id: Unique identifier for the account. (required)
        :type account_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AccountGenericResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'account_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_account" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['account_id']:
            _path_params['account_id'] = _params['account_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "AccountGenericResponse",
            '401': "Error",
            '404': "Error",
            '461': "Error",
        }

        return self.api_client.call_api(
            '/accounts/{account_id}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_account_relationship(self, account_id : Annotated[StrictStr, Field(..., description="Unique identifier for the account.")], relationship_id : Annotated[StrictStr, Field(..., description="Relationship ID of the account associate with the account entity")], **kwargs) -> Relationship:  # noqa: E501
        """Get account relationship  # noqa: E501

        Get account relationship by ID  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_account_relationship(account_id, relationship_id, async_req=True)
        >>> result = thread.get()

        :param account_id: Unique identifier for the account. (required)
        :type account_id: str
        :param relationship_id: Relationship ID of the account associate with the account entity (required)
        :type relationship_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Relationship
        """
        kwargs['_return_http_data_only'] = True
        return self.get_account_relationship_with_http_info(account_id, relationship_id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_account_relationship_with_http_info(self, account_id : Annotated[StrictStr, Field(..., description="Unique identifier for the account.")], relationship_id : Annotated[StrictStr, Field(..., description="Relationship ID of the account associate with the account entity")], **kwargs):  # noqa: E501
        """Get account relationship  # noqa: E501

        Get account relationship by ID  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_account_relationship_with_http_info(account_id, relationship_id, async_req=True)
        >>> result = thread.get()

        :param account_id: Unique identifier for the account. (required)
        :type account_id: str
        :param relationship_id: Relationship ID of the account associate with the account entity (required)
        :type relationship_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Relationship, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'account_id',
            'relationship_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_account_relationship" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['account_id']:
            _path_params['account_id'] = _params['account_id']
        if _params['relationship_id']:
            _path_params['relationship_id'] = _params['relationship_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "Relationship",
            '401': "Error",
            '404': "Error",
            '461': "Error",
        }

        return self.api_client.call_api(
            '/accounts/{account_id}/relationships/{relationship_id}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_account_template(self, template_id : Annotated[StrictStr, Field(..., description="Account Template ID")], **kwargs) -> AccountTemplateResponse:  # noqa: E501
        """Get account template  # noqa: E501

        Get an account template  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_account_template(template_id, async_req=True)
        >>> result = thread.get()

        :param template_id: Account Template ID (required)
        :type template_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AccountTemplateResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.get_account_template_with_http_info(template_id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_account_template_with_http_info(self, template_id : Annotated[StrictStr, Field(..., description="Account Template ID")], **kwargs):  # noqa: E501
        """Get account template  # noqa: E501

        Get an account template  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_account_template_with_http_info(template_id, async_req=True)
        >>> result = thread.get()

        :param template_id: Account Template ID (required)
        :type template_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AccountTemplateResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'template_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_account_template" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['template_id']:
            _path_params['template_id'] = _params['template_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "AccountTemplateResponse",
        }

        return self.api_client.call_api(
            '/accounts/templates/{template_id}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_account_relationship(self, account_id : Annotated[StrictStr, Field(..., description="Unique identifier for the account.")], limit : Optional[conint(strict=True, ge=1)] = None, page_token : Optional[StrictStr] = None, **kwargs) -> RelationshipList:  # noqa: E501
        """List account relationships  # noqa: E501

        List all customers of an account  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_account_relationship(account_id, limit, page_token, async_req=True)
        >>> result = thread.get()

        :param account_id: Unique identifier for the account. (required)
        :type account_id: str
        :param limit:
        :type limit: int
        :param page_token:
        :type page_token: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: RelationshipList
        """
        kwargs['_return_http_data_only'] = True
        return self.list_account_relationship_with_http_info(account_id, limit, page_token, **kwargs)  # noqa: E501

    @validate_arguments
    def list_account_relationship_with_http_info(self, account_id : Annotated[StrictStr, Field(..., description="Unique identifier for the account.")], limit : Optional[conint(strict=True, ge=1)] = None, page_token : Optional[StrictStr] = None, **kwargs):  # noqa: E501
        """List account relationships  # noqa: E501

        List all customers of an account  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_account_relationship_with_http_info(account_id, limit, page_token, async_req=True)
        >>> result = thread.get()

        :param account_id: Unique identifier for the account. (required)
        :type account_id: str
        :param limit:
        :type limit: int
        :param page_token:
        :type page_token: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(RelationshipList, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'account_id',
            'limit',
            'page_token'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_account_relationship" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['account_id']:
            _path_params['account_id'] = _params['account_id']

        # process the query parameters
        _query_params = []
        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))
        if _params.get('page_token') is not None:  # noqa: E501
            _query_params.append(('page_token', _params['page_token']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "RelationshipList",
            '401': "Error",
            '404': "Error",
            '461': "Error",
        }

        return self.api_client.call_api(
            '/accounts/{account_id}/relationships', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_account_resource_products(self, product_type : Annotated[StrictStr, Field(..., description="Type of account product")], limit : Optional[conint(strict=True, ge=1)] = None, page_token : Optional[StrictStr] = None, start_date : Annotated[Optional[date], Field(description="Date range filtering for type INTEREST. All rates in interest resource have to have valid_from later or equal to start_date.")] = None, end_date : Annotated[Optional[date], Field(description="Date range filtering for type INTEREST. All rates in interest resource have to have valid_to earlier or equal to end_date.")] = None, **kwargs) -> AccountProductList:  # noqa: E501
        """List account products  # noqa: E501

        List account Products   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_account_resource_products(product_type, limit, page_token, start_date, end_date, async_req=True)
        >>> result = thread.get()

        :param product_type: Type of account product (required)
        :type product_type: str
        :param limit:
        :type limit: int
        :param page_token:
        :type page_token: str
        :param start_date: Date range filtering for type INTEREST. All rates in interest resource have to have valid_from later or equal to start_date.
        :type start_date: date
        :param end_date: Date range filtering for type INTEREST. All rates in interest resource have to have valid_to earlier or equal to end_date.
        :type end_date: date
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AccountProductList
        """
        kwargs['_return_http_data_only'] = True
        return self.list_account_resource_products_with_http_info(product_type, limit, page_token, start_date, end_date, **kwargs)  # noqa: E501

    @validate_arguments
    def list_account_resource_products_with_http_info(self, product_type : Annotated[StrictStr, Field(..., description="Type of account product")], limit : Optional[conint(strict=True, ge=1)] = None, page_token : Optional[StrictStr] = None, start_date : Annotated[Optional[date], Field(description="Date range filtering for type INTEREST. All rates in interest resource have to have valid_from later or equal to start_date.")] = None, end_date : Annotated[Optional[date], Field(description="Date range filtering for type INTEREST. All rates in interest resource have to have valid_to earlier or equal to end_date.")] = None, **kwargs):  # noqa: E501
        """List account products  # noqa: E501

        List account Products   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_account_resource_products_with_http_info(product_type, limit, page_token, start_date, end_date, async_req=True)
        >>> result = thread.get()

        :param product_type: Type of account product (required)
        :type product_type: str
        :param limit:
        :type limit: int
        :param page_token:
        :type page_token: str
        :param start_date: Date range filtering for type INTEREST. All rates in interest resource have to have valid_from later or equal to start_date.
        :type start_date: date
        :param end_date: Date range filtering for type INTEREST. All rates in interest resource have to have valid_to earlier or equal to end_date.
        :type end_date: date
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AccountProductList, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'product_type',
            'limit',
            'page_token',
            'start_date',
            'end_date'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_account_resource_products" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))
        if _params.get('page_token') is not None:  # noqa: E501
            _query_params.append(('page_token', _params['page_token']))
        if _params.get('start_date') is not None:  # noqa: E501
            _query_params.append(('start_date', _params['start_date']))
        if _params.get('end_date') is not None:  # noqa: E501
            _query_params.append(('end_date', _params['end_date']))
        if _params.get('product_type') is not None:  # noqa: E501
            _query_params.append(('product_type', _params['product_type']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "AccountProductList",
        }

        return self.api_client.call_api(
            '/accounts/products', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_account_templates(self, account_type : Annotated[Optional[AccountType], Field(description="The type of the account ")] = None, limit : Optional[conint(strict=True, ge=1)] = None, page_token : Optional[StrictStr] = None, **kwargs) -> TemplateList:  # noqa: E501
        """List account templates  # noqa: E501

        List account templates   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_account_templates(account_type, limit, page_token, async_req=True)
        >>> result = thread.get()

        :param account_type: The type of the account 
        :type account_type: AccountType
        :param limit:
        :type limit: int
        :param page_token:
        :type page_token: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TemplateList
        """
        kwargs['_return_http_data_only'] = True
        return self.list_account_templates_with_http_info(account_type, limit, page_token, **kwargs)  # noqa: E501

    @validate_arguments
    def list_account_templates_with_http_info(self, account_type : Annotated[Optional[AccountType], Field(description="The type of the account ")] = None, limit : Optional[conint(strict=True, ge=1)] = None, page_token : Optional[StrictStr] = None, **kwargs):  # noqa: E501
        """List account templates  # noqa: E501

        List account templates   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_account_templates_with_http_info(account_type, limit, page_token, async_req=True)
        >>> result = thread.get()

        :param account_type: The type of the account 
        :type account_type: AccountType
        :param limit:
        :type limit: int
        :param page_token:
        :type page_token: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(TemplateList, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'account_type',
            'limit',
            'page_token'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_account_templates" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('account_type') is not None:  # noqa: E501
            _query_params.append(('account_type', _params['account_type']))
        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))
        if _params.get('page_token') is not None:  # noqa: E501
            _query_params.append(('page_token', _params['page_token']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "TemplateList",
        }

        return self.api_client.call_api(
            '/accounts/templates', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_accounts(self, id : Annotated[Optional[List[StrictStr]], Field(description="Account ID(s). Multiple IDs can be provided as a comma-separated list. ")] = None, account_type : Annotated[Optional[AccountType], Field(description="The type of the account ")] = None, linked_account_id : Annotated[Optional[List[StrictStr]], Field(description="Return only resources that are linked to the specified backing account in balance_floor or balance_ceiling. Multiple IDs can be provided as a comma-separated list. ")] = None, overdraft_account_id : Annotated[Optional[List[StrictStr]], Field(description="Overdraft account ID(s). Multiple IDs can be provided as a comma-separated list. This parameter is deprecated and will be removed in a future API version. Use linked_account_id instead. ")] = None, overflow_account_id : Annotated[Optional[List[StrictStr]], Field(description="Overflow account ID(s). Multiple IDs can be provided as a comma-separated list. This parameter is deprecated and will be removed in a future API version. Use linked_account_id instead. ")] = None, account_number : Annotated[Optional[List[StrictStr]], Field(description="Account number(s). Multiple account numbers can be provided as a comma-separated list. When only a single account number is provided, any * characters in the string are wildcards, and match any characters. ")] = None, status : Optional[Status] = None, interest_product_id : Annotated[Optional[StrictStr], Field(description="Interest product ID that accounts associate with. Multiple IDs can be provided as a comma-separated list.")] = None, customer_type : Annotated[Optional[CustomerType], Field(description="Customer type of the account, BUSINESS or PERSONAL ")] = None, spend_control_ids : Annotated[Optional[List[StrictStr]], Field(description="Spend Control ID(s). Multiple IDs can be provided as a comma-separated list. Return only resources that use the specified Spend Controls. ")] = None, customer_id : Annotated[Optional[StrictStr], Field(description="The customer's unique identifier")] = None, business_id : Annotated[Optional[List[StrictStr]], Field(description="Unique identifier for the business. Multiple IDs can be provided as a comma-separated list. ")] = None, person_id : Annotated[Optional[List[StrictStr]], Field(description="Unique identifier for the person. Multiple IDs can be provided as a comma-separated list. ")] = None, first_name : Optional[StrictStr] = None, last_name : Optional[StrictStr] = None, limit : Optional[conint(strict=True, ge=1)] = None, page_token : Optional[StrictStr] = None, sort_by : Annotated[Optional[List[StrictStr]], Field(description="Specifies the sort order for the returned accounts. ")] = None, **kwargs) -> AccountList:  # noqa: E501
        """List accounts  # noqa: E501

        Get paginated list of Accounts associated  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_accounts(id, account_type, linked_account_id, overdraft_account_id, overflow_account_id, account_number, status, interest_product_id, customer_type, spend_control_ids, customer_id, business_id, person_id, first_name, last_name, limit, page_token, sort_by, async_req=True)
        >>> result = thread.get()

        :param id: Account ID(s). Multiple IDs can be provided as a comma-separated list. 
        :type id: List[str]
        :param account_type: The type of the account 
        :type account_type: AccountType
        :param linked_account_id: Return only resources that are linked to the specified backing account in balance_floor or balance_ceiling. Multiple IDs can be provided as a comma-separated list. 
        :type linked_account_id: List[str]
        :param overdraft_account_id: Overdraft account ID(s). Multiple IDs can be provided as a comma-separated list. This parameter is deprecated and will be removed in a future API version. Use linked_account_id instead. 
        :type overdraft_account_id: List[str]
        :param overflow_account_id: Overflow account ID(s). Multiple IDs can be provided as a comma-separated list. This parameter is deprecated and will be removed in a future API version. Use linked_account_id instead. 
        :type overflow_account_id: List[str]
        :param account_number: Account number(s). Multiple account numbers can be provided as a comma-separated list. When only a single account number is provided, any * characters in the string are wildcards, and match any characters. 
        :type account_number: List[str]
        :param status:
        :type status: Status
        :param interest_product_id: Interest product ID that accounts associate with. Multiple IDs can be provided as a comma-separated list.
        :type interest_product_id: str
        :param customer_type: Customer type of the account, BUSINESS or PERSONAL 
        :type customer_type: CustomerType
        :param spend_control_ids: Spend Control ID(s). Multiple IDs can be provided as a comma-separated list. Return only resources that use the specified Spend Controls. 
        :type spend_control_ids: List[str]
        :param customer_id: The customer's unique identifier
        :type customer_id: str
        :param business_id: Unique identifier for the business. Multiple IDs can be provided as a comma-separated list. 
        :type business_id: List[str]
        :param person_id: Unique identifier for the person. Multiple IDs can be provided as a comma-separated list. 
        :type person_id: List[str]
        :param first_name:
        :type first_name: str
        :param last_name:
        :type last_name: str
        :param limit:
        :type limit: int
        :param page_token:
        :type page_token: str
        :param sort_by: Specifies the sort order for the returned accounts. 
        :type sort_by: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AccountList
        """
        kwargs['_return_http_data_only'] = True
        return self.list_accounts_with_http_info(id, account_type, linked_account_id, overdraft_account_id, overflow_account_id, account_number, status, interest_product_id, customer_type, spend_control_ids, customer_id, business_id, person_id, first_name, last_name, limit, page_token, sort_by, **kwargs)  # noqa: E501

    @validate_arguments
    def list_accounts_with_http_info(self, id : Annotated[Optional[List[StrictStr]], Field(description="Account ID(s). Multiple IDs can be provided as a comma-separated list. ")] = None, account_type : Annotated[Optional[AccountType], Field(description="The type of the account ")] = None, linked_account_id : Annotated[Optional[List[StrictStr]], Field(description="Return only resources that are linked to the specified backing account in balance_floor or balance_ceiling. Multiple IDs can be provided as a comma-separated list. ")] = None, overdraft_account_id : Annotated[Optional[List[StrictStr]], Field(description="Overdraft account ID(s). Multiple IDs can be provided as a comma-separated list. This parameter is deprecated and will be removed in a future API version. Use linked_account_id instead. ")] = None, overflow_account_id : Annotated[Optional[List[StrictStr]], Field(description="Overflow account ID(s). Multiple IDs can be provided as a comma-separated list. This parameter is deprecated and will be removed in a future API version. Use linked_account_id instead. ")] = None, account_number : Annotated[Optional[List[StrictStr]], Field(description="Account number(s). Multiple account numbers can be provided as a comma-separated list. When only a single account number is provided, any * characters in the string are wildcards, and match any characters. ")] = None, status : Optional[Status] = None, interest_product_id : Annotated[Optional[StrictStr], Field(description="Interest product ID that accounts associate with. Multiple IDs can be provided as a comma-separated list.")] = None, customer_type : Annotated[Optional[CustomerType], Field(description="Customer type of the account, BUSINESS or PERSONAL ")] = None, spend_control_ids : Annotated[Optional[List[StrictStr]], Field(description="Spend Control ID(s). Multiple IDs can be provided as a comma-separated list. Return only resources that use the specified Spend Controls. ")] = None, customer_id : Annotated[Optional[StrictStr], Field(description="The customer's unique identifier")] = None, business_id : Annotated[Optional[List[StrictStr]], Field(description="Unique identifier for the business. Multiple IDs can be provided as a comma-separated list. ")] = None, person_id : Annotated[Optional[List[StrictStr]], Field(description="Unique identifier for the person. Multiple IDs can be provided as a comma-separated list. ")] = None, first_name : Optional[StrictStr] = None, last_name : Optional[StrictStr] = None, limit : Optional[conint(strict=True, ge=1)] = None, page_token : Optional[StrictStr] = None, sort_by : Annotated[Optional[List[StrictStr]], Field(description="Specifies the sort order for the returned accounts. ")] = None, **kwargs):  # noqa: E501
        """List accounts  # noqa: E501

        Get paginated list of Accounts associated  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_accounts_with_http_info(id, account_type, linked_account_id, overdraft_account_id, overflow_account_id, account_number, status, interest_product_id, customer_type, spend_control_ids, customer_id, business_id, person_id, first_name, last_name, limit, page_token, sort_by, async_req=True)
        >>> result = thread.get()

        :param id: Account ID(s). Multiple IDs can be provided as a comma-separated list. 
        :type id: List[str]
        :param account_type: The type of the account 
        :type account_type: AccountType
        :param linked_account_id: Return only resources that are linked to the specified backing account in balance_floor or balance_ceiling. Multiple IDs can be provided as a comma-separated list. 
        :type linked_account_id: List[str]
        :param overdraft_account_id: Overdraft account ID(s). Multiple IDs can be provided as a comma-separated list. This parameter is deprecated and will be removed in a future API version. Use linked_account_id instead. 
        :type overdraft_account_id: List[str]
        :param overflow_account_id: Overflow account ID(s). Multiple IDs can be provided as a comma-separated list. This parameter is deprecated and will be removed in a future API version. Use linked_account_id instead. 
        :type overflow_account_id: List[str]
        :param account_number: Account number(s). Multiple account numbers can be provided as a comma-separated list. When only a single account number is provided, any * characters in the string are wildcards, and match any characters. 
        :type account_number: List[str]
        :param status:
        :type status: Status
        :param interest_product_id: Interest product ID that accounts associate with. Multiple IDs can be provided as a comma-separated list.
        :type interest_product_id: str
        :param customer_type: Customer type of the account, BUSINESS or PERSONAL 
        :type customer_type: CustomerType
        :param spend_control_ids: Spend Control ID(s). Multiple IDs can be provided as a comma-separated list. Return only resources that use the specified Spend Controls. 
        :type spend_control_ids: List[str]
        :param customer_id: The customer's unique identifier
        :type customer_id: str
        :param business_id: Unique identifier for the business. Multiple IDs can be provided as a comma-separated list. 
        :type business_id: List[str]
        :param person_id: Unique identifier for the person. Multiple IDs can be provided as a comma-separated list. 
        :type person_id: List[str]
        :param first_name:
        :type first_name: str
        :param last_name:
        :type last_name: str
        :param limit:
        :type limit: int
        :param page_token:
        :type page_token: str
        :param sort_by: Specifies the sort order for the returned accounts. 
        :type sort_by: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AccountList, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id',
            'account_type',
            'linked_account_id',
            'overdraft_account_id',
            'overflow_account_id',
            'account_number',
            'status',
            'interest_product_id',
            'customer_type',
            'spend_control_ids',
            'customer_id',
            'business_id',
            'person_id',
            'first_name',
            'last_name',
            'limit',
            'page_token',
            'sort_by'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_accounts" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('id') is not None:  # noqa: E501
            _query_params.append(('id', _params['id']))
            _collection_formats['id'] = 'csv'
        if _params.get('account_type') is not None:  # noqa: E501
            _query_params.append(('account_type', _params['account_type']))
        if _params.get('linked_account_id') is not None:  # noqa: E501
            _query_params.append(('linked_account_id', _params['linked_account_id']))
            _collection_formats['linked_account_id'] = 'csv'
        if _params.get('overdraft_account_id') is not None:  # noqa: E501
            _query_params.append(('overdraft_account_id', _params['overdraft_account_id']))
            _collection_formats['overdraft_account_id'] = 'csv'
        if _params.get('overflow_account_id') is not None:  # noqa: E501
            _query_params.append(('overflow_account_id', _params['overflow_account_id']))
            _collection_formats['overflow_account_id'] = 'csv'
        if _params.get('account_number') is not None:  # noqa: E501
            _query_params.append(('account_number', _params['account_number']))
            _collection_formats['account_number'] = 'csv'
        if _params.get('status') is not None:  # noqa: E501
            _query_params.append(('status', _params['status']))
        if _params.get('interest_product_id') is not None:  # noqa: E501
            _query_params.append(('interest_product_id', _params['interest_product_id']))
        if _params.get('customer_type') is not None:  # noqa: E501
            _query_params.append(('customer_type', _params['customer_type']))
        if _params.get('spend_control_ids') is not None:  # noqa: E501
            _query_params.append(('spend_control_ids', _params['spend_control_ids']))
            _collection_formats['spend_control_ids'] = 'csv'
        if _params.get('customer_id') is not None:  # noqa: E501
            _query_params.append(('customer_id', _params['customer_id']))
        if _params.get('business_id') is not None:  # noqa: E501
            _query_params.append(('business_id', _params['business_id']))
            _collection_formats['business_id'] = 'csv'
        if _params.get('person_id') is not None:  # noqa: E501
            _query_params.append(('person_id', _params['person_id']))
            _collection_formats['person_id'] = 'csv'
        if _params.get('first_name') is not None:  # noqa: E501
            _query_params.append(('first_name', _params['first_name']))
        if _params.get('last_name') is not None:  # noqa: E501
            _query_params.append(('last_name', _params['last_name']))
        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))
        if _params.get('page_token') is not None:  # noqa: E501
            _query_params.append(('page_token', _params['page_token']))
        if _params.get('sort_by') is not None:  # noqa: E501
            _query_params.append(('sort_by', _params['sort_by']))
            _collection_formats['sort_by'] = 'csv'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "AccountList",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '404': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/accounts', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def patch_account(self, account_id : Annotated[StrictStr, Field(..., description="Unique identifier for the account.")], account : Annotated[Account, Field(..., description="Account fields to be patched")], idempotency_key : Annotated[Optional[StrictStr], Field(description="An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.")] = None, **kwargs) -> AccountGenericResponse:  # noqa: E501
        """Patch account  # noqa: E501

        Patch account.  Immutable fields:   - account_number   - account_type   - account_template_id   - customer_type  Please note:   - Other fields cannot be modified when access_status is FROZEN.   - access_status has to be patched individually without other fields.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.patch_account(account_id, account, idempotency_key, async_req=True)
        >>> result = thread.get()

        :param account_id: Unique identifier for the account. (required)
        :type account_id: str
        :param account: Account fields to be patched (required)
        :type account: Account
        :param idempotency_key: An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.
        :type idempotency_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AccountGenericResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.patch_account_with_http_info(account_id, account, idempotency_key, **kwargs)  # noqa: E501

    @validate_arguments
    def patch_account_with_http_info(self, account_id : Annotated[StrictStr, Field(..., description="Unique identifier for the account.")], account : Annotated[Account, Field(..., description="Account fields to be patched")], idempotency_key : Annotated[Optional[StrictStr], Field(description="An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.")] = None, **kwargs):  # noqa: E501
        """Patch account  # noqa: E501

        Patch account.  Immutable fields:   - account_number   - account_type   - account_template_id   - customer_type  Please note:   - Other fields cannot be modified when access_status is FROZEN.   - access_status has to be patched individually without other fields.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.patch_account_with_http_info(account_id, account, idempotency_key, async_req=True)
        >>> result = thread.get()

        :param account_id: Unique identifier for the account. (required)
        :type account_id: str
        :param account: Account fields to be patched (required)
        :type account: Account
        :param idempotency_key: An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.
        :type idempotency_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AccountGenericResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'account_id',
            'account',
            'idempotency_key'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_account" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['account_id']:
            _path_params['account_id'] = _params['account_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['idempotency_key']:
            _header_params['Idempotency-Key'] = _params['idempotency_key']

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['account']:
            _body_params = _params['account']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "AccountGenericResponse",
            '401': "Error",
            '404': "Error",
            '461': "Error",
        }

        return self.api_client.call_api(
            '/accounts/{account_id}', 'PATCH',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def patch_account_product(self, product_id : Annotated[StrictStr, Field(..., description="Account Product ID")], patch_account_product : Annotated[PatchAccountProduct, Field(..., description="Account product fields to be patched")], idempotency_key : Annotated[Optional[StrictStr], Field(description="An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.")] = None, **kwargs) -> AccountProduct:  # noqa: E501
        """Patch account product  # noqa: E501

        Patch account product. Rates requires at minimum 1 entry if specified.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.patch_account_product(product_id, patch_account_product, idempotency_key, async_req=True)
        >>> result = thread.get()

        :param product_id: Account Product ID (required)
        :type product_id: str
        :param patch_account_product: Account product fields to be patched (required)
        :type patch_account_product: PatchAccountProduct
        :param idempotency_key: An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.
        :type idempotency_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AccountProduct
        """
        kwargs['_return_http_data_only'] = True
        return self.patch_account_product_with_http_info(product_id, patch_account_product, idempotency_key, **kwargs)  # noqa: E501

    @validate_arguments
    def patch_account_product_with_http_info(self, product_id : Annotated[StrictStr, Field(..., description="Account Product ID")], patch_account_product : Annotated[PatchAccountProduct, Field(..., description="Account product fields to be patched")], idempotency_key : Annotated[Optional[StrictStr], Field(description="An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.")] = None, **kwargs):  # noqa: E501
        """Patch account product  # noqa: E501

        Patch account product. Rates requires at minimum 1 entry if specified.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.patch_account_product_with_http_info(product_id, patch_account_product, idempotency_key, async_req=True)
        >>> result = thread.get()

        :param product_id: Account Product ID (required)
        :type product_id: str
        :param patch_account_product: Account product fields to be patched (required)
        :type patch_account_product: PatchAccountProduct
        :param idempotency_key: An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.
        :type idempotency_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AccountProduct, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'product_id',
            'patch_account_product',
            'idempotency_key'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_account_product" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['product_id']:
            _path_params['product_id'] = _params['product_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['idempotency_key']:
            _header_params['Idempotency-Key'] = _params['idempotency_key']

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['patch_account_product']:
            _body_params = _params['patch_account_product']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "AccountProduct",
            '401': "Error",
            '404': "Error",
        }

        return self.api_client.call_api(
            '/accounts/products/{product_id}', 'PATCH',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def update_account(self, account_id : Annotated[StrictStr, Field(..., description="Unique identifier for the account.")], account : Annotated[Account, Field(..., description="Account to update")], **kwargs) -> AccountGenericResponse:  # noqa: E501
        """Update account  # noqa: E501

        Update account  Shadow mode required fields:   - account_number   - status  Lead mode required fields:   - All fields are required.  Please note:   - access_status needs to be in ACTIVE.   - PUT request cannot change access_status.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_account(account_id, account, async_req=True)
        >>> result = thread.get()

        :param account_id: Unique identifier for the account. (required)
        :type account_id: str
        :param account: Account to update (required)
        :type account: Account
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AccountGenericResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.update_account_with_http_info(account_id, account, **kwargs)  # noqa: E501

    @validate_arguments
    def update_account_with_http_info(self, account_id : Annotated[StrictStr, Field(..., description="Unique identifier for the account.")], account : Annotated[Account, Field(..., description="Account to update")], **kwargs):  # noqa: E501
        """Update account  # noqa: E501

        Update account  Shadow mode required fields:   - account_number   - status  Lead mode required fields:   - All fields are required.  Please note:   - access_status needs to be in ACTIVE.   - PUT request cannot change access_status.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_account_with_http_info(account_id, account, async_req=True)
        >>> result = thread.get()

        :param account_id: Unique identifier for the account. (required)
        :type account_id: str
        :param account: Account to update (required)
        :type account: Account
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AccountGenericResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'account_id',
            'account'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_account" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['account_id']:
            _path_params['account_id'] = _params['account_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['account']:
            _body_params = _params['account']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "AccountGenericResponse",
            '401': "Error",
            '404': "Error",
            '461': "Error",
        }

        return self.api_client.call_api(
            '/accounts/{account_id}', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def update_account_relationship(self, account_id : Annotated[StrictStr, Field(..., description="Unique identifier for the account.")], relationship_id : Annotated[StrictStr, Field(..., description="Relationship ID of the account associate with the account entity")], relationship : Annotated[Relationship, Field(..., description="Account relationship to be updated")], **kwargs) -> Relationship:  # noqa: E501
        """Update account relationship  # noqa: E501

        Update account relationship. Only relationship_type can be updated. customer_id should not be modified.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_account_relationship(account_id, relationship_id, relationship, async_req=True)
        >>> result = thread.get()

        :param account_id: Unique identifier for the account. (required)
        :type account_id: str
        :param relationship_id: Relationship ID of the account associate with the account entity (required)
        :type relationship_id: str
        :param relationship: Account relationship to be updated (required)
        :type relationship: Relationship
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Relationship
        """
        kwargs['_return_http_data_only'] = True
        return self.update_account_relationship_with_http_info(account_id, relationship_id, relationship, **kwargs)  # noqa: E501

    @validate_arguments
    def update_account_relationship_with_http_info(self, account_id : Annotated[StrictStr, Field(..., description="Unique identifier for the account.")], relationship_id : Annotated[StrictStr, Field(..., description="Relationship ID of the account associate with the account entity")], relationship : Annotated[Relationship, Field(..., description="Account relationship to be updated")], **kwargs):  # noqa: E501
        """Update account relationship  # noqa: E501

        Update account relationship. Only relationship_type can be updated. customer_id should not be modified.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_account_relationship_with_http_info(account_id, relationship_id, relationship, async_req=True)
        >>> result = thread.get()

        :param account_id: Unique identifier for the account. (required)
        :type account_id: str
        :param relationship_id: Relationship ID of the account associate with the account entity (required)
        :type relationship_id: str
        :param relationship: Account relationship to be updated (required)
        :type relationship: Relationship
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Relationship, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'account_id',
            'relationship_id',
            'relationship'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_account_relationship" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['account_id']:
            _path_params['account_id'] = _params['account_id']
        if _params['relationship_id']:
            _path_params['relationship_id'] = _params['relationship_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['relationship']:
            _body_params = _params['relationship']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "Relationship",
            '401': "Error",
            '404': "Error",
            '461': "Error",
        }

        return self.api_client.call_api(
            '/accounts/{account_id}/relationships/{relationship_id}', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def update_account_template(self, template_id : Annotated[StrictStr, Field(..., description="Account Template ID")], account_template : Annotated[AccountTemplate, Field(..., description="Account template to update")], **kwargs) -> AccountTemplateResponse:  # noqa: E501
        """Update account template  # noqa: E501

        Update account template   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_account_template(template_id, account_template, async_req=True)
        >>> result = thread.get()

        :param template_id: Account Template ID (required)
        :type template_id: str
        :param account_template: Account template to update (required)
        :type account_template: AccountTemplate
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AccountTemplateResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.update_account_template_with_http_info(template_id, account_template, **kwargs)  # noqa: E501

    @validate_arguments
    def update_account_template_with_http_info(self, template_id : Annotated[StrictStr, Field(..., description="Account Template ID")], account_template : Annotated[AccountTemplate, Field(..., description="Account template to update")], **kwargs):  # noqa: E501
        """Update account template  # noqa: E501

        Update account template   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_account_template_with_http_info(template_id, account_template, async_req=True)
        >>> result = thread.get()

        :param template_id: Account Template ID (required)
        :type template_id: str
        :param account_template: Account template to update (required)
        :type account_template: AccountTemplate
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AccountTemplateResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'template_id',
            'account_template'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_account_template" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['template_id']:
            _path_params['template_id'] = _params['template_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['account_template']:
            _body_params = _params['account_template']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "AccountTemplateResponse",
        }

        return self.api_client.call_api(
            '/accounts/templates/{template_id}', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
