# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['synctera_client',
 'synctera_client.api',
 'synctera_client.apis',
 'synctera_client.apis.paths',
 'synctera_client.apis.tags',
 'synctera_client.model',
 'synctera_client.models',
 'synctera_client.paths',
 'synctera_client.paths.accounts',
 'synctera_client.paths.accounts_account_id',
 'synctera_client.paths.accounts_account_id_relationships',
 'synctera_client.paths.accounts_account_id_relationships_relationship_id',
 'synctera_client.paths.accounts_products',
 'synctera_client.paths.accounts_products_product_id',
 'synctera_client.paths.accounts_templates',
 'synctera_client.paths.accounts_templates_template_id',
 'synctera_client.paths.ach',
 'synctera_client.paths.ach_transaction_id',
 'synctera_client.paths.ach_transaction_simulations_receiving_return',
 'synctera_client.paths.ach_transaction_simulations_receiving_transaction',
 'synctera_client.paths.businesses',
 'synctera_client.paths.businesses_business_id',
 'synctera_client.paths.cards',
 'synctera_client.paths.cards_activate',
 'synctera_client.paths.cards_card_id',
 'synctera_client.paths.cards_card_id_barcodes',
 'synctera_client.paths.cards_card_id_changes',
 'synctera_client.paths.cards_card_id_client_token',
 'synctera_client.paths.cards_card_id_digital_wallet_tokens_applepay',
 'synctera_client.paths.cards_card_id_digital_wallet_tokens_googlepay',
 'synctera_client.paths.cards_card_id_webhook_simulations_fulfillment',
 'synctera_client.paths.cards_card_widget_url',
 'synctera_client.paths.cards_digital_wallet_tokens',
 'synctera_client.paths.cards_digital_wallet_tokens_digital_wallet_token_id',
 'synctera_client.paths.cards_gateways',
 'synctera_client.paths.cards_gateways_gateway_id',
 'synctera_client.paths.cards_images',
 'synctera_client.paths.cards_images_card_image_id',
 'synctera_client.paths.cards_images_card_image_id_data',
 'synctera_client.paths.cards_products',
 'synctera_client.paths.cards_single_use_token',
 'synctera_client.paths.cards_transaction_simulations_authorization',
 'synctera_client.paths.cards_transaction_simulations_authorization_advice',
 'synctera_client.paths.cards_transaction_simulations_clearing',
 'synctera_client.paths.cards_transaction_simulations_financial',
 'synctera_client.paths.cards_transaction_simulations_financial_advice',
 'synctera_client.paths.cards_transaction_simulations_financial_balance_inquiry',
 'synctera_client.paths.cards_transaction_simulations_financial_original_credit',
 'synctera_client.paths.cards_transaction_simulations_financial_withdrawal',
 'synctera_client.paths.cards_transaction_simulations_reversal',
 'synctera_client.paths.cash_pickups',
 'synctera_client.paths.cash_pickups_cash_pickup_id',
 'synctera_client.paths.customers',
 'synctera_client.paths.customers_customer_id',
 'synctera_client.paths.customers_customer_id_disclosures',
 'synctera_client.paths.customers_customer_id_employment',
 'synctera_client.paths.customers_customer_id_employment_employment_id',
 'synctera_client.paths.customers_customer_id_prefill',
 'synctera_client.paths.customers_customer_id_risk_ratings',
 'synctera_client.paths.customers_customer_id_risk_ratings_risk_rating_id',
 'synctera_client.paths.customers_customer_id_verifications',
 'synctera_client.paths.customers_customer_id_verifications_verification_id',
 'synctera_client.paths.customers_customer_id_verify',
 'synctera_client.paths.customers_customer_id_watchlists_alerts',
 'synctera_client.paths.customers_customer_id_watchlists_alerts_alert_id',
 'synctera_client.paths.customers_customer_id_watchlists_subscriptions',
 'synctera_client.paths.customers_customer_id_watchlists_subscriptions_subscription_id',
 'synctera_client.paths.customers_customer_id_watchlists_suppressions',
 'synctera_client.paths.disclosures',
 'synctera_client.paths.disclosures_disclosure_id',
 'synctera_client.paths.documents',
 'synctera_client.paths.documents_document_id',
 'synctera_client.paths.documents_document_id_contents',
 'synctera_client.paths.documents_document_id_versions',
 'synctera_client.paths.documents_document_id_versions_document_version',
 'synctera_client.paths.documents_document_id_versions_document_version_contents',
 'synctera_client.paths.external_accounts',
 'synctera_client.paths.external_accounts_access_tokens',
 'synctera_client.paths.external_accounts_add_vendor_accounts',
 'synctera_client.paths.external_accounts_external_account_id',
 'synctera_client.paths.external_accounts_external_account_id_balance',
 'synctera_client.paths.external_accounts_external_account_id_transactions',
 'synctera_client.paths.external_accounts_link_tokens',
 'synctera_client.paths.external_accounts_sync_vendor_accounts',
 'synctera_client.paths.external_cards',
 'synctera_client.paths.external_cards_external_card_id',
 'synctera_client.paths.external_cards_tokens',
 'synctera_client.paths.external_cards_transfers',
 'synctera_client.paths.external_cards_transfers_transfer_id',
 'synctera_client.paths.external_cards_transfers_transfer_id_reversals',
 'synctera_client.paths.internal_accounts',
 'synctera_client.paths.internal_accounts_internal_account_id',
 'synctera_client.paths.monitoring_alerts',
 'synctera_client.paths.monitoring_alerts_alert_id',
 'synctera_client.paths.monitoring_subscriptions',
 'synctera_client.paths.monitoring_subscriptions_subscription_id',
 'synctera_client.paths.payment_schedules',
 'synctera_client.paths.payment_schedules_payment_schedule_id',
 'synctera_client.paths.payment_schedules_payments',
 'synctera_client.paths.persons',
 'synctera_client.paths.persons_person_id',
 'synctera_client.paths.persons_person_id_prefill',
 'synctera_client.paths.rdc_deposits',
 'synctera_client.paths.rdc_deposits_deposit_id',
 'synctera_client.paths.reconciliations',
 'synctera_client.paths.reconciliations_reconciliation_id',
 'synctera_client.paths.relationships',
 'synctera_client.paths.relationships_relationship_id',
 'synctera_client.paths.spend_controls',
 'synctera_client.paths.spend_controls_spend_control_id',
 'synctera_client.paths.statements',
 'synctera_client.paths.statements_statement_id',
 'synctera_client.paths.transactions_internal_transfer',
 'synctera_client.paths.transactions_internal_transfer_id',
 'synctera_client.paths.transactions_pending',
 'synctera_client.paths.transactions_pending_id',
 'synctera_client.paths.transactions_posted',
 'synctera_client.paths.transactions_posted_id',
 'synctera_client.paths.verifications',
 'synctera_client.paths.verifications_adhoc',
 'synctera_client.paths.verifications_verification_id',
 'synctera_client.paths.verifications_verify',
 'synctera_client.paths.webhooks',
 'synctera_client.paths.webhooks_trigger',
 'synctera_client.paths.webhooks_webhook_id',
 'synctera_client.paths.webhooks_webhook_id_events',
 'synctera_client.paths.webhooks_webhook_id_events_event_id',
 'synctera_client.paths.webhooks_webhook_id_events_event_id_resend',
 'synctera_client.paths.wipe',
 'synctera_client.paths.wires',
 'synctera_client.paths.wires_wire_id']

package_data = \
{'': ['*']}

install_requires = \
['certifi>=2017.4.17,<2018.0.0',
 'frozendict>=2.3.4,<3.0.0',
 'python-dateutil>=2.7.0,<3.0.0',
 'typing_extensions>=4.3.0,<5.0.0',
 'urllib3>=1.26.7,<2.0.0']

setup_kwargs = {
    'name': 'synctera-client',
    'version': '0.32.0.dev3',
    'description': 'Synctera API Client generated by openapi-generator',
    'long_description': '# synctera-client\n<h2>Let\'s build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company\'s banking needs and are designed to be easy to understand and implement.</p><p>We\'re continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class=\'text-blue-600\' href=\'https://synctera.com/contact\' target=\'_blank\' rel=\'noreferrer\'>contact us</a>.</p>\n\n\nThis Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:\n\n- API version: 0.32.0.dev3\n- Package version: 1.0.0\n- Build package: org.openapitools.codegen.languages.PythonNextgenClientCodegen\n\n## Requirements.\n\nPython 3.7+\n\n## Installation & Usage\n### pip install\n\nIf the python package is hosted on a repository, you can install directly using:\n\n```sh\npip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git\n```\n(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)\n\nThen import the package:\n```python\nimport synctera_client\n```\n\n### Setuptools\n\nInstall via [Setuptools](http://pypi.python.org/pypi/setuptools).\n\n```sh\npython setup.py install --user\n```\n(or `sudo python setup.py install` to install the package for all users)\n\nThen import the package:\n```python\nimport synctera_client\n```\n\n## Getting Started\n\nPlease follow the [installation procedure](#installation--usage) and then run the following:\n\n```python\nfrom __future__ import print_function\n\nimport time\nimport synctera_client\nfrom synctera_client.rest import ApiException\nfrom pprint import pprint\n\n# Defining the host is optional and defaults to https://api.synctera.com/v0\n# See configuration.py for a list of all supported configuration parameters.\nconfiguration = synctera_client.Configuration(\n    host = "https://api.synctera.com/v0"\n)\n\n# The client must configure the authentication and authorization parameters\n# in accordance with the API server security policy.\n# Examples for each auth method are provided below, use the example that\n# satisfies your auth use case.\n\n# Configure Bearer authorization (api_key): bearerAuth\nconfiguration = synctera_client.Configuration(\n    access_token = os.environ["BEARER_TOKEN"]\n)\n\n\n# Enter a context with an instance of the API client\nwith synctera_client.ApiClient(configuration) as api_client:\n    # Create an instance of the API class\n    api_instance = synctera_client.ACHApi(api_client)\n    outgoing_ach_request = synctera_client.OutgoingAchRequest() # OutgoingAchRequest | Send ACH request\n    idempotency_key = \'7d943c51-e4ff-4e57-9558-08cab6b963c7\' # str | An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry. (optional)\n\n    try:\n        # Send an ACH\n        api_response = api_instance.add_transaction_out(outgoing_ach_request, idempotency_key=idempotency_key)\n        print("The response of ACHApi->add_transaction_out:\\n")\n        pprint(api_response)\n    except ApiException as e:\n        print("Exception when calling ACHApi->add_transaction_out: %s\\n" % e)\n\n```\n\n## Documentation for API Endpoints\n\nAll URIs are relative to *https://api.synctera.com/v0*\n\nClass | Method | HTTP request | Description\n------------ | ------------- | ------------- | -------------\n*ACHApi* | [**add_transaction_out**](docs/ACHApi.md#add_transaction_out) | **POST** /ach | Send an ACH\n*ACHApi* | [**get_transaction_out**](docs/ACHApi.md#get_transaction_out) | **GET** /ach/{transaction_id} | Get a sent ACH transaction\n*ACHApi* | [**list_transactions_out**](docs/ACHApi.md#list_transactions_out) | **GET** /ach | List sent ACH transactions\n*ACHApi* | [**patch_transaction_out**](docs/ACHApi.md#patch_transaction_out) | **PATCH** /ach/{transaction_id} | Update a sent ACH transaction\n*ACHTransactionSimulationsApi* | [**ach_return_simulation**](docs/ACHTransactionSimulationsApi.md#ach_return_simulation) | **POST** /ach/transaction_simulations/receiving_return | Simulate receiving ACH return\n*ACHTransactionSimulationsApi* | [**ach_transaction_simulation**](docs/ACHTransactionSimulationsApi.md#ach_transaction_simulation) | **POST** /ach/transaction_simulations/receiving_transaction | Simulate receiving ACH transaction\n*AccountsApi* | [**create_account**](docs/AccountsApi.md#create_account) | **POST** /accounts | Create an account\n*AccountsApi* | [**create_account_relationship**](docs/AccountsApi.md#create_account_relationship) | **POST** /accounts/{account_id}/relationships | Create account relationship\n*AccountsApi* | [**create_account_resource_product**](docs/AccountsApi.md#create_account_resource_product) | **POST** /accounts/products | Create an account product\n*AccountsApi* | [**create_account_template**](docs/AccountsApi.md#create_account_template) | **POST** /accounts/templates | Create an account template\n*AccountsApi* | [**delete_account_relationship**](docs/AccountsApi.md#delete_account_relationship) | **DELETE** /accounts/{account_id}/relationships/{relationship_id} | Delete account relationship\n*AccountsApi* | [**delete_account_template**](docs/AccountsApi.md#delete_account_template) | **DELETE** /accounts/templates/{template_id} | Delete account template\n*AccountsApi* | [**get_account**](docs/AccountsApi.md#get_account) | **GET** /accounts/{account_id} | Get account\n*AccountsApi* | [**get_account_relationship**](docs/AccountsApi.md#get_account_relationship) | **GET** /accounts/{account_id}/relationships/{relationship_id} | Get account relationship\n*AccountsApi* | [**get_account_template**](docs/AccountsApi.md#get_account_template) | **GET** /accounts/templates/{template_id} | Get account template\n*AccountsApi* | [**list_account_relationship**](docs/AccountsApi.md#list_account_relationship) | **GET** /accounts/{account_id}/relationships | List account relationships\n*AccountsApi* | [**list_account_resource_products**](docs/AccountsApi.md#list_account_resource_products) | **GET** /accounts/products | List account products\n*AccountsApi* | [**list_account_templates**](docs/AccountsApi.md#list_account_templates) | **GET** /accounts/templates | List account templates\n*AccountsApi* | [**list_accounts**](docs/AccountsApi.md#list_accounts) | **GET** /accounts | List accounts\n*AccountsApi* | [**patch_account**](docs/AccountsApi.md#patch_account) | **PATCH** /accounts/{account_id} | Patch account\n*AccountsApi* | [**patch_account_product**](docs/AccountsApi.md#patch_account_product) | **PATCH** /accounts/products/{product_id} | Patch account product\n*AccountsApi* | [**update_account**](docs/AccountsApi.md#update_account) | **PUT** /accounts/{account_id} | Update account\n*AccountsApi* | [**update_account_relationship**](docs/AccountsApi.md#update_account_relationship) | **PUT** /accounts/{account_id}/relationships/{relationship_id} | Update account relationship\n*AccountsApi* | [**update_account_template**](docs/AccountsApi.md#update_account_template) | **PUT** /accounts/templates/{template_id} | Update account template\n*BusinessesApi* | [**create_business**](docs/BusinessesApi.md#create_business) | **POST** /businesses | Create a business\n*BusinessesApi* | [**get_business**](docs/BusinessesApi.md#get_business) | **GET** /businesses/{business_id} | Get business\n*BusinessesApi* | [**list_businesses**](docs/BusinessesApi.md#list_businesses) | **GET** /businesses | List business\n*BusinessesApi* | [**update_business**](docs/BusinessesApi.md#update_business) | **PATCH** /businesses/{business_id} | Patch business\n*CardTransactionSimulationsApi* | [**simulate_authorization**](docs/CardTransactionSimulationsApi.md#simulate_authorization) | **POST** /cards/transaction_simulations/authorization | Simulate authorization\n*CardTransactionSimulationsApi* | [**simulate_authorization_advice**](docs/CardTransactionSimulationsApi.md#simulate_authorization_advice) | **POST** /cards/transaction_simulations/authorization/advice | Simulate authorization advice\n*CardTransactionSimulationsApi* | [**simulate_balance_inquiry**](docs/CardTransactionSimulationsApi.md#simulate_balance_inquiry) | **POST** /cards/transaction_simulations/financial/balance_inquiry | Simulate balance inquiry\n*CardTransactionSimulationsApi* | [**simulate_clearing**](docs/CardTransactionSimulationsApi.md#simulate_clearing) | **POST** /cards/transaction_simulations/clearing | Simulate clearing or refund\n*CardTransactionSimulationsApi* | [**simulate_financial**](docs/CardTransactionSimulationsApi.md#simulate_financial) | **POST** /cards/transaction_simulations/financial | Simulate financial\n*CardTransactionSimulationsApi* | [**simulate_financial_advice**](docs/CardTransactionSimulationsApi.md#simulate_financial_advice) | **POST** /cards/transaction_simulations/financial/advice | Simulate financial advice\n*CardTransactionSimulationsApi* | [**simulate_original_credit**](docs/CardTransactionSimulationsApi.md#simulate_original_credit) | **POST** /cards/transaction_simulations/financial/original_credit | Simulate OCT\n*CardTransactionSimulationsApi* | [**simulate_reversal**](docs/CardTransactionSimulationsApi.md#simulate_reversal) | **POST** /cards/transaction_simulations/reversal | Simulate reversal\n*CardTransactionSimulationsApi* | [**simulate_withdrawal**](docs/CardTransactionSimulationsApi.md#simulate_withdrawal) | **POST** /cards/transaction_simulations/financial/withdrawal | Simulate ATM withdrawal\n*CardWebhookSimulationsApi* | [**simulate_card_fulfillment_event**](docs/CardWebhookSimulationsApi.md#simulate_card_fulfillment_event) | **POST** /cards/{card_id}/webhook_simulations/fulfillment | Simulate Card Fulfillment Event\n*CardsApi* | [**activate_card**](docs/CardsApi.md#activate_card) | **POST** /cards/activate | Activate a card\n*CardsApi* | [**create_card_image**](docs/CardsApi.md#create_card_image) | **POST** /cards/images | Create Card Image\n*CardsApi* | [**create_gateway**](docs/CardsApi.md#create_gateway) | **POST** /cards/gateways | Create Gateway\n*CardsApi* | [**get_card**](docs/CardsApi.md#get_card) | **GET** /cards/{card_id} | Get Card\n*CardsApi* | [**get_card_barcode**](docs/CardsApi.md#get_card_barcode) | **GET** /cards/{card_id}/barcodes | Get Card Barcode\n*CardsApi* | [**get_card_image_data**](docs/CardsApi.md#get_card_image_data) | **GET** /cards/images/{card_image_id}/data | Get Card Image Data\n*CardsApi* | [**get_card_image_details**](docs/CardsApi.md#get_card_image_details) | **GET** /cards/images/{card_image_id} | Get Card Image Details\n*CardsApi* | [**get_card_widget_url**](docs/CardsApi.md#get_card_widget_url) | **GET** /cards/card_widget_url | Get card widget URL\n*CardsApi* | [**get_client_access_token**](docs/CardsApi.md#get_client_access_token) | **POST** /cards/{card_id}/client_token | Get a client token\n*CardsApi* | [**get_client_single_use_token**](docs/CardsApi.md#get_client_single_use_token) | **POST** /cards/single_use_token | Get single-use token\n*CardsApi* | [**get_gateway**](docs/CardsApi.md#get_gateway) | **GET** /cards/gateways/{gateway_id} | Get Gateway\n*CardsApi* | [**issue_card**](docs/CardsApi.md#issue_card) | **POST** /cards | Issue a Card\n*CardsApi* | [**list_card_image_details**](docs/CardsApi.md#list_card_image_details) | **GET** /cards/images | List Card Image Details\n*CardsApi* | [**list_card_products**](docs/CardsApi.md#list_card_products) | **GET** /cards/products | List Card Products\n*CardsApi* | [**list_cards**](docs/CardsApi.md#list_cards) | **GET** /cards | List Cards\n*CardsApi* | [**list_changes**](docs/CardsApi.md#list_changes) | **GET** /cards/{card_id}/changes | List Card Changes\n*CardsApi* | [**list_gateways**](docs/CardsApi.md#list_gateways) | **GET** /cards/gateways | List Gateways\n*CardsApi* | [**update_card**](docs/CardsApi.md#update_card) | **PATCH** /cards/{card_id} | Update Card\n*CardsApi* | [**update_card_image_details**](docs/CardsApi.md#update_card_image_details) | **PATCH** /cards/images/{card_image_id} | Update Card Image Details\n*CardsApi* | [**update_gateway**](docs/CardsApi.md#update_gateway) | **PATCH** /cards/gateways/{gateway_id} | Update Gateway\n*CardsApi* | [**upload_card_image_data**](docs/CardsApi.md#upload_card_image_data) | **POST** /cards/images/{card_image_id}/data | Upload Card Image\n*CashPickupsAlphaApi* | [**create_cash_pickup**](docs/CashPickupsAlphaApi.md#create_cash_pickup) | **POST** /cash_pickups | Create a cash pickup\n*CashPickupsAlphaApi* | [**get_cash_pickup**](docs/CashPickupsAlphaApi.md#get_cash_pickup) | **GET** /cash_pickups/{cash_pickup_id} | Get a cash pickup\n*CashPickupsAlphaApi* | [**list_cash_pickups**](docs/CashPickupsAlphaApi.md#list_cash_pickups) | **GET** /cash_pickups | List cash pickups\n*CashPickupsAlphaApi* | [**patch_cash_pickup**](docs/CashPickupsAlphaApi.md#patch_cash_pickup) | **PATCH** /cash_pickups/{cash_pickup_id} | Update a cash pickup\n*CustomersApi* | [**create_customer**](docs/CustomersApi.md#create_customer) | **POST** /customers | Create a Customer\n*CustomersApi* | [**create_customer_employment**](docs/CustomersApi.md#create_customer_employment) | **POST** /customers/{customer_id}/employment | Create employment record\n*CustomersApi* | [**create_customer_risk_rating**](docs/CustomersApi.md#create_customer_risk_rating) | **POST** /customers/{customer_id}/risk_ratings | Create customer risk rating\n*CustomersApi* | [**get_all_customer_employment**](docs/CustomersApi.md#get_all_customer_employment) | **GET** /customers/{customer_id}/employment | List customer employment records\n*CustomersApi* | [**get_all_customer_risk_ratings**](docs/CustomersApi.md#get_all_customer_risk_ratings) | **GET** /customers/{customer_id}/risk_ratings | List customer risk ratings\n*CustomersApi* | [**get_customer**](docs/CustomersApi.md#get_customer) | **GET** /customers/{customer_id} | Get Customer\n*CustomersApi* | [**get_customer_risk_rating**](docs/CustomersApi.md#get_customer_risk_rating) | **GET** /customers/{customer_id}/risk_ratings/{risk_rating_id} | Get customer risk rating\n*CustomersApi* | [**get_party_employment**](docs/CustomersApi.md#get_party_employment) | **GET** /customers/{customer_id}/employment/{employment_id} | Get customer employment record\n*CustomersApi* | [**list_customers**](docs/CustomersApi.md#list_customers) | **GET** /customers | List Customers\n*CustomersApi* | [**patch_customer**](docs/CustomersApi.md#patch_customer) | **PATCH** /customers/{customer_id} | Patch Customer\n*CustomersApi* | [**prefill_customer**](docs/CustomersApi.md#prefill_customer) | **POST** /customers/{customer_id}/prefill | Prefill customer\n*CustomersApi* | [**update_customer**](docs/CustomersApi.md#update_customer) | **PUT** /customers/{customer_id} | Update Customer\n*CustomersApi* | [**update_party_employment**](docs/CustomersApi.md#update_party_employment) | **PUT** /customers/{customer_id}/employment/{employment_id} | Update customer employment record\n*DigitalWalletTokensApi* | [**create_digital_wallet_apple**](docs/DigitalWalletTokensApi.md#create_digital_wallet_apple) | **POST** /cards/{card_id}/digital_wallet_tokens/applepay | Create digital wallet token provision request for Apple Pay\n*DigitalWalletTokensApi* | [**create_digital_wallet_google**](docs/DigitalWalletTokensApi.md#create_digital_wallet_google) | **POST** /cards/{card_id}/digital_wallet_tokens/googlepay | Create digital wallet token provision request for Google Pay\n*DigitalWalletTokensApi* | [**get_digital_wallet_token**](docs/DigitalWalletTokensApi.md#get_digital_wallet_token) | **GET** /cards/digital_wallet_tokens/{digital_wallet_token_id} | Get Digital Wallet Token\n*DigitalWalletTokensApi* | [**list_digital_wallet_tokens**](docs/DigitalWalletTokensApi.md#list_digital_wallet_tokens) | **GET** /cards/digital_wallet_tokens | List Digital Wallet Tokens\n*DigitalWalletTokensApi* | [**update_digital_wallet_token_status**](docs/DigitalWalletTokensApi.md#update_digital_wallet_token_status) | **PATCH** /cards/digital_wallet_tokens/{digital_wallet_token_id} | Update Digital Wallet Token&#39;s life cycle status\n*DisclosuresApi* | [**create_disclosure**](docs/DisclosuresApi.md#create_disclosure) | **POST** /disclosures | Create disclosure record\n*DisclosuresApi* | [**get_disclosure**](docs/DisclosuresApi.md#get_disclosure) | **GET** /disclosures/{disclosure_id} | Get disclosure\n*DisclosuresApi* | [**list_disclosures**](docs/DisclosuresApi.md#list_disclosures) | **GET** /disclosures | List disclosures\n*DisclosuresDeprecatedApi* | [**create_disclosure1**](docs/DisclosuresDeprecatedApi.md#create_disclosure1) | **POST** /customers/{customer_id}/disclosures | Create a Disclosure\n*DisclosuresDeprecatedApi* | [**list_disclosures1**](docs/DisclosuresDeprecatedApi.md#list_disclosures1) | **GET** /customers/{customer_id}/disclosures | List Disclosures\n*DocumentsApi* | [**create_document**](docs/DocumentsApi.md#create_document) | **POST** /documents | Create a document\n*DocumentsApi* | [**create_document_version**](docs/DocumentsApi.md#create_document_version) | **POST** /documents/{document_id}/versions | Create a new document version\n*DocumentsApi* | [**get_document**](docs/DocumentsApi.md#get_document) | **GET** /documents/{document_id} | Get a document\n*DocumentsApi* | [**get_document_contents**](docs/DocumentsApi.md#get_document_contents) | **GET** /documents/{document_id}/contents | Get contents of latest document version\n*DocumentsApi* | [**get_document_version**](docs/DocumentsApi.md#get_document_version) | **GET** /documents/{document_id}/versions/{document_version} | Get a document by version\n*DocumentsApi* | [**get_document_version_contents**](docs/DocumentsApi.md#get_document_version_contents) | **GET** /documents/{document_id}/versions/{document_version}/contents | Get document contents by version\n*DocumentsApi* | [**list_documents**](docs/DocumentsApi.md#list_documents) | **GET** /documents | List documents\n*DocumentsApi* | [**update_document**](docs/DocumentsApi.md#update_document) | **PATCH** /documents/{document_id} | Update a document\n*ExternalAccountsApi* | [**add_external_accounts**](docs/ExternalAccountsApi.md#add_external_accounts) | **POST** /external_accounts | Add an external account\n*ExternalAccountsApi* | [**add_vendor_external_accounts**](docs/ExternalAccountsApi.md#add_vendor_external_accounts) | **POST** /external_accounts/add_vendor_accounts | Add external accounts through a vendor, such as Plaid.\n*ExternalAccountsApi* | [**create_access_token**](docs/ExternalAccountsApi.md#create_access_token) | **POST** /external_accounts/access_tokens | Create a permanent access token for an external account\n*ExternalAccountsApi* | [**create_verification_link_token**](docs/ExternalAccountsApi.md#create_verification_link_token) | **POST** /external_accounts/link_tokens | Create a link token to verify an external account\n*ExternalAccountsApi* | [**delete_external_account**](docs/ExternalAccountsApi.md#delete_external_account) | **DELETE** /external_accounts/{external_account_id} | Delete an external account\n*ExternalAccountsApi* | [**get_external_account**](docs/ExternalAccountsApi.md#get_external_account) | **GET** /external_accounts/{external_account_id} | Get an external account\n*ExternalAccountsApi* | [**get_external_account_balance**](docs/ExternalAccountsApi.md#get_external_account_balance) | **GET** /external_accounts/{external_account_id}/balance | Get an external account balance\n*ExternalAccountsApi* | [**get_external_account_transactions**](docs/ExternalAccountsApi.md#get_external_account_transactions) | **GET** /external_accounts/{external_account_id}/transactions | List transactions of a given external account\n*ExternalAccountsApi* | [**list_external_accounts**](docs/ExternalAccountsApi.md#list_external_accounts) | **GET** /external_accounts | List external accounts\n*ExternalAccountsApi* | [**sync_vendor_external_accounts**](docs/ExternalAccountsApi.md#sync_vendor_external_accounts) | **POST** /external_accounts/sync_vendor_accounts | Sync external accounts through a vendor, such as Plaid.\n*ExternalAccountsApi* | [**update_external_account**](docs/ExternalAccountsApi.md#update_external_account) | **PATCH** /external_accounts/{external_account_id} | Patch an external account\n*ExternalCardsAlphaApi* | [**create_external_card_from_token**](docs/ExternalCardsAlphaApi.md#create_external_card_from_token) | **POST** /external_cards/tokens | Create External Card from token\n*ExternalCardsAlphaApi* | [**create_external_card_transfer**](docs/ExternalCardsAlphaApi.md#create_external_card_transfer) | **POST** /external_cards/transfers | Create External Card Transfer\n*ExternalCardsAlphaApi* | [**create_external_card_transfer_reversal**](docs/ExternalCardsAlphaApi.md#create_external_card_transfer_reversal) | **POST** /external_cards/transfers/{transfer_id}/reversals | Create External Card Transfer Reversal\n*ExternalCardsAlphaApi* | [**get_external_card**](docs/ExternalCardsAlphaApi.md#get_external_card) | **GET** /external_cards/{external_card_id} | Get External Card\n*ExternalCardsAlphaApi* | [**get_external_card_transfer**](docs/ExternalCardsAlphaApi.md#get_external_card_transfer) | **GET** /external_cards/transfers/{transfer_id} | Get External Card Transfer\n*ExternalCardsAlphaApi* | [**list_external_card_transfers**](docs/ExternalCardsAlphaApi.md#list_external_card_transfers) | **GET** /external_cards/transfers | List External Card Transfers\n*ExternalCardsAlphaApi* | [**list_external_cards**](docs/ExternalCardsAlphaApi.md#list_external_cards) | **GET** /external_cards | List External Cards\n*InternalAccountsApi* | [**add_internal_accounts**](docs/InternalAccountsApi.md#add_internal_accounts) | **POST** /internal_accounts | Add internal accounts\n*InternalAccountsApi* | [**get_internal_accounts**](docs/InternalAccountsApi.md#get_internal_accounts) | **GET** /internal_accounts/{internal_account_id} | Get internal account by id\n*InternalAccountsApi* | [**list_internal_accounts**](docs/InternalAccountsApi.md#list_internal_accounts) | **GET** /internal_accounts | List internal accounts\n*InternalAccountsApi* | [**patch_internal_account**](docs/InternalAccountsApi.md#patch_internal_account) | **PATCH** /internal_accounts/{internal_account_id} | Patch internal account\n*InternalTransferApi* | [**create_internal_transfer**](docs/InternalTransferApi.md#create_internal_transfer) | **POST** /transactions/internal_transfer | Create an internal transfer\n*InternalTransferApi* | [**get_internal_transfer_by_id**](docs/InternalTransferApi.md#get_internal_transfer_by_id) | **GET** /transactions/internal_transfer/{id} | Get an internal transfer\n*InternalTransferApi* | [**update_internal_transfer_by_id**](docs/InternalTransferApi.md#update_internal_transfer_by_id) | **PATCH** /transactions/internal_transfer/{id} | Update an internal transfer\n*KYCKYBVerificationsApi* | [**create_verification**](docs/KYCKYBVerificationsApi.md#create_verification) | **POST** /verifications | Create a verification\n*KYCKYBVerificationsApi* | [**get_verification1**](docs/KYCKYBVerificationsApi.md#get_verification1) | **GET** /verifications/{verification_id} | Get verification\n*KYCKYBVerificationsApi* | [**list_verifications1**](docs/KYCKYBVerificationsApi.md#list_verifications1) | **GET** /verifications | List verifications\n*KYCKYBVerificationsApi* | [**verify**](docs/KYCKYBVerificationsApi.md#verify) | **POST** /verifications/verify | Verify a customer&#39;s identity\n*KYCKYBVerificationsApi* | [**verify_ad_hoc**](docs/KYCKYBVerificationsApi.md#verify_ad_hoc) | **POST** /verifications/adhoc | Check if an individual is on any watchlists\n*KYCVerificationDeprecatedApi* | [**create_customer_verification_result**](docs/KYCVerificationDeprecatedApi.md#create_customer_verification_result) | **POST** /customers/{customer_id}/verifications | Create a customer verification result\n*KYCVerificationDeprecatedApi* | [**get_verification**](docs/KYCVerificationDeprecatedApi.md#get_verification) | **GET** /customers/{customer_id}/verifications/{verification_id} | Get verification result\n*KYCVerificationDeprecatedApi* | [**list_verifications**](docs/KYCVerificationDeprecatedApi.md#list_verifications) | **GET** /customers/{customer_id}/verifications | List verification results\n*KYCVerificationDeprecatedApi* | [**verify_customer**](docs/KYCVerificationDeprecatedApi.md#verify_customer) | **POST** /customers/{customer_id}/verify | Verify a customer&#39;s identity\n*MonitoringApi* | [**create_subscription**](docs/MonitoringApi.md#create_subscription) | **POST** /monitoring/subscriptions | Subscribe a customer or business to monitoring\n*MonitoringApi* | [**delete_subscription**](docs/MonitoringApi.md#delete_subscription) | **DELETE** /monitoring/subscriptions/{subscription_id} | Delete monitoring subscription\n*MonitoringApi* | [**get_alert**](docs/MonitoringApi.md#get_alert) | **GET** /monitoring/alerts/{alert_id} | Retrieve a monitoring alert\n*MonitoringApi* | [**get_subscription**](docs/MonitoringApi.md#get_subscription) | **GET** /monitoring/subscriptions/{subscription_id} | Retrieve monitoring subscription\n*MonitoringApi* | [**list_alerts**](docs/MonitoringApi.md#list_alerts) | **GET** /monitoring/alerts | List monitoring alerts\n*MonitoringApi* | [**list_subscriptions**](docs/MonitoringApi.md#list_subscriptions) | **GET** /monitoring/subscriptions | List monitoring subscriptions\n*MonitoringApi* | [**update_alert**](docs/MonitoringApi.md#update_alert) | **PATCH** /monitoring/alerts/{alert_id} | Update a monitoring alert\n*PaymentSchedulesApi* | [**create_payment_schedule**](docs/PaymentSchedulesApi.md#create_payment_schedule) | **POST** /payment_schedules | Create a payment schedule\n*PaymentSchedulesApi* | [**list_payment_schedules**](docs/PaymentSchedulesApi.md#list_payment_schedules) | **GET** /payment_schedules | List payment schedules\n*PaymentSchedulesApi* | [**list_payments**](docs/PaymentSchedulesApi.md#list_payments) | **GET** /payment_schedules/payments | List payments\n*PaymentSchedulesApi* | [**patch_payment_schedule**](docs/PaymentSchedulesApi.md#patch_payment_schedule) | **PATCH** /payment_schedules/{payment_schedule_id} | Update a payment schedule\n*PersonsApi* | [**create_person**](docs/PersonsApi.md#create_person) | **POST** /persons | Create a person\n*PersonsApi* | [**get_person**](docs/PersonsApi.md#get_person) | **GET** /persons/{person_id} | Get person\n*PersonsApi* | [**list_persons**](docs/PersonsApi.md#list_persons) | **GET** /persons | List persons\n*PersonsApi* | [**prefill_person**](docs/PersonsApi.md#prefill_person) | **POST** /persons/{person_id}/prefill | Prefill person\n*PersonsApi* | [**update_person**](docs/PersonsApi.md#update_person) | **PATCH** /persons/{person_id} | Update person\n*ReconciliationsApi* | [**create_reconciliation**](docs/ReconciliationsApi.md#create_reconciliation) | **POST** /reconciliations | Create a reconciliation\n*ReconciliationsApi* | [**get_reconciliation**](docs/ReconciliationsApi.md#get_reconciliation) | **GET** /reconciliations/{reconciliation_id} | Get reconciliation\n*ReconciliationsApi* | [**list_reconciliations**](docs/ReconciliationsApi.md#list_reconciliations) | **GET** /reconciliations | List reconciliations\n*RelationshipsApi* | [**create_relationship**](docs/RelationshipsApi.md#create_relationship) | **POST** /relationships | Create a relationship\n*RelationshipsApi* | [**delete_relationship**](docs/RelationshipsApi.md#delete_relationship) | **DELETE** /relationships/{relationship_id} | Delete relationship\n*RelationshipsApi* | [**get_relationship**](docs/RelationshipsApi.md#get_relationship) | **GET** /relationships/{relationship_id} | Get relationship\n*RelationshipsApi* | [**list_relationships**](docs/RelationshipsApi.md#list_relationships) | **GET** /relationships | List relationships\n*RelationshipsApi* | [**update_relationship**](docs/RelationshipsApi.md#update_relationship) | **PATCH** /relationships/{relationship_id} | Update relationship\n*RemoteCheckDepositBetaApi* | [**create_rdc_deposit**](docs/RemoteCheckDepositBetaApi.md#create_rdc_deposit) | **POST** /rdc/deposits | Create a Remote Check Deposit\n*RemoteCheckDepositBetaApi* | [**get_rdc_deposit**](docs/RemoteCheckDepositBetaApi.md#get_rdc_deposit) | **GET** /rdc/deposits/{deposit_id} | Get Remote Check Deposit\n*RemoteCheckDepositBetaApi* | [**list_rdc_deposits**](docs/RemoteCheckDepositBetaApi.md#list_rdc_deposits) | **GET** /rdc/deposits | List Remote Check Deposits\n*SandboxWipeAlphaApi* | [**wipe_workspace**](docs/SandboxWipeAlphaApi.md#wipe_workspace) | **POST** /wipe | Delete data\n*SpendControlsBetaApi* | [**create_spend_control**](docs/SpendControlsBetaApi.md#create_spend_control) | **POST** /spend_controls | Create Spend Control\n*SpendControlsBetaApi* | [**get_spend_control**](docs/SpendControlsBetaApi.md#get_spend_control) | **GET** /spend_controls/{spend_control_id} | Get Spend Control\n*SpendControlsBetaApi* | [**list_spend_controls**](docs/SpendControlsBetaApi.md#list_spend_controls) | **GET** /spend_controls | List Spend Controls\n*SpendControlsBetaApi* | [**update_spend_control**](docs/SpendControlsBetaApi.md#update_spend_control) | **PATCH** /spend_controls/{spend_control_id} | Update Spend Control\n*StatementsApi* | [**get_statement**](docs/StatementsApi.md#get_statement) | **GET** /statements/{statement_id} | Get a statement\n*StatementsApi* | [**list_statements**](docs/StatementsApi.md#list_statements) | **GET** /statements | List statements\n*TransactionsApi* | [**get_pending_transaction_by_id**](docs/TransactionsApi.md#get_pending_transaction_by_id) | **GET** /transactions/pending/{id} | Get a pending transaction\n*TransactionsApi* | [**get_posted_transaction_by_id**](docs/TransactionsApi.md#get_posted_transaction_by_id) | **GET** /transactions/posted/{id} | Get a posted transaction\n*TransactionsApi* | [**list_pending_transactions**](docs/TransactionsApi.md#list_pending_transactions) | **GET** /transactions/pending | List pending transactions\n*TransactionsApi* | [**list_posted_transactions**](docs/TransactionsApi.md#list_posted_transactions) | **GET** /transactions/posted | List posted transactions\n*WatchlistDeprecatedApi* | [**get_watchlist_alert**](docs/WatchlistDeprecatedApi.md#get_watchlist_alert) | **GET** /customers/{customer_id}/watchlists/alerts/{alert_id} | Retrieve watchlist monitoring alert\n*WatchlistDeprecatedApi* | [**get_watchlist_subscription**](docs/WatchlistDeprecatedApi.md#get_watchlist_subscription) | **GET** /customers/{customer_id}/watchlists/subscriptions/{subscription_id} | Retrieve watchlist monitoring subscription\n*WatchlistDeprecatedApi* | [**list_watchlist_alerts**](docs/WatchlistDeprecatedApi.md#list_watchlist_alerts) | **GET** /customers/{customer_id}/watchlists/alerts | List watchlist monitoring alerts for a customer\n*WatchlistDeprecatedApi* | [**list_watchlist_subscriptions**](docs/WatchlistDeprecatedApi.md#list_watchlist_subscriptions) | **GET** /customers/{customer_id}/watchlists/subscriptions | List watchlist monitoring subscriptions for a customer\n*WatchlistDeprecatedApi* | [**suppress_watchlist_entity_alert**](docs/WatchlistDeprecatedApi.md#suppress_watchlist_entity_alert) | **POST** /customers/{customer_id}/watchlists/suppressions | Suppress entity alert\n*WatchlistDeprecatedApi* | [**update_watchlist_alert**](docs/WatchlistDeprecatedApi.md#update_watchlist_alert) | **PUT** /customers/{customer_id}/watchlists/alerts/{alert_id} | Update watchlist alert\n*WatchlistDeprecatedApi* | [**update_watchlist_subscription**](docs/WatchlistDeprecatedApi.md#update_watchlist_subscription) | **PUT** /customers/{customer_id}/watchlists/subscriptions/{subscription_id} | Update watchlist monitoring subscription\n*WatchlistDeprecatedApi* | [**watchlist_subscribe**](docs/WatchlistDeprecatedApi.md#watchlist_subscribe) | **POST** /customers/{customer_id}/watchlists/subscriptions | Subscribe a customer to watchlist monitoring\n*WebhooksApi* | [**create_webhook1**](docs/WebhooksApi.md#create_webhook1) | **POST** /webhooks | Create a webhook\n*WebhooksApi* | [**delete_webhook**](docs/WebhooksApi.md#delete_webhook) | **DELETE** /webhooks/{webhook_id} | Delete a webhook\n*WebhooksApi* | [**get_event**](docs/WebhooksApi.md#get_event) | **GET** /webhooks/{webhook_id}/events/{event_id} | Get webhook event\n*WebhooksApi* | [**get_webhook1**](docs/WebhooksApi.md#get_webhook1) | **GET** /webhooks/{webhook_id} | Get a webhook\n*WebhooksApi* | [**list_events**](docs/WebhooksApi.md#list_events) | **GET** /webhooks/{webhook_id}/events | List webhook events\n*WebhooksApi* | [**list_webhooks1**](docs/WebhooksApi.md#list_webhooks1) | **GET** /webhooks | List webhooks\n*WebhooksApi* | [**resend_event**](docs/WebhooksApi.md#resend_event) | **POST** /webhooks/{webhook_id}/events/{event_id}/resend | Resend an event\n*WebhooksApi* | [**trigger_event**](docs/WebhooksApi.md#trigger_event) | **POST** /webhooks/trigger | Trigger an event\n*WebhooksApi* | [**update_webhook**](docs/WebhooksApi.md#update_webhook) | **PUT** /webhooks/{webhook_id} | Update a webhook\n*WiresAlphaApi* | [**cancel_wire**](docs/WiresAlphaApi.md#cancel_wire) | **PATCH** /wires/{wire_id} | Cancel an outgoing wire\n*WiresAlphaApi* | [**create_wire**](docs/WiresAlphaApi.md#create_wire) | **POST** /wires | Send a wire\n*WiresAlphaApi* | [**get_wire**](docs/WiresAlphaApi.md#get_wire) | **GET** /wires/{wire_id} | Get a wire by id\n*WiresAlphaApi* | [**list_wires**](docs/WiresAlphaApi.md#list_wires) | **GET** /wires | List wires\n\n\n## Documentation For Models\n\n - [Account](docs/Account.md)\n - [AccountAccessStatus](docs/AccountAccessStatus.md)\n - [AccountBase](docs/AccountBase.md)\n - [AccountChargeSecured](docs/AccountChargeSecured.md)\n - [AccountChargeSecuredAllOf](docs/AccountChargeSecuredAllOf.md)\n - [AccountCreation](docs/AccountCreation.md)\n - [AccountCreationAllOf](docs/AccountCreationAllOf.md)\n - [AccountDepository](docs/AccountDepository.md)\n - [AccountDepositoryAllOf](docs/AccountDepositoryAllOf.md)\n - [AccountGenericResponse](docs/AccountGenericResponse.md)\n - [AccountIdentifiers](docs/AccountIdentifiers.md)\n - [AccountLineOfCredit](docs/AccountLineOfCredit.md)\n - [AccountLineOfCreditAllOf](docs/AccountLineOfCreditAllOf.md)\n - [AccountList](docs/AccountList.md)\n - [AccountListAllOf](docs/AccountListAllOf.md)\n - [AccountProduct](docs/AccountProduct.md)\n - [AccountProductList](docs/AccountProductList.md)\n - [AccountProductListAllOf](docs/AccountProductListAllOf.md)\n - [AccountRange](docs/AccountRange.md)\n - [AccountRangeResponse](docs/AccountRangeResponse.md)\n - [AccountRangeResponseList](docs/AccountRangeResponseList.md)\n - [AccountRangeResponseListAllOf](docs/AccountRangeResponseListAllOf.md)\n - [AccountRangeUpdateRequest](docs/AccountRangeUpdateRequest.md)\n - [AccountRelationshipType](docs/AccountRelationshipType.md)\n - [AccountRouting](docs/AccountRouting.md)\n - [AccountSummary](docs/AccountSummary.md)\n - [AccountSummaryBalanceCeiling](docs/AccountSummaryBalanceCeiling.md)\n - [AccountSummaryBalanceFloor](docs/AccountSummaryBalanceFloor.md)\n - [AccountTemplate](docs/AccountTemplate.md)\n - [AccountTemplateResponse](docs/AccountTemplateResponse.md)\n - [AccountToAccountTransferRequest](docs/AccountToAccountTransferRequest.md)\n - [AccountType](docs/AccountType.md)\n - [AccountVerification](docs/AccountVerification.md)\n - [AccrualPayoutSchedule](docs/AccrualPayoutSchedule.md)\n - [AchInstruction](docs/AchInstruction.md)\n - [AchRequestHoldData](docs/AchRequestHoldData.md)\n - [AchReturnSimulationRequest](docs/AchReturnSimulationRequest.md)\n - [AchTransaction](docs/AchTransaction.md)\n - [AchTransactionAllOf](docs/AchTransactionAllOf.md)\n - [AchTransactionData](docs/AchTransactionData.md)\n - [AchTransactionSimulationRequest](docs/AchTransactionSimulationRequest.md)\n - [AchTransactionSubtypes](docs/AchTransactionSubtypes.md)\n - [AddAccountsRequest](docs/AddAccountsRequest.md)\n - [AddAccountsRequestAccountIdentifiers](docs/AddAccountsRequestAccountIdentifiers.md)\n - [AddAccountsRequestRoutingIdentifiers](docs/AddAccountsRequestRoutingIdentifiers.md)\n - [AddVendorAccountFailure](docs/AddVendorAccountFailure.md)\n - [AddVendorAccountsErrorReason](docs/AddVendorAccountsErrorReason.md)\n - [AddVendorAccountsRequest](docs/AddVendorAccountsRequest.md)\n - [AddVendorAccountsResponse](docs/AddVendorAccountsResponse.md)\n - [AdditionalData](docs/AdditionalData.md)\n - [AdditionalOwnerData](docs/AdditionalOwnerData.md)\n - [Address](docs/Address.md)\n - [Address1](docs/Address1.md)\n - [Address2](docs/Address2.md)\n - [AdhocVerificationRequest](docs/AdhocVerificationRequest.md)\n - [AdhocVerificationResponse](docs/AdhocVerificationResponse.md)\n - [Alias](docs/Alias.md)\n - [AliasList](docs/AliasList.md)\n - [AppleDigitalWalletProvisionRequest](docs/AppleDigitalWalletProvisionRequest.md)\n - [AppleDigitalWalletProvisionResponse](docs/AppleDigitalWalletProvisionResponse.md)\n - [ApplicationListResponse](docs/ApplicationListResponse.md)\n - [ApplicationListResponseAllOf](docs/ApplicationListResponseAllOf.md)\n - [ApplicationRequest](docs/ApplicationRequest.md)\n - [ApplicationResponse](docs/ApplicationResponse.md)\n - [ApplicationType](docs/ApplicationType.md)\n - [ApplicationUpdateRequest](docs/ApplicationUpdateRequest.md)\n - [AuthRequestModel](docs/AuthRequestModel.md)\n - [AuthorizationAdviceModel](docs/AuthorizationAdviceModel.md)\n - [Balance](docs/Balance.md)\n - [BalanceCeiling](docs/BalanceCeiling.md)\n - [BalanceFloor](docs/BalanceFloor.md)\n - [BalanceInquiryRequestModel](docs/BalanceInquiryRequestModel.md)\n - [BalanceType](docs/BalanceType.md)\n - [BanRule](docs/BanRule.md)\n - [BanRuleList](docs/BanRuleList.md)\n - [BanRuleListAllOf](docs/BanRuleListAllOf.md)\n - [BanRulePatch](docs/BanRulePatch.md)\n - [BanRuleStatus](docs/BanRuleStatus.md)\n - [BanStatus](docs/BanStatus.md)\n - [BankDebitNetworkResponse](docs/BankDebitNetworkResponse.md)\n - [BankDebitNetworkResponseAllOf](docs/BankDebitNetworkResponseAllOf.md)\n - [Base](docs/Base.md)\n - [BaseAccountVerification](docs/BaseAccountVerification.md)\n - [BaseCard](docs/BaseCard.md)\n - [BaseCardAllOf](docs/BaseCardAllOf.md)\n - [BaseCashPickup](docs/BaseCashPickup.md)\n - [BaseDisclosure](docs/BaseDisclosure.md)\n - [BaseMasterDisclosure](docs/BaseMasterDisclosure.md)\n - [BasePerson](docs/BasePerson.md)\n - [BasePerson1](docs/BasePerson1.md)\n - [BaseStatement](docs/BaseStatement.md)\n - [BaseStatementAllOf](docs/BaseStatementAllOf.md)\n - [BaseTemplateFields](docs/BaseTemplateFields.md)\n - [BaseTransaction](docs/BaseTransaction.md)\n - [BaseTransactionDecline](docs/BaseTransactionDecline.md)\n - [BillingAddress](docs/BillingAddress.md)\n - [BillingPeriod](docs/BillingPeriod.md)\n - [Bin](docs/Bin.md)\n - [BinAndDebitNetwork](docs/BinAndDebitNetwork.md)\n - [BinAndDebitNetworkList](docs/BinAndDebitNetworkList.md)\n - [BinAndDebitNetworkListAllOf](docs/BinAndDebitNetworkListAllOf.md)\n - [BinNetworkMapping](docs/BinNetworkMapping.md)\n - [BinNetworkMappingResponse](docs/BinNetworkMappingResponse.md)\n - [BinResponse](docs/BinResponse.md)\n - [BinResponseList](docs/BinResponseList.md)\n - [BinResponseListAllOf](docs/BinResponseListAllOf.md)\n - [BinStatus](docs/BinStatus.md)\n - [BinUpdateRequest](docs/BinUpdateRequest.md)\n - [Business](docs/Business.md)\n - [Business1](docs/Business1.md)\n - [BusinessBusinessOwnerRelationship](docs/BusinessBusinessOwnerRelationship.md)\n - [BusinessList](docs/BusinessList.md)\n - [BusinessListAllOf](docs/BusinessListAllOf.md)\n - [CalculationMethod](docs/CalculationMethod.md)\n - [CardAcceptorModel](docs/CardAcceptorModel.md)\n - [CardActivationRequest](docs/CardActivationRequest.md)\n - [CardBrand](docs/CardBrand.md)\n - [CardCategory](docs/CardCategory.md)\n - [CardChange](docs/CardChange.md)\n - [CardChangeState](docs/CardChangeState.md)\n - [CardChangesList](docs/CardChangesList.md)\n - [CardChangesListAllOf](docs/CardChangesListAllOf.md)\n - [CardEditRequest](docs/CardEditRequest.md)\n - [CardFormat](docs/CardFormat.md)\n - [CardFulfillmentStatus](docs/CardFulfillmentStatus.md)\n - [CardImageDetails](docs/CardImageDetails.md)\n - [CardImageDetailsList](docs/CardImageDetailsList.md)\n - [CardImageDetailsListAllOf](docs/CardImageDetailsListAllOf.md)\n - [CardImageMode](docs/CardImageMode.md)\n - [CardImageRejectionReason](docs/CardImageRejectionReason.md)\n - [CardImageStatus](docs/CardImageStatus.md)\n - [CardIssuanceRequest](docs/CardIssuanceRequest.md)\n - [CardListResponse](docs/CardListResponse.md)\n - [CardListResponseAllOf](docs/CardListResponseAllOf.md)\n - [CardOptions](docs/CardOptions.md)\n - [CardPin](docs/CardPin.md)\n - [CardPinStatus](docs/CardPinStatus.md)\n - [CardProduct](docs/CardProduct.md)\n - [CardProductAllOf](docs/CardProductAllOf.md)\n - [CardProductInternal](docs/CardProductInternal.md)\n - [CardProductInternalAllOf](docs/CardProductInternalAllOf.md)\n - [CardProductListResponse](docs/CardProductListResponse.md)\n - [CardProductListResponseAllOf](docs/CardProductListResponseAllOf.md)\n - [CardProductResponse](docs/CardProductResponse.md)\n - [CardProductType](docs/CardProductType.md)\n - [CardProductUpdateRequest](docs/CardProductUpdateRequest.md)\n - [CardProgram](docs/CardProgram.md)\n - [CardProgramResponse](docs/CardProgramResponse.md)\n - [CardProgramResponseList](docs/CardProgramResponseList.md)\n - [CardProgramResponseListAllOf](docs/CardProgramResponseListAllOf.md)\n - [CardProgramUpdateRequest](docs/CardProgramUpdateRequest.md)\n - [CardResponse](docs/CardResponse.md)\n - [CardStatus](docs/CardStatus.md)\n - [CardStatusObject](docs/CardStatusObject.md)\n - [CardStatusReasonCode](docs/CardStatusReasonCode.md)\n - [CardStatusRequest](docs/CardStatusRequest.md)\n - [CardTransaction](docs/CardTransaction.md)\n - [CardTransactionAllOf](docs/CardTransactionAllOf.md)\n - [CardTransactionData](docs/CardTransactionData.md)\n - [CardTransactionDataCurrencyConversion](docs/CardTransactionDataCurrencyConversion.md)\n - [CardTransactionDataMerchant](docs/CardTransactionDataMerchant.md)\n - [CardTransactionDataPos](docs/CardTransactionDataPos.md)\n - [CardTransactionSubtypes](docs/CardTransactionSubtypes.md)\n - [CardWidgetUrlResponse](docs/CardWidgetUrlResponse.md)\n - [CashPickup](docs/CashPickup.md)\n - [CashPickupAllOf](docs/CashPickupAllOf.md)\n - [CashPickupList](docs/CashPickupList.md)\n - [CashPickupListAllOf](docs/CashPickupListAllOf.md)\n - [CashPickupPatchRequest](docs/CashPickupPatchRequest.md)\n - [CashPickupPatchRequestAllOf](docs/CashPickupPatchRequestAllOf.md)\n - [CashPickupPostRequest](docs/CashPickupPostRequest.md)\n - [CashPickupStatus](docs/CashPickupStatus.md)\n - [ChangeChannel](docs/ChangeChannel.md)\n - [ChangeType](docs/ChangeType.md)\n - [CheckTransaction](docs/CheckTransaction.md)\n - [CheckTransactionAllOf](docs/CheckTransactionAllOf.md)\n - [CheckTransactionData](docs/CheckTransactionData.md)\n - [CheckTransactionSubtypes](docs/CheckTransactionSubtypes.md)\n - [ClearingModel](docs/ClearingModel.md)\n - [ClientToken](docs/ClientToken.md)\n - [ContestAch](docs/ContestAch.md)\n - [CreateCardImageRequest](docs/CreateCardImageRequest.md)\n - [CreateGatewayRequest](docs/CreateGatewayRequest.md)\n - [CreateWebhookRequest](docs/CreateWebhookRequest.md)\n - [CustomHeaders](docs/CustomHeaders.md)\n - [Customer](docs/Customer.md)\n - [CustomerAlias](docs/CustomerAlias.md)\n - [CustomerAliasList](docs/CustomerAliasList.md)\n - [CustomerAliasListAllOf](docs/CustomerAliasListAllOf.md)\n - [CustomerAllOf](docs/CustomerAllOf.md)\n - [CustomerInBody](docs/CustomerInBody.md)\n - [CustomerKycStatus](docs/CustomerKycStatus.md)\n - [CustomerList](docs/CustomerList.md)\n - [CustomerListAllOf](docs/CustomerListAllOf.md)\n - [CustomerType](docs/CustomerType.md)\n - [CustomerVerification](docs/CustomerVerification.md)\n - [CustomerVerificationResult](docs/CustomerVerificationResult.md)\n - [CustomerVerificationResultList](docs/CustomerVerificationResultList.md)\n - [CustomerVerificationResultListAllOf](docs/CustomerVerificationResultListAllOf.md)\n - [CustomerVerifyResponse](docs/CustomerVerifyResponse.md)\n - [CustomerVerifyResponseAllOf](docs/CustomerVerifyResponseAllOf.md)\n - [DcSign](docs/DcSign.md)\n - [DebitNetwork](docs/DebitNetwork.md)\n - [DebitNetworkCreateRequest](docs/DebitNetworkCreateRequest.md)\n - [DebitNetworkResponse](docs/DebitNetworkResponse.md)\n - [DebitNetworkResponseList](docs/DebitNetworkResponseList.md)\n - [DebitNetworkResponseListAllOf](docs/DebitNetworkResponseListAllOf.md)\n - [DeleteResponse](docs/DeleteResponse.md)\n - [Deposit](docs/Deposit.md)\n - [DepositList](docs/DepositList.md)\n - [DepositListAllOf](docs/DepositListAllOf.md)\n - [DepositPatchRequest](docs/DepositPatchRequest.md)\n - [Detail](docs/Detail.md)\n - [DeviceType](docs/DeviceType.md)\n - [DigitalWalletTokenAddressVerification](docs/DigitalWalletTokenAddressVerification.md)\n - [DigitalWalletTokenEditRequest](docs/DigitalWalletTokenEditRequest.md)\n - [DigitalWalletTokenResponse](docs/DigitalWalletTokenResponse.md)\n - [DigitalWalletTokenState](docs/DigitalWalletTokenState.md)\n - [DigitalWalletTokenization](docs/DigitalWalletTokenization.md)\n - [Disclosure](docs/Disclosure.md)\n - [Disclosure1](docs/Disclosure1.md)\n - [DisclosureList](docs/DisclosureList.md)\n - [DisclosureListAllOf](docs/DisclosureListAllOf.md)\n - [DisclosureResponse](docs/DisclosureResponse.md)\n - [DisclosureType](docs/DisclosureType.md)\n - [DishonorAch](docs/DishonorAch.md)\n - [Document](docs/Document.md)\n - [DocumentList](docs/DocumentList.md)\n - [DocumentListAllOf](docs/DocumentListAllOf.md)\n - [DocumentType](docs/DocumentType.md)\n - [EmbossName](docs/EmbossName.md)\n - [Employment](docs/Employment.md)\n - [EmploymentList](docs/EmploymentList.md)\n - [EmploymentListAllOf](docs/EmploymentListAllOf.md)\n - [Encryption](docs/Encryption.md)\n - [EnhancedTransactionData](docs/EnhancedTransactionData.md)\n - [EnhancedTransactionDataEnhancedRawInner](docs/EnhancedTransactionDataEnhancedRawInner.md)\n - [Environment](docs/Environment.md)\n - [Error](docs/Error.md)\n - [EvaluationContext](docs/EvaluationContext.md)\n - [EvaluationContextCustomer](docs/EvaluationContextCustomer.md)\n - [EvaluationResponse](docs/EvaluationResponse.md)\n - [EvaluationResult](docs/EvaluationResult.md)\n - [Event](docs/Event.md)\n - [EventList](docs/EventList.md)\n - [EventListAllOf](docs/EventListAllOf.md)\n - [EventResend](docs/EventResend.md)\n - [EventTrigger](docs/EventTrigger.md)\n - [EventType](docs/EventType.md)\n - [EventType1](docs/EventType1.md)\n - [EventTypeExplicit](docs/EventTypeExplicit.md)\n - [EventTypeWildcard](docs/EventTypeWildcard.md)\n - [ExtAccountCustomerType](docs/ExtAccountCustomerType.md)\n - [ExternalAccount](docs/ExternalAccount.md)\n - [ExternalAccountAccessToken](docs/ExternalAccountAccessToken.md)\n - [ExternalAccountBalance](docs/ExternalAccountBalance.md)\n - [ExternalAccountLinkToken](docs/ExternalAccountLinkToken.md)\n - [ExternalAccountTransaction](docs/ExternalAccountTransaction.md)\n - [ExternalAccountVendorData](docs/ExternalAccountVendorData.md)\n - [ExternalAccountVendorValues](docs/ExternalAccountVendorValues.md)\n - [ExternalAccountsList](docs/ExternalAccountsList.md)\n - [ExternalAccountsListAllOf](docs/ExternalAccountsListAllOf.md)\n - [ExternalAccountsTransactionList](docs/ExternalAccountsTransactionList.md)\n - [ExternalCardListResponse](docs/ExternalCardListResponse.md)\n - [ExternalCardListResponseAllOf](docs/ExternalCardListResponseAllOf.md)\n - [ExternalCardRequest](docs/ExternalCardRequest.md)\n - [ExternalCardResponse](docs/ExternalCardResponse.md)\n - [ExternalCardTransaction](docs/ExternalCardTransaction.md)\n - [ExternalCardTransactionAllOf](docs/ExternalCardTransactionAllOf.md)\n - [ExternalCardTransactionSubtypes](docs/ExternalCardTransactionSubtypes.md)\n - [ExternalCardVerifications](docs/ExternalCardVerifications.md)\n - [ExternalPaymentDate](docs/ExternalPaymentDate.md)\n - [Fee](docs/Fee.md)\n - [FinancialInstitution](docs/FinancialInstitution.md)\n - [FinancialRequestModel](docs/FinancialRequestModel.md)\n - [FinicityAccountVerification](docs/FinicityAccountVerification.md)\n - [Form](docs/Form.md)\n - [FulfillmentDetails](docs/FulfillmentDetails.md)\n - [FundingSource](docs/FundingSource.md)\n - [FundingSourceResponse](docs/FundingSourceResponse.md)\n - [FundingSourceResponseList](docs/FundingSourceResponseList.md)\n - [GatewayListResponse](docs/GatewayListResponse.md)\n - [GatewayListResponseAllOf](docs/GatewayListResponseAllOf.md)\n - [GatewayResponse](docs/GatewayResponse.md)\n - [GetCardBarcode200Response](docs/GetCardBarcode200Response.md)\n - [GetViralLoopWaitlists](docs/GetViralLoopWaitlists.md)\n - [GoogleDigitalWalletProvisionRequest](docs/GoogleDigitalWalletProvisionRequest.md)\n - [GoogleDigitalWalletProvisionResponse](docs/GoogleDigitalWalletProvisionResponse.md)\n - [HoldCancelRequest](docs/HoldCancelRequest.md)\n - [HoldCreateRequest](docs/HoldCreateRequest.md)\n - [HoldCreateRequestStatus](docs/HoldCreateRequestStatus.md)\n - [HoldData](docs/HoldData.md)\n - [HoldDeclineRequest](docs/HoldDeclineRequest.md)\n - [HoldModifyRequest](docs/HoldModifyRequest.md)\n - [HoldPatchRequest](docs/HoldPatchRequest.md)\n - [HoldPostingRequest](docs/HoldPostingRequest.md)\n - [InAppProvisioning](docs/InAppProvisioning.md)\n - [IngestionStatus](docs/IngestionStatus.md)\n - [Interest](docs/Interest.md)\n - [InternalAccount](docs/InternalAccount.md)\n - [InternalAccountPatch](docs/InternalAccountPatch.md)\n - [InternalAccountPurpose](docs/InternalAccountPurpose.md)\n - [InternalAccountType](docs/InternalAccountType.md)\n - [InternalAccountsList](docs/InternalAccountsList.md)\n - [InternalAccountsListAllOf](docs/InternalAccountsListAllOf.md)\n - [InternalTransfer](docs/InternalTransfer.md)\n - [InternalTransferInstruction](docs/InternalTransferInstruction.md)\n - [InternalTransferPatch](docs/InternalTransferPatch.md)\n - [InternalTransferResponse](docs/InternalTransferResponse.md)\n - [InternalTransferResponseAllOf](docs/InternalTransferResponseAllOf.md)\n - [InternalTransferTransaction](docs/InternalTransferTransaction.md)\n - [InternalTransferTransactionAllOf](docs/InternalTransferTransactionAllOf.md)\n - [InternalTransferTransactionData](docs/InternalTransferTransactionData.md)\n - [InternalTransferTransactionSubtypes](docs/InternalTransferTransactionSubtypes.md)\n - [ManualAccountVerification](docs/ManualAccountVerification.md)\n - [ManualEntry](docs/ManualEntry.md)\n - [MasterDisclosure](docs/MasterDisclosure.md)\n - [MasterDisclosureList](docs/MasterDisclosureList.md)\n - [MasterDisclosureListAllOf](docs/MasterDisclosureListAllOf.md)\n - [Merchant](docs/Merchant.md)\n - [MinimumPayment](docs/MinimumPayment.md)\n - [MinimumPaymentFull](docs/MinimumPaymentFull.md)\n - [MinimumPaymentPartial](docs/MinimumPaymentPartial.md)\n - [MinimumPaymentType](docs/MinimumPaymentType.md)\n - [MinimumPaymentTypeFull](docs/MinimumPaymentTypeFull.md)\n - [MinimumPaymentTypeRateOrAmount](docs/MinimumPaymentTypeRateOrAmount.md)\n - [MonitoringAlert](docs/MonitoringAlert.md)\n - [MonitoringAlertList](docs/MonitoringAlertList.md)\n - [MonitoringAlertListAllOf](docs/MonitoringAlertListAllOf.md)\n - [MonitoringStatus](docs/MonitoringStatus.md)\n - [MonitoringSubscription](docs/MonitoringSubscription.md)\n - [MonitoringSubscriptionList](docs/MonitoringSubscriptionList.md)\n - [MonitoringSubscriptionListAllOf](docs/MonitoringSubscriptionListAllOf.md)\n - [NetworkFeeModel](docs/NetworkFeeModel.md)\n - [NoteCreate](docs/NoteCreate.md)\n - [NoteList](docs/NoteList.md)\n - [NoteListAllOf](docs/NoteListAllOf.md)\n - [NoteResponse](docs/NoteResponse.md)\n - [OriginalCreditRequestModel](docs/OriginalCreditRequestModel.md)\n - [OriginalCreditSenderData](docs/OriginalCreditSenderData.md)\n - [OutgoingAch](docs/OutgoingAch.md)\n - [OutgoingAchList](docs/OutgoingAchList.md)\n - [OutgoingAchListAllOf](docs/OutgoingAchListAllOf.md)\n - [OutgoingAchPatch](docs/OutgoingAchPatch.md)\n - [OutgoingAchRequest](docs/OutgoingAchRequest.md)\n - [PaginatedResponse](docs/PaginatedResponse.md)\n - [PaginatedResponse1](docs/PaginatedResponse1.md)\n - [PaginatedTransactions](docs/PaginatedTransactions.md)\n - [PatchAccountProduct](docs/PatchAccountProduct.md)\n - [PatchAccountsRequestAccountIdentifiers](docs/PatchAccountsRequestAccountIdentifiers.md)\n - [PatchAccountsRequestRoutingIdentifiers](docs/PatchAccountsRequestRoutingIdentifiers.md)\n - [PatchBanStatus](docs/PatchBanStatus.md)\n - [PatchBusiness](docs/PatchBusiness.md)\n - [PatchBusinessBusinessOwnerRelationship](docs/PatchBusinessBusinessOwnerRelationship.md)\n - [PatchBusinessBusinessOwnerRelationshipAllOf](docs/PatchBusinessBusinessOwnerRelationshipAllOf.md)\n - [PatchCustomer](docs/PatchCustomer.md)\n - [PatchDocument](docs/PatchDocument.md)\n - [PatchExternalAccount](docs/PatchExternalAccount.md)\n - [PatchInterest](docs/PatchInterest.md)\n - [PatchPaymentSchedule](docs/PatchPaymentSchedule.md)\n - [PatchPerson](docs/PatchPerson.md)\n - [PatchPersonBusinessOwnerRelationship](docs/PatchPersonBusinessOwnerRelationship.md)\n - [PatchPersonBusinessOwnerRelationshipAllOf](docs/PatchPersonBusinessOwnerRelationshipAllOf.md)\n - [PatchPersonBusinessRelationship](docs/PatchPersonBusinessRelationship.md)\n - [PatchPersonBusinessRelationshipAllOf](docs/PatchPersonBusinessRelationshipAllOf.md)\n - [PatchRelationshipIn](docs/PatchRelationshipIn.md)\n - [Payment](docs/Payment.md)\n - [PaymentDate](docs/PaymentDate.md)\n - [PaymentErrorDetails](docs/PaymentErrorDetails.md)\n - [PaymentInstruction](docs/PaymentInstruction.md)\n - [PaymentList](docs/PaymentList.md)\n - [PaymentListAllOf](docs/PaymentListAllOf.md)\n - [PaymentSchedule](docs/PaymentSchedule.md)\n - [PaymentScheduleList](docs/PaymentScheduleList.md)\n - [PaymentScheduleListAllOf](docs/PaymentScheduleListAllOf.md)\n - [PaymentScheduleStatus](docs/PaymentScheduleStatus.md)\n - [PaymentStatus](docs/PaymentStatus.md)\n - [PaymentType](docs/PaymentType.md)\n - [PendingTransaction](docs/PendingTransaction.md)\n - [PendingTransactionData](docs/PendingTransactionData.md)\n - [PendingTransactionHistory](docs/PendingTransactionHistory.md)\n - [PendingTransactionHistoryData](docs/PendingTransactionHistoryData.md)\n - [PendingTransactions](docs/PendingTransactions.md)\n - [Person](docs/Person.md)\n - [Person1](docs/Person1.md)\n - [PersonBusinessOwnerRelationship](docs/PersonBusinessOwnerRelationship.md)\n - [PersonBusinessRelationship](docs/PersonBusinessRelationship.md)\n - [PersonList](docs/PersonList.md)\n - [PersonListAllOf](docs/PersonListAllOf.md)\n - [PhysicalCard](docs/PhysicalCard.md)\n - [PhysicalCardAllOf](docs/PhysicalCardAllOf.md)\n - [PhysicalCardFormat](docs/PhysicalCardFormat.md)\n - [PhysicalCardIssuanceRequest](docs/PhysicalCardIssuanceRequest.md)\n - [PhysicalCardPlusStatus](docs/PhysicalCardPlusStatus.md)\n - [PhysicalCardResponse](docs/PhysicalCardResponse.md)\n - [PhysicalCardResponseAllOf](docs/PhysicalCardResponseAllOf.md)\n - [PhysicalCardResponseStatus](docs/PhysicalCardResponseStatus.md)\n - [PhysicalCardResponseStatusAllOf](docs/PhysicalCardResponseStatusAllOf.md)\n - [PingResponse](docs/PingResponse.md)\n - [PlaidAccountVerification](docs/PlaidAccountVerification.md)\n - [PostedTransaction](docs/PostedTransaction.md)\n - [PostedTransactionData](docs/PostedTransactionData.md)\n - [PostedTransactionReverseRequest](docs/PostedTransactionReverseRequest.md)\n - [PostedTransactions](docs/PostedTransactions.md)\n - [PrefillRequest](docs/PrefillRequest.md)\n - [Prospect](docs/Prospect.md)\n - [Prospect1](docs/Prospect1.md)\n - [Prospect1AllOf](docs/Prospect1AllOf.md)\n - [ProspectEditable](docs/ProspectEditable.md)\n - [ProspectStatus](docs/ProspectStatus.md)\n - [ProspectsList](docs/ProspectsList.md)\n - [ProspectsListAllOf](docs/ProspectsListAllOf.md)\n - [ProviderType](docs/ProviderType.md)\n - [ProvisioningControls](docs/ProvisioningControls.md)\n - [PushTokenizeRequestData](docs/PushTokenizeRequestData.md)\n - [QuickstartT10](docs/QuickstartT10.md)\n - [QuickstartT10Response](docs/QuickstartT10Response.md)\n - [RateDetails](docs/RateDetails.md)\n - [RawResponse](docs/RawResponse.md)\n - [RecipientName](docs/RecipientName.md)\n - [Reconciliation](docs/Reconciliation.md)\n - [ReconciliationInput](docs/ReconciliationInput.md)\n - [ReconciliationList](docs/ReconciliationList.md)\n - [ReconciliationListAllOf](docs/ReconciliationListAllOf.md)\n - [RelatedResourceType](docs/RelatedResourceType.md)\n - [RelatedResourceType1](docs/RelatedResourceType1.md)\n - [Relationship](docs/Relationship.md)\n - [Relationship1](docs/Relationship1.md)\n - [RelationshipIn](docs/RelationshipIn.md)\n - [RelationshipList](docs/RelationshipList.md)\n - [RelationshipListAllOf](docs/RelationshipListAllOf.md)\n - [RelationshipRole](docs/RelationshipRole.md)\n - [RelationshipsList](docs/RelationshipsList.md)\n - [RelationshipsListAllOf](docs/RelationshipsListAllOf.md)\n - [ResendResponse](docs/ResendResponse.md)\n - [ResourceType](docs/ResourceType.md)\n - [ResponseHistoryItem](docs/ResponseHistoryItem.md)\n - [ReturnAch](docs/ReturnAch.md)\n - [ReversalModel](docs/ReversalModel.md)\n - [RiskData](docs/RiskData.md)\n - [RiskRating](docs/RiskRating.md)\n - [RiskRatingList](docs/RiskRatingList.md)\n - [RiskRatingListAllOf](docs/RiskRatingListAllOf.md)\n - [SavingsSummary](docs/SavingsSummary.md)\n - [ScheduleConfig](docs/ScheduleConfig.md)\n - [Security](docs/Security.md)\n - [Shipping](docs/Shipping.md)\n - [SimulateCardFulfillment](docs/SimulateCardFulfillment.md)\n - [SingleUseTokenRequest](docs/SingleUseTokenRequest.md)\n - [SingleUseTokenResponse](docs/SingleUseTokenResponse.md)\n - [SocureEventBody](docs/SocureEventBody.md)\n - [SocureGlobalWatchlist](docs/SocureGlobalWatchlist.md)\n - [SocureMatch](docs/SocureMatch.md)\n - [SocureMatchComments](docs/SocureMatchComments.md)\n - [SocureWatchlistResult](docs/SocureWatchlistResult.md)\n - [SpendControl](docs/SpendControl.md)\n - [SpendControlDirection](docs/SpendControlDirection.md)\n - [SpendControlResponse](docs/SpendControlResponse.md)\n - [SpendControlResponseAllOf](docs/SpendControlResponseAllOf.md)\n - [SpendControlResponseList](docs/SpendControlResponseList.md)\n - [SpendControlResponseListAllOf](docs/SpendControlResponseListAllOf.md)\n - [SpendControlRollingWindowDays](docs/SpendControlRollingWindowDays.md)\n - [SpendControlRollingWindowDaysAllOf](docs/SpendControlRollingWindowDaysAllOf.md)\n - [SpendControlTimeRange](docs/SpendControlTimeRange.md)\n - [SpendControlTimeRangeType](docs/SpendControlTimeRangeType.md)\n - [SpendControlUpdateRequest](docs/SpendControlUpdateRequest.md)\n - [SpendingLimitWithTime](docs/SpendingLimitWithTime.md)\n - [SpendingLimits](docs/SpendingLimits.md)\n - [SpendingLimitsTransaction](docs/SpendingLimitsTransaction.md)\n - [SsnSource](docs/SsnSource.md)\n - [Statement](docs/Statement.md)\n - [StatementAllOf](docs/StatementAllOf.md)\n - [StatementList](docs/StatementList.md)\n - [StatementListAllOf](docs/StatementListAllOf.md)\n - [StatementSummary](docs/StatementSummary.md)\n - [Status](docs/Status.md)\n - [Status1](docs/Status1.md)\n - [TemplateFields](docs/TemplateFields.md)\n - [TemplateFieldsChargeSecured](docs/TemplateFieldsChargeSecured.md)\n - [TemplateFieldsChargeSecuredAllOf](docs/TemplateFieldsChargeSecuredAllOf.md)\n - [TemplateFieldsDepository](docs/TemplateFieldsDepository.md)\n - [TemplateFieldsDepositoryAllOf](docs/TemplateFieldsDepositoryAllOf.md)\n - [TemplateFieldsGenericResponse](docs/TemplateFieldsGenericResponse.md)\n - [TemplateFieldsLineOfCredit](docs/TemplateFieldsLineOfCredit.md)\n - [TemplateFieldsLineOfCreditAllOf](docs/TemplateFieldsLineOfCreditAllOf.md)\n - [TemplateList](docs/TemplateList.md)\n - [TemplateListAllOf](docs/TemplateListAllOf.md)\n - [TokenList](docs/TokenList.md)\n - [TokenListResponse](docs/TokenListResponse.md)\n - [Transaction](docs/Transaction.md)\n - [Transaction1](docs/Transaction1.md)\n - [TransactionData](docs/TransactionData.md)\n - [TransactionDirectPostRequest](docs/TransactionDirectPostRequest.md)\n - [TransactionLine](docs/TransactionLine.md)\n - [TransactionLine1](docs/TransactionLine1.md)\n - [TransactionOptions](docs/TransactionOptions.md)\n - [TransactionUpdateMetaRequest](docs/TransactionUpdateMetaRequest.md)\n - [TransferListResponse](docs/TransferListResponse.md)\n - [TransferListResponseAllOf](docs/TransferListResponseAllOf.md)\n - [TransferRequest](docs/TransferRequest.md)\n - [TransferResponse](docs/TransferResponse.md)\n - [TransferReversalRequest](docs/TransferReversalRequest.md)\n - [TransferType](docs/TransferType.md)\n - [TransferTypeRequest](docs/TransferTypeRequest.md)\n - [TriggerEventRequest](docs/TriggerEventRequest.md)\n - [TxnEnhancer](docs/TxnEnhancer.md)\n - [UpdateCardImageRequest](docs/UpdateCardImageRequest.md)\n - [UpdateGatewayRequest](docs/UpdateGatewayRequest.md)\n - [UpdateTransfer](docs/UpdateTransfer.md)\n - [VendorInfo](docs/VendorInfo.md)\n - [VendorInfo1](docs/VendorInfo1.md)\n - [VendorJson](docs/VendorJson.md)\n - [VendorXml](docs/VendorXml.md)\n - [Verification](docs/Verification.md)\n - [VerificationAllOf](docs/VerificationAllOf.md)\n - [VerificationList](docs/VerificationList.md)\n - [VerificationListAllOf](docs/VerificationListAllOf.md)\n - [VerificationRequest](docs/VerificationRequest.md)\n - [VerificationRequestAllOf](docs/VerificationRequestAllOf.md)\n - [VerificationResult](docs/VerificationResult.md)\n - [VerificationStatus](docs/VerificationStatus.md)\n - [VerificationType](docs/VerificationType.md)\n - [VerificationType1](docs/VerificationType1.md)\n - [VerificationVendorInfo](docs/VerificationVendorInfo.md)\n - [VerificationVendorInfoDetail](docs/VerificationVendorInfoDetail.md)\n - [VerificationVendorJson](docs/VerificationVendorJson.md)\n - [VerificationVendorXml](docs/VerificationVendorXml.md)\n - [VerifyResponse](docs/VerifyResponse.md)\n - [VerifyResponseAllOf](docs/VerifyResponseAllOf.md)\n - [ViralLoopWaitlists](docs/ViralLoopWaitlists.md)\n - [VirtualCard](docs/VirtualCard.md)\n - [VirtualCardIssuanceRequest](docs/VirtualCardIssuanceRequest.md)\n - [VirtualCardPlusStatus](docs/VirtualCardPlusStatus.md)\n - [VirtualCardResponse](docs/VirtualCardResponse.md)\n - [VirtualCardResponseAllOf](docs/VirtualCardResponseAllOf.md)\n - [VirtualCardResponseStatus](docs/VirtualCardResponseStatus.md)\n - [Waitlist](docs/Waitlist.md)\n - [WaitlistAllOf](docs/WaitlistAllOf.md)\n - [WaitlistAnalytics](docs/WaitlistAnalytics.md)\n - [WaitlistAnalyticsList](docs/WaitlistAnalyticsList.md)\n - [WaitlistEditable](docs/WaitlistEditable.md)\n - [WaitlistsList](docs/WaitlistsList.md)\n - [WaitlistsListAllOf](docs/WaitlistsListAllOf.md)\n - [WalletProviderCardOnFile](docs/WalletProviderCardOnFile.md)\n - [WatchlistAlert](docs/WatchlistAlert.md)\n - [WatchlistAlertList](docs/WatchlistAlertList.md)\n - [WatchlistAlertListAllOf](docs/WatchlistAlertListAllOf.md)\n - [WatchlistSubscription](docs/WatchlistSubscription.md)\n - [WatchlistSubscriptionList](docs/WatchlistSubscriptionList.md)\n - [WatchlistSubscriptionListAllOf](docs/WatchlistSubscriptionListAllOf.md)\n - [WatchlistSuppress](docs/WatchlistSuppress.md)\n - [Webhook](docs/Webhook.md)\n - [WebhookConfig](docs/WebhookConfig.md)\n - [WebhookList](docs/WebhookList.md)\n - [WebhookListAllOf](docs/WebhookListAllOf.md)\n - [WebhookRequest](docs/WebhookRequest.md)\n - [WebhookRequestObject](docs/WebhookRequestObject.md)\n - [WebhookResponse](docs/WebhookResponse.md)\n - [WebhookResponseAllOf](docs/WebhookResponseAllOf.md)\n - [WidgetType](docs/WidgetType.md)\n - [Wire](docs/Wire.md)\n - [WireList](docs/WireList.md)\n - [WireListAllOf](docs/WireListAllOf.md)\n - [WireRequest](docs/WireRequest.md)\n - [WireTransaction](docs/WireTransaction.md)\n - [WireTransactionAllOf](docs/WireTransactionAllOf.md)\n - [WireTransactionData](docs/WireTransactionData.md)\n - [WireTransactionSubtypes](docs/WireTransactionSubtypes.md)\n - [WithdrawalRequestModel](docs/WithdrawalRequestModel.md)\n - [Workspace](docs/Workspace.md)\n - [WorkspaceList](docs/WorkspaceList.md)\n - [WorkspaceListAllOf](docs/WorkspaceListAllOf.md)\n\n\n## Documentation For Authorization\n\n\n## bearerAuth\n\n- **Type**: Bearer authentication (api_key)\n\n\n## Author\n\n\n\n\n',
    'author': 'Swadesh',
    'author_email': 'dev@swadesh.co',
    'maintainer': 'D. Kasi Pavan Kumar',
    'maintainer_email': 'kasi@swadesh.co',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
