// modules are defined as an array
// [ module function, map of requires ]
//
// map of requires is short require name -> numeric require
//
// anything defined in a previous bundle is accessed via the
// orig method which is the require for previous bundles
parcelRequire = (function (modules, cache, entry, globalName) {
  // Save the require from previous bundle to this closure if any
  var previousRequire = typeof parcelRequire === 'function' && parcelRequire;
  var nodeRequire = typeof require === 'function' && require;

  function newRequire(name, jumped) {
    if (!cache[name]) {
      if (!modules[name]) {
        // if we cannot find the module within our internal map or
        // cache jump to the current global require ie. the last bundle
        // that was added to the page.
        var currentRequire = typeof parcelRequire === 'function' && parcelRequire;
        if (!jumped && currentRequire) {
          return currentRequire(name, true);
        }

        // If there are other bundles on this page the require from the
        // previous one is saved to 'previousRequire'. Repeat this as
        // many times as there are bundles until the module is found or
        // we exhaust the require chain.
        if (previousRequire) {
          return previousRequire(name, true);
        }

        // Try the node require function if it exists.
        if (nodeRequire && typeof name === 'string') {
          return nodeRequire(name);
        }

        var err = new Error('Cannot find module \'' + name + '\'');
        err.code = 'MODULE_NOT_FOUND';
        throw err;
      }

      localRequire.resolve = resolve;
      localRequire.cache = {};

      var module = cache[name] = new newRequire.Module(name);

      modules[name][0].call(module.exports, localRequire, module, module.exports, this);
    }

    return cache[name].exports;

    function localRequire(x){
      return newRequire(localRequire.resolve(x));
    }

    function resolve(x){
      return modules[name][1][x] || x;
    }
  }

  function Module(moduleName) {
    this.id = moduleName;
    this.bundle = newRequire;
    this.exports = {};
  }

  newRequire.isParcelRequire = true;
  newRequire.Module = Module;
  newRequire.modules = modules;
  newRequire.cache = cache;
  newRequire.parent = previousRequire;
  newRequire.register = function (id, exports) {
    modules[id] = [function (require, module) {
      module.exports = exports;
    }, {}];
  };

  var error;
  for (var i = 0; i < entry.length; i++) {
    try {
      newRequire(entry[i]);
    } catch (e) {
      // Save first error but execute all entries
      if (!error) {
        error = e;
      }
    }
  }

  if (entry.length) {
    // Expose entry point to Node, AMD or browser globals
    // Based on https://github.com/ForbesLindesay/umd/blob/master/template.js
    var mainExports = newRequire(entry[entry.length - 1]);

    // CommonJS
    if (typeof exports === "object" && typeof module !== "undefined") {
      module.exports = mainExports;

    // RequireJS
    } else if (typeof define === "function" && define.amd) {
     define(function () {
       return mainExports;
     });

    // <script>
    } else if (globalName) {
      this[globalName] = mainExports;
    }
  }

  // Override the current require with this new one
  parcelRequire = newRequire;

  if (error) {
    // throw error from earlier, _after updating parcelRequire_
    throw error;
  }

  return newRequire;
})({"../../../../../../../../../../aws-sdk.external":[function(require,module,exports) {
module.exports=require('aws-sdk');
},{}],"index.ts":[function(require,module,exports) {
"use strict";

var __awaiter = this && this.__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

var __generator = this && this.__generator || function (thisArg, body) {
  var _ = {
    label: 0,
    sent: function () {
      if (t[0] & 1) throw t[1];
      return t[1];
    },
    trys: [],
    ops: []
  },
      f,
      y,
      t,
      g;
  return g = {
    next: verb(0),
    "throw": verb(1),
    "return": verb(2)
  }, typeof Symbol === "function" && (g[Symbol.iterator] = function () {
    return this;
  }), g;

  function verb(n) {
    return function (v) {
      return step([n, v]);
    };
  }

  function step(op) {
    if (f) throw new TypeError("Generator is already executing.");

    while (_) try {
      if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
      if (y = 0, t) op = [op[0] & 2, t.value];

      switch (op[0]) {
        case 0:
        case 1:
          t = op;
          break;

        case 4:
          _.label++;
          return {
            value: op[1],
            done: false
          };

        case 5:
          _.label++;
          y = op[1];
          op = [0];
          continue;

        case 7:
          op = _.ops.pop();

          _.trys.pop();

          continue;

        default:
          if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) {
            _ = 0;
            continue;
          }

          if (op[0] === 3 && (!t || op[1] > t[0] && op[1] < t[3])) {
            _.label = op[1];
            break;
          }

          if (op[0] === 6 && _.label < t[1]) {
            _.label = t[1];
            t = op;
            break;
          }

          if (t && _.label < t[2]) {
            _.label = t[2];

            _.ops.push(op);

            break;
          }

          if (t[2]) _.ops.pop();

          _.trys.pop();

          continue;
      }

      op = body.call(thisArg, _);
    } catch (e) {
      op = [6, e];
      y = 0;
    } finally {
      f = t = 0;
    }

    if (op[0] & 5) throw op[1];
    return {
      value: op[0] ? op[1] : void 0,
      done: true
    };
  }
};

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handler = void 0;

var aws_sdk_1 = require("aws-sdk");

var ecs = new aws_sdk_1.ECS();

var getProperties = function (props) {
  return {
    cluster: props.Cluster,
    serviceName: props.ServiceName,
    taskDefinition: props.TaskDefinition,
    launchType: props.LaunchType,
    platformVersion: props.PlatformVersion,
    desiredCount: props.DesiredCount,
    subnets: props.Subnets,
    securityGroups: props.SecurityGroups,
    targetGroupArn: props.TargetGroupArn,
    containerPort: props.ContainerPort,
    schedulingStrategy: props.SchedulingStrategy
  };
};

var onCreate = function (event) {
  return __awaiter(void 0, void 0, Promise, function () {
    var _a, cluster, serviceName, taskDefinition, launchType, platformVersion, desiredCount, subnets, securityGroups, targetGroupArn, containerPort, schedulingStrategy, service;

    return __generator(this, function (_b) {
      switch (_b.label) {
        case 0:
          _a = getProperties(event.ResourceProperties), cluster = _a.cluster, serviceName = _a.serviceName, taskDefinition = _a.taskDefinition, launchType = _a.launchType, platformVersion = _a.platformVersion, desiredCount = _a.desiredCount, subnets = _a.subnets, securityGroups = _a.securityGroups, targetGroupArn = _a.targetGroupArn, containerPort = _a.containerPort, schedulingStrategy = _a.schedulingStrategy;
          return [4
          /*yield*/
          , ecs.createService({
            cluster: cluster,
            serviceName: serviceName,
            taskDefinition: taskDefinition,
            launchType: launchType,
            platformVersion: platformVersion,
            desiredCount: desiredCount,
            schedulingStrategy: schedulingStrategy,
            deploymentController: {
              type: 'CODE_DEPLOY'
            },
            networkConfiguration: {
              awsvpcConfiguration: {
                subnets: subnets,
                securityGroups: securityGroups
              }
            },
            loadBalancers: [{
              targetGroupArn: targetGroupArn,
              containerPort: containerPort,
              containerName: 'sample-website'
            }]
          }).promise()];

        case 1:
          service = _b.sent().service;
          if (!service) throw Error('Service could not be created');
          return [2
          /*return*/
          , {
            PhysicalResourceId: service.serviceArn,
            Data: {
              ServiceName: service.serviceName
            }
          }];
      }
    });
  });
};
/**
 * For services using the blue/green (CODE_DEPLOY) deployment controller,
 * only the desired count, deployment configuration, task placement constraints
 * and strategies, and health check grace period can be updated using this API.
 * If the network configuration, platform version, or task definition need to be
 * updated, a new AWS CodeDeploy deployment should be created.
 * For more information, see CreateDeployment in the AWS CodeDeploy API Reference.
 */


var onUpdate = function (event) {
  return __awaiter(void 0, void 0, Promise, function () {
    var _a, cluster, serviceName, desiredCount, service;

    return __generator(this, function (_b) {
      switch (_b.label) {
        case 0:
          _a = getProperties(event.ResourceProperties), cluster = _a.cluster, serviceName = _a.serviceName, desiredCount = _a.desiredCount;
          return [4
          /*yield*/
          , ecs.updateService({
            service: serviceName,
            cluster: cluster,
            desiredCount: desiredCount
          }).promise()];

        case 1:
          service = _b.sent().service;
          if (!service) throw Error('Service could not be updated');
          return [2
          /*return*/
          , {
            PhysicalResourceId: service.serviceArn,
            Data: {
              ServiceName: service.serviceName
            }
          }];
      }
    });
  });
};

var onDelete = function (event) {
  return __awaiter(void 0, void 0, Promise, function () {
    var _a, cluster, serviceName;

    return __generator(this, function (_b) {
      switch (_b.label) {
        case 0:
          _a = getProperties(event.ResourceProperties), cluster = _a.cluster, serviceName = _a.serviceName;
          return [4
          /*yield*/
          , ecs.deleteService({
            service: serviceName,
            cluster: cluster,
            force: true
          }).promise()];

        case 1:
          _b.sent();

          return [2
          /*return*/
          ];
      }
    });
  });
};

exports.handler = function (event) {
  return __awaiter(void 0, void 0, Promise, function () {
    var requestType;
    return __generator(this, function (_a) {
      requestType = event.RequestType;

      switch (requestType) {
        case 'Create':
          return [2
          /*return*/
          , onCreate(event)];

        case 'Update':
          return [2
          /*return*/
          , onUpdate(event)];

        case 'Delete':
          return [2
          /*return*/
          , onDelete(event)];

        default:
          throw new Error("Invalid request type: " + requestType);
      }

      return [2
      /*return*/
      ];
    });
  });
};
},{"aws-sdk":"../../../../../../../../../../aws-sdk.external"}]},{},["index.ts"], null)
//# sourceMappingURL=/index.js.map