"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BuildSpecGenerator = void 0;
class BuildSpecGenerator {
    constructor(spec) {
        this.spec = spec;
    }
    static empty() {
        return new BuildSpecGenerator({ version: '0.2' });
    }
    static default(props) {
        return new BuildSpecGenerator({
            version: '0.2',
            phases: {
                pre_build: {
                    commands: [
                        'echo Build started on `date`',
                        'echo Logging in to Amazon ECR...',
                        'aws --version',
                        `aws ecr get-login-password | docker login --username AWS --password-stdin ${props.account}.dkr.ecr.${props.region}.amazonaws.com`,
                        'COMMIT_HASH=$(echo $CODEBUILD_RESOLVED_SOURCE_VERSION | cut -c 1-7)',
                        'IMAGE_TAG=${COMMIT_HASH:=latest}',
                        'echo Replacing placeholder...',
                        'sed -i "s|SED_REPLACE_EXECUTION_ROLE_ARN|$EXECUTION_ROLE_ARN|g" taskdef.json',
                        'sed -i "s|SED_REPLACE_FAMILY|$FAMILY|g" taskdef.json',
                        'echo Current taskDefinition:',
                        'cat taskdef.json',
                    ],
                },
                build: {
                    commands: [
                        'echo Building the Docker image...',
                        'docker version',
                        'docker build -t $REPOSITORY_URI:latest -t $REPOSITORY_URI:$IMAGE_TAG -f Dockerfile .',
                    ],
                },
                post_build: {
                    commands: [
                        'echo Pushing the Docker images to container registry...',
                        'docker push $REPOSITORY_URI:latest',
                        'docker push $REPOSITORY_URI:$IMAGE_TAG',
                        'echo Writing image definitions file...',
                        'printf \'{"ImageURI":"%s"}\' $REPOSITORY_URI:$IMAGE_TAG > imageDetail.json',
                        'echo Build completed on `date`',
                    ],
                },
            },
            artifacts: {
                files: ['appspec.yaml', 'taskdef.json'],
                'secondary-artifacts': {
                    ManifestArtifact: {
                        files: ['appspec.yaml', 'taskdef.json'],
                    },
                    ImageArtifact: {
                        files: ['imageDetail.json'],
                    },
                },
            },
        });
    }
    render() {
        return this.spec;
    }
}
exports.BuildSpecGenerator = BuildSpecGenerator;
//# sourceMappingURL=data:application/json;base64,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