"""Module listing the available operators and stages"""

# Package imports
# ---------------------------
from monggregate.utils import StrEnum


# Enums
# ---------------------------
class AggregationVariableEnum(StrEnum):
    """Enumeration of available aggregation variables"""

    NOW = "$$NOW" # Returns the current datetime value,
                # which is same across all members of the deployment and remains constant throughout the aggregation pipeline.
                # (Available in 4.2+)
    CLUSTER_TIME = "$$CLUSTER_TIME" # Returns the current timestamp value, which is same across all members of the deployment and remains constant throughout the aggregation pipeline.
                                    # For replica sets and sharded clusters only. (Available in 4.2+)
    ROOT = "$$ROOT" # References the root document, i.e. the top-level document.
    CURRENT = "$$CURRENT" # References the start of the field path, which by default is ROOT but can be changed.
    REMOVE = "$$REMOVE" # Allows for the conditional exclusion of fields. (Available in 3.6+)
    DESCEND = "$$DESCEND" # One of the allowed results of a $redact expression.
    PRUNE = "$$PRUNE" # One of the allowed results of a $redact expression.
    KEEP = "$$KEEP" # One of the allowed results of a $redact expression.NOW = "$$NOW" # Returns the current datetime value,
                # which is same across all members of the deployment and remains constant throughout the aggregation pipeline.
                # (Available in 4.2+)

class StageEnum(StrEnum):
    """"Enumeration of available stages"""

class OperatorEnum(StrEnum):
    """Enumeration of available operators"""


    ABS = "$abs"
    ACCUMULATOR = "$accumulator"
    ACOS = "$acos"
    ACOSH = "$acosh"
    ADD = "$add"
    ADD_TO_SET = "$addToSet"
    ALL_ELEMENTS_TRUE = "$allElementsTrue"
    AND = "$and"
    ANY_ELEMENTS_TRUE = "$anyElementsTrue"
    ARRAY_ELEM_AT = "$arrayElemAt"
    ARRAY_TO_OBJECT = "$arrayToObject"
    ASIN = "$asin"
    ASINH = "$asinh"
    ATAN = "$atan"
    ATAN2 = "$atan2"
    ATANH = "$atanh"
    AVG = "$avg"
    BINARY_SIZE = "$binarySize"
    BSON_SIZE ="$bsonSize"
    CEIL = "$ceil"
    CMP = "$cmp"
    CONCAT = "$concat"
    CONCAT_ARRAYS = "$concatArrays"
    COND = "$cond"
    CONVERT = "$convert"
    COS = "$cos"
    COSH = "$cosh"
    DATE_FROM_PARTS = "$dateFromParts"
    DATE_FROM_STRING = "$dateFromString"
    DATE_TO_PARTS = "$dateToParts"
    DATE_TO_STRING = "$dateToString"
    DAY_OF_MONTH ="$dayOfMonth"
    DAY_OF_WEEK = "$dayOfWeek"
    DAY_OF_YEAR = "$dayOfYear"
    DEGREES_TO_RADIANS = "$degreesToRadians"
    DIVIDE = "$divide"
    EQ = "$eq"
    EXP = "$exp"
    FILTER = "$filter"
    FIRST = "$first" # two operators one for array one for accumulator
    FLOOR = "$floor"
    FUNCTION = "$function"
    GET_FIELD = "$getField"
    GT = "$gt"
    GTE = "$gte"
    HOUR = "$hour"
    IF_NULL = "$ifNull"
    IN = "$in"
    INDEX_OF_ARRAY = "$indexOfArray"
    INDEX_OF_BYTES = "$indexOfBytes"
    INDEX_OF_CP = "$indexOfCP"
    IS_ARRAY = "$isArray"
    IS_NUMBER = "$isNumber"
    ISO_DAY_OF_WEEK = "$isoDayOfWeek"
    ISO_WEEK = "$isoWeek"
    ISO_WEEK_YEAR ="$isoWeekYear"
    LAST = "$last"  # two operators one for array one for accumulator
    LET ="$let"
    LITERAL = "$literal"
    LN = "$ln"
    LOG = "$log"
    LOG10 = "$log10"
    LT = "$lt"
    LTE = "$lte"
    LTRIM = "$ltrim"
    MAP = "$map"
    MAX = "$max"
    MERGE_OBJECTS = "$mergeObjects"
    META = "$meta"
    MILLI_SECOND = "$millisecond"
    MIN = "$min"
    MINUTE ="$minute"
    MOD ="$mod"
    MONTH = "$month"
    MULTIPLY ="$multiply"
    NE ="$ne"
    NOT ="$not"
    OBJECT_TO_ARRAY ="$objectToArray"
    OR = "$or"
    POW = "$pow"
    PUSH = "$push"
    RADIANS_TO_DEGREES = "$radiansToDegrees"
    RAND = "$rand"
    RANGE = "$range"
    REDUCE = "$reduce"
    REGEX_FIND ="$regexFind"
    REGEX_FIND_ALL = "$regexFindAll"
    REGEX_MATCH = "$regexMatch"
    REPLACE_ONE ="$replaceOne"
    REPLACE_ALL = "$replaceAll"
    REVERSE_ARRAY = "$reverseArray"
    ROUND = "$round"
    RTRIM = "$rtrim"
    SECOND = "$second"
    SET_DIFFERENCE = "$setDifference"
    SET_EQUALS = "$setEquals"
    SET_FIELD = "$setField"
    SET_INTERSECTION = "$setIntersection"
    SET_IS_SUBSET = "$setIsSubset"
    SET_UNION = "$setUnion"
    SIN = "$sin"
    SINH = "$sinh"
    SIZE = "$size"
    SLICE = "$slice"
    SPLIT = "$split"
    SQRT = "$sqrt"
    STD_DEV_POP = "$stdDevPop"
    STD_DEV_SAMP = "$stdDevSamp"
    STR_LEN_BYTES = "$strLenBytes"
    STR_LEN_CP = "$strLenCP"
    STR_CASE_CMP = "$strcasecmp"
    SUBSTR = "$substr"
    SUBSTR_BYTES = "$substrBytes"
    SUBSTR_CP = "$substrCP"
    SUBSTRACT = "$subtract"
    SUM = "$sum"
    SWITCH = "$switch"
    TAN = "$tan"
    TANH = "$tanh"
    TO_BOOL ="$toBool"
    TO_DATE = "$toDate"
    TO_DECIMAL = "$toDecimal"
    TO_DOUBLE = "$toDouble"
    TO_INT = "$toInt"
    TO_LONG = "$toLong"
    TO_LOWER = "$toLower"
    TO_OBJECT_ID = "$toObjectId"
    TO_STRING = "$toString"
    TO_UPPER = "$toUpper"
    TRIM = "$trim"
    TRUNC = "$trunc"
    TYPE = "$type"
    WEEK = "$week"
    YEAR = "$year"
    ZIP = "$zip"
