import pathlib
from _typeshed import StrPath
from typing import Any, Type, TypeVar

_P = TypeVar("_P", bound=PurePath)

class PurePath(pathlib.PurePath):
    def __new__(cls: Type[_P], *args: StrPath) -> _P: ...
    def with_stem(self: _P, stem: str) -> _P: ...
    def is_relative_to(self, *other: StrPath) -> bool: ...

class PurePosixPath(PurePath): ...
class PureWindowsPath(PurePath): ...

class Path(pathlib.Path):
    def __new__(cls: Type[_P], *args: StrPath, **kwargs: Any) -> _P: ...
    def readlink(self: _P) -> _P: ...
    def link_to(self, target: StrPath | bytes) -> None: ...
    def is_mount(self) -> bool: ...
    def is_image_file(self) -> bool: ...
    def is_audio_file(self) -> bool: ...
    def is_video_file(self) -> bool: ...

class PosixPath(Path, PurePosixPath): ...
class WindowsPath(Path, PureWindowsPath): ...
