# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DistributionArgs', 'Distribution']

@pulumi.input_type
class DistributionArgs:
    def __init__(__self__, *,
                 distribution_config: pulumi.Input['DistributionConfigArgs'],
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionTagArgs']]]] = None):
        """
        The set of arguments for constructing a Distribution resource.
        """
        pulumi.set(__self__, "distribution_config", distribution_config)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="distributionConfig")
    def distribution_config(self) -> pulumi.Input['DistributionConfigArgs']:
        return pulumi.get(self, "distribution_config")

    @distribution_config.setter
    def distribution_config(self, value: pulumi.Input['DistributionConfigArgs']):
        pulumi.set(self, "distribution_config", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DistributionTagArgs']]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionTagArgs']]]]):
        pulumi.set(self, "tags", value)


class Distribution(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 distribution_config: Optional[pulumi.Input[pulumi.InputType['DistributionConfigArgs']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DistributionTagArgs']]]]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::CloudFront::Distribution

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DistributionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::CloudFront::Distribution

        :param str resource_name: The name of the resource.
        :param DistributionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DistributionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 distribution_config: Optional[pulumi.Input[pulumi.InputType['DistributionConfigArgs']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DistributionTagArgs']]]]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DistributionArgs.__new__(DistributionArgs)

            if distribution_config is None and not opts.urn:
                raise TypeError("Missing required property 'distribution_config'")
            __props__.__dict__["distribution_config"] = distribution_config
            __props__.__dict__["tags"] = tags
            __props__.__dict__["domain_name"] = None
        super(Distribution, __self__).__init__(
            'aws-native:cloudfront:Distribution',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Distribution':
        """
        Get an existing Distribution resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = DistributionArgs.__new__(DistributionArgs)

        __props__.__dict__["distribution_config"] = None
        __props__.__dict__["domain_name"] = None
        __props__.__dict__["tags"] = None
        return Distribution(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="distributionConfig")
    def distribution_config(self) -> pulumi.Output['outputs.DistributionConfig']:
        return pulumi.get(self, "distribution_config")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Output[str]:
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.DistributionTag']]]:
        return pulumi.get(self, "tags")

