# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pysmartdatamodels']

package_data = \
{'': ['*'], 'pysmartdatamodels': ['model-assets/*']}

install_requires = \
['jsonref>=1.1.0,<2.0.0',
 'jsonschema>=4.17.3,<5.0.0',
 'pytz>=2022.7.1,<2023.0.0',
 'requests>=2.28.2,<3.0.0']

setup_kwargs = {
    'name': 'pysmartdatamodels',
    'version': '0.5.40',
    'description': 'Open-licensed and free data models to model your digital twins, share data in data spaces or develop smart applications',
    'long_description': '[![Smart Data Models](https://smartdatamodels.org/wp-content/uploads/2022/01/SmartDataModels_logo.png "Logo")](https://smartdatamodels.org)  \n\nSmart Data Models \n==================\n\nThe [Smart Data Models](https://smartdatamodels.org) is a program lead by [4 organizations](https://smartdatamodels.org/index.php/faqs/) with the collaboration of [more than 80](https://smartdatamodels.org/index.php/statistics/) and open to collaboration. It provides multisector agile standardized free and open-licensed data models based either on actual use cases or on adopted open standards.\nThe data models describe the entities and their attributes to be used in digital twins deployments, data spaces and other smart applications. The data models are grouped in subjects. Each subject is available at a unique repository at [https://smart-data-models.github.com](https://smart-data-models.github.com). Contributions to existing data models can be done there. New ones are drafted in the [incubated repository](https://github.com/smart-data-models/incubated/) once [filled this form](https://smartdatamodels.org/index.php/new-incubated-data-models/) for getting the permissions. [This manual](https://bit.ly/contribution_manual) helps you with the creation. There is a database of [contributors](https://smartdatamodels.org/index.php/contributors/) available. \n\nThis python package includes all the data models and several functions (listed below) to use them in your developments.\n\nEvery data model is open licensed and the list of its attributes and every attribute definition is included. Also, there is a function to check if a key values payload complies with a data model.  \n\nIf you want to be updated on this package you can join this [mailing list](https://smartdatamodels.org/index.php/developers-list/) (Announcements are sent only when something relevant happens). We love to hear from you at info@smartdatamodels.org\n\nThere are several online tools to manage and to create the data models, [generate examples](https://smartdatamodels.org/index.php/generate-a-ngsi-ld-keyvalues-payload-compliant-with-a-data-model/) or to adapt to [existing ontologies](https://smartdatamodels.org/index.php/generate-acontext-based-on-external-ontologies-iris/). See tools menu option at the [home site](https://smartdatamodels.org).\n\nCurrently, there are thirteen domains. \n#### [Smart Cities](https://github.com/smart-data-models/SmartCities)\n#### [Smart Agrifood](https://smartdatamodels.org/index.php/statistics/)\n#### [Smart Water](https://github.com/smart-data-models/SmartWater)\n#### [Smart Energy](https://github.com/smart-data-models/SmartEnergy)\n#### [Smart Environment](https://github.com/smart-data-models/SmartEnvironment)\n#### [Smart Robotics](https://github.com/smart-data-models/SmartRobotics)\n#### [Smart Sensoring](https://github.com/smart-data-models/Smart-Sensoring)\n#### [Cross sector](https://github.com/smart-data-models/CrossSector)\n#### [Smart Aeronautics](https://github.com/smart-data-models/SmartAeronautics)\n#### [Smart Destination](https://github.com/smart-data-models/SmartDestination)\n#### [Smart Health](https://github.com/smart-data-models/SmartHealth)\n#### [Smart Manufacturing](https://github.com/smart-data-models/SmartManufacturing)\n#### [Smart Logistics](https://github.com/smart-data-models/SmartLogistics)\n\n## Functions available include:\n\n1- List all data models. Function list_all_datamodels()\n\n2- List all subjects. Function list_all_subjects()\n\n3- List the data models of a subject. Function datamodels_subject(subject)\n\n4- List description of an attribute. Function description_attribute(subject, datamodel, attribute)\n\n5- List data-type of an attribute. Function datatype_attribute(subject, datamodel, attribute)\n\n6- Give reference model for an attribute. Function model_attribute(subject, datamodel, attribute)\n\n7- Give reference units for an attribute. Function attributes_datamodel(subject, datamodel)\n\n8- List the attributes of a data model. Function attributes_datamodel(subject, datamodel)\n\n9- List the NGSI type (Property, Relationship or Geoproperty) of the attribute. Function ngsi_datatype_attribute(subject, datamodel, attribute)\n\n10- Print a list of data models attributes separated by a separator. Function print_datamodel(subject, datamodel, separator, meta_attributes)\n\n11- Returns the link to the repository of a subject. Function subject_repolink(subject)\n\n12- Returns the links to the repositories of a data model name. Function datamodel_repolink(datamodel)\n\n13- Update the official data model list or the database of attributes from the source. Function update_data()\n\n## Pending features (glad to receive contributions to them)\n\nC.- Function to allow submission of improvements (i.e. missing recommended units or model) and comments to the different data models. Currently, you can do it searching for your data model here \n[https://smartdatamodels.org/index.php/list-of-data-models-3/](https://smartdatamodels.org/index.php/list-of-data-models-3/) going to the github repo and making your PR or raising your issues there.\n\nD.- Function to submit a new data model to an incubation repository. Currently, this is done manually [incubated repository](https://github.com/smart-data-models/incubated/tree/master). By filling this [form](https://smartdatamodels.org/index.php/new-incubated-data-models/) you are granted to contribute with new data models. For existing data models just see point C    \n\nif you want to suggest other functions / needs please let us know at info@smartdatamodels.org.\n\n### some example code\n\nfrom pysmartdatamodels import pysmartdatamodels as sdm\n\nsubject = "dataModel.Weather"\n\ndataModel = "WeatherForecast"\n\nattribute = "precipitation"\n\nprint(sdm.list_all_datamodels())\n\nprint(sdm.list_all_subjects())\n\nprint(sdm.datamodels_subject("dataModel.Weather"))\n\nprint(sdm.description_attribute(subject, dataModel, attribute))\n\nprint(sdm.datatype_attribute(subject, dataModel, attribute))\n\nprint(sdm.model_attribute(subject, dataModel, attribute))\n\nprint(sdm.units_attribute(subject, dataModel, attribute))\n\nprint(sdm.attributes_datamodel(subject, dataModel))\n\nprint(sdm.subject_repolink(subject))\n\nprint(sdm.datamodel_repolink(dataModel))\n\nprint(sdm.print_datamodel(subject, dataModel, ",", [\n        "property",\n        "type",\n        "dataModel",\n        "repoName",\n        "description",\n        "typeNGSI",\n        "modelTags",\n        "format",\n        "units",\n        "model",\n    ]))\n\nsdm.update_data()\n',
    'author': 'aabella',
    'author_email': 'alberto.abella@fiware.org',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
