# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/00_core.ipynb.

# %% auto 0
__all__ = ['readonlymeta', 'specabc', 'aspec_abc', 'dspec_abc', 'attrspec_abc', 'Spec', 'spec', 'aspec']

# %% ../nbs/00_core.ipynb 4
import copy, itertools
from abc import ABC, ABCMeta
from enum import StrEnum, auto
from atyp import AnyQ

# %% ../nbs/00_core.ipynb 5
from ispec.utils import (getattrs, kwsopt, kwsobj, arg1st)
from ispec.types import AttrSpec, islist, isdict, istuple, isallstr

# %% ../nbs/00_core.ipynb 7
class readonlymeta(ABCMeta):
    def __new__(cls, name, bases, dct):
        new_cls = super().__new__(cls, name, bases, dct)
        new_cls.__slots__ = tuple(set(getattr(new_cls, '__slots__', ())) | {'aspec'})
        return new_cls

# %% ../nbs/00_core.ipynb 10
# NOTE: using `__slots__`` yields bases error
    # __slots__ = ('aspec',)

class specabc(ABC, metaclass=readonlymeta):
    __readonly__ = ()
    def __init_subclass__(cls, *args, **kwargs):        
        '''Ensures that subclasses have an appropriate `aspec` defined.'''
        # Check if 'aspec' is defined and valid
        super().__init_subclass__(*args, **kwargs)
                
        if hasattr(cls, 'aspec'):
            if not isinstance(cls.aspec, (list, tuple, dict)):
                raise TypeError(f"aspec must be either an iterable of strings or a dictionary of str: Any, got {type(cls.aspec)}")
            
            if istuple(cls.aspec) and not isallstr(cls.aspec):
                raise TypeError("If type(aspec) == tuple, all items must be strings")
            
            if isdict(cls.aspec) and not isallstr(cls.aspec.keys()):
                raise TypeError("If type(aspec) == dict, all keys must be strings")
        
            # Read-only property for aspec        
            if kwargs.get('aspec', None):
                setattr(cls, 'aspec', kwargs['aspec'])
            
            # NOTE: using this yields <property> instead of a tuple
            # def aspec_getter(self):
            #     return getattr(self, '__aspec', cls.aspec)
            # setattr(cls, 'aspec', property(aspec_getter))

    def __setattr__(cls, name, value):
        '''
        Set the class attribute if it's not read-only.
        
        Parameters
        ----------
        name : str
            The name of the attribute.
            
        value : Any
            The value to set the attribute to.
        
        Raises
        ------
        AttributeError
            If the attribute is read-only.
        '''
        if name in cls.__readonly__:
            if not hasattr(cls, '_allow_set_readonly'):
                raise AttributeError(f"can't set attribute '{name}'")
        super().__setattr__(name, value)

    
    def __copy__(self):
        '''Temporarily allow setting read-only attributes during copying.'''        
        self._allow_set_readonly = True
        new_obj = copy.copy(self)
        del self._allow_set_readonly
        if hasattr(new_obj, '_allow_set_readonly'):
            del new_obj._allow_set_readonly
        return new_obj

    def __deepcopy__(self, memo):
        '''Temporarily allow setting read-only attributes during deepcopying.'''
        self._allow_set_readonly = True
        new_obj = copy.deepcopy(self, memo)
        del self._allow_set_readonly
        if hasattr(new_obj, '_allow_set_readonly'):
            del new_obj._allow_set_readonly
        return new_obj

# %% ../nbs/00_core.ipynb 12
class aspec_abc(specabc):
    __readonly__ = ('aspec', )

class dspec_abc(specabc):
    __readonly__ = ('dspec', )

class attrspec_abc(specabc):
    __readonly__ = ('aspec', 'dspec', )

# %% ../nbs/00_core.ipynb 15
class Spec(StrEnum):
    aspec = auto()
    dspec = auto()

    @classmethod
    def specs(cls):
        return tuple(list(map(lambda e: e.value, cls)))

Spec.specs()

# %% ../nbs/00_core.ipynb 18
class spec(specabc):
    '''
    Class mixin with attribute utilities.
    
    Attributes
    ----------
    specs : {('aspec', ), ('aspec', 'dspec', ), ('aspec', 'dspec), (), }, default: ()
        The attribute specifications to use.
        
    __readonly__ : tuple, default: ()
        Attributes that cannot be set.


    attrs : dict
        A dictionary containing the instance attributes determined by 
        the specs in `specs` e.g. `aspec` and / or `dspec`.
        This is a read-only property.

    clsname : str
        The name of the class. This is a read-only property.

    Methods
    -------
    __setattr__(name, value):
        Set the class attribute if it's not read-only.

    getattrkeys(spec: str, dyn: bool = False) -> tuple[str, ...]:
        Return attribute keys stored in `spec`.

    getattrvals(self, spec: str, dyn: bool = False) -> tuple[Any, ...]:
        Return default attribute values stored in `spec`.
    
    skeys() -> tuple[str, ...]:
        Return all attribute keys stored for each spec stored in `specs`.

    svals() -> tuple[str, ...]:
        Return default attribute values stored for each spec stored in `specs`.
    
    getattrs(**kwargs):
        Get instance parameters with optional overrides.
        
    makesame(*args, **kwargs):
        Call class constructor with the same attributes as the current instance.
    
    isinst(other):
        Check if the provided value is an instance of this class.
        
    sameattrs(other):
        Check if the provided value is an instance of this class with the same attributes.
        
    diffattrs(other):
        Check if the provided value is an instance of this class with different attributes.

    getattrname(dattr: str) -> str:
        Get the name of the dynamic attribute.
    
    getdattr(dattr: str, default: Any = None) -> Any:
        Get the value of the dynamic attribute.

    setdattr(dattr: str, value: Any = None):
        Set the value of the dynamic attribute.

    update_attrname(dattr: str, **kwargs):
        Update the name of the dynamic attribute.
    
    update_dattrval(aname: str, **kwargs):
        Update the value of the dynamic attribute.
    
    update_dattr(dattr: str, **kwargs):
        Update the name and value of the dynamic attribute.

    update_aspec(**kwargs):
        Update the attribute specification.

    update_dspec(**kwargs):
        Update the dynamic attribute specification.

    update_specs(**kwargs):
        Update the specifications in `specs` e.g. `aspec` and / or `dspec`.

    getclsattr(attr: str, default: Any = None) -> Any:
        Get the value of the class attribute.

    setclsattr(attr: str, val: Any = None):
        Set the value of the class attribute.

    copy():
        Return a shallow copy of the instance.
    
    deepcopy():
        Return a deep copy of the instance.
    '''
    specs = ()

    def __setattr__(cls, name, value):
        '''
        Set the class attribute if it's not read-only.
        
        Parameters
        ----------
        name : str
            The name of the attribute.
            
        value : Any
            The value to set the attribute to.
        
        Raises
        ------
        AttributeError
            If the attribute is read-only.
        '''
        if name in cls.__readonly__:
            raise AttributeError(f"can't set attribute '{name}'")
        super().__setattr__(name, value)
    
    def getattrkeys(self, spec: str, dyn: bool = False) -> tuple:
        '''
        Return attribute keys stored in `aspec`.

        Parameters
        ----------
        spec : str
            The attribute specification to use.
        dyn : bool, default: False
            If True, return the dynamic attribute keys.
        
        Returns
        -------
        tuple
            A tuple containing the keys in `aspec`.
        '''
        keys = ()
        spec = getattr(self, spec, None)
        if spec is None:     pass
        elif isdict(spec):   keys = tuple(spec.keys())
        elif islist(spec):   keys = tuple(spec)
        elif istuple(spec):  keys = tuple(spec)
        elif isallstr(spec): keys = tuple(spec)
        else:                pass

        if dyn: keys = tuple(getattrs(self, keys).values())
        
        return keys
    
    def getattrvals(self, spec: str, dyn: bool = False) -> tuple:
        '''
        Return default attribute values stored in `spec`.
        
        Returns
        -------
        tuple
            A tuple containing the default attribute values.
        '''        
        keys = self.getattrkeys(spec, dyn=dyn)
        spec = getattr(self, spec, None)
        if isinstance(spec, dict): return tuple(spec.values())
        else:                      return tuple([None] * len(keys))
        
    def skeys(self) -> tuple:
        '''
        Return all attribute keys stored for each spec stored in `specs`.
        
        Returns
        -------
        tuple
            A tuple containing the keys in `aspec` and `dspec`.
        '''        
        return tuple(itertools.chain(*(
            self.getattrkeys(spec, dyn=spec.startswith('d')) 
            for spec in self.specs
        )))
    
    def svals(self) -> tuple:
        '''
        Return default attribute values stored for each spec stored in `specs`.        
        
        Returns
        -------
        tuple
            A tuple containing the default attribute values.
        '''
        return tuple(itertools.chain(*(
            self.getattrvals(spec, dyn=spec.startswith('d')) 
            for spec in self.specs
        )))
        
    def getattrs(self, **kwargs) -> dict:
        '''
        Get instance parameters with optional overrides.
        
        Parameters
        ----------
        kwargs : dict
            Dictionary containing overrides for the instance attributes.
        
        Returns
        -------
        dict
            A dictionary containing the instance attributes.
        '''        
        return kwsopt(self.attrs, **getattrs(kwargs, self.skeys()))
     
    def makesame(self, *args, **kwargs):
        '''
        Call class constructor with the same attributes as the current instance.
        
        Parameters
        ----------
        args : Any
            Positional arguments to pass to the class constructor.
            
        kwargs : Any
            Keyword arguments to pass to the class constructor.
            
        Returns
        -------
        object
            A new instance of the class with the same attributes.
        '''
        return type(self)(*args, **self.getattrs(**kwargs))
    
    @classmethod
    def isinst(cls, other: AnyQ) -> bool:
        '''
        Check if the provided value is an instance of this class.
        
        Parameters
        ----------
        other : Any
            The object to check.
            
        Returns
        -------
        bool
            True if `other` is an instance of this class, otherwise False.
        '''
        return isinstance(other, cls)

    def sameattrs(self, other: AnyQ) -> bool:
        '''
        Check if the provided value is an instance of this class with the same attributes.
        
        Parameters
        ----------
        other : Any
            The object to check against.
            
        Returns
        -------
        bool
            True if `other` is an instance with the same attributes, otherwise False.
        '''
        if self.isinst(other): return self.attrs == other.attrs
        return False
    
    def diffattrs(self, other: AnyQ) -> bool:
        '''
        Check if the provided value is an instance of this class with different attributes.
        
        Parameters
        ----------
        other : Any
            The object to check against.
            
        Returns
        -------
        bool
            True if `other` is an instance with different attributes, otherwise False.
        '''
        return not self.sameargs(other)

    @property
    def attrs(self) -> dict:
        '''
        Fetches the values of attributes as specified in `aspec`.
        
        Returns
        -------
        dict
            A dictionary containing the instance attributes.
        '''      
        return getattrs(self, self.skeys(), self.svals())
    @attrs.setter
    def attrs(self, value):
        '''
        Raises
        ------
        AttributeError
            Attempting to set the 'attrs' property will raise an AttributeError.
        '''
        raise AttributeError("Cannot set the 'attrs' property")

    @property    
    def clsname(self) -> str:
        '''
        The name of the class.
        
        Returns
        -------
        str
            The class name.
        '''     
        return type(self).__name__
    @clsname.setter
    def clsname(self, value):
        '''
        Raises
        ------
        AttributeError
            Attempting to set the 'clsname' property will raise an AttributeError.
        '''
        raise AttributeError("Cannot set the 'clsname' property")
    
    def getattrname(self, dattr: str) -> str:
        '''
        Get the name of the dynamic attribute.
        
        Parameters
        ----------
        dattr : str
            The name of the dynamic attribute.
            
        Returns
        -------
        name : str, None
            The name of the dynamic attribute.
        '''
        return getattr(self, dattr, None)

    def getdattr(self, dattr: str, default: AnyQ = None):
        '''get dynamic attribute'''
        aname = self.getattrname(dattr)      # get the dyanmic attribute's attribute name
        if aname is None: return default     # if the attr name doesn't exist return default
        return getattr(self, aname, default) # get the dynamic attribute's value
    
    def setdattr(self, dattr: str, value: AnyQ = None):
        '''set dynamic attribute'''
        aname = self.getattrname(dattr) # get the dyanmic attribute's attribute name
        if aname is None: return        # if the attr name doesn't exist return default
        setattr(self, aname, value)     # get the dynamic attribute's value

    def update_attrname(self, dattr: str, **kwargs):
        cur = self.getattrname(dattr)
        kws = kwargs.get(dattr, None)
        setattr(self, dattr, arg1st(kws, cur))

    def update_dattrval(self, aname: str, **kwargs):        
        if aname is None: return        
        cur = getattr(self, aname, None)
        kws = kwargs.get(aname, None)
        setattr(self, aname, arg1st(kws, cur))

    def update_dattr(self, dattr: str, **kwargs):
        self.update_attrname(dattr, **kwargs)
        aname = self.getattrname(dattr)
        self.update_dattrval(aname, **kwargs)  

    def update_aspec(self, **kwargs):
        if not hasattr(self, 'aspec'): return
        for attr in self.aspec:
            aval = kwsobj(self, attr, **kwargs)
            setattr(self, attr, aval)

    def update_dspec(self, **kwargs):
        if not hasattr(self, 'dspec'): return
        for dattr in self.dspec:
            self.update_dattr(dattr, **kwargs)

    def update_specs(self, **kwargs):
        if not hasattr(self, 'specs'): return 
        for spec in self.specs:
            sval = kwsobj(self, spec, **kwargs)
            setattr(self, spec, sval)
            match spec:
                case 'dspec':
                    self.update_dspec(**kwargs)
                case 'aspec':
                    self.update_aspec(**kwargs)
                case _:
                    pass

    def __init__(self, *args, **kwargs):
        self.update_aspec(**kwargs)
        self.update_dspec(**kwargs)


    @classmethod
    def getclsattr(cls, attr: str, default: AnyQ = None):
        '''get class attribute'''
        if not hasattr(cls, attr):
            raise AttributeError(f'Class {cls} has not attribute {attr}')
        return getattr(cls, attr, default)
    
    @classmethod
    def setclsattr(cls, attr: str, val: AnyQ = None):
        '''set class attribute'''
        if not hasattr(cls, attr): return
        setattr(cls, attr, val)  

    def copy(self):
        return copy.copy(self)
    
    def deepcopy(self):
        return copy.deepcopy(self)

# %% ../nbs/00_core.ipynb 20
class aspec(spec):
    '''
    Class mixin with attribute utilities.

    Attributes
    ----------
    aspec : list | tuple | dict, optional
        The attribute specification. Must be either an iterable of strings 
        or a dictionary of `str: Any`. Defaults to an empty tuple.
    
    dspec : list | tuple | dict, optional
        The dynamic attribute specification. Must be either an iterable of strings 
        or a dictionary of `str: str`. Defaults to an empty tuple.

    specs: {('aspec', ), ('aspec', 'dspec', ), ('aspec', 'dspec), (), }, default: (Spec.aspec.value, Spec.dspec.value)
        The attribute specifications to use.
        
    __readonly__ : tuple, default: (Spec.aspec.value, Spec.dspec.value)
        Attributes that cannot be set.

    Methods
    -------
    __setattr__(name, value):
        Set the class attribute if it's not read-only.
        
    getattrkeys(spec: str, dyn: bool = False) -> tuple[str, ...]:
        Return attribute keys stored in `spec`.

    getattrvals(self, spec: str, dyn: bool = False) -> tuple[Any, ...]:
        Return default attribute values stored in `spec`.
    
    skeys() -> tuple[str, ...]:
        Return all attribute keys stored for each spec stored in `specs`.

    svals() -> tuple[str, ...]:
        Return default attribute values stored for each spec stored in `specs`.
    
    getattrs(**kwargs):
        Get instance parameters with optional overrides.
        
    makesame(*args, **kwargs):
        Call class constructor with the same attributes as the current instance.
    
    isinst(other):
        Check if the provided value is an instance of this class.
        
    sameattrs(other):
        Check if the provided value is an instance of this class with the same attributes.
        
    diffattrs(other):
        Check if the provided value is an instance of this class with different attributes.

    getattrname(dattr: str) -> str:
        Get the name of the dynamic attribute.
    
    getdattr(dattr: str, default: Any = None) -> Any:
        Get the value of the dynamic attribute.

    setdattr(dattr: str, value: Any = None):
        Set the value of the dynamic attribute.

    update_attrname(dattr: str, **kwargs):
        Update the name of the dynamic attribute.
    
    update_dattrval(aname: str, **kwargs):
        Update the value of the dynamic attribute.
    
    update_dattr(dattr: str, **kwargs):
        Update the name and value of the dynamic attribute.

    update_aspec(**kwargs):
        Update the attribute specification.

    update_dspec(**kwargs):
        Update the dynamic attribute specification.

    update_specs(**kwargs):
        Update the specifications in `specs` e.g. `aspec` and / or `dspec`.

    getclsattr(attr: str, default: Any = None) -> Any:
        Get the value of the class attribute.

    setclsattr(attr: str, val: Any = None):
        Set the value of the class attribute.

    copy():
        Return a shallow copy of the instance.
    
    deepcopy():
        Return a deep copy of the instance.
    '''

    aspec: AttrSpec = ()
    dspec: AttrSpec = ()
    specs: tuple = (Spec.aspec.value, Spec.dspec.value)
    __readonly__ = (Spec.aspec.value, Spec.dspec.value)

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
