# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/105_models.RNN.ipynb (unless otherwise specified).

__all__ = ['RNN', 'LSTM', 'GRU']

# Cell
from ..imports import *
from .layers import *

# Cell
class _RNN_Base(Module):
    def __init__(self, c_in, c_out, hidden_size=100, n_layers=1, bias=True, rnn_dropout=0, bidirectional=False, fc_dropout=0.):
        self.rnn = self._cell(c_in, hidden_size, num_layers=n_layers, bias=bias, batch_first=True, dropout=rnn_dropout, bidirectional=bidirectional)
        self.dropout = nn.Dropout(fc_dropout) if fc_dropout else noop
        self.fc = nn.Linear(hidden_size * (1 + bidirectional), c_out)

    def forward(self, x):
        x = x.transpose(2,1) # [batch_size x n_vars x seq_len] --> [batch_size x seq_len x n_vars]
        output, _ = self.rnn(x) # output from all sequence steps: [batch_size x seq_len x hidden_size * (1 + bidirectional)]
        output = output[:, -1] # output from last sequence step : [batch_size x hidden_size * (1 + bidirectional)]
        output = self.fc(self.dropout(output))
        return output

class RNN(_RNN_Base):
    _cell = nn.RNN

class LSTM(_RNN_Base):
    _cell = nn.LSTM

class GRU(_RNN_Base):
    _cell = nn.GRU