# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/200_trading.utils.ipynb (unless otherwise specified).

__all__ = ['MAJORS', 'MINORS', 'SYMBOLS', 'get_triple_barrier_label', 'plot_equity_curve']

# Cell
from ..imports import *
from fastcore.test import *

# Cell
MAJORS = sorted(['AUDUSD', 'EURUSD', 'GBPUSD', 'NZDUSD', 'USDCAD', 'USDCHF', 'USDJPY'])
MINORS = sorted(['AUDCAD', 'AUDCHF', 'AUDJPY', 'AUDNZD', 'CADCHF', 'CADJPY', 'CHFJPY', 'EURAUD', 'EURCAD', 'EURCHF', 'EURGBP',
          'EURJPY', 'EURNZD', 'GBPAUD', 'GBPCAD', 'GBPCHF', 'GBPJPY', 'GBPNZD', 'NZDCAD', 'NZDCHF', 'NZDJPY'])
SYMBOLS = sorted(MAJORS + MINORS)

# Cell
def get_triple_barrier_label(a, thr=1):
    tp = np.argwhere(a >= thr)[0][0] if (a >= thr).sum() > 0 else len(a)
    sl = np.argwhere(a <= -thr)[0][0] if (a <= -thr).sum() > 0 else len(a)
    return 1 if tp < sl else -1 if sl < tp else 0

# Cell
def plot_equity_curve(Rs):
    plt.plot(np.cumproduct(concat(array([100]), 1 + Rs / 100)))
    plt.show()