"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TransitRouterVpcAttachment = exports.TransitRouterVpcAttachmentProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const cen_generated_1 = require("./cen.generated");
Object.defineProperty(exports, "TransitRouterVpcAttachmentProperty", { enumerable: true, get: function () { return cen_generated_1.RosTransitRouterVpcAttachment; } });
/**
 * A ROS resource type:  `ALIYUN::CEN::TransitRouterVpcAttachment`
 */
class TransitRouterVpcAttachment extends ros.Resource {
    /**
     * Create a new `ALIYUN::CEN::TransitRouterVpcAttachment`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosTransitRouterVpcAttachment = new cen_generated_1.RosTransitRouterVpcAttachment(this, id, {
            routeTableAssociationEnabled: props.routeTableAssociationEnabled,
            deletionForce: props.deletionForce,
            autoCreateVpcRoute: props.autoCreateVpcRoute,
            vpcId: props.vpcId,
            chargeType: props.chargeType,
            routeTablePropagationEnabled: props.routeTablePropagationEnabled,
            cenId: props.cenId,
            transitRouterAttachmentName: props.transitRouterAttachmentName,
            zoneMappings: props.zoneMappings,
            vpcOwnerId: props.vpcOwnerId,
            transitRouterAttachmentDescription: props.transitRouterAttachmentDescription,
            transitRouterId: props.transitRouterId,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosTransitRouterVpcAttachment;
        this.attrCenId = rosTransitRouterVpcAttachment.attrCenId;
        this.attrClientToken = rosTransitRouterVpcAttachment.attrClientToken;
        this.attrResourceType = rosTransitRouterVpcAttachment.attrResourceType;
        this.attrTransitRouterAttachmentDescription = rosTransitRouterVpcAttachment.attrTransitRouterAttachmentDescription;
        this.attrTransitRouterAttachmentId = rosTransitRouterVpcAttachment.attrTransitRouterAttachmentId;
        this.attrTransitRouterAttachmentName = rosTransitRouterVpcAttachment.attrTransitRouterAttachmentName;
        this.attrTransitRouterId = rosTransitRouterVpcAttachment.attrTransitRouterId;
        this.attrVpcId = rosTransitRouterVpcAttachment.attrVpcId;
        this.attrVpcOwnerId = rosTransitRouterVpcAttachment.attrVpcOwnerId;
    }
}
exports.TransitRouterVpcAttachment = TransitRouterVpcAttachment;
//# sourceMappingURL=data:application/json;base64,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