"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TransitRouterRouteTable = exports.TransitRouterRouteTableProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const cen_generated_1 = require("./cen.generated");
Object.defineProperty(exports, "TransitRouterRouteTableProperty", { enumerable: true, get: function () { return cen_generated_1.RosTransitRouterRouteTable; } });
/**
 * A ROS resource type:  `ALIYUN::CEN::TransitRouterRouteTable`
 */
class TransitRouterRouteTable extends ros.Resource {
    /**
     * Create a new `ALIYUN::CEN::TransitRouterRouteTable`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosTransitRouterRouteTable = new cen_generated_1.RosTransitRouterRouteTable(this, id, {
            transitRouterRouteTableDescription: props.transitRouterRouteTableDescription,
            transitRouterRouteTableName: props.transitRouterRouteTableName,
            transitRouterId: props.transitRouterId,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosTransitRouterRouteTable;
        this.attrClientToken = rosTransitRouterRouteTable.attrClientToken;
        this.attrTransitRouterId = rosTransitRouterRouteTable.attrTransitRouterId;
        this.attrTransitRouterRouteTableDescription = rosTransitRouterRouteTable.attrTransitRouterRouteTableDescription;
        this.attrTransitRouterRouteTableId = rosTransitRouterRouteTable.attrTransitRouterRouteTableId;
        this.attrTransitRouterRouteTableName = rosTransitRouterRouteTable.attrTransitRouterRouteTableName;
        this.attrTransitRouterRouteTableType = rosTransitRouterRouteTable.attrTransitRouterRouteTableType;
    }
}
exports.TransitRouterRouteTable = TransitRouterRouteTable;
//# sourceMappingURL=data:application/json;base64,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