"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TransitRouterRouteEntry = exports.TransitRouterRouteEntryProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const cen_generated_1 = require("./cen.generated");
Object.defineProperty(exports, "TransitRouterRouteEntryProperty", { enumerable: true, get: function () { return cen_generated_1.RosTransitRouterRouteEntry; } });
/**
 * A ROS resource type:  `ALIYUN::CEN::TransitRouterRouteEntry`
 */
class TransitRouterRouteEntry extends ros.Resource {
    /**
     * Create a new `ALIYUN::CEN::TransitRouterRouteEntry`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosTransitRouterRouteEntry = new cen_generated_1.RosTransitRouterRouteEntry(this, id, {
            transitRouterRouteTableId: props.transitRouterRouteTableId,
            transitRouterRouteEntryDestinationCidrBlock: props.transitRouterRouteEntryDestinationCidrBlock,
            transitRouterRouteEntryNextHopId: props.transitRouterRouteEntryNextHopId,
            transitRouterRouteEntryDescription: props.transitRouterRouteEntryDescription,
            transitRouterRouteEntryNextHopType: props.transitRouterRouteEntryNextHopType,
            transitRouterRouteEntryName: props.transitRouterRouteEntryName,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosTransitRouterRouteEntry;
        this.attrTransitRouterRouteEntryDescription = rosTransitRouterRouteEntry.attrTransitRouterRouteEntryDescription;
        this.attrTransitRouterRouteEntryDestinationCidrBlock = rosTransitRouterRouteEntry.attrTransitRouterRouteEntryDestinationCidrBlock;
        this.attrTransitRouterRouteEntryId = rosTransitRouterRouteEntry.attrTransitRouterRouteEntryId;
        this.attrTransitRouterRouteEntryName = rosTransitRouterRouteEntry.attrTransitRouterRouteEntryName;
        this.attrTransitRouterRouteEntryNextHopId = rosTransitRouterRouteEntry.attrTransitRouterRouteEntryNextHopId;
        this.attrTransitRouterRouteEntryNextHopType = rosTransitRouterRouteEntry.attrTransitRouterRouteEntryNextHopType;
        this.attrTransitRouterRouteEntryType = rosTransitRouterRouteEntry.attrTransitRouterRouteEntryType;
        this.attrTransitRouterRouteTableId = rosTransitRouterRouteEntry.attrTransitRouterRouteTableId;
    }
}
exports.TransitRouterRouteEntry = TransitRouterRouteEntry;
//# sourceMappingURL=data:application/json;base64,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