"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TransitRouterPeerAttachment = exports.TransitRouterPeerAttachmentProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const cen_generated_1 = require("./cen.generated");
Object.defineProperty(exports, "TransitRouterPeerAttachmentProperty", { enumerable: true, get: function () { return cen_generated_1.RosTransitRouterPeerAttachment; } });
/**
 * A ROS resource type:  `ALIYUN::CEN::TransitRouterPeerAttachment`
 */
class TransitRouterPeerAttachment extends ros.Resource {
    /**
     * Create a new `ALIYUN::CEN::TransitRouterPeerAttachment`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosTransitRouterPeerAttachment = new cen_generated_1.RosTransitRouterPeerAttachment(this, id, {
            autoPublishRouteEnabled: props.autoPublishRouteEnabled,
            bandwidth: props.bandwidth,
            cenId: props.cenId,
            transitRouterAttachmentName: props.transitRouterAttachmentName,
            peerTransitRouterId: props.peerTransitRouterId,
            cenBandwidthPackageId: props.cenBandwidthPackageId,
            transitRouterAttachmentDescription: props.transitRouterAttachmentDescription,
            transitRouterId: props.transitRouterId,
            peerTransitRouterRegionId: props.peerTransitRouterRegionId,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosTransitRouterPeerAttachment;
        this.attrAutoPublishRouteEnabled = rosTransitRouterPeerAttachment.attrAutoPublishRouteEnabled;
        this.attrBandwidth = rosTransitRouterPeerAttachment.attrBandwidth;
        this.attrCenBandwidthPackageId = rosTransitRouterPeerAttachment.attrCenBandwidthPackageId;
        this.attrCenId = rosTransitRouterPeerAttachment.attrCenId;
        this.attrClientToken = rosTransitRouterPeerAttachment.attrClientToken;
        this.attrGeographicSpanId = rosTransitRouterPeerAttachment.attrGeographicSpanId;
        this.attrPeerTransitRouterId = rosTransitRouterPeerAttachment.attrPeerTransitRouterId;
        this.attrPeerTransitRouterOwnerId = rosTransitRouterPeerAttachment.attrPeerTransitRouterOwnerId;
        this.attrPeerTransitRouterRegionId = rosTransitRouterPeerAttachment.attrPeerTransitRouterRegionId;
        this.attrResourceType = rosTransitRouterPeerAttachment.attrResourceType;
        this.attrTransitRouterAttachmentDescription = rosTransitRouterPeerAttachment.attrTransitRouterAttachmentDescription;
        this.attrTransitRouterAttachmentId = rosTransitRouterPeerAttachment.attrTransitRouterAttachmentId;
        this.attrTransitRouterAttachmentName = rosTransitRouterPeerAttachment.attrTransitRouterAttachmentName;
        this.attrTransitRouterId = rosTransitRouterPeerAttachment.attrTransitRouterId;
    }
}
exports.TransitRouterPeerAttachment = TransitRouterPeerAttachment;
//# sourceMappingURL=data:application/json;base64,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