"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChildInstanceRouteEntryToAttachment = exports.ChildInstanceRouteEntryToAttachmentProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const cen_generated_1 = require("./cen.generated");
Object.defineProperty(exports, "ChildInstanceRouteEntryToAttachmentProperty", { enumerable: true, get: function () { return cen_generated_1.RosChildInstanceRouteEntryToAttachment; } });
/**
 * A ROS resource type:  `ALIYUN::CEN::ChildInstanceRouteEntryToAttachment`
 */
class ChildInstanceRouteEntryToAttachment extends ros.Resource {
    /**
     * Create a new `ALIYUN::CEN::ChildInstanceRouteEntryToAttachment`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosChildInstanceRouteEntryToAttachment = new cen_generated_1.RosChildInstanceRouteEntryToAttachment(this, id, {
            transitRouterAttachmentId: props.transitRouterAttachmentId,
            routeTableId: props.routeTableId,
            cenId: props.cenId,
            destinationCidrBlock: props.destinationCidrBlock,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosChildInstanceRouteEntryToAttachment;
        this.attrCenId = rosChildInstanceRouteEntryToAttachment.attrCenId;
        this.attrDestinationCidrBlock = rosChildInstanceRouteEntryToAttachment.attrDestinationCidrBlock;
        this.attrRouteTableId = rosChildInstanceRouteEntryToAttachment.attrRouteTableId;
        this.attrTransitRouterAttachmentId = rosChildInstanceRouteEntryToAttachment.attrTransitRouterAttachmentId;
    }
}
exports.ChildInstanceRouteEntryToAttachment = ChildInstanceRouteEntryToAttachment;
//# sourceMappingURL=data:application/json;base64,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