"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CenVbrHealthCheck = exports.CenVbrHealthCheckProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const cen_generated_1 = require("./cen.generated");
Object.defineProperty(exports, "CenVbrHealthCheckProperty", { enumerable: true, get: function () { return cen_generated_1.RosCenVbrHealthCheck; } });
/**
 * A ROS resource type:  `ALIYUN::CEN::CenVbrHealthCheck`
 */
class CenVbrHealthCheck extends ros.Resource {
    /**
     * Create a new `ALIYUN::CEN::CenVbrHealthCheck`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosCenVbrHealthCheck = new cen_generated_1.RosCenVbrHealthCheck(this, id, {
            vbrInstanceRegionId: props.vbrInstanceRegionId,
            healthCheckInterval: props.healthCheckInterval,
            vbrInstanceId: props.vbrInstanceId,
            vbrInstanceOwnerId: props.vbrInstanceOwnerId,
            healthCheckSourceIp: props.healthCheckSourceIp,
            healthyThreshold: props.healthyThreshold,
            cenId: props.cenId,
            healthCheckTargetIp: props.healthCheckTargetIp,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosCenVbrHealthCheck;
        this.attrCenId = rosCenVbrHealthCheck.attrCenId;
        this.attrHealthCheckInterval = rosCenVbrHealthCheck.attrHealthCheckInterval;
        this.attrHealthCheckSourceIp = rosCenVbrHealthCheck.attrHealthCheckSourceIp;
        this.attrHealthCheckTargetIp = rosCenVbrHealthCheck.attrHealthCheckTargetIp;
        this.attrHealthyThreshold = rosCenVbrHealthCheck.attrHealthyThreshold;
        this.attrVbrInstanceId = rosCenVbrHealthCheck.attrVbrInstanceId;
        this.attrVbrInstanceOwnerId = rosCenVbrHealthCheck.attrVbrInstanceOwnerId;
        this.attrVbrInstanceRegionId = rosCenVbrHealthCheck.attrVbrInstanceRegionId;
    }
}
exports.CenVbrHealthCheck = CenVbrHealthCheck;
//# sourceMappingURL=data:application/json;base64,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