"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CenBandwidthLimit = exports.CenBandwidthLimitProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const cen_generated_1 = require("./cen.generated");
Object.defineProperty(exports, "CenBandwidthLimitProperty", { enumerable: true, get: function () { return cen_generated_1.RosCenBandwidthLimit; } });
/**
 * A ROS resource type:  `ALIYUN::CEN::CenBandwidthLimit`
 */
class CenBandwidthLimit extends ros.Resource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the properties of this ROS resource, which will be assigned to ROS resource.
     */
    /**
     * Create a new `ALIYUN::CEN::CenBandwidthLimit`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosCenBandwidthLimit = new cen_generated_1.RosCenBandwidthLimit(this, id, {
            oppositeRegionId: props.oppositeRegionId,
            cenId: props.cenId,
            bandwidthLimit: props.bandwidthLimit,
            localRegionId: props.localRegionId,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosCenBandwidthLimit;
    }
}
exports.CenBandwidthLimit = CenBandwidthLimit;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2VuYmFuZHdpZHRobGltaXQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJjZW5iYW5kd2lkdGhsaW1pdC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSw4Q0FBOEM7QUFDOUMsbURBQXVEO0FBRXRCLDBHQUZ4QixvQ0FBb0IsT0FFNkI7QUE0QjFEOztHQUVHO0FBQ0gsTUFBYSxpQkFBa0IsU0FBUSxHQUFHLENBQUMsUUFBUTtJQUUvQzs7O09BR0c7SUFFSDs7Ozs7O09BTUc7SUFDSCxZQUFZLEtBQW9CLEVBQUUsRUFBVSxFQUFFLEtBQTZCLEVBQUUsbUNBQTJDLElBQUk7UUFDeEgsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUVqQixNQUFNLG9CQUFvQixHQUFHLElBQUksb0NBQW9CLENBQUMsSUFBSSxFQUFFLEVBQUUsRUFBRztZQUM3RCxnQkFBZ0IsRUFBRSxLQUFLLENBQUMsZ0JBQWdCO1lBQ3hDLEtBQUssRUFBRSxLQUFLLENBQUMsS0FBSztZQUNsQixjQUFjLEVBQUUsS0FBSyxDQUFDLGNBQWM7WUFDcEMsYUFBYSxFQUFFLEtBQUssQ0FBQyxhQUFhO1NBQ3JDLEVBQUUsZ0NBQWdDLElBQUksSUFBSSxDQUFDLEtBQUssQ0FBQyxnQ0FBZ0MsQ0FBQyxDQUFDO1FBQ3BGLElBQUksQ0FBQyxRQUFRLEdBQUcsb0JBQW9CLENBQUM7SUFDekMsQ0FBQztDQUNKO0FBekJELDhDQXlCQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIHJvcyBmcm9tICdAYWxpY2xvdWQvcm9zLWNkay1jb3JlJztcbmltcG9ydCB7IFJvc0NlbkJhbmR3aWR0aExpbWl0IH0gZnJvbSAnLi9jZW4uZ2VuZXJhdGVkJztcbi8vIEdlbmVyYXRlZCBmcm9tIHRoZSBBbGlDbG91ZCBST1MgUmVzb3VyY2UgU3BlY2lmaWNhdGlvblxuZXhwb3J0IHsgUm9zQ2VuQmFuZHdpZHRoTGltaXQgYXMgQ2VuQmFuZHdpZHRoTGltaXRQcm9wZXJ0eSB9O1xuXG4vKipcbiAqIFByb3BlcnRpZXMgZm9yIGRlZmluaW5nIGEgYEFMSVlVTjo6Q0VOOjpDZW5CYW5kd2lkdGhMaW1pdGBcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBDZW5CYW5kd2lkdGhMaW1pdFByb3BzIHtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IGJhbmR3aWR0aExpbWl0OiBUaGUgYmFuZHdpZHRoIGNvbmZpZ3VyZWQgZm9yIHRoZSBpbnRlcmNvbm5lY3RlZCByZWdpb25zIGNvbW11bmljYXRpb24uIE1pbmltYWwgdmFsdWU6IDFcbiAgICAgKi9cbiAgICByZWFkb25seSBiYW5kd2lkdGhMaW1pdDogbnVtYmVyIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgY2VuSWQ6IFRoZSBJRCBvZiB0aGUgQ0VOIGluc3RhbmNlLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGNlbklkOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBsb2NhbFJlZ2lvbklkOiBUaGUgSUQgb2YgdGhlIGxvY2FsIHJlZ2lvbi5cbiAgICAgKi9cbiAgICByZWFkb25seSBsb2NhbFJlZ2lvbklkOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBvcHBvc2l0ZVJlZ2lvbklkOiBUaGUgSUQgb2YgdGhlIG90aGVyIGludGVyY29ubmVjdGVkIHJlZ2lvbi5cbiAgICAgKi9cbiAgICByZWFkb25seSBvcHBvc2l0ZVJlZ2lvbklkOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG59XG5cbi8qKlxuICogQSBST1MgcmVzb3VyY2UgdHlwZTogIGBBTElZVU46OkNFTjo6Q2VuQmFuZHdpZHRoTGltaXRgXG4gKi9cbmV4cG9ydCBjbGFzcyBDZW5CYW5kd2lkdGhMaW1pdCBleHRlbmRzIHJvcy5SZXNvdXJjZSB7XG5cbiAgICAvKipcbiAgICAgKiBBIGZhY3RvcnkgbWV0aG9kIHRoYXQgY3JlYXRlcyBhIG5ldyBpbnN0YW5jZSBvZiB0aGlzIGNsYXNzIGZyb20gYW4gb2JqZWN0XG4gICAgICogY29udGFpbmluZyB0aGUgcHJvcGVydGllcyBvZiB0aGlzIFJPUyByZXNvdXJjZSwgd2hpY2ggd2lsbCBiZSBhc3NpZ25lZCB0byBST1MgcmVzb3VyY2UuXG4gICAgICovXG5cbiAgICAvKipcbiAgICAgKiBDcmVhdGUgYSBuZXcgYEFMSVlVTjo6Q0VOOjpDZW5CYW5kd2lkdGhMaW1pdGAuXG4gICAgICpcbiAgICAgKiBQYXJhbSBzY29wZSAtIHNjb3BlIGluIHdoaWNoIHRoaXMgcmVzb3VyY2UgaXMgZGVmaW5lZFxuICAgICAqIFBhcmFtIGlkICAgIC0gc2NvcGVkIGlkIG9mIHRoZSByZXNvdXJjZVxuICAgICAqIFBhcmFtIHByb3BzIC0gcmVzb3VyY2UgcHJvcGVydGllc1xuICAgICAqL1xuICAgIGNvbnN0cnVjdG9yKHNjb3BlOiByb3MuQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogQ2VuQmFuZHdpZHRoTGltaXRQcm9wcywgZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQ6Ym9vbGVhbiA9IHRydWUpIHtcbiAgICAgICAgc3VwZXIoc2NvcGUsIGlkKTtcblxuICAgICAgICBjb25zdCByb3NDZW5CYW5kd2lkdGhMaW1pdCA9IG5ldyBSb3NDZW5CYW5kd2lkdGhMaW1pdCh0aGlzLCBpZCwgIHtcbiAgICAgICAgICAgIG9wcG9zaXRlUmVnaW9uSWQ6IHByb3BzLm9wcG9zaXRlUmVnaW9uSWQsXG4gICAgICAgICAgICBjZW5JZDogcHJvcHMuY2VuSWQsXG4gICAgICAgICAgICBiYW5kd2lkdGhMaW1pdDogcHJvcHMuYmFuZHdpZHRoTGltaXQsXG4gICAgICAgICAgICBsb2NhbFJlZ2lvbklkOiBwcm9wcy5sb2NhbFJlZ2lvbklkLFxuICAgICAgICB9LCBlbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludCAmJiB0aGlzLnN0YWNrLmVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50KTtcbiAgICAgICAgdGhpcy5yZXNvdXJjZSA9IHJvc0NlbkJhbmR3aWR0aExpbWl0O1xuICAgIH1cbn1cbiJdfQ==