import * as cloudwatch from '@aws-cdk/aws-cloudwatch';
declare module "./vpn" {
    /**
     * @stability stable
     */
    interface IVpnConnection {
        /**
         * Return the given named metric for this VPNConnection.
         *
         * @stability stable
         */
        metric(metricName: string, props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The state of the tunnel. 0 indicates DOWN and 1 indicates UP.
         *
         * Average over 5 minutes
         *
         * @stability stable
         */
        metricTunnelState(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The bytes received through the VPN tunnel.
         *
         * Sum over 5 minutes
         *
         * @stability stable
         */
        metricTunnelDataIn(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The bytes sent through the VPN tunnel.
         *
         * Sum over 5 minutes
         *
         * @stability stable
         */
        metricTunnelDataOut(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    }
    /**
     * Define a VPN Connection.
     *
     * @stability stable
     * @resource AWS::EC2::VPNConnection
     */
    interface VpnConnection {
        /**
         * Return the given named metric for this VPNConnection.
         *
         * @stability stable
         */
        metric(metricName: string, props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The state of the tunnel. 0 indicates DOWN and 1 indicates UP.
         *
         * Average over 5 minutes
         *
         * @stability stable
         */
        metricTunnelState(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The bytes received through the VPN tunnel.
         *
         * Sum over 5 minutes
         *
         * @stability stable
         */
        metricTunnelDataIn(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The bytes sent through the VPN tunnel.
         *
         * Sum over 5 minutes
         *
         * @stability stable
         */
        metricTunnelDataOut(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    }
}
