# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/17_annotator_explorer.ipynb (unless otherwise specified).

__all__ = ['ExploreAnnotatorState', 'ExploreAnnotator']

# Internal Cell
from .im2im_annotator import ImCanvas
from .base import BaseState, AppWidgetState, Annotator
from .navi_widget import Navi
from .storage import MapeableStorage, get_image_list_from_folder
from .mltypes import InputImage, Output
from abc import ABC, abstractmethod
from IPython.display import display
from pathlib import Path
from ipywidgets import AppLayout, HBox, Layout
from typing import Any, List, Optional

# Cell

class ExploreAnnotatorState(BaseState):
    image_path: Optional[str]

# Internal Cell

class ExploreAnnotatorGUI(AppLayout):

    def __init__(
        self,
        app_state: AppWidgetState,
        explorer_state: ExploreAnnotatorState,
        fit_canvas: bool = False,
        has_border: bool = False
    ):
        self._app_state = app_state
        self._state = explorer_state

        self._navi = Navi()

        self._controls_box = HBox(
            [self._navi],
            layout=Layout(
                display='flex',
                flex_flow='row wrap',
                align_items='center'
            )
        )

        self._image = ImCanvas(
            width=self._app_state.size[0],
            height=self._app_state.size[1],
            fit_canvas=fit_canvas,
            has_border=has_border
        )

        # set the values already instantiated on state
        if self._state.image_path:
            self._image._draw_image(self._state.image_path)

        self._listen_max_im_number_changes()
        self._navi.on_navi_clicked = self._update_index

        self._state.subscribe(self._image._draw_image, 'image_path')

        super().__init__(header=None,
                         left_sidebar=None,
                         center=self._image,
                         right_sidebar=None,
                         footer=self._controls_box,
                         pane_widths=(2, 8, 0),
                         pane_heights=(1, 4, 1))

    def _listen_max_im_number_changes(self):
        self._update_max_navi_slider(self._app_state.max_im_number)
        self._app_state.subscribe(self._update_max_navi_slider, 'max_im_number')

    def _update_max_navi_slider(self, max_im_number: int):
        self._navi.max_im_num = max_im_number

    def _update_index(self, index: int):
        self._app_state.index = index

    def on_client_ready(self, callback):
        self._image.observe_client_ready(callback)

# Internal Cell
class Storage(ABC):
    @abstractmethod
    def bulk_annotation(self, index: int, annotation: List):
        pass

    @abstractmethod
    def find(self, index: int):
        pass

# Internal Cell
class InMemoryStorage(Storage, MapeableStorage):
    def __init__(
        self,
        image_dir: Path,
    ):
        super().__init__()
        self.images = sorted(get_image_list_from_folder(image_dir))
        self.update({str(image): [] for image in self.images})

    def get_image(self, index: int) -> str:
        return str(self.images[index])

    def bulk_annotation(self, index: int, annotations: list):
        image_path = self.get_image(index)
        self.mapping[image_path] = annotations

    def find(self, index: int):
        image_path = self.get_image(index)
        return self.__getitem__(image_path)

# Internal Cell

class ExploreAnnotatorController:
    def __init__(
        self,
        app_state: AppWidgetState,
        explorer_state: ExploreAnnotatorState,
        storage: Storage
    ):
        self._last_index = 0
        self._app_state = app_state
        self._state = explorer_state
        self._storage = storage

        self._app_state.subscribe(self._update_current_frame, 'index')
        self._update_max_im_number()
        self._update_current_frame()

    def _update_max_im_number(self):
        self._app_state.max_im_number = len(self._storage)

    def _update_current_frame(self, index: int = 0):
        self._save_annotation(self._last_index)
        # "Storage" has no attribute "get_image"
        self._state.image_path = self._storage.get_image(index)  # type: ignore
        self._last_index = index

    def _save_annotation(self, index: int):
        annotations: List[Any] = []
        self._storage.bulk_annotation(index, annotations)

# Cell

class ExploreAnnotator(Annotator):
    def __init__(
        self,
        project_path: Path,
        input_item: InputImage,
        output_item: Output,
        has_border: bool = False,
        *args, **kwargs
    ):
        app_state = AppWidgetState(uuid=str(id(self)), **{
            # "Input" has no attribute "width", "height"
            'size': (input_item.width, input_item.height)  # type: ignore
        })

        super().__init__(app_state)

        self._state = ExploreAnnotatorState(uuid=str(id(self)))

        # "Input" has no attribute "dir"
        self._storage = InMemoryStorage(project_path / input_item.dir)  # type: ignore

        self._controller = ExploreAnnotatorController(
            self.app_state,
            self._state,
            self._storage
        )

        self._view = ExploreAnnotatorGUI(
            self.app_state,
            self._state,
            fit_canvas=input_item.fit_canvas,
            has_border=has_border
        )

    def __repr__(self):
        display(self._view)
        return ""