# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/02b_grid_menu.ipynb (unless otherwise specified).

__all__ = ['GridMenu']

# Internal Cell
from math import ceil
from functools import partial
from typing import Callable, Iterable, Optional, Tuple
import warnings
import attr
from ipywidgets import GridBox, Output, Layout

# Internal Cell
@attr.define(slots=False)
class Grid:
    width: int
    height: int
    n_rows: Optional[int] = 3
    n_cols: Optional[int] = 3
    disp_number: int = 9
    display_label: bool = False

    @property
    def num_items(self) -> int:
        row, col = self.area_adjusted(self.disp_number)
        return row * col

    def area_adjusted(self, n_total: int) -> Tuple[int, int]:
        """Returns the row and col automatic arranged"""
        if self.n_cols is None:
            if self.n_rows is None:  # automatic arrange
                label_cols = 3
                label_rows = ceil(n_total / label_cols)
            else:  # calc cols to show all labels
                label_rows = self.n_rows
                label_cols = ceil(n_total / label_rows)
        else:
            if self.n_rows is None:  # calc rows to show all labels
                label_cols = self.n_cols
                label_rows = ceil(n_total / label_cols)
            else:  # user defined
                label_cols = self.n_cols
                label_rows = self.n_rows

        return label_rows, label_cols

# Cell
class GridMenu(GridBox):
    debug_output = Output(layout={'border': '1px solid black'})

    def __init__(
        self,
        grid: Grid,
        widgets: Optional[Iterable] = None,
    ):
        self.callback = None
        self.gap = 40 if grid.display_label else 15
        self.grid = grid

        n_row, n_col = grid.area_adjusted(grid.disp_number)
        column = grid.width + self.gap
        row = grid.height + self.gap
        centered_settings = {
            'grid_template_columns': " ".join([f'{(column)}px' for _
                                               in range(n_col)]),
            'grid_template_rows': " ".join([f'{row}px' for _
                                            in range(n_row)]),
            'justify_content': 'center',
            'align_content': 'space-around'
        }

        super().__init__(
            layout=Layout(**centered_settings)
        )

        if widgets:
            self.load(widgets)
        self.widgets = widgets

    def _fill_widgets(self, widgets: Iterable):
        if self.widgets is None:
            self.widgets = widgets

            self.children = self.widgets

            if self.callback:
                self.register_on_click()
        else:
            iter_state = iter(widgets)

            for widget in self.widgets:
                i_widget = next(iter_state, None)
                if i_widget:
                    widget.update(i_widget)
                else:
                    widget.clear()

    def _filter_widgets(self, widgets: Iterable) -> Iterable:
        """Limit the number of widgets to be rendered
        according to the grid's area"""
        widgets_list = list(widgets)  # Iterable don't have len()
        num_widgets = len(widgets_list)
        row, col = self.grid.area_adjusted(num_widgets)
        num_items = row * col

        if num_widgets > num_items:
            warnings.warn("!! Not all labels shown. Check n_cols, n_rows args !!")
            return widgets_list[:num_items]

        return widgets

    @debug_output.capture(clear_output=False)
    def load(self, widgets: Iterable, callback: Optional[Callable] = None):
        widgets_filtered = self._filter_widgets(widgets)
        self._fill_widgets(widgets_filtered)

        if callback:
            self.on_click(callback)

    @debug_output.capture(clear_output=False)
    def on_click(self, callback: Callable):
        setattr(self, 'callback', callback)
        self.register_on_click()

    @debug_output.capture(clear_output=False)
    def register_on_click(self):
        if self.widgets:
            for widget in self.widgets:
                widget.reset_callbacks()

                widget.on_click(
                    partial(
                        self.callback,
                        value=widget.value
                    )
                )

    def clear(self):
        self.widgets = None
        self.children = tuple()