"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NodeGroup = exports.CapacityType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const provider_aws_1 = require("@cdktf/provider-aws");
const constructs_1 = require("constructs");
/**
 * @stability stable
 */
var CapacityType;
(function (CapacityType) {
    CapacityType["SPOT"] = "SPOT";
    CapacityType["ON_DEMAND"] = "ON_DEMAND";
})(CapacityType = exports.CapacityType || (exports.CapacityType = {}));
/**
 * @stability stable
 */
class NodeGroup extends constructs_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b, _c, _d, _e, _f, _g, _h, _j, _k;
        super(scope, id);
        this.minCapacity = (_c = (_b = props.scalingConfig) === null || _b === void 0 ? void 0 : _b.minCapacity) !== null && _c !== void 0 ? _c : 0;
        this.desiredCapacity = (_e = (_d = props.scalingConfig) === null || _d === void 0 ? void 0 : _d.desiredCapacity) !== null && _e !== void 0 ? _e : this.minCapacity;
        this.maxCapacity = ((_g = (_f = props.scalingConfig) === null || _f === void 0 ? void 0 : _f.maxCapacity) !== null && _g !== void 0 ? _g : (this.desiredCapacity > 0)) ?
            this.desiredCapacity : 1;
        this.nodeGroupRoleArn = (_h = props.nodeRole) !== null && _h !== void 0 ? _h : this._createNodeGroupRole().arn;
        new provider_aws_1.eks.EksNodeGroup(this, 'NodeGroup', {
            clusterName: props.clusterName,
            nodeRoleArn: this.nodeGroupRoleArn,
            subnetIds: props.subnets,
            scalingConfig: {
                desiredSize: this.desiredCapacity,
                minSize: this.minCapacity,
                maxSize: this.maxCapacity,
            },
            capacityType: (_j = props.capacityType) !== null && _j !== void 0 ? _j : CapacityType.ON_DEMAND,
            instanceTypes: (_k = props.instanceTypes) !== null && _k !== void 0 ? _k : ['t3.large'],
            dependsOn: props.dependsOn,
        });
    }
    _createNodeGroupRole() {
        const role = new provider_aws_1.iam.IamRole(this, 'MNGRole', {
            assumeRolePolicy: JSON.stringify({
                Version: '2012-10-17',
                Statement: [
                    {
                        Action: 'sts:AssumeRole',
                        Effect: 'Allow',
                        Sid: '',
                        Principal: {
                            Service: 'ec2.amazonaws.com',
                        },
                    },
                ],
            }),
        });
        new provider_aws_1.iam.IamPolicyAttachment(this, 'AmazonEKSWorkerNodePolicyAttachment', {
            name: 'AmazonEKSWorkerNodePolicyAttachment',
            policyArn: 'arn:aws:iam::aws:policy/AmazonEKSWorkerNodePolicy',
            roles: [role.name],
        });
        new provider_aws_1.iam.IamPolicyAttachment(this, 'AmazonEKS_CNI_PolicyAttachment', {
            name: 'AmazonEKS_CNI_PolicyAttachment',
            policyArn: 'arn:aws:iam::aws:policy/AmazonEKS_CNI_Policy',
            roles: [role.name],
        });
        new provider_aws_1.iam.IamPolicyAttachment(this, 'AmazonEC2ContainerRegistryReadOnlyAttachment', {
            name: 'AmazonEC2ContainerRegistryReadOnlyAttachment',
            policyArn: 'arn:aws:iam::aws:policy/AmazonEC2ContainerRegistryReadOnly',
            roles: [role.name],
        });
        return role;
    }
}
exports.NodeGroup = NodeGroup;
_a = JSII_RTTI_SYMBOL_1;
NodeGroup[_a] = { fqn: "@pahud/cdktf-aws-eks.NodeGroup", version: "0.3.0" };
//# sourceMappingURL=data:application/json;base64,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