"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Cluster = exports.KubernetesVersion = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const provider_aws_1 = require("@cdktf/provider-aws");
const k8s = require("@cdktf/provider-kubernetes");
const cdktf_1 = require("cdktf");
const constructs_1 = require("constructs");
const _1 = require(".");
const awsVpc = require("./imports/modules/terraform-aws-modules/vpc/aws");
/**
 * Kubernetes cluster version.
 *
 * @stability stable
 */
class KubernetesVersion {
    /**
     *
     * @param version cluster version number
     */
    constructor(version) {
        this.version = version;
    }
    /**
     * Custom cluster version.
     *
     * @param version custom version number.
     * @stability stable
     */
    static of(version) { return new KubernetesVersion(version); }
}
exports.KubernetesVersion = KubernetesVersion;
_a = JSII_RTTI_SYMBOL_1;
KubernetesVersion[_a] = { fqn: "@pahud/cdktf-aws-eks.KubernetesVersion", version: "0.3.0" };
/**
 * Kubernetes version 1.14.
 *
 * @stability stable
 */
KubernetesVersion.V1_14 = KubernetesVersion.of('1.14');
/**
 * Kubernetes version 1.15.
 *
 * @stability stable
 */
KubernetesVersion.V1_15 = KubernetesVersion.of('1.15');
/**
 * Kubernetes version 1.16.
 *
 * @stability stable
 */
KubernetesVersion.V1_16 = KubernetesVersion.of('1.16');
/**
 * Kubernetes version 1.17.
 *
 * @stability stable
 */
KubernetesVersion.V1_17 = KubernetesVersion.of('1.17');
/**
 * Kubernetes version 1.18.
 *
 * @stability stable
 */
KubernetesVersion.V1_18 = KubernetesVersion.of('1.18');
/**
 * Kubernetes version 1.19.
 *
 * @stability stable
 */
KubernetesVersion.V1_19 = KubernetesVersion.of('1.19');
/**
 * Kubernetes version 1.20.
 *
 * @stability stable
 */
KubernetesVersion.V1_20 = KubernetesVersion.of('1.20');
/**
 * Kubernetes version 1.21.
 *
 * @stability stable
 */
KubernetesVersion.V1_21 = KubernetesVersion.of('1.21');
/**
 * The Amazon EKS Cluster with a default nodegroup.
 *
 * @stability stable
 */
class Cluster extends constructs_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _c, _d;
        super(scope, id);
        this.props = props;
        ;
        this.region = (_c = props.region) !== null && _c !== void 0 ? _c : 'us-east-1';
        new provider_aws_1.AwsProvider(this, 'aws', { region: this.region });
        // no private subnets given
        if (!props.privateSubnets) {
            const vpc = this._createVpc();
            this.vpc = vpc;
            this.vpcId = cdktf_1.Token.asString(vpc.vpcIdOutput);
            this.privateSubnets = cdktf_1.Token.asList(vpc.privateSubnetsOutput);
            this.publicSubnets = cdktf_1.Token.asList(vpc.publicSubnetsOutput);
        }
        else {
            this.privateSubnets = props.privateSubnets;
            this.publicSubnets = props.publicSubnets;
        }
        // create the cluster
        this.clusterName = (_d = props.clusterName) !== null && _d !== void 0 ? _d : `${id}cluster`;
        const cluster = new provider_aws_1.eks.EksCluster(this, 'EksCluster', {
            name: this.clusterName,
            version: props.version.version,
            vpcConfig: {
                // the cluster should associate with all available subnets
                subnetIds: this.vpcId ? this.getAllSubnetsFromVpcId(this.vpcId, [this.vpc]).ids :
                    this.privateSubnets.concat(this.publicSubnets),
            },
            roleArn: this._createClusterRole().arn,
        });
        this.cluster = cluster;
        // cluster should be created after vpc
        if (this.vpc) {
            cluster.node.addDependency(this.vpc);
        }
        this.defaultNodeGroup = new _1.NodeGroup(this, 'NG', {
            clusterName: cluster.name,
            subnets: this.privateSubnets,
            scalingConfig: props.scalingConfig,
            capacityType: props.capacityType,
            instanceTypes: props.instanceTypes,
            dependsOn: [this.cluster],
        });
        const clusterAuthData = new provider_aws_1.eks.DataAwsEksClusterAuth(this, 'DataAwsEksClusterAuth', {
            name: this.clusterName,
        });
        let cert = `\${base64decode(${cluster.certificateAuthority})}`;
        const k8sprovider = new k8s.KubernetesProvider(this, 'Kubernetes', {
            host: cdktf_1.Token.asString(cluster.endpoint),
            token: cdktf_1.Token.asString(clusterAuthData.token),
        });
        k8sprovider.addOverride('cluster_ca_certificate', cert);
        new cdktf_1.TerraformOutput(this, 'KubelctlCommand', {
            value: `aws --region ${this.region} eks update-kubeconfig --name ${this.clusterName}`,
        });
    }
    _createVpc() {
        const vpc = new awsVpc.TerraformAwsModulesVpcAws(this, 'Vpc', {
            cidr: '10.0.0.0/16',
            azs: new provider_aws_1.datasources.DataAwsAvailabilityZones(this, 'AZs', {
                state: 'available',
            }).names,
            publicSubnets: ['10.0.1.0/24', '10.0.2.0/24', '10.0.3.0/24'],
            privateSubnets: ['10.0.11.0/24', '10.0.12.0/24', '10.0.13.0/24'],
            singleNatGateway: true,
            enableNatGateway: true,
            oneNatGatewayPerAz: false,
        });
        return vpc;
    }
    _createClusterRole() {
        const role = new provider_aws_1.iam.IamRole(this, 'ClusterRole', {
            assumeRolePolicy: JSON.stringify({
                Version: '2012-10-17',
                Statement: [
                    {
                        Action: 'sts:AssumeRole',
                        Effect: 'Allow',
                        Sid: '',
                        Principal: {
                            Service: 'eks.amazonaws.com',
                        },
                    },
                ],
            }),
        });
        new provider_aws_1.iam.IamPolicyAttachment(this, 'AmazonEKSClusterPolicyAttachment', {
            name: 'AmazonEKSClusterPolicyAttachment',
            policyArn: 'arn:aws:iam::aws:policy/AmazonEKSClusterPolicy',
            roles: [role.name],
        });
        new provider_aws_1.iam.IamPolicyAttachment(this, 'AmazonEKSVPCResourceControllerAttachment', {
            name: 'AmazonEKSVPCResourceControllerAttachment',
            policyArn: 'arn:aws:iam::aws:policy/AmazonEKSVPCResourceController',
            roles: [role.name],
        });
        return role;
    }
    getAllSubnetsFromVpcId(vpcId, dependable) {
        return new provider_aws_1.vpc.DataAwsSubnetIds(this, 'subnets', {
            vpcId,
            dependsOn: dependable,
        });
    }
    /**
     * @stability stable
     */
    addNodeGroup(id, options) {
        var _c, _d, _e;
        new _1.NodeGroup(this, id, {
            ...options,
            clusterName: this.clusterName,
            nodeRole: (_c = options.nodeRole) !== null && _c !== void 0 ? _c : (_d = this.defaultNodeGroup) === null || _d === void 0 ? void 0 : _d.nodeGroupRoleArn,
            subnets: (_e = options.subnets) !== null && _e !== void 0 ? _e : this.privateSubnets,
            dependsOn: [this.cluster],
        });
    }
}
exports.Cluster = Cluster;
_b = JSII_RTTI_SYMBOL_1;
Cluster[_b] = { fqn: "@pahud/cdktf-aws-eks.Cluster", version: "0.3.0" };
//# sourceMappingURL=data:application/json;base64,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