# generated by datamodel-codegen:
#   filename:  argo-workflows-3.6.2.json

from __future__ import annotations

from enum import Enum
from typing import Annotated, Dict, List, Optional

from hera.shared._pydantic import BaseModel, Field

from ...apimachinery.pkg.api import resource
from ...apimachinery.pkg.apis.meta import v1
from ...apimachinery.pkg.util import intstr


class SecretKeySelector(BaseModel):
    key: Annotated[
        str,
        Field(description=("The key of the secret to select from.  Must be a valid secret key.")),
    ]
    name: Annotated[
        Optional[str],
        Field(
            description=(
                "Name of the referent. This field is effectively required, but due to"
                " backwards compatibility is allowed to be empty. Instances of this"
                " type with an empty value here are almost certainly wrong. More info:"
                " https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names"
            )
        ),
    ] = None
    optional: Annotated[
        Optional[bool],
        Field(description="Specify whether the Secret or its key must be defined"),
    ] = None


class ConfigMapKeySelector(BaseModel):
    key: Annotated[str, Field(description="The key to select.")]
    name: Annotated[
        Optional[str],
        Field(
            description=(
                "Name of the referent. This field is effectively required, but due to"
                " backwards compatibility is allowed to be empty. Instances of this"
                " type with an empty value here are almost certainly wrong. More info:"
                " https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names"
            )
        ),
    ] = None
    optional: Annotated[
        Optional[bool],
        Field(description="Specify whether the ConfigMap or its key must be defined"),
    ] = None


class AWSElasticBlockStoreVolumeSource(BaseModel):
    fs_type: Annotated[
        Optional[str],
        Field(
            alias="fsType",
            description=(
                "fsType is the filesystem type of the volume that you want to mount."
                " Tip: Ensure that the filesystem type is supported by the host"
                ' operating system. Examples: "ext4", "xfs", "ntfs". Implicitly'
                ' inferred to be "ext4" if unspecified. More info:'
                " https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore"
            ),
        ),
    ] = None
    partition: Annotated[
        Optional[int],
        Field(
            description=(
                "partition is the partition in the volume that you want to mount. If"
                " omitted, the default is to mount by volume name. Examples: For volume"
                ' /dev/sda1, you specify the partition as "1". Similarly, the volume'
                ' partition for /dev/sda is "0" (or you can leave the property empty).'
            )
        ),
    ] = None
    read_only: Annotated[
        Optional[bool],
        Field(
            alias="readOnly",
            description=(
                "readOnly value true will force the readOnly setting in VolumeMounts."
                " More info:"
                " https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore"
            ),
        ),
    ] = None
    volume_id: Annotated[
        str,
        Field(
            alias="volumeID",
            description=(
                "volumeID is unique ID of the persistent disk resource in AWS (Amazon"
                " EBS volume). More info:"
                " https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore"
            ),
        ),
    ]


class AppArmorProfile(BaseModel):
    localhost_profile: Annotated[
        Optional[str],
        Field(
            alias="localhostProfile",
            description=(
                "localhostProfile indicates a profile loaded on the node that should be"
                " used. The profile must be preconfigured on the node to work. Must"
                " match the loaded name of the profile. Must be set if and only if type"
                ' is "Localhost".'
            ),
        ),
    ] = None
    type: Annotated[
        str,
        Field(
            description=(
                "type indicates which kind of AppArmor profile will be applied. Valid"
                " options are:\n  Localhost - a profile pre-loaded on the node.\n "
                " RuntimeDefault - the container runtime's default profile.\n "
                " Unconfined - no AppArmor enforcement."
            )
        ),
    ]


class AzureDiskVolumeSource(BaseModel):
    caching_mode: Annotated[
        Optional[str],
        Field(
            alias="cachingMode",
            description=("cachingMode is the Host Caching mode: None, Read Only, Read Write."),
        ),
    ] = None
    disk_name: Annotated[
        str,
        Field(
            alias="diskName",
            description="diskName is the Name of the data disk in the blob storage",
        ),
    ]
    disk_uri: Annotated[
        str,
        Field(
            alias="diskURI",
            description="diskURI is the URI of data disk in the blob storage",
        ),
    ]
    fs_type: Annotated[
        Optional[str],
        Field(
            alias="fsType",
            description=(
                "fsType is Filesystem type to mount. Must be a filesystem type"
                ' supported by the host operating system. Ex. "ext4", "xfs", "ntfs".'
                ' Implicitly inferred to be "ext4" if unspecified.'
            ),
        ),
    ] = None
    kind: Annotated[
        Optional[str],
        Field(
            description=(
                "kind expected values are Shared: multiple blob disks per storage"
                " account  Dedicated: single blob disk per storage account  Managed:"
                " azure managed data disk (only in managed availability set). defaults"
                " to shared"
            )
        ),
    ] = None
    read_only: Annotated[
        Optional[bool],
        Field(
            alias="readOnly",
            description=(
                "readOnly Defaults to false (read/write). ReadOnly here will force the"
                " ReadOnly setting in VolumeMounts."
            ),
        ),
    ] = None


class AzureFileVolumeSource(BaseModel):
    read_only: Annotated[
        Optional[bool],
        Field(
            alias="readOnly",
            description=(
                "readOnly defaults to false (read/write). ReadOnly here will force the"
                " ReadOnly setting in VolumeMounts."
            ),
        ),
    ] = None
    secret_name: Annotated[
        str,
        Field(
            alias="secretName",
            description=("secretName is the  name of secret that contains Azure Storage Account Name and Key"),
        ),
    ]
    share_name: Annotated[str, Field(alias="shareName", description="shareName is the azure share Name")]


class LocalObjectReference(BaseModel):
    name: Annotated[
        Optional[str],
        Field(
            description=(
                "Name of the referent. This field is effectively required, but due to"
                " backwards compatibility is allowed to be empty. Instances of this"
                " type with an empty value here are almost certainly wrong. More info:"
                " https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names"
            )
        ),
    ] = None


class Capabilities(BaseModel):
    add: Annotated[Optional[List[str]], Field(description="Added capabilities")] = None
    drop: Annotated[Optional[List[str]], Field(description="Removed capabilities")] = None


class ConfigMapEnvSource(BaseModel):
    name: Annotated[
        Optional[str],
        Field(
            description=(
                "Name of the referent. This field is effectively required, but due to"
                " backwards compatibility is allowed to be empty. Instances of this"
                " type with an empty value here are almost certainly wrong. More info:"
                " https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names"
            )
        ),
    ] = None
    optional: Annotated[
        Optional[bool],
        Field(description="Specify whether the ConfigMap must be defined"),
    ] = None


class ContainerPort(BaseModel):
    container_port: Annotated[
        int,
        Field(
            alias="containerPort",
            description=(
                "Number of port to expose on the pod's IP address. This must be a valid port number, 0 < x < 65536."
            ),
        ),
    ]
    host_ip: Annotated[
        Optional[str],
        Field(alias="hostIP", description="What host IP to bind the external port to."),
    ] = None
    host_port: Annotated[
        Optional[int],
        Field(
            alias="hostPort",
            description=(
                "Number of port to expose on the host. If specified, this must be a"
                " valid port number, 0 < x < 65536. If HostNetwork is specified, this"
                " must match ContainerPort. Most containers do not need this."
            ),
        ),
    ] = None
    name: Annotated[
        Optional[str],
        Field(
            description=(
                "If specified, this must be an IANA_SVC_NAME and unique within the pod."
                " Each named port in a pod must have a unique name. Name for the port"
                " that can be referred to by services."
            )
        ),
    ] = None
    protocol: Annotated[
        Optional[str],
        Field(description=('Protocol for port. Must be UDP, TCP, or SCTP. Defaults to "TCP".')),
    ] = None


class ContainerResizePolicy(BaseModel):
    resource_name: Annotated[
        str,
        Field(
            alias="resourceName",
            description=(
                "Name of the resource to which this resource resize policy applies. Supported values: cpu, memory."
            ),
        ),
    ]
    restart_policy: Annotated[
        str,
        Field(
            alias="restartPolicy",
            description=(
                "Restart policy to apply when specified resource is resized. If not"
                " specified, it defaults to NotRequired."
            ),
        ),
    ]


class ObjectFieldSelector(BaseModel):
    api_version: Annotated[
        Optional[str],
        Field(
            alias="apiVersion",
            description=('Version of the schema the FieldPath is written in terms of, defaults to "v1".'),
        ),
    ] = None
    field_path: Annotated[
        str,
        Field(
            alias="fieldPath",
            description="Path of the field to select in the specified API version.",
        ),
    ]


class SecretEnvSource(BaseModel):
    name: Annotated[
        Optional[str],
        Field(
            description=(
                "Name of the referent. This field is effectively required, but due to"
                " backwards compatibility is allowed to be empty. Instances of this"
                " type with an empty value here are almost certainly wrong. More info:"
                " https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names"
            )
        ),
    ] = None
    optional: Annotated[Optional[bool], Field(description="Specify whether the Secret must be defined")] = None


class ObjectReference(BaseModel):
    api_version: Annotated[
        Optional[str],
        Field(alias="apiVersion", description="API version of the referent."),
    ] = None
    field_path: Annotated[
        Optional[str],
        Field(
            alias="fieldPath",
            description=(
                "If referring to a piece of an object instead of an entire object, this"
                " string should contain a valid JSON/Go field access statement, such as"
                " desiredState.manifest.containers[2]. For example, if the object"
                " reference is to a container within a pod, this would take on a value"
                ' like: "spec.containers{name}" (where "name" refers to the name of the'
                " container that triggered the event) or if no container name is"
                ' specified "spec.containers[2]" (container with index 2 in this pod).'
                " This syntax is chosen only to have some well-defined way of"
                " referencing a part of an object."
            ),
        ),
    ] = None
    kind: Annotated[
        Optional[str],
        Field(
            description=(
                "Kind of the referent. More info:"
                " https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds"
            )
        ),
    ] = None
    name: Annotated[
        Optional[str],
        Field(
            description=(
                "Name of the referent. More info:"
                " https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names"
            )
        ),
    ] = None
    namespace: Annotated[
        Optional[str],
        Field(
            description=(
                "Namespace of the referent. More info:"
                " https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/"
            )
        ),
    ] = None
    resource_version: Annotated[
        Optional[str],
        Field(
            alias="resourceVersion",
            description=(
                "Specific resourceVersion to which this reference is made, if any. More"
                " info:"
                " https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency"
            ),
        ),
    ] = None
    uid: Annotated[
        Optional[str],
        Field(
            description=(
                "UID of the referent. More info:"
                " https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#uids"
            )
        ),
    ] = None


class EventSource(BaseModel):
    component: Annotated[Optional[str], Field(description="Component from which the event is generated.")] = None
    host: Annotated[Optional[str], Field(description="Node name on which the event is generated.")] = None


class ExecAction(BaseModel):
    command: Annotated[
        Optional[List[str]],
        Field(
            description=(
                "Command is the command line to execute inside the container, the"
                " working directory for the command  is root ('/') in the container's"
                " filesystem. The command is simply exec'd, it is not run inside a"
                " shell, so traditional shell instructions ('|', etc) won't work. To"
                " use a shell, you need to explicitly call out to that shell. Exit"
                " status of 0 is treated as live/healthy and non-zero is unhealthy."
            )
        ),
    ] = None


class FCVolumeSource(BaseModel):
    fs_type: Annotated[
        Optional[str],
        Field(
            alias="fsType",
            description=(
                "fsType is the filesystem type to mount. Must be a filesystem type"
                ' supported by the host operating system. Ex. "ext4", "xfs", "ntfs".'
                ' Implicitly inferred to be "ext4" if unspecified.'
            ),
        ),
    ] = None
    lun: Annotated[Optional[int], Field(description="lun is Optional: FC target lun number")] = None
    read_only: Annotated[
        Optional[bool],
        Field(
            alias="readOnly",
            description=(
                "readOnly is Optional: Defaults to false (read/write). ReadOnly here"
                " will force the ReadOnly setting in VolumeMounts."
            ),
        ),
    ] = None
    target_ww_ns: Annotated[
        Optional[List[str]],
        Field(
            alias="targetWWNs",
            description="targetWWNs is Optional: FC target worldwide names (WWNs)",
        ),
    ] = None
    wwids: Annotated[
        Optional[List[str]],
        Field(
            description=(
                "wwids Optional: FC volume world wide identifiers (wwids) Either wwids"
                " or combination of targetWWNs and lun must be set, but not both"
                " simultaneously."
            )
        ),
    ] = None


class FlockerVolumeSource(BaseModel):
    dataset_name: Annotated[
        Optional[str],
        Field(
            alias="datasetName",
            description=(
                "datasetName is Name of the dataset stored as metadata -> name on the"
                " dataset for Flocker should be considered as deprecated"
            ),
        ),
    ] = None
    dataset_uuid: Annotated[
        Optional[str],
        Field(
            alias="datasetUUID",
            description=("datasetUUID is the UUID of the dataset. This is unique identifier of a Flocker dataset"),
        ),
    ] = None


class GCEPersistentDiskVolumeSource(BaseModel):
    fs_type: Annotated[
        Optional[str],
        Field(
            alias="fsType",
            description=(
                "fsType is filesystem type of the volume that you want to mount. Tip:"
                " Ensure that the filesystem type is supported by the host operating"
                ' system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be'
                ' "ext4" if unspecified. More info:'
                " https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk"
            ),
        ),
    ] = None
    partition: Annotated[
        Optional[int],
        Field(
            description=(
                "partition is the partition in the volume that you want to mount. If"
                " omitted, the default is to mount by volume name. Examples: For volume"
                ' /dev/sda1, you specify the partition as "1". Similarly, the volume'
                ' partition for /dev/sda is "0" (or you can leave the property empty).'
                " More info:"
                " https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk"
            )
        ),
    ] = None
    pd_name: Annotated[
        str,
        Field(
            alias="pdName",
            description=(
                "pdName is unique name of the PD resource in GCE. Used to identify the"
                " disk in GCE. More info:"
                " https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk"
            ),
        ),
    ]
    read_only: Annotated[
        Optional[bool],
        Field(
            alias="readOnly",
            description=(
                "readOnly here will force the ReadOnly setting in VolumeMounts."
                " Defaults to false. More info:"
                " https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk"
            ),
        ),
    ] = None


class GRPCAction(BaseModel):
    port: Annotated[
        int,
        Field(description=("Port number of the gRPC service. Number must be in the range 1 to 65535.")),
    ]
    service: Annotated[
        Optional[str],
        Field(
            description=(
                "Service is the name of the service to place in the gRPC"
                " HealthCheckRequest (see"
                " https://github.com/grpc/grpc/blob/master/doc/health-checking.md).\n\nIf"
                " this is not specified, the default behavior is defined by gRPC."
            )
        ),
    ] = None


class GitRepoVolumeSource(BaseModel):
    directory: Annotated[
        Optional[str],
        Field(
            description=(
                "directory is the target directory name. Must not contain or start with"
                " '..'.  If '.' is supplied, the volume directory will be the git"
                " repository.  Otherwise, if specified, the volume will contain the git"
                " repository in the subdirectory with the given name."
            )
        ),
    ] = None
    repository: Annotated[str, Field(description="repository is the URL")]
    revision: Annotated[
        Optional[str],
        Field(description="revision is the commit hash for the specified revision."),
    ] = None


class GlusterfsVolumeSource(BaseModel):
    endpoints: Annotated[
        str,
        Field(
            description=(
                "endpoints is the endpoint name that details Glusterfs topology. More"
                " info:"
                " https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod"
            )
        ),
    ]
    path: Annotated[
        str,
        Field(
            description=(
                "path is the Glusterfs volume path. More info:"
                " https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod"
            )
        ),
    ]
    read_only: Annotated[
        Optional[bool],
        Field(
            alias="readOnly",
            description=(
                "readOnly here will force the Glusterfs volume to be mounted with"
                " read-only permissions. Defaults to false. More info:"
                " https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod"
            ),
        ),
    ] = None


class HTTPHeader(BaseModel):
    name: Annotated[
        str,
        Field(
            description=(
                "The header field name. This will be canonicalized upon output, so"
                " case-variant names will be understood as the same header."
            )
        ),
    ]
    value: Annotated[str, Field(description="The header field value")]


class HostAlias(BaseModel):
    hostnames: Annotated[Optional[List[str]], Field(description="Hostnames for the above IP address.")] = None
    ip: Annotated[str, Field(description="IP address of the host file entry.")]


class HostPathVolumeSource(BaseModel):
    path: Annotated[
        str,
        Field(
            description=(
                "path of the directory on the host. If the path is a symlink, it will"
                " follow the link to the real path. More info:"
                " https://kubernetes.io/docs/concepts/storage/volumes#hostpath"
            )
        ),
    ]
    type: Annotated[
        Optional[str],
        Field(
            description=(
                'type for HostPath Volume Defaults to "" More info:'
                " https://kubernetes.io/docs/concepts/storage/volumes#hostpath"
            )
        ),
    ] = None


class KeyToPath(BaseModel):
    key: Annotated[str, Field(description="key is the key to project.")]
    mode: Annotated[
        Optional[int],
        Field(
            description=(
                "mode is Optional: mode bits used to set permissions on this file. Must"
                " be an octal value between 0000 and 0777 or a decimal value between 0"
                " and 511. YAML accepts both octal and decimal values, JSON requires"
                " decimal values for mode bits. If not specified, the volume"
                " defaultMode will be used. This might be in conflict with other"
                " options that affect the file mode, like fsGroup, and the result can"
                " be other mode bits set."
            )
        ),
    ] = None
    path: Annotated[
        str,
        Field(
            description=(
                "path is the relative path of the file to map the key to. May not be an"
                " absolute path. May not contain the path element '..'. May not start"
                " with the string '..'."
            )
        ),
    ]


class SleepAction(BaseModel):
    seconds: Annotated[int, Field(description="Seconds is the number of seconds to sleep.")]


class ModifyVolumeStatus(BaseModel):
    status: Annotated[
        str,
        Field(
            description=(
                "status is the status of the ControllerModifyVolume operation. It can"
                " be in any of following states:\n - Pending\n   Pending indicates that"
                " the PersistentVolumeClaim cannot be modified due to unmet"
                " requirements, such as\n   the specified VolumeAttributesClass not"
                " existing.\n - InProgress\n   InProgress indicates that the volume is"
                " being modified.\n - Infeasible\n  Infeasible indicates that the"
                " request has been rejected as invalid by the CSI driver. To\n\t "
                " resolve the error, a valid VolumeAttributesClass needs to be"
                " specified.\nNote: New statuses can be added in the future. Consumers"
                " should check for unknown statuses and fail appropriately."
            )
        ),
    ]
    target_volume_attributes_class_name: Annotated[
        Optional[str],
        Field(
            alias="targetVolumeAttributesClassName",
            description=(
                "targetVolumeAttributesClassName is the name of the"
                " VolumeAttributesClass the PVC currently being reconciled"
            ),
        ),
    ] = None


class NFSVolumeSource(BaseModel):
    path: Annotated[
        str,
        Field(
            description=(
                "path that is exported by the NFS server. More info:"
                " https://kubernetes.io/docs/concepts/storage/volumes#nfs"
            )
        ),
    ]
    read_only: Annotated[
        Optional[bool],
        Field(
            alias="readOnly",
            description=(
                "readOnly here will force the NFS export to be mounted with read-only"
                " permissions. Defaults to false. More info:"
                " https://kubernetes.io/docs/concepts/storage/volumes#nfs"
            ),
        ),
    ] = None
    server: Annotated[
        str,
        Field(
            description=(
                "server is the hostname or IP address of the NFS server. More info:"
                " https://kubernetes.io/docs/concepts/storage/volumes#nfs"
            )
        ),
    ]


class NodeSelectorRequirement(BaseModel):
    key: Annotated[str, Field(description="The label key that the selector applies to.")]
    operator: Annotated[
        str,
        Field(
            description=(
                "Represents a key's relationship to a set of values. Valid operators"
                " are In, NotIn, Exists, DoesNotExist. Gt, and Lt."
            )
        ),
    ]
    values: Annotated[
        Optional[List[str]],
        Field(
            description=(
                "An array of string values. If the operator is In or NotIn, the values"
                " array must be non-empty. If the operator is Exists or DoesNotExist,"
                " the values array must be empty. If the operator is Gt or Lt, the"
                " values array must have a single element, which will be interpreted as"
                " an integer. This array is replaced during a strategic merge patch."
            )
        ),
    ] = None


class NodeSelectorTerm(BaseModel):
    match_expressions: Annotated[
        Optional[List[NodeSelectorRequirement]],
        Field(
            alias="matchExpressions",
            description="A list of node selector requirements by node's labels.",
        ),
    ] = None
    match_fields: Annotated[
        Optional[List[NodeSelectorRequirement]],
        Field(
            alias="matchFields",
            description="A list of node selector requirements by node's fields.",
        ),
    ] = None


class TypedLocalObjectReference(BaseModel):
    api_group: Annotated[
        Optional[str],
        Field(
            alias="apiGroup",
            description=(
                "APIGroup is the group for the resource being referenced. If APIGroup"
                " is not specified, the specified Kind must be in the core API group."
                " For any other third-party types, APIGroup is required."
            ),
        ),
    ] = None
    kind: Annotated[str, Field(description="Kind is the type of resource being referenced")]
    name: Annotated[str, Field(description="Name is the name of resource being referenced")]


class TypedObjectReference(BaseModel):
    api_group: Annotated[
        Optional[str],
        Field(
            alias="apiGroup",
            description=(
                "APIGroup is the group for the resource being referenced. If APIGroup"
                " is not specified, the specified Kind must be in the core API group."
                " For any other third-party types, APIGroup is required."
            ),
        ),
    ] = None
    kind: Annotated[str, Field(description="Kind is the type of resource being referenced")]
    name: Annotated[str, Field(description="Name is the name of resource being referenced")]
    namespace: Annotated[
        Optional[str],
        Field(
            description=(
                "Namespace is the namespace of resource being referenced Note that when"
                " a namespace is specified, a gateway.networking.k8s.io/ReferenceGrant"
                " object is required in the referent namespace to allow that"
                " namespace's owner to accept the reference. See the ReferenceGrant"
                " documentation for details. (Alpha) This field requires the"
                " CrossNamespaceVolumeDataSource feature gate to be enabled."
            )
        ),
    ] = None


class VolumeResourceRequirements(BaseModel):
    limits: Annotated[
        Optional[Dict[str, resource.Quantity]],
        Field(
            description=(
                "Limits describes the maximum amount of compute resources allowed. More"
                " info:"
                " https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/"
            )
        ),
    ] = None
    requests: Annotated[
        Optional[Dict[str, resource.Quantity]],
        Field(
            description=(
                "Requests describes the minimum amount of compute resources required."
                " If Requests is omitted for a container, it defaults to Limits if that"
                " is explicitly specified, otherwise to an implementation-defined"
                " value. Requests cannot exceed Limits. More info:"
                " https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/"
            )
        ),
    ] = None


class PersistentVolumeClaimVolumeSource(BaseModel):
    claim_name: Annotated[
        str,
        Field(
            alias="claimName",
            description=(
                "claimName is the name of a PersistentVolumeClaim in the same namespace"
                " as the pod using this volume. More info:"
                " https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims"
            ),
        ),
    ]
    read_only: Annotated[
        Optional[bool],
        Field(
            alias="readOnly",
            description=("readOnly Will force the ReadOnly setting in VolumeMounts. Default false."),
        ),
    ] = None


class PhotonPersistentDiskVolumeSource(BaseModel):
    fs_type: Annotated[
        Optional[str],
        Field(
            alias="fsType",
            description=(
                "fsType is the filesystem type to mount. Must be a filesystem type"
                ' supported by the host operating system. Ex. "ext4", "xfs", "ntfs".'
                ' Implicitly inferred to be "ext4" if unspecified.'
            ),
        ),
    ] = None
    pd_id: Annotated[
        str,
        Field(
            alias="pdID",
            description=("pdID is the ID that identifies Photon Controller persistent disk"),
        ),
    ]


class PodDNSConfigOption(BaseModel):
    name: Annotated[Optional[str], Field(description="Required.")] = None
    value: Optional[str] = None


class SELinuxOptions(BaseModel):
    level: Annotated[
        Optional[str],
        Field(description="Level is SELinux level label that applies to the container."),
    ] = None
    role: Annotated[
        Optional[str],
        Field(description="Role is a SELinux role label that applies to the container."),
    ] = None
    type: Annotated[
        Optional[str],
        Field(description="Type is a SELinux type label that applies to the container."),
    ] = None
    user: Annotated[
        Optional[str],
        Field(description="User is a SELinux user label that applies to the container."),
    ] = None


class SeccompProfile(BaseModel):
    localhost_profile: Annotated[
        Optional[str],
        Field(
            alias="localhostProfile",
            description=(
                "localhostProfile indicates a profile defined in a file on the node"
                " should be used. The profile must be preconfigured on the node to"
                " work. Must be a descending path, relative to the kubelet's"
                " configured seccomp profile location. Must be set if type is"
                ' "Localhost". Must NOT be set for any other type.'
            ),
        ),
    ] = None
    type: Annotated[
        str,
        Field(
            description=(
                "type indicates which kind of seccomp profile will be applied. Valid"
                " options are:\n\nLocalhost - a profile defined in a file on the node"
                " should be used. RuntimeDefault - the container runtime default"
                " profile should be used. Unconfined - no profile should be applied."
            )
        ),
    ]


class WindowsSecurityContextOptions(BaseModel):
    gmsa_credential_spec: Annotated[
        Optional[str],
        Field(
            alias="gmsaCredentialSpec",
            description=(
                "GMSACredentialSpec is where the GMSA admission webhook"
                " (https://github.com/kubernetes-sigs/windows-gmsa) inlines the"
                " contents of the GMSA credential spec named by the"
                " GMSACredentialSpecName field."
            ),
        ),
    ] = None
    gmsa_credential_spec_name: Annotated[
        Optional[str],
        Field(
            alias="gmsaCredentialSpecName",
            description=("GMSACredentialSpecName is the name of the GMSA credential spec to use."),
        ),
    ] = None
    host_process: Annotated[
        Optional[bool],
        Field(
            alias="hostProcess",
            description=(
                "HostProcess determines if a container should be run as a 'Host"
                " Process' container. All of a Pod's containers must have the same"
                " effective HostProcess value (it is not allowed to have a mix of"
                " HostProcess containers and non-HostProcess containers). In addition,"
                " if HostProcess is true then HostNetwork must also be set to true."
            ),
        ),
    ] = None
    run_as_user_name: Annotated[
        Optional[str],
        Field(
            alias="runAsUserName",
            description=(
                "The UserName in Windows to run the entrypoint of the container"
                " process. Defaults to the user specified in image metadata if"
                " unspecified. May also be set in PodSecurityContext. If set in both"
                " SecurityContext and PodSecurityContext, the value specified in"
                " SecurityContext takes precedence."
            ),
        ),
    ] = None


class PortworxVolumeSource(BaseModel):
    fs_type: Annotated[
        Optional[str],
        Field(
            alias="fsType",
            description=(
                "fSType represents the filesystem type to mount Must be a filesystem"
                ' type supported by the host operating system. Ex. "ext4", "xfs".'
                ' Implicitly inferred to be "ext4" if unspecified.'
            ),
        ),
    ] = None
    read_only: Annotated[
        Optional[bool],
        Field(
            alias="readOnly",
            description=(
                "readOnly defaults to false (read/write). ReadOnly here will force the"
                " ReadOnly setting in VolumeMounts."
            ),
        ),
    ] = None
    volume_id: Annotated[
        str,
        Field(
            alias="volumeID",
            description="volumeID uniquely identifies a Portworx volume",
        ),
    ]


class QuobyteVolumeSource(BaseModel):
    group: Annotated[
        Optional[str],
        Field(description="group to map volume access to Default is no group"),
    ] = None
    read_only: Annotated[
        Optional[bool],
        Field(
            alias="readOnly",
            description=(
                "readOnly here will force the Quobyte volume to be mounted with"
                " read-only permissions. Defaults to false."
            ),
        ),
    ] = None
    registry: Annotated[
        str,
        Field(
            description=(
                "registry represents a single or multiple Quobyte Registry services"
                " specified as a string as host:port pair (multiple entries are"
                " separated with commas) which acts as the central registry for volumes"
            )
        ),
    ]
    tenant: Annotated[
        Optional[str],
        Field(
            description=(
                "tenant owning the given Quobyte volume in the Backend Used with"
                " dynamically provisioned Quobyte volumes, value is set by the plugin"
            )
        ),
    ] = None
    user: Annotated[
        Optional[str],
        Field(description="user to map volume access to Defaults to serivceaccount user"),
    ] = None
    volume: Annotated[
        str,
        Field(description=("volume is a string that references an already created Quobyte volume by name.")),
    ]


class ResourceClaim(BaseModel):
    name: Annotated[
        str,
        Field(
            description=(
                "Name must match the name of one entry in pod.spec.resourceClaims of"
                " the Pod where this field is used. It makes that resource available"
                " inside a container."
            )
        ),
    ]


class SecretProjection(BaseModel):
    items: Annotated[
        Optional[List[KeyToPath]],
        Field(
            description=(
                "items if unspecified, each key-value pair in the Data field of the"
                " referenced Secret will be projected into the volume as a file whose"
                " name is the key and content is the value. If specified, the listed"
                " keys will be projected into the specified paths, and unlisted keys"
                " will not be present. If a key is specified which is not present in"
                " the Secret, the volume setup will error unless it is marked optional."
                " Paths must be relative and may not contain the '..' path or start"
                " with '..'."
            )
        ),
    ] = None
    name: Annotated[
        Optional[str],
        Field(
            description=(
                "Name of the referent. This field is effectively required, but due to"
                " backwards compatibility is allowed to be empty. Instances of this"
                " type with an empty value here are almost certainly wrong. More info:"
                " https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names"
            )
        ),
    ] = None
    optional: Annotated[
        Optional[bool],
        Field(description=("optional field specify whether the Secret or its key must be defined")),
    ] = None


class SecretVolumeSource(BaseModel):
    default_mode: Annotated[
        Optional[int],
        Field(
            alias="defaultMode",
            description=(
                "defaultMode is Optional: mode bits used to set permissions on created"
                " files by default. Must be an octal value between 0000 and 0777 or a"
                " decimal value between 0 and 511. YAML accepts both octal and decimal"
                " values, JSON requires decimal values for mode bits. Defaults to 0644."
                " Directories within the path are not affected by this setting. This"
                " might be in conflict with other options that affect the file mode,"
                " like fsGroup, and the result can be other mode bits set."
            ),
        ),
    ] = None
    items: Annotated[
        Optional[List[KeyToPath]],
        Field(
            description=(
                "items If unspecified, each key-value pair in the Data field of the"
                " referenced Secret will be projected into the volume as a file whose"
                " name is the key and content is the value. If specified, the listed"
                " keys will be projected into the specified paths, and unlisted keys"
                " will not be present. If a key is specified which is not present in"
                " the Secret, the volume setup will error unless it is marked optional."
                " Paths must be relative and may not contain the '..' path or start"
                " with '..'."
            )
        ),
    ] = None
    optional: Annotated[
        Optional[bool],
        Field(description=("optional field specify whether the Secret or its keys must be defined")),
    ] = None
    secret_name: Annotated[
        Optional[str],
        Field(
            alias="secretName",
            description=(
                "secretName is the name of the secret in the pod's namespace to use."
                " More info: https://kubernetes.io/docs/concepts/storage/volumes#secret"
            ),
        ),
    ] = None


class ServiceAccountTokenProjection(BaseModel):
    audience: Annotated[
        Optional[str],
        Field(
            description=(
                "audience is the intended audience of the token. A recipient of a token"
                " must identify itself with an identifier specified in the audience of"
                " the token, and otherwise should reject the token. The audience"
                " defaults to the identifier of the apiserver."
            )
        ),
    ] = None
    expiration_seconds: Annotated[
        Optional[int],
        Field(
            alias="expirationSeconds",
            description=(
                "expirationSeconds is the requested duration of validity of the service"
                " account token. As the token approaches expiration, the kubelet volume"
                " plugin will proactively rotate the service account token. The kubelet"
                " will start trying to rotate the token if the token is older than 80"
                " percent of its time to live or if the token is older than 24"
                " hours.Defaults to 1 hour and must be at least 10 minutes."
            ),
        ),
    ] = None
    path: Annotated[
        str,
        Field(description=("path is the path relative to the mount point of the file to project the token into.")),
    ]


class Sysctl(BaseModel):
    name: Annotated[str, Field(description="Name of a property to set")]
    value: Annotated[str, Field(description="Value of a property to set")]


class Toleration(BaseModel):
    effect: Annotated[
        Optional[str],
        Field(
            description=(
                "Effect indicates the taint effect to match. Empty means match all"
                " taint effects. When specified, allowed values are NoSchedule,"
                " PreferNoSchedule and NoExecute."
            )
        ),
    ] = None
    key: Annotated[
        Optional[str],
        Field(
            description=(
                "Key is the taint key that the toleration applies to. Empty means match"
                " all taint keys. If the key is empty, operator must be Exists; this"
                " combination means to match all values and all keys."
            )
        ),
    ] = None
    operator: Annotated[
        Optional[str],
        Field(
            description=(
                "Operator represents a key's relationship to the value. Valid operators"
                " are Exists and Equal. Defaults to Equal. Exists is equivalent to"
                " wildcard for value, so that a pod can tolerate all taints of a"
                " particular category."
            )
        ),
    ] = None
    toleration_seconds: Annotated[
        Optional[int],
        Field(
            alias="tolerationSeconds",
            description=(
                "TolerationSeconds represents the period of time the toleration (which"
                " must be of effect NoExecute, otherwise this field is ignored)"
                " tolerates the taint. By default, it is not set, which means tolerate"
                " the taint forever (do not evict). Zero and negative values will be"
                " treated as 0 (evict immediately) by the system."
            ),
        ),
    ] = None
    value: Annotated[
        Optional[str],
        Field(
            description=(
                "Value is the taint value the toleration matches to. If the operator is"
                " Exists, the value should be empty, otherwise just a regular string."
            )
        ),
    ] = None


class VsphereVirtualDiskVolumeSource(BaseModel):
    fs_type: Annotated[
        Optional[str],
        Field(
            alias="fsType",
            description=(
                "fsType is filesystem type to mount. Must be a filesystem type"
                ' supported by the host operating system. Ex. "ext4", "xfs", "ntfs".'
                ' Implicitly inferred to be "ext4" if unspecified.'
            ),
        ),
    ] = None
    storage_policy_id: Annotated[
        Optional[str],
        Field(
            alias="storagePolicyID",
            description=(
                "storagePolicyID is the storage Policy Based Management (SPBM) profile"
                " ID associated with the StoragePolicyName."
            ),
        ),
    ] = None
    storage_policy_name: Annotated[
        Optional[str],
        Field(
            alias="storagePolicyName",
            description=("storagePolicyName is the storage Policy Based Management (SPBM) profile name."),
        ),
    ] = None
    volume_path: Annotated[
        str,
        Field(
            alias="volumePath",
            description="volumePath is the path that identifies vSphere volume vmdk",
        ),
    ]


class VolumeDevice(BaseModel):
    device_path: Annotated[
        str,
        Field(
            alias="devicePath",
            description=("devicePath is the path inside of the container that the device will be mapped to."),
        ),
    ]
    name: Annotated[
        str,
        Field(description="name must match the name of a persistentVolumeClaim in the pod"),
    ]


class VolumeMount(BaseModel):
    mount_path: Annotated[
        str,
        Field(
            alias="mountPath",
            description=("Path within the container at which the volume should be mounted.  Must not contain ':'."),
        ),
    ]
    mount_propagation: Annotated[
        Optional[str],
        Field(
            alias="mountPropagation",
            description=(
                "mountPropagation determines how mounts are propagated from the host to"
                " container and the other way around. When not set,"
                " MountPropagationNone is used. This field is beta in 1.10. When"
                " RecursiveReadOnly is set to IfPossible or to Enabled,"
                " MountPropagation must be None or unspecified (which defaults to"
                " None)."
            ),
        ),
    ] = None
    name: Annotated[str, Field(description="This must match the Name of a Volume.")]
    read_only: Annotated[
        Optional[bool],
        Field(
            alias="readOnly",
            description=("Mounted read-only if true, read-write otherwise (false or unspecified). Defaults to false."),
        ),
    ] = None
    recursive_read_only: Annotated[
        Optional[str],
        Field(
            alias="recursiveReadOnly",
            description=(
                "RecursiveReadOnly specifies whether read-only mounts should be handled"
                " recursively.\n\nIf ReadOnly is false, this field has no meaning and"
                " must be unspecified.\n\nIf ReadOnly is true, and this field is set to"
                " Disabled, the mount is not made recursively read-only.  If this field"
                " is set to IfPossible, the mount is made recursively read-only, if it"
                " is supported by the container runtime.  If this field is set to"
                " Enabled, the mount is made recursively read-only if it is supported"
                " by the container runtime, otherwise the pod will not be started and"
                " an error will be generated to indicate the reason.\n\nIf this field"
                " is set to IfPossible or Enabled, MountPropagation must be set to None"
                " (or be unspecified, which defaults to None).\n\nIf this field is not"
                " specified, it is treated as an equivalent of Disabled."
            ),
        ),
    ] = None
    sub_path: Annotated[
        Optional[str],
        Field(
            alias="subPath",
            description=(
                "Path within the volume from which the container's volume should be"
                ' mounted. Defaults to "" (volume\'s root).'
            ),
        ),
    ] = None
    sub_path_expr: Annotated[
        Optional[str],
        Field(
            alias="subPathExpr",
            description=(
                "Expanded path within the volume from which the container's volume"
                " should be mounted. Behaves similarly to SubPath but environment"
                " variable references $(VAR_NAME) are expanded using the container's"
                ' environment. Defaults to "" (volume\'s root). SubPathExpr and SubPath'
                " are mutually exclusive."
            ),
        ),
    ] = None


class ImagePullPolicy(Enum):
    always = "Always"
    never = "Never"
    if_not_present = "IfNotPresent"


class PersistentVolumeClaimCondition(BaseModel):
    last_probe_time: Annotated[
        Optional[v1.Time],
        Field(
            alias="lastProbeTime",
            description="lastProbeTime is the time we probed the condition.",
        ),
    ] = None
    last_transition_time: Annotated[
        Optional[v1.Time],
        Field(
            alias="lastTransitionTime",
            description=("lastTransitionTime is the time the condition transitioned from one status to another."),
        ),
    ] = None
    message: Annotated[
        Optional[str],
        Field(description=("message is the human-readable message indicating details about last transition.")),
    ] = None
    reason: Annotated[
        Optional[str],
        Field(
            description=(
                "reason is a unique, this should be a short, machine understandable"
                " string that gives the reason for condition's last transition. If it"
                ' reports "Resizing" that means the underlying persistent volume is'
                " being resized."
            )
        ),
    ] = None
    status: str
    type: str


class ServicePort(BaseModel):
    app_protocol: Annotated[
        Optional[str],
        Field(
            alias="appProtocol",
            description=(
                "The application protocol for this port. This is used as a hint for"
                " implementations to offer richer behavior for protocols that they"
                " understand. This field follows standard Kubernetes label syntax."
                " Valid values are either:\n\n* Un-prefixed protocol names - reserved"
                " for IANA standard service names (as per RFC-6335 and"
                " https://www.iana.org/assignments/service-names).\n\n*"
                " Kubernetes-defined prefixed names:\n  * 'kubernetes.io/h2c' - HTTP/2"
                " prior knowledge over cleartext as described in"
                " https://www.rfc-editor.org/rfc/rfc9113.html#name-starting-http-2-with-prior-\n"
                "  * 'kubernetes.io/ws'  - WebSocket over cleartext as described in"
                " https://www.rfc-editor.org/rfc/rfc6455\n  * 'kubernetes.io/wss' -"
                " WebSocket over TLS as described in"
                " https://www.rfc-editor.org/rfc/rfc6455\n\n* Other protocols should"
                " use implementation-defined prefixed names such as"
                " mycompany.com/my-custom-protocol."
            ),
        ),
    ] = None
    name: Annotated[
        Optional[str],
        Field(
            description=(
                "The name of this port within the service. This must be a DNS_LABEL."
                " All ports within a ServiceSpec must have unique names. When"
                " considering the endpoints for a Service, this must match the 'name'"
                " field in the EndpointPort. Optional if only one ServicePort is"
                " defined on this service."
            )
        ),
    ] = None
    node_port: Annotated[
        Optional[int],
        Field(
            alias="nodePort",
            description=(
                "The port on each node on which this service is exposed when type is"
                " NodePort or LoadBalancer.  Usually assigned by the system. If a value"
                " is specified, in-range, and not in use it will be used, otherwise the"
                " operation will fail.  If not specified, a port will be allocated if"
                " this Service requires one.  If this field is specified when creating"
                " a Service which does not need it, creation will fail. This field will"
                " be wiped when updating a Service to no longer need it (e.g. changing"
                " type from NodePort to ClusterIP). More info:"
                " https://kubernetes.io/docs/concepts/services-networking/service/#type-nodeport"
            ),
        ),
    ] = None
    port: Annotated[int, Field(description="The port that will be exposed by this service.")]
    protocol: Annotated[
        Optional[str],
        Field(description=('The IP protocol for this port. Supports "TCP", "UDP", and "SCTP". Default is TCP.')),
    ] = None
    target_port: Annotated[
        Optional[intstr.IntOrString],
        Field(
            alias="targetPort",
            description=(
                "Number or name of the port to access on the pods targeted by the"
                " service. Number must be in the range 1 to 65535. Name must be an"
                " IANA_SVC_NAME. If this is a string, it will be looked up as a named"
                " port in the target Pod's container ports. If this is not specified,"
                " the value of the 'port' field is used (an identity map). This field"
                " is ignored for services with clusterIP=None, and should be omitted or"
                " set equal to the 'port' field. More info:"
                " https://kubernetes.io/docs/concepts/services-networking/service/#defining-a-service"
            ),
        ),
    ] = None


class TCPSocketAction(BaseModel):
    host: Annotated[
        Optional[str],
        Field(description="Optional: Host name to connect to, defaults to the pod IP."),
    ] = None
    port: Annotated[
        intstr.IntOrString,
        Field(
            description=(
                "Number or name of the port to access on the container. Number must be"
                " in the range 1 to 65535. Name must be an IANA_SVC_NAME."
            )
        ),
    ]


class CSIVolumeSource(BaseModel):
    driver: Annotated[
        str,
        Field(
            description=(
                "driver is the name of the CSI driver that handles this volume. Consult"
                " with your admin for the correct name as registered in the cluster."
            )
        ),
    ]
    fs_type: Annotated[
        Optional[str],
        Field(
            alias="fsType",
            description=(
                'fsType to mount. Ex. "ext4", "xfs", "ntfs". If not provided, the empty'
                " value is passed to the associated CSI driver which will determine the"
                " default filesystem to apply."
            ),
        ),
    ] = None
    node_publish_secret_ref: Annotated[
        Optional[LocalObjectReference],
        Field(
            alias="nodePublishSecretRef",
            description=(
                "nodePublishSecretRef is a reference to the secret object containing"
                " sensitive information to pass to the CSI driver to complete the CSI"
                " NodePublishVolume and NodeUnpublishVolume calls. This field is"
                " optional, and  may be empty if no secret is required. If the secret"
                " object contains more than one secret, all secret references are"
                " passed."
            ),
        ),
    ] = None
    read_only: Annotated[
        Optional[bool],
        Field(
            alias="readOnly",
            description=(
                "readOnly specifies a read-only configuration for the volume. Defaults to false (read/write)."
            ),
        ),
    ] = None
    volume_attributes: Annotated[
        Optional[Dict[str, str]],
        Field(
            alias="volumeAttributes",
            description=(
                "volumeAttributes stores driver-specific properties that are passed to"
                " the CSI driver. Consult your driver's documentation for supported"
                " values."
            ),
        ),
    ] = None


class CephFSVolumeSource(BaseModel):
    monitors: Annotated[
        List[str],
        Field(
            description=(
                "monitors is Required: Monitors is a collection of Ceph monitors More"
                " info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it"
            )
        ),
    ]
    path: Annotated[
        Optional[str],
        Field(
            description=("path is Optional: Used as the mounted root, rather than the full Ceph tree, default is /")
        ),
    ] = None
    read_only: Annotated[
        Optional[bool],
        Field(
            alias="readOnly",
            description=(
                "readOnly is Optional: Defaults to false (read/write). ReadOnly here"
                " will force the ReadOnly setting in VolumeMounts. More info:"
                " https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it"
            ),
        ),
    ] = None
    secret_file: Annotated[
        Optional[str],
        Field(
            alias="secretFile",
            description=(
                "secretFile is Optional: SecretFile is the path to key ring for User,"
                " default is /etc/ceph/user.secret More info:"
                " https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it"
            ),
        ),
    ] = None
    secret_ref: Annotated[
        Optional[LocalObjectReference],
        Field(
            alias="secretRef",
            description=(
                "secretRef is Optional: SecretRef is reference to the authentication"
                " secret for User, default is empty. More info:"
                " https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it"
            ),
        ),
    ] = None
    user: Annotated[
        Optional[str],
        Field(
            description=(
                "user is optional: User is the rados user name, default is admin More"
                " info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it"
            )
        ),
    ] = None


class CinderVolumeSource(BaseModel):
    fs_type: Annotated[
        Optional[str],
        Field(
            alias="fsType",
            description=(
                "fsType is the filesystem type to mount. Must be a filesystem type"
                ' supported by the host operating system. Examples: "ext4", "xfs",'
                ' "ntfs". Implicitly inferred to be "ext4" if unspecified. More info:'
                " https://examples.k8s.io/mysql-cinder-pd/README.md"
            ),
        ),
    ] = None
    read_only: Annotated[
        Optional[bool],
        Field(
            alias="readOnly",
            description=(
                "readOnly defaults to false (read/write). ReadOnly here will force the"
                " ReadOnly setting in VolumeMounts. More info:"
                " https://examples.k8s.io/mysql-cinder-pd/README.md"
            ),
        ),
    ] = None
    secret_ref: Annotated[
        Optional[LocalObjectReference],
        Field(
            alias="secretRef",
            description=(
                "secretRef is optional: points to a secret object containing parameters used to connect to OpenStack."
            ),
        ),
    ] = None
    volume_id: Annotated[
        str,
        Field(
            alias="volumeID",
            description=(
                "volumeID used to identify the volume in cinder. More info:"
                " https://examples.k8s.io/mysql-cinder-pd/README.md"
            ),
        ),
    ]


class FlexVolumeSource(BaseModel):
    driver: Annotated[
        str,
        Field(description="driver is the name of the driver to use for this volume."),
    ]
    fs_type: Annotated[
        Optional[str],
        Field(
            alias="fsType",
            description=(
                "fsType is the filesystem type to mount. Must be a filesystem type"
                ' supported by the host operating system. Ex. "ext4", "xfs", "ntfs".'
                " The default filesystem depends on FlexVolume script."
            ),
        ),
    ] = None
    options: Annotated[
        Optional[Dict[str, str]],
        Field(description=("options is Optional: this field holds extra command options if any.")),
    ] = None
    read_only: Annotated[
        Optional[bool],
        Field(
            alias="readOnly",
            description=(
                "readOnly is Optional: defaults to false (read/write). ReadOnly here"
                " will force the ReadOnly setting in VolumeMounts."
            ),
        ),
    ] = None
    secret_ref: Annotated[
        Optional[LocalObjectReference],
        Field(
            alias="secretRef",
            description=(
                "secretRef is Optional: secretRef is reference to the secret object"
                " containing sensitive information to pass to the plugin scripts. This"
                " may be empty if no secret object is specified. If the secret object"
                " contains more than one secret, all secrets are passed to the plugin"
                " scripts."
            ),
        ),
    ] = None


class ISCSIVolumeSource(BaseModel):
    chap_auth_discovery: Annotated[
        Optional[bool],
        Field(
            alias="chapAuthDiscovery",
            description=("chapAuthDiscovery defines whether support iSCSI Discovery CHAP authentication"),
        ),
    ] = None
    chap_auth_session: Annotated[
        Optional[bool],
        Field(
            alias="chapAuthSession",
            description=("chapAuthSession defines whether support iSCSI Session CHAP authentication"),
        ),
    ] = None
    fs_type: Annotated[
        Optional[str],
        Field(
            alias="fsType",
            description=(
                "fsType is the filesystem type of the volume that you want to mount."
                " Tip: Ensure that the filesystem type is supported by the host"
                ' operating system. Examples: "ext4", "xfs", "ntfs". Implicitly'
                ' inferred to be "ext4" if unspecified. More info:'
                " https://kubernetes.io/docs/concepts/storage/volumes#iscsi"
            ),
        ),
    ] = None
    initiator_name: Annotated[
        Optional[str],
        Field(
            alias="initiatorName",
            description=(
                "initiatorName is the custom iSCSI Initiator Name. If initiatorName is"
                " specified with iscsiInterface simultaneously, new iSCSI interface"
                " <target portal>:<volume name> will be created for the connection."
            ),
        ),
    ] = None
    iqn: Annotated[str, Field(description="iqn is the target iSCSI Qualified Name.")]
    iscsi_interface: Annotated[
        Optional[str],
        Field(
            alias="iscsiInterface",
            description=(
                "iscsiInterface is the interface Name that uses an iSCSI transport. Defaults to 'default' (tcp)."
            ),
        ),
    ] = None
    lun: Annotated[int, Field(description="lun represents iSCSI Target Lun number.")]
    portals: Annotated[
        Optional[List[str]],
        Field(
            description=(
                "portals is the iSCSI Target Portal List. The portal is either an IP or"
                " ip_addr:port if the port is other than default (typically TCP ports"
                " 860 and 3260)."
            )
        ),
    ] = None
    read_only: Annotated[
        Optional[bool],
        Field(
            alias="readOnly",
            description=("readOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false."),
        ),
    ] = None
    secret_ref: Annotated[
        Optional[LocalObjectReference],
        Field(
            alias="secretRef",
            description=("secretRef is the CHAP Secret for iSCSI target and initiator authentication"),
        ),
    ] = None
    target_portal: Annotated[
        str,
        Field(
            alias="targetPortal",
            description=(
                "targetPortal is iSCSI Target Portal. The Portal is either an IP or"
                " ip_addr:port if the port is other than default (typically TCP ports"
                " 860 and 3260)."
            ),
        ),
    ]


class RBDVolumeSource(BaseModel):
    fs_type: Annotated[
        Optional[str],
        Field(
            alias="fsType",
            description=(
                "fsType is the filesystem type of the volume that you want to mount."
                " Tip: Ensure that the filesystem type is supported by the host"
                ' operating system. Examples: "ext4", "xfs", "ntfs". Implicitly'
                ' inferred to be "ext4" if unspecified. More info:'
                " https://kubernetes.io/docs/concepts/storage/volumes#rbd"
            ),
        ),
    ] = None
    image: Annotated[
        str,
        Field(
            description=(
                "image is the rados image name. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it"
            )
        ),
    ]
    keyring: Annotated[
        Optional[str],
        Field(
            description=(
                "keyring is the path to key ring for RBDUser. Default is"
                " /etc/ceph/keyring. More info:"
                " https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it"
            )
        ),
    ] = None
    monitors: Annotated[
        List[str],
        Field(
            description=(
                "monitors is a collection of Ceph monitors. More info:"
                " https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it"
            )
        ),
    ]
    pool: Annotated[
        Optional[str],
        Field(
            description=(
                "pool is the rados pool name. Default is rbd. More info:"
                " https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it"
            )
        ),
    ] = None
    read_only: Annotated[
        Optional[bool],
        Field(
            alias="readOnly",
            description=(
                "readOnly here will force the ReadOnly setting in VolumeMounts."
                " Defaults to false. More info:"
                " https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it"
            ),
        ),
    ] = None
    secret_ref: Annotated[
        Optional[LocalObjectReference],
        Field(
            alias="secretRef",
            description=(
                "secretRef is name of the authentication secret for RBDUser. If"
                " provided overrides keyring. Default is nil. More info:"
                " https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it"
            ),
        ),
    ] = None
    user: Annotated[
        Optional[str],
        Field(
            description=(
                "user is the rados user name. Default is admin. More info:"
                " https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it"
            )
        ),
    ] = None


class ScaleIOVolumeSource(BaseModel):
    fs_type: Annotated[
        Optional[str],
        Field(
            alias="fsType",
            description=(
                "fsType is the filesystem type to mount. Must be a filesystem type"
                ' supported by the host operating system. Ex. "ext4", "xfs", "ntfs".'
                ' Default is "xfs".'
            ),
        ),
    ] = None
    gateway: Annotated[
        str,
        Field(description="gateway is the host address of the ScaleIO API Gateway."),
    ]
    protection_domain: Annotated[
        Optional[str],
        Field(
            alias="protectionDomain",
            description=("protectionDomain is the name of the ScaleIO Protection Domain for the configured storage."),
        ),
    ] = None
    read_only: Annotated[
        Optional[bool],
        Field(
            alias="readOnly",
            description=(
                "readOnly Defaults to false (read/write). ReadOnly here will force the"
                " ReadOnly setting in VolumeMounts."
            ),
        ),
    ] = None
    secret_ref: Annotated[
        LocalObjectReference,
        Field(
            alias="secretRef",
            description=(
                "secretRef references to the secret for ScaleIO user and other"
                " sensitive information. If this is not provided, Login operation will"
                " fail."
            ),
        ),
    ]
    ssl_enabled: Annotated[
        Optional[bool],
        Field(
            alias="sslEnabled",
            description=("sslEnabled Flag enable/disable SSL communication with Gateway, default false"),
        ),
    ] = None
    storage_mode: Annotated[
        Optional[str],
        Field(
            alias="storageMode",
            description=(
                "storageMode indicates whether the storage for a volume should be"
                " ThickProvisioned or ThinProvisioned. Default is ThinProvisioned."
            ),
        ),
    ] = None
    storage_pool: Annotated[
        Optional[str],
        Field(
            alias="storagePool",
            description=("storagePool is the ScaleIO Storage Pool associated with the protection domain."),
        ),
    ] = None
    system: Annotated[
        str,
        Field(description=("system is the name of the storage system as configured in ScaleIO.")),
    ]
    volume_name: Annotated[
        Optional[str],
        Field(
            alias="volumeName",
            description=(
                "volumeName is the name of a volume already created in the ScaleIO"
                " system that is associated with this volume source."
            ),
        ),
    ] = None


class StorageOSVolumeSource(BaseModel):
    fs_type: Annotated[
        Optional[str],
        Field(
            alias="fsType",
            description=(
                "fsType is the filesystem type to mount. Must be a filesystem type"
                ' supported by the host operating system. Ex. "ext4", "xfs", "ntfs".'
                ' Implicitly inferred to be "ext4" if unspecified.'
            ),
        ),
    ] = None
    read_only: Annotated[
        Optional[bool],
        Field(
            alias="readOnly",
            description=(
                "readOnly defaults to false (read/write). ReadOnly here will force the"
                " ReadOnly setting in VolumeMounts."
            ),
        ),
    ] = None
    secret_ref: Annotated[
        Optional[LocalObjectReference],
        Field(
            alias="secretRef",
            description=(
                "secretRef specifies the secret to use for obtaining the StorageOS API"
                " credentials.  If not specified, default values will be attempted."
            ),
        ),
    ] = None
    volume_name: Annotated[
        Optional[str],
        Field(
            alias="volumeName",
            description=(
                "volumeName is the human-readable name of the StorageOS volume.  Volume"
                " names are only unique within a namespace."
            ),
        ),
    ] = None
    volume_namespace: Annotated[
        Optional[str],
        Field(
            alias="volumeNamespace",
            description=(
                "volumeNamespace specifies the scope of the volume within StorageOS. "
                " If no namespace is specified then the Pod's namespace will be used. "
                " This allows the Kubernetes name scoping to be mirrored within"
                " StorageOS for tighter integration. Set VolumeName to any name to"
                ' override the default behaviour. Set to "default" if you are not using'
                " namespaces within StorageOS. Namespaces that do not pre-exist within"
                " StorageOS will be created."
            ),
        ),
    ] = None


class EmptyDirVolumeSource(BaseModel):
    medium: Annotated[
        Optional[str],
        Field(
            description=(
                "medium represents what type of storage medium should back this"
                ' directory. The default is "" which means to use the node\'s default'
                " medium. Must be an empty string (default) or Memory. More info:"
                " https://kubernetes.io/docs/concepts/storage/volumes#emptydir"
            )
        ),
    ] = None
    size_limit: Annotated[
        Optional[resource.Quantity],
        Field(
            alias="sizeLimit",
            description=(
                "sizeLimit is the total amount of local storage required for this"
                " EmptyDir volume. The size limit is also applicable for memory medium."
                " The maximum usage on memory medium EmptyDir would be the minimum"
                " value between the SizeLimit specified here and the sum of memory"
                " limits of all containers in a pod. The default is nil which means"
                " that the limit is undefined. More info:"
                " https://kubernetes.io/docs/concepts/storage/volumes#emptydir"
            ),
        ),
    ] = None


class ResourceFieldSelector(BaseModel):
    container_name: Annotated[
        Optional[str],
        Field(
            alias="containerName",
            description="Container name: required for volumes, optional for env vars",
        ),
    ] = None
    divisor: Annotated[
        Optional[resource.Quantity],
        Field(description=('Specifies the output format of the exposed resources, defaults to "1"')),
    ] = None
    resource: Annotated[str, Field(description="Required: resource to select")]


class EnvFromSource(BaseModel):
    config_map_ref: Annotated[
        Optional[ConfigMapEnvSource],
        Field(alias="configMapRef", description="The ConfigMap to select from"),
    ] = None
    prefix: Annotated[
        Optional[str],
        Field(description=("An optional identifier to prepend to each key in the ConfigMap. Must be a C_IDENTIFIER.")),
    ] = None
    secret_ref: Annotated[
        Optional[SecretEnvSource],
        Field(alias="secretRef", description="The Secret to select from"),
    ] = None


class EventSeries(BaseModel):
    count: Annotated[
        Optional[int],
        Field(description=("Number of occurrences in this series up to the last heartbeat time")),
    ] = None
    last_observed_time: Annotated[
        Optional[v1.MicroTime],
        Field(alias="lastObservedTime", description="Time of the last occurrence observed"),
    ] = None


class PersistentVolumeClaimStatus(BaseModel):
    access_modes: Annotated[
        Optional[List[str]],
        Field(
            alias="accessModes",
            description=(
                "accessModes contains the actual access modes the volume backing the"
                " PVC has. More info:"
                " https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1"
            ),
        ),
    ] = None
    allocated_resource_statuses: Annotated[
        Optional[Dict[str, str]],
        Field(
            alias="allocatedResourceStatuses",
            description=(
                "allocatedResourceStatuses stores status of resource being resized for"
                " the given PVC. Key names follow standard Kubernetes label syntax."
                " Valid values are either:\n\t* Un-prefixed keys:\n\t\t- storage - the"
                " capacity of the volume.\n\t* Custom resources must use"
                " implementation-defined prefixed names such as"
                ' "example.com/my-custom-resource"\nApart from above values - keys that'
                " are unprefixed or have kubernetes.io prefix are considered reserved"
                " and hence may not be used.\n\nClaimResourceStatus can be in any of"
                " following states:\n\t- ControllerResizeInProgress:\n\t\tState set"
                " when resize controller starts resizing the volume in"
                " control-plane.\n\t- ControllerResizeFailed:\n\t\tState set when"
                " resize has failed in resize controller with a terminal error.\n\t-"
                " NodeResizePending:\n\t\tState set when resize controller has finished"
                " resizing the volume but further resizing of\n\t\tvolume is needed on"
                " the node.\n\t- NodeResizeInProgress:\n\t\tState set when kubelet"
                " starts resizing the volume.\n\t- NodeResizeFailed:\n\t\tState set"
                " when resizing has failed in kubelet with a terminal error. Transient"
                " errors don't set\n\t\tNodeResizeFailed.\nFor example: if expanding a"
                " PVC for more capacity - this field can be one of the following"
                " states:\n\t- pvc.status.allocatedResourceStatus['storage'] ="
                ' "ControllerResizeInProgress"\n     -'
                " pvc.status.allocatedResourceStatus['storage'] ="
                ' "ControllerResizeFailed"\n     -'
                " pvc.status.allocatedResourceStatus['storage'] ="
                ' "NodeResizePending"\n     -'
                " pvc.status.allocatedResourceStatus['storage'] ="
                ' "NodeResizeInProgress"\n     -'
                " pvc.status.allocatedResourceStatus['storage'] ="
                ' "NodeResizeFailed"\nWhen this field is not set, it means that no'
                " resize operation is in progress for the given PVC.\n\nA controller"
                " that receives PVC update with previously unknown resourceName or"
                " ClaimResourceStatus should ignore the update for the purpose it was"
                " designed. For example - a controller that only is responsible for"
                " resizing capacity of the volume, should ignore PVC updates that"
                " change other valid resources associated with PVC.\n\nThis is an alpha"
                " field and requires enabling RecoverVolumeExpansionFailure feature."
            ),
        ),
    ] = None
    allocated_resources: Annotated[
        Optional[Dict[str, resource.Quantity]],
        Field(
            alias="allocatedResources",
            description=(
                "allocatedResources tracks the resources allocated to a PVC including"
                " its capacity. Key names follow standard Kubernetes label syntax."
                " Valid values are either:\n\t* Un-prefixed keys:\n\t\t- storage - the"
                " capacity of the volume.\n\t* Custom resources must use"
                " implementation-defined prefixed names such as"
                ' "example.com/my-custom-resource"\nApart from above values - keys that'
                " are unprefixed or have kubernetes.io prefix are considered reserved"
                " and hence may not be used.\n\nCapacity reported here may be larger"
                " than the actual capacity when a volume expansion operation is"
                " requested. For storage quota, the larger value from"
                " allocatedResources and PVC.spec.resources is used. If"
                " allocatedResources is not set, PVC.spec.resources alone is used for"
                " quota calculation. If a volume expansion capacity request is lowered,"
                " allocatedResources is only lowered if there are no expansion"
                " operations in progress and if the actual volume capacity is equal or"
                " lower than the requested capacity.\n\nA controller that receives PVC"
                " update with previously unknown resourceName should ignore the update"
                " for the purpose it was designed. For example - a controller that only"
                " is responsible for resizing capacity of the volume, should ignore PVC"
                " updates that change other valid resources associated with"
                " PVC.\n\nThis is an alpha field and requires enabling"
                " RecoverVolumeExpansionFailure feature."
            ),
        ),
    ] = None
    capacity: Annotated[
        Optional[Dict[str, resource.Quantity]],
        Field(description=("capacity represents the actual resources of the underlying volume.")),
    ] = None
    conditions: Annotated[
        Optional[List[PersistentVolumeClaimCondition]],
        Field(
            description=(
                "conditions is the current Condition of persistent volume claim. If"
                " underlying persistent volume is being resized then the Condition will"
                " be set to 'Resizing'."
            )
        ),
    ] = None
    current_volume_attributes_class_name: Annotated[
        Optional[str],
        Field(
            alias="currentVolumeAttributesClassName",
            description=(
                "currentVolumeAttributesClassName is the current name of the"
                " VolumeAttributesClass the PVC is using. When unset, there is no"
                " VolumeAttributeClass applied to this PersistentVolumeClaim This is an"
                " alpha field and requires enabling VolumeAttributesClass feature."
            ),
        ),
    ] = None
    modify_volume_status: Annotated[
        Optional[ModifyVolumeStatus],
        Field(
            alias="modifyVolumeStatus",
            description=(
                "ModifyVolumeStatus represents the status object of"
                " ControllerModifyVolume operation. When this is unset, there is no"
                " ModifyVolume operation being attempted. This is an alpha field and"
                " requires enabling VolumeAttributesClass feature."
            ),
        ),
    ] = None
    phase: Annotated[
        Optional[str],
        Field(description="phase represents the current phase of PersistentVolumeClaim."),
    ] = None


class PreferredSchedulingTerm(BaseModel):
    preference: Annotated[
        NodeSelectorTerm,
        Field(description=("A node selector term, associated with the corresponding weight.")),
    ]
    weight: Annotated[
        int,
        Field(description=("Weight associated with matching the corresponding nodeSelectorTerm, in the range 1-100.")),
    ]


class PodSecurityContext(BaseModel):
    app_armor_profile: Annotated[
        Optional[AppArmorProfile],
        Field(
            alias="appArmorProfile",
            description=(
                "appArmorProfile is the AppArmor options to use by the containers in"
                " this pod. Note that this field cannot be set when spec.os.name is"
                " windows."
            ),
        ),
    ] = None
    fs_group: Annotated[
        Optional[int],
        Field(
            alias="fsGroup",
            description=(
                "A special supplemental group that applies to all containers in a pod."
                " Some volume types allow the Kubelet to change the ownership of that"
                " volume to be owned by the pod:\n\n1. The owning GID will be the"
                " FSGroup 2. The setgid bit is set (new files created in the volume"
                " will be owned by FSGroup) 3. The permission bits are OR'd with"
                " rw-rw----\n\nIf unset, the Kubelet will not modify the ownership and"
                " permissions of any volume. Note that this field cannot be set when"
                " spec.os.name is windows."
            ),
        ),
    ] = None
    fs_group_change_policy: Annotated[
        Optional[str],
        Field(
            alias="fsGroupChangePolicy",
            description=(
                "fsGroupChangePolicy defines behavior of changing ownership and"
                " permission of the volume before being exposed inside Pod. This field"
                " will only apply to volume types which support fsGroup based"
                " ownership(and permissions). It will have no effect on ephemeral"
                " volume types such as: secret, configmaps and emptydir. Valid values"
                ' are "OnRootMismatch" and "Always". If not specified, "Always" is'
                " used. Note that this field cannot be set when spec.os.name is"
                " windows."
            ),
        ),
    ] = None
    run_as_group: Annotated[
        Optional[int],
        Field(
            alias="runAsGroup",
            description=(
                "The GID to run the entrypoint of the container process. Uses runtime"
                " default if unset. May also be set in SecurityContext.  If set in both"
                " SecurityContext and PodSecurityContext, the value specified in"
                " SecurityContext takes precedence for that container. Note that this"
                " field cannot be set when spec.os.name is windows."
            ),
        ),
    ] = None
    run_as_non_root: Annotated[
        Optional[bool],
        Field(
            alias="runAsNonRoot",
            description=(
                "Indicates that the container must run as a non-root user. If true, the"
                " Kubelet will validate the image at runtime to ensure that it does not"
                " run as UID 0 (root) and fail to start the container if it does. If"
                " unset or false, no such validation will be performed. May also be set"
                " in SecurityContext.  If set in both SecurityContext and"
                " PodSecurityContext, the value specified in SecurityContext takes"
                " precedence."
            ),
        ),
    ] = None
    run_as_user: Annotated[
        Optional[int],
        Field(
            alias="runAsUser",
            description=(
                "The UID to run the entrypoint of the container process. Defaults to"
                " user specified in image metadata if unspecified. May also be set in"
                " SecurityContext.  If set in both SecurityContext and"
                " PodSecurityContext, the value specified in SecurityContext takes"
                " precedence for that container. Note that this field cannot be set"
                " when spec.os.name is windows."
            ),
        ),
    ] = None
    se_linux_options: Annotated[
        Optional[SELinuxOptions],
        Field(
            alias="seLinuxOptions",
            description=(
                "The SELinux context to be applied to all containers. If unspecified,"
                " the container runtime will allocate a random SELinux context for each"
                " container.  May also be set in SecurityContext.  If set in both"
                " SecurityContext and PodSecurityContext, the value specified in"
                " SecurityContext takes precedence for that container. Note that this"
                " field cannot be set when spec.os.name is windows."
            ),
        ),
    ] = None
    seccomp_profile: Annotated[
        Optional[SeccompProfile],
        Field(
            alias="seccompProfile",
            description=(
                "The seccomp options to use by the containers in this pod. Note that"
                " this field cannot be set when spec.os.name is windows."
            ),
        ),
    ] = None
    supplemental_groups: Annotated[
        Optional[List[int]],
        Field(
            alias="supplementalGroups",
            description=(
                "A list of groups applied to the first process run in each container,"
                " in addition to the container's primary GID, the fsGroup (if"
                " specified), and group memberships defined in the container image for"
                " the uid of the container process. If unspecified, no additional"
                " groups are added to any container. Note that group memberships"
                " defined in the container image for the uid of the container process"
                " are still effective, even if they are not included in this list. Note"
                " that this field cannot be set when spec.os.name is windows."
            ),
        ),
    ] = None
    sysctls: Annotated[
        Optional[List[Sysctl]],
        Field(
            description=(
                "Sysctls hold a list of namespaced sysctls used for the pod. Pods with"
                " unsupported sysctls (by the container runtime) might fail to launch."
                " Note that this field cannot be set when spec.os.name is windows."
            )
        ),
    ] = None
    windows_options: Annotated[
        Optional[WindowsSecurityContextOptions],
        Field(
            alias="windowsOptions",
            description=(
                "The Windows specific settings applied to all containers. If"
                " unspecified, the options within a container's SecurityContext will be"
                " used. If set in both SecurityContext and PodSecurityContext, the"
                " value specified in SecurityContext takes precedence. Note that this"
                " field cannot be set when spec.os.name is linux."
            ),
        ),
    ] = None


class SecurityContext(BaseModel):
    allow_privilege_escalation: Annotated[
        Optional[bool],
        Field(
            alias="allowPrivilegeEscalation",
            description=(
                "AllowPrivilegeEscalation controls whether a process can gain more"
                " privileges than its parent process. This bool directly controls if"
                " the no_new_privs flag will be set on the container process."
                " AllowPrivilegeEscalation is true always when the container is: 1) run"
                " as Privileged 2) has CAP_SYS_ADMIN Note that this field cannot be set"
                " when spec.os.name is windows."
            ),
        ),
    ] = None
    app_armor_profile: Annotated[
        Optional[AppArmorProfile],
        Field(
            alias="appArmorProfile",
            description=(
                "appArmorProfile is the AppArmor options to use by this container. If"
                " set, this profile overrides the pod's appArmorProfile. Note that this"
                " field cannot be set when spec.os.name is windows."
            ),
        ),
    ] = None
    capabilities: Annotated[
        Optional[Capabilities],
        Field(
            description=(
                "The capabilities to add/drop when running containers. Defaults to the"
                " default set of capabilities granted by the container runtime. Note"
                " that this field cannot be set when spec.os.name is windows."
            )
        ),
    ] = None
    privileged: Annotated[
        Optional[bool],
        Field(
            description=(
                "Run container in privileged mode. Processes in privileged containers"
                " are essentially equivalent to root on the host. Defaults to false."
                " Note that this field cannot be set when spec.os.name is windows."
            )
        ),
    ] = None
    proc_mount: Annotated[
        Optional[str],
        Field(
            alias="procMount",
            description=(
                "procMount denotes the type of proc mount to use for the containers."
                " The default is DefaultProcMount which uses the container runtime"
                " defaults for readonly paths and masked paths. This requires the"
                " ProcMountType feature flag to be enabled. Note that this field cannot"
                " be set when spec.os.name is windows."
            ),
        ),
    ] = None
    read_only_root_filesystem: Annotated[
        Optional[bool],
        Field(
            alias="readOnlyRootFilesystem",
            description=(
                "Whether this container has a read-only root filesystem. Default is"
                " false. Note that this field cannot be set when spec.os.name is"
                " windows."
            ),
        ),
    ] = None
    run_as_group: Annotated[
        Optional[int],
        Field(
            alias="runAsGroup",
            description=(
                "The GID to run the entrypoint of the container process. Uses runtime"
                " default if unset. May also be set in PodSecurityContext.  If set in"
                " both SecurityContext and PodSecurityContext, the value specified in"
                " SecurityContext takes precedence. Note that this field cannot be set"
                " when spec.os.name is windows."
            ),
        ),
    ] = None
    run_as_non_root: Annotated[
        Optional[bool],
        Field(
            alias="runAsNonRoot",
            description=(
                "Indicates that the container must run as a non-root user. If true, the"
                " Kubelet will validate the image at runtime to ensure that it does not"
                " run as UID 0 (root) and fail to start the container if it does. If"
                " unset or false, no such validation will be performed. May also be set"
                " in PodSecurityContext.  If set in both SecurityContext and"
                " PodSecurityContext, the value specified in SecurityContext takes"
                " precedence."
            ),
        ),
    ] = None
    run_as_user: Annotated[
        Optional[int],
        Field(
            alias="runAsUser",
            description=(
                "The UID to run the entrypoint of the container process. Defaults to"
                " user specified in image metadata if unspecified. May also be set in"
                " PodSecurityContext.  If set in both SecurityContext and"
                " PodSecurityContext, the value specified in SecurityContext takes"
                " precedence. Note that this field cannot be set when spec.os.name is"
                " windows."
            ),
        ),
    ] = None
    se_linux_options: Annotated[
        Optional[SELinuxOptions],
        Field(
            alias="seLinuxOptions",
            description=(
                "The SELinux context to be applied to the container. If unspecified,"
                " the container runtime will allocate a random SELinux context for each"
                " container.  May also be set in PodSecurityContext.  If set in both"
                " SecurityContext and PodSecurityContext, the value specified in"
                " SecurityContext takes precedence. Note that this field cannot be set"
                " when spec.os.name is windows."
            ),
        ),
    ] = None
    seccomp_profile: Annotated[
        Optional[SeccompProfile],
        Field(
            alias="seccompProfile",
            description=(
                "The seccomp options to use by this container. If seccomp options are"
                " provided at both the pod & container level, the container options"
                " override the pod options. Note that this field cannot be set when"
                " spec.os.name is windows."
            ),
        ),
    ] = None
    windows_options: Annotated[
        Optional[WindowsSecurityContextOptions],
        Field(
            alias="windowsOptions",
            description=(
                "The Windows specific settings applied to all containers. If"
                " unspecified, the options from the PodSecurityContext will be used. If"
                " set in both SecurityContext and PodSecurityContext, the value"
                " specified in SecurityContext takes precedence. Note that this field"
                " cannot be set when spec.os.name is linux."
            ),
        ),
    ] = None


class DownwardAPIVolumeFile(BaseModel):
    field_ref: Annotated[
        Optional[ObjectFieldSelector],
        Field(
            alias="fieldRef",
            description=(
                "Required: Selects a field of the pod: only annotations, labels, name,"
                " namespace and uid are supported."
            ),
        ),
    ] = None
    mode: Annotated[
        Optional[int],
        Field(
            description=(
                "Optional: mode bits used to set permissions on this file, must be an"
                " octal value between 0000 and 0777 or a decimal value between 0 and"
                " 511. YAML accepts both octal and decimal values, JSON requires"
                " decimal values for mode bits. If not specified, the volume"
                " defaultMode will be used. This might be in conflict with other"
                " options that affect the file mode, like fsGroup, and the result can"
                " be other mode bits set."
            )
        ),
    ] = None
    path: Annotated[
        str,
        Field(
            description=(
                "Required: Path is  the relative path name of the file to be created."
                " Must not be absolute or contain the '..' path. Must be utf-8 encoded."
                " The first item of the relative path must not start with '..'"
            )
        ),
    ]
    resource_field_ref: Annotated[
        Optional[ResourceFieldSelector],
        Field(
            alias="resourceFieldRef",
            description=(
                "Selects a resource of the container: only resources limits and"
                " requests (limits.cpu, limits.memory, requests.cpu and"
                " requests.memory) are currently supported."
            ),
        ),
    ] = None


class EnvVarSource(BaseModel):
    config_map_key_ref: Annotated[
        Optional[ConfigMapKeySelector],
        Field(alias="configMapKeyRef", description="Selects a key of a ConfigMap."),
    ] = None
    field_ref: Annotated[
        Optional[ObjectFieldSelector],
        Field(
            alias="fieldRef",
            description=(
                "Selects a field of the pod: supports metadata.name,"
                " metadata.namespace, `metadata.labels['<KEY>']`,"
                " `metadata.annotations['<KEY>']`, spec.nodeName,"
                " spec.serviceAccountName, status.hostIP, status.podIP, status.podIPs."
            ),
        ),
    ] = None
    resource_field_ref: Annotated[
        Optional[ResourceFieldSelector],
        Field(
            alias="resourceFieldRef",
            description=(
                "Selects a resource of the container: only resources limits and"
                " requests (limits.cpu, limits.memory, limits.ephemeral-storage,"
                " requests.cpu, requests.memory and requests.ephemeral-storage) are"
                " currently supported."
            ),
        ),
    ] = None
    secret_key_ref: Annotated[
        Optional[SecretKeySelector],
        Field(
            alias="secretKeyRef",
            description="Selects a key of a secret in the pod's namespace",
        ),
    ] = None


class EnvVar(BaseModel):
    name: Annotated[
        str,
        Field(description="Name of the environment variable. Must be a C_IDENTIFIER."),
    ]
    value: Annotated[
        Optional[str],
        Field(
            description=(
                "Variable references $(VAR_NAME) are expanded using the previously"
                " defined environment variables in the container and any service"
                " environment variables. If a variable cannot be resolved, the"
                " reference in the input string will be unchanged. Double $$ are"
                " reduced to a single $, which allows for escaping the $(VAR_NAME)"
                ' syntax: i.e. "$$(VAR_NAME)" will produce the string literal'
                ' "$(VAR_NAME)". Escaped references will never be expanded, regardless'
                ' of whether the variable exists or not. Defaults to "".'
            )
        ),
    ] = None
    value_from: Annotated[
        Optional[EnvVarSource],
        Field(
            alias="valueFrom",
            description=("Source for the environment variable's value. Cannot be used if value is not empty."),
        ),
    ] = None


class ResourceRequirements(BaseModel):
    claims: Annotated[
        Optional[List[ResourceClaim]],
        Field(
            description=(
                "Claims lists the names of resources, defined in spec.resourceClaims,"
                " that are used by this container.\n\nThis is an alpha field and"
                " requires enabling the DynamicResourceAllocation feature gate.\n\nThis"
                " field is immutable. It can only be set for containers."
            )
        ),
    ] = None
    limits: Annotated[
        Optional[Dict[str, resource.Quantity]],
        Field(
            description=(
                "Limits describes the maximum amount of compute resources allowed. More"
                " info:"
                " https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/"
            )
        ),
    ] = None
    requests: Annotated[
        Optional[Dict[str, resource.Quantity]],
        Field(
            description=(
                "Requests describes the minimum amount of compute resources required."
                " If Requests is omitted for a container, it defaults to Limits if that"
                " is explicitly specified, otherwise to an implementation-defined"
                " value. Requests cannot exceed Limits. More info:"
                " https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/"
            )
        ),
    ] = None


class PodDNSConfig(BaseModel):
    nameservers: Annotated[
        Optional[List[str]],
        Field(
            description=(
                "A list of DNS name server IP addresses. This will be appended to the"
                " base nameservers generated from DNSPolicy. Duplicated nameservers"
                " will be removed."
            )
        ),
    ] = None
    options: Annotated[
        Optional[List[PodDNSConfigOption]],
        Field(
            description=(
                "A list of DNS resolver options. This will be merged with the base"
                " options generated from DNSPolicy. Duplicated entries will be removed."
                " Resolution options given in Options will override those that appear"
                " in the base DNSPolicy."
            )
        ),
    ] = None
    searches: Annotated[
        Optional[List[str]],
        Field(
            description=(
                "A list of DNS search domains for host-name lookup. This will be"
                " appended to the base search paths generated from DNSPolicy."
                " Duplicated search paths will be removed."
            )
        ),
    ] = None


class ConfigMapProjection(BaseModel):
    items: Annotated[
        Optional[List[KeyToPath]],
        Field(
            description=(
                "items if unspecified, each key-value pair in the Data field of the"
                " referenced ConfigMap will be projected into the volume as a file"
                " whose name is the key and content is the value. If specified, the"
                " listed keys will be projected into the specified paths, and unlisted"
                " keys will not be present. If a key is specified which is not present"
                " in the ConfigMap, the volume setup will error unless it is marked"
                " optional. Paths must be relative and may not contain the '..' path or"
                " start with '..'."
            )
        ),
    ] = None
    name: Annotated[
        Optional[str],
        Field(
            description=(
                "Name of the referent. This field is effectively required, but due to"
                " backwards compatibility is allowed to be empty. Instances of this"
                " type with an empty value here are almost certainly wrong. More info:"
                " https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names"
            )
        ),
    ] = None
    optional: Annotated[
        Optional[bool],
        Field(description=("optional specify whether the ConfigMap or its keys must be defined")),
    ] = None


class ConfigMapVolumeSource(BaseModel):
    default_mode: Annotated[
        Optional[int],
        Field(
            alias="defaultMode",
            description=(
                "defaultMode is optional: mode bits used to set permissions on created"
                " files by default. Must be an octal value between 0000 and 0777 or a"
                " decimal value between 0 and 511. YAML accepts both octal and decimal"
                " values, JSON requires decimal values for mode bits. Defaults to 0644."
                " Directories within the path are not affected by this setting. This"
                " might be in conflict with other options that affect the file mode,"
                " like fsGroup, and the result can be other mode bits set."
            ),
        ),
    ] = None
    items: Annotated[
        Optional[List[KeyToPath]],
        Field(
            description=(
                "items if unspecified, each key-value pair in the Data field of the"
                " referenced ConfigMap will be projected into the volume as a file"
                " whose name is the key and content is the value. If specified, the"
                " listed keys will be projected into the specified paths, and unlisted"
                " keys will not be present. If a key is specified which is not present"
                " in the ConfigMap, the volume setup will error unless it is marked"
                " optional. Paths must be relative and may not contain the '..' path or"
                " start with '..'."
            )
        ),
    ] = None
    name: Annotated[
        Optional[str],
        Field(
            description=(
                "Name of the referent. This field is effectively required, but due to"
                " backwards compatibility is allowed to be empty. Instances of this"
                " type with an empty value here are almost certainly wrong. More info:"
                " https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names"
            )
        ),
    ] = None
    optional: Annotated[
        Optional[bool],
        Field(description=("optional specify whether the ConfigMap or its keys must be defined")),
    ] = None


class DownwardAPIProjection(BaseModel):
    items: Annotated[
        Optional[List[DownwardAPIVolumeFile]],
        Field(description="Items is a list of DownwardAPIVolume file"),
    ] = None


class DownwardAPIVolumeSource(BaseModel):
    default_mode: Annotated[
        Optional[int],
        Field(
            alias="defaultMode",
            description=(
                "Optional: mode bits to use on created files by default. Must be a"
                " Optional: mode bits used to set permissions on created files by"
                " default. Must be an octal value between 0000 and 0777 or a decimal"
                " value between 0 and 511. YAML accepts both octal and decimal values,"
                " JSON requires decimal values for mode bits. Defaults to 0644."
                " Directories within the path are not affected by this setting. This"
                " might be in conflict with other options that affect the file mode,"
                " like fsGroup, and the result can be other mode bits set."
            ),
        ),
    ] = None
    items: Annotated[
        Optional[List[DownwardAPIVolumeFile]],
        Field(description="Items is a list of downward API volume file"),
    ] = None


class HTTPGetAction(BaseModel):
    host: Annotated[
        Optional[str],
        Field(
            description=(
                "Host name to connect to, defaults to the pod IP. You probably want to"
                ' set "Host" in httpHeaders instead.'
            )
        ),
    ] = None
    http_headers: Annotated[
        Optional[List[HTTPHeader]],
        Field(
            alias="httpHeaders",
            description=("Custom headers to set in the request. HTTP allows repeated headers."),
        ),
    ] = None
    path: Annotated[Optional[str], Field(description="Path to access on the HTTP server.")] = None
    port: Annotated[
        int,
        Field(
            description=(
                "Name or number of the port to access on the container. Number must be"
                " in the range 1 to 65535. Name must be an IANA_SVC_NAME."
            )
        ),
    ]
    scheme: Annotated[
        Optional[str],
        Field(description="Scheme to use for connecting to the host. Defaults to HTTP."),
    ] = None


class NodeSelector(BaseModel):
    node_selector_terms: Annotated[
        List[NodeSelectorTerm],
        Field(
            alias="nodeSelectorTerms",
            description="Required. A list of node selector terms. The terms are ORed.",
        ),
    ]


class ClusterTrustBundleProjection(BaseModel):
    label_selector: Annotated[
        Optional[v1.LabelSelector],
        Field(
            alias="labelSelector",
            description=(
                "Select all ClusterTrustBundles that match this label selector.  Only"
                " has effect if signerName is set.  Mutually-exclusive with name.  If"
                ' unset, interpreted as "match nothing".  If set but empty, interpreted'
                ' as "match everything".'
            ),
        ),
    ] = None
    name: Annotated[
        Optional[str],
        Field(
            description=(
                "Select a single ClusterTrustBundle by object name.  Mutually-exclusive"
                " with signerName and labelSelector."
            )
        ),
    ] = None
    optional: Annotated[
        Optional[bool],
        Field(
            description=(
                "If true, don't block pod startup if the referenced"
                " ClusterTrustBundle(s) aren't available.  If using name, then the"
                " named ClusterTrustBundle is allowed not to exist.  If using"
                " signerName, then the combination of signerName and labelSelector is"
                " allowed to match zero ClusterTrustBundles."
            )
        ),
    ] = None
    path: Annotated[
        str,
        Field(description="Relative path from the volume root to write the bundle."),
    ]
    signer_name: Annotated[
        Optional[str],
        Field(
            alias="signerName",
            description=(
                "Select all ClusterTrustBundles that match this signer name."
                " Mutually-exclusive with name.  The contents of all selected"
                " ClusterTrustBundles will be unified and deduplicated."
            ),
        ),
    ] = None


class PodAffinityTerm(BaseModel):
    label_selector: Annotated[
        Optional[v1.LabelSelector],
        Field(
            alias="labelSelector",
            description=(
                "A label query over a set of resources, in this case pods. If it's"
                " null, this PodAffinityTerm matches with no Pods."
            ),
        ),
    ] = None
    match_label_keys: Annotated[
        Optional[List[str]],
        Field(
            alias="matchLabelKeys",
            description=(
                "MatchLabelKeys is a set of pod label keys to select which pods will be"
                " taken into consideration. The keys are used to lookup values from the"
                " incoming pod labels, those key-value labels are merged with"
                " `labelSelector` as `key in (value)` to select the group of existing"
                " pods which pods will be taken into consideration for the incoming"
                " pod's pod (anti) affinity. Keys that don't exist in the incoming pod"
                " labels will be ignored. The default value is empty. The same key is"
                " forbidden to exist in both matchLabelKeys and labelSelector. Also,"
                " matchLabelKeys cannot be set when labelSelector isn't set. This is an"
                " alpha field and requires enabling MatchLabelKeysInPodAffinity feature"
                " gate."
            ),
        ),
    ] = None
    mismatch_label_keys: Annotated[
        Optional[List[str]],
        Field(
            alias="mismatchLabelKeys",
            description=(
                "MismatchLabelKeys is a set of pod label keys to select which pods will"
                " be taken into consideration. The keys are used to lookup values from"
                " the incoming pod labels, those key-value labels are merged with"
                " `labelSelector` as `key notin (value)` to select the group of"
                " existing pods which pods will be taken into consideration for the"
                " incoming pod's pod (anti) affinity. Keys that don't exist in the"
                " incoming pod labels will be ignored. The default value is empty. The"
                " same key is forbidden to exist in both mismatchLabelKeys and"
                " labelSelector. Also, mismatchLabelKeys cannot be set when"
                " labelSelector isn't set. This is an alpha field and requires enabling"
                " MatchLabelKeysInPodAffinity feature gate."
            ),
        ),
    ] = None
    namespace_selector: Annotated[
        Optional[v1.LabelSelector],
        Field(
            alias="namespaceSelector",
            description=(
                "A label query over the set of namespaces that the term applies to. The"
                " term is applied to the union of the namespaces selected by this field"
                " and the ones listed in the namespaces field. null selector and null"
                ' or empty namespaces list means "this pod\'s namespace". An empty'
                " selector ({}) matches all namespaces."
            ),
        ),
    ] = None
    namespaces: Annotated[
        Optional[List[str]],
        Field(
            description=(
                "namespaces specifies a static list of namespace names that the term"
                " applies to. The term is applied to the union of the namespaces listed"
                " in this field and the ones selected by namespaceSelector. null or"
                " empty namespaces list and null namespaceSelector means \"this pod's"
                ' namespace".'
            )
        ),
    ] = None
    topology_key: Annotated[
        str,
        Field(
            alias="topologyKey",
            description=(
                "This pod should be co-located (affinity) or not co-located"
                " (anti-affinity) with the pods matching the labelSelector in the"
                " specified namespaces, where co-located is defined as running on a"
                " node whose value of the label with key topologyKey matches that of"
                " any node on which any of the selected pods is running. Empty"
                " topologyKey is not allowed."
            ),
        ),
    ]


class NodeAffinity(BaseModel):
    preferred_during_scheduling_ignored_during_execution: Annotated[
        Optional[List[PreferredSchedulingTerm]],
        Field(
            alias="preferredDuringSchedulingIgnoredDuringExecution",
            description=(
                "The scheduler will prefer to schedule pods to nodes that satisfy the"
                " affinity expressions specified by this field, but it may choose a"
                " node that violates one or more of the expressions. The node that is"
                " most preferred is the one with the greatest sum of weights, i.e. for"
                " each node that meets all of the scheduling requirements (resource"
                " request, requiredDuringScheduling affinity expressions, etc.),"
                " compute a sum by iterating through the elements of this field and"
                ' adding "weight" to the sum if the node matches the corresponding'
                " matchExpressions; the node(s) with the highest sum are the most"
                " preferred."
            ),
        ),
    ] = None
    required_during_scheduling_ignored_during_execution: Annotated[
        Optional[NodeSelector],
        Field(
            alias="requiredDuringSchedulingIgnoredDuringExecution",
            description=(
                "If the affinity requirements specified by this field are not met at"
                " scheduling time, the pod will not be scheduled onto the node. If the"
                " affinity requirements specified by this field cease to be met at some"
                " point during pod execution (e.g. due to an update), the system may or"
                " may not try to eventually evict the pod from its node."
            ),
        ),
    ] = None


class PersistentVolumeClaimSpec(BaseModel):
    access_modes: Annotated[
        Optional[List[str]],
        Field(
            alias="accessModes",
            description=(
                "accessModes contains the desired access modes the volume should have."
                " More info:"
                " https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1"
            ),
        ),
    ] = None
    data_source: Annotated[
        Optional[TypedLocalObjectReference],
        Field(
            alias="dataSource",
            description=(
                "dataSource field can be used to specify either: * An existing"
                " VolumeSnapshot object (snapshot.storage.k8s.io/VolumeSnapshot) * An"
                " existing PVC (PersistentVolumeClaim) If the provisioner or an"
                " external controller can support the specified data source, it will"
                " create a new volume based on the contents of the specified data"
                " source. When the AnyVolumeDataSource feature gate is enabled,"
                " dataSource contents will be copied to dataSourceRef, and"
                " dataSourceRef contents will be copied to dataSource when"
                " dataSourceRef.namespace is not specified. If the namespace is"
                " specified, then dataSourceRef will not be copied to dataSource."
            ),
        ),
    ] = None
    data_source_ref: Annotated[
        Optional[TypedObjectReference],
        Field(
            alias="dataSourceRef",
            description=(
                "dataSourceRef specifies the object from which to populate the volume"
                " with data, if a non-empty volume is desired. This may be any object"
                " from a non-empty API group (non core object) or a"
                " PersistentVolumeClaim object. When this field is specified, volume"
                " binding will only succeed if the type of the specified object matches"
                " some installed volume populator or dynamic provisioner. This field"
                " will replace the functionality of the dataSource field and as such if"
                " both fields are non-empty, they must have the same value. For"
                " backwards compatibility, when namespace isn't specified in"
                " dataSourceRef, both fields (dataSource and dataSourceRef) will be set"
                " to the same value automatically if one of them is empty and the other"
                " is non-empty. When namespace is specified in dataSourceRef,"
                " dataSource isn't set to the same value and must be empty. There are"
                " three important differences between dataSource and dataSourceRef: *"
                " While dataSource only allows two specific types of objects,"
                " dataSourceRef\n  allows any non-core object, as well as"
                " PersistentVolumeClaim objects.\n* While dataSource ignores disallowed"
                " values (dropping them), dataSourceRef\n  preserves all values, and"
                " generates an error if a disallowed value is\n  specified.\n* While"
                " dataSource only allows local objects, dataSourceRef allows objects\n "
                " in any namespaces.\n(Beta) Using this field requires the"
                " AnyVolumeDataSource feature gate to be enabled. (Alpha) Using the"
                " namespace field of dataSourceRef requires the"
                " CrossNamespaceVolumeDataSource feature gate to be enabled."
            ),
        ),
    ] = None
    resources: Annotated[
        Optional[VolumeResourceRequirements],
        Field(
            description=(
                "resources represents the minimum resources the volume should have. If"
                " RecoverVolumeExpansionFailure feature is enabled users are allowed to"
                " specify resource requirements that are lower than previous value but"
                " must still be higher than capacity recorded in the status field of"
                " the claim. More info:"
                " https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources"
            )
        ),
    ] = None
    selector: Annotated[
        Optional[v1.LabelSelector],
        Field(description=("selector is a label query over volumes to consider for binding.")),
    ] = None
    storage_class_name: Annotated[
        Optional[str],
        Field(
            alias="storageClassName",
            description=(
                "storageClassName is the name of the StorageClass required by the"
                " claim. More info:"
                " https://kubernetes.io/docs/concepts/storage/persistent-volumes#class-1"
            ),
        ),
    ] = None
    volume_attributes_class_name: Annotated[
        Optional[str],
        Field(
            alias="volumeAttributesClassName",
            description=(
                "volumeAttributesClassName may be used to set the VolumeAttributesClass"
                " used by this claim. If specified, the CSI driver will create or"
                " update the volume with the attributes defined in the corresponding"
                " VolumeAttributesClass. This has a different purpose than"
                " storageClassName, it can be changed after the claim is created. An"
                " empty string value means that no VolumeAttributesClass will be"
                " applied to the claim but it's not allowed to reset this field to"
                " empty string once it is set. If unspecified and the"
                " PersistentVolumeClaim is unbound, the default VolumeAttributesClass"
                " will be set by the persistentvolume controller if it exists. If the"
                " resource referred to by volumeAttributesClass does not exist, this"
                " PersistentVolumeClaim will be set to a Pending state, as reflected by"
                " the modifyVolumeStatus field, until such as a resource exists. More"
                " info:"
                " https://kubernetes.io/docs/concepts/storage/volume-attributes-classes/"
                " (Alpha) Using this field requires the VolumeAttributesClass feature"
                " gate to be enabled."
            ),
        ),
    ] = None
    volume_mode: Annotated[
        Optional[str],
        Field(
            alias="volumeMode",
            description=(
                "volumeMode defines what type of volume is required by the claim. Value"
                " of Filesystem is implied when not included in claim spec."
            ),
        ),
    ] = None
    volume_name: Annotated[
        Optional[str],
        Field(
            alias="volumeName",
            description=("volumeName is the binding reference to the PersistentVolume backing this claim."),
        ),
    ] = None


class LifecycleHandler(BaseModel):
    exec: Annotated[Optional[ExecAction], Field(description="Exec specifies the action to take.")] = None
    http_get: Annotated[
        Optional[HTTPGetAction],
        Field(
            alias="httpGet",
            description="HTTPGet specifies the http request to perform.",
        ),
    ] = None
    sleep: Annotated[
        Optional[SleepAction],
        Field(description=("Sleep represents the duration that the container should sleep before being terminated.")),
    ] = None
    tcp_socket: Annotated[
        Optional[TCPSocketAction],
        Field(
            alias="tcpSocket",
            description=(
                "Deprecated. TCPSocket is NOT supported as a LifecycleHandler and kept"
                " for the backward compatibility. There are no validation of this field"
                " and lifecycle hooks will fail in runtime when tcp handler is"
                " specified."
            ),
        ),
    ] = None


class Probe(BaseModel):
    exec: Annotated[Optional[ExecAction], Field(description="Exec specifies the action to take.")] = None
    failure_threshold: Annotated[
        Optional[int],
        Field(
            alias="failureThreshold",
            description=(
                "Minimum consecutive failures for the probe to be considered failed"
                " after having succeeded. Defaults to 3. Minimum value is 1."
            ),
        ),
    ] = None
    grpc: Annotated[
        Optional[GRPCAction],
        Field(description="GRPC specifies an action involving a GRPC port."),
    ] = None
    http_get: Annotated[
        Optional[HTTPGetAction],
        Field(
            alias="httpGet",
            description="HTTPGet specifies the http request to perform.",
        ),
    ] = None
    initial_delay_seconds: Annotated[
        Optional[int],
        Field(
            alias="initialDelaySeconds",
            description=(
                "Number of seconds after the container has started before liveness"
                " probes are initiated. More info:"
                " https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes"
            ),
        ),
    ] = None
    period_seconds: Annotated[
        Optional[int],
        Field(
            alias="periodSeconds",
            description=("How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1."),
        ),
    ] = None
    success_threshold: Annotated[
        Optional[int],
        Field(
            alias="successThreshold",
            description=(
                "Minimum consecutive successes for the probe to be considered"
                " successful after having failed. Defaults to 1. Must be 1 for liveness"
                " and startup. Minimum value is 1."
            ),
        ),
    ] = None
    tcp_socket: Annotated[
        Optional[TCPSocketAction],
        Field(
            alias="tcpSocket",
            description="TCPSocket specifies an action involving a TCP port.",
        ),
    ] = None
    termination_grace_period_seconds: Annotated[
        Optional[int],
        Field(
            alias="terminationGracePeriodSeconds",
            description=(
                "Optional duration in seconds the pod needs to terminate gracefully"
                " upon probe failure. The grace period is the duration in seconds after"
                " the processes running in the pod are sent a termination signal and"
                " the time when the processes are forcibly halted with a kill signal."
                " Set this value longer than the expected cleanup time for your"
                " process. If this value is nil, the pod's"
                " terminationGracePeriodSeconds will be used. Otherwise, this value"
                " overrides the value provided by the pod spec. Value must be"
                " non-negative integer. The value zero indicates stop immediately via"
                " the kill signal (no opportunity to shut down). This is a beta field"
                " and requires enabling ProbeTerminationGracePeriod feature gate."
                " Minimum value is 1. spec.terminationGracePeriodSeconds is used if"
                " unset."
            ),
        ),
    ] = None
    timeout_seconds: Annotated[
        Optional[int],
        Field(
            alias="timeoutSeconds",
            description=(
                "Number of seconds after which the probe times out. Defaults to 1"
                " second. Minimum value is 1. More info:"
                " https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes"
            ),
        ),
    ] = None


class VolumeProjection(BaseModel):
    cluster_trust_bundle: Annotated[
        Optional[ClusterTrustBundleProjection],
        Field(
            alias="clusterTrustBundle",
            description=(
                "ClusterTrustBundle allows a pod to access the `.spec.trustBundle`"
                " field of ClusterTrustBundle objects in an auto-updating"
                " file.\n\nAlpha, gated by the ClusterTrustBundleProjection feature"
                " gate.\n\nClusterTrustBundle objects can either be selected by name,"
                " or by the combination of signer name and a label selector.\n\nKubelet"
                " performs aggressive normalization of the PEM contents written into"
                " the pod filesystem.  Esoteric PEM features such as inter-block"
                " comments and block headers are stripped.  Certificates are"
                " deduplicated. The ordering of certificates within the file is"
                " arbitrary, and Kubelet may change the order over time."
            ),
        ),
    ] = None
    config_map: Annotated[
        Optional[ConfigMapProjection],
        Field(
            alias="configMap",
            description="configMap information about the configMap data to project",
        ),
    ] = None
    downward_api: Annotated[
        Optional[DownwardAPIProjection],
        Field(
            alias="downwardAPI",
            description="downwardAPI information about the downwardAPI data to project",
        ),
    ] = None
    secret: Annotated[
        Optional[SecretProjection],
        Field(description="secret information about the secret data to project"),
    ] = None
    service_account_token: Annotated[
        Optional[ServiceAccountTokenProjection],
        Field(
            alias="serviceAccountToken",
            description=("serviceAccountToken is information about the serviceAccountToken data to project"),
        ),
    ] = None


class WeightedPodAffinityTerm(BaseModel):
    pod_affinity_term: Annotated[
        PodAffinityTerm,
        Field(
            alias="podAffinityTerm",
            description=("Required. A pod affinity term, associated with the corresponding weight."),
        ),
    ]
    weight: Annotated[
        int,
        Field(description=("weight associated with matching the corresponding podAffinityTerm, in the range 1-100.")),
    ]


class Event(BaseModel):
    action: Annotated[
        Optional[str],
        Field(description=("What action was taken/failed regarding to the Regarding object.")),
    ] = None
    api_version: Annotated[
        Optional[str],
        Field(
            alias="apiVersion",
            description=(
                "APIVersion defines the versioned schema of this representation of an"
                " object. Servers should convert recognized schemas to the latest"
                " internal value, and may reject unrecognized values. More info:"
                " https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources"
            ),
        ),
    ] = None
    count: Annotated[Optional[int], Field(description="The number of times this event has occurred.")] = None
    event_time: Annotated[
        Optional[v1.MicroTime],
        Field(alias="eventTime", description="Time when this Event was first observed."),
    ] = None
    first_timestamp: Annotated[
        Optional[v1.Time],
        Field(
            alias="firstTimestamp",
            description=("The time at which the event was first recorded. (Time of server receipt is in TypeMeta.)"),
        ),
    ] = None
    involved_object: Annotated[
        ObjectReference,
        Field(alias="involvedObject", description="The object that this event is about."),
    ]
    kind: Annotated[
        Optional[str],
        Field(
            description=(
                "Kind is a string value representing the REST resource this object"
                " represents. Servers may infer this from the endpoint the client"
                " submits requests to. Cannot be updated. In CamelCase. More info:"
                " https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds"
            )
        ),
    ] = None
    last_timestamp: Annotated[
        Optional[v1.Time],
        Field(
            alias="lastTimestamp",
            description=("The time at which the most recent occurrence of this event was recorded."),
        ),
    ] = None
    message: Annotated[
        Optional[str],
        Field(description="A human-readable description of the status of this operation."),
    ] = None
    metadata: Annotated[
        v1.ObjectMeta,
        Field(
            description=(
                "Standard object's metadata. More info:"
                " https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata"
            )
        ),
    ]
    reason: Annotated[
        Optional[str],
        Field(
            description=(
                "This should be a short, machine understandable string that gives the"
                " reason for the transition into the object's current status."
            )
        ),
    ] = None
    related: Annotated[
        Optional[ObjectReference],
        Field(description="Optional secondary object for more complex actions."),
    ] = None
    reporting_component: Annotated[
        Optional[str],
        Field(
            alias="reportingComponent",
            description=("Name of the controller that emitted this Event, e.g. `kubernetes.io/kubelet`."),
        ),
    ] = None
    reporting_instance: Annotated[
        Optional[str],
        Field(
            alias="reportingInstance",
            description="ID of the controller instance, e.g. `kubelet-xyzf`.",
        ),
    ] = None
    series: Annotated[
        Optional[EventSeries],
        Field(description=("Data about the Event series this event represents or nil if it's a singleton Event.")),
    ] = None
    source: Annotated[
        Optional[EventSource],
        Field(description=("The component reporting this event. Should be a short machine understandable string.")),
    ] = None
    type: Annotated[
        Optional[str],
        Field(description=("Type of this event (Normal, Warning), new types could be added in the future")),
    ] = None


class PersistentVolumeClaim(BaseModel):
    api_version: Annotated[
        Optional[str],
        Field(
            alias="apiVersion",
            description=(
                "APIVersion defines the versioned schema of this representation of an"
                " object. Servers should convert recognized schemas to the latest"
                " internal value, and may reject unrecognized values. More info:"
                " https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources"
            ),
        ),
    ] = None
    kind: Annotated[
        Optional[str],
        Field(
            description=(
                "Kind is a string value representing the REST resource this object"
                " represents. Servers may infer this from the endpoint the client"
                " submits requests to. Cannot be updated. In CamelCase. More info:"
                " https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds"
            )
        ),
    ] = None
    metadata: Annotated[
        Optional[v1.ObjectMeta],
        Field(
            description=(
                "Standard object's metadata. More info:"
                " https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata"
            )
        ),
    ] = None
    spec: Annotated[
        Optional[PersistentVolumeClaimSpec],
        Field(
            description=(
                "spec defines the desired characteristics of a volume requested by a"
                " pod author. More info:"
                " https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims"
            )
        ),
    ] = None
    status: Annotated[
        Optional[PersistentVolumeClaimStatus],
        Field(
            description=(
                "status represents the current information/status of a persistent"
                " volume claim. Read-only. More info:"
                " https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims"
            )
        ),
    ] = None


class PersistentVolumeClaimTemplate(BaseModel):
    metadata: Annotated[
        Optional[v1.ObjectMeta],
        Field(
            description=(
                "May contain labels and annotations that will be copied into the PVC"
                " when creating it. No other fields are allowed and will be rejected"
                " during validation."
            )
        ),
    ] = None
    spec: Annotated[
        PersistentVolumeClaimSpec,
        Field(
            description=(
                "The specification for the PersistentVolumeClaim. The entire content is"
                " copied unchanged into the PVC that gets created from this template."
                " The same fields as in a PersistentVolumeClaim are also valid here."
            )
        ),
    ]


class Lifecycle(BaseModel):
    post_start: Annotated[
        Optional[LifecycleHandler],
        Field(
            alias="postStart",
            description=(
                "PostStart is called immediately after a container is created. If the"
                " handler fails, the container is terminated and restarted according to"
                " its restart policy. Other management of the container blocks until"
                " the hook completes. More info:"
                " https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks"
            ),
        ),
    ] = None
    pre_stop: Annotated[
        Optional[LifecycleHandler],
        Field(
            alias="preStop",
            description=(
                "PreStop is called immediately before a container is terminated due to"
                " an API request or management event such as liveness/startup probe"
                " failure, preemption, resource contention, etc. The handler is not"
                " called if the container crashes or exits. The Pod's termination grace"
                " period countdown begins before the PreStop hook is executed."
                " Regardless of the outcome of the handler, the container will"
                " eventually terminate within the Pod's termination grace period"
                " (unless delayed by finalizers). Other management of the container"
                " blocks until the hook completes or until the termination grace period"
                " is reached. More info:"
                " https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks"
            ),
        ),
    ] = None


class EphemeralVolumeSource(BaseModel):
    volume_claim_template: Annotated[
        Optional[PersistentVolumeClaimTemplate],
        Field(
            alias="volumeClaimTemplate",
            description=(
                "Will be used to create a stand-alone PVC to provision the volume. The"
                " pod in which this EphemeralVolumeSource is embedded will be the owner"
                " of the PVC, i.e. the PVC will be deleted together with the pod.  The"
                " name of the PVC will be `<pod name>-<volume name>` where `<volume"
                " name>` is the name from the `PodSpec.Volumes` array entry. Pod"
                " validation will reject the pod if the concatenated name is not valid"
                " for a PVC (for example, too long).\n\nAn existing PVC with that name"
                " that is not owned by the pod will *not* be used for the pod to avoid"
                " using an unrelated volume by mistake. Starting the pod is then"
                " blocked until the unrelated PVC is removed. If such a pre-created PVC"
                " is meant to be used by the pod, the PVC has to updated with an owner"
                " reference to the pod once the pod exists. Normally this should not be"
                " necessary, but it may be useful when manually reconstructing a broken"
                " cluster.\n\nThis field is read-only and no changes will be made by"
                " Kubernetes to the PVC after it has been created.\n\nRequired, must"
                " not be nil."
            ),
        ),
    ] = None


class Container(BaseModel):
    args: Annotated[
        Optional[List[str]],
        Field(
            description=(
                "Arguments to the entrypoint. The container image's CMD is used if"
                " this is not provided. Variable references $(VAR_NAME) are expanded"
                " using the container's environment. If a variable cannot be resolved,"
                " the reference in the input string will be unchanged. Double $$ are"
                " reduced to a single $, which allows for escaping the $(VAR_NAME)"
                ' syntax: i.e. "$$(VAR_NAME)" will produce the string literal'
                ' "$(VAR_NAME)". Escaped references will never be expanded, regardless'
                " of whether the variable exists or not. Cannot be updated. More info:"
                " https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell"
            )
        ),
    ] = None
    command: Annotated[
        Optional[List[str]],
        Field(
            description=(
                "Entrypoint array. Not executed within a shell. The container image's"
                " ENTRYPOINT is used if this is not provided. Variable references"
                " $(VAR_NAME) are expanded using the container's environment. If a"
                " variable cannot be resolved, the reference in the input string will"
                " be unchanged. Double $$ are reduced to a single $, which allows for"
                ' escaping the $(VAR_NAME) syntax: i.e. "$$(VAR_NAME)" will produce the'
                ' string literal "$(VAR_NAME)". Escaped references will never be'
                " expanded, regardless of whether the variable exists or not. Cannot be"
                " updated. More info:"
                " https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell"
            )
        ),
    ] = None
    env: Annotated[
        Optional[List[EnvVar]],
        Field(description=("List of environment variables to set in the container. Cannot be updated.")),
    ] = None
    env_from: Annotated[
        Optional[List[EnvFromSource]],
        Field(
            alias="envFrom",
            description=(
                "List of sources to populate environment variables in the container."
                " The keys defined within a source must be a C_IDENTIFIER. All invalid"
                " keys will be reported as an event when the container is starting."
                " When a key exists in multiple sources, the value associated with the"
                " last source will take precedence. Values defined by an Env with a"
                " duplicate key will take precedence. Cannot be updated."
            ),
        ),
    ] = None
    image: Annotated[
        str,
        Field(
            description=(
                "Container image name. More info:"
                " https://kubernetes.io/docs/concepts/containers/images This field is"
                " optional to allow higher level config management to default or"
                " override container images in workload controllers like Deployments"
                " and StatefulSets."
            )
        ),
    ]
    image_pull_policy: Annotated[
        Optional[str],
        Field(
            alias="imagePullPolicy",
            description=(
                "Image pull policy. One of Always, Never, IfNotPresent. Defaults to"
                " Always if :latest tag is specified, or IfNotPresent otherwise. Cannot"
                " be updated. More info:"
                " https://kubernetes.io/docs/concepts/containers/images#updating-images"
            ),
        ),
    ] = None
    lifecycle: Annotated[
        Optional[Lifecycle],
        Field(
            description=(
                "Actions that the management system should take in response to"
                " container lifecycle events. Cannot be updated."
            )
        ),
    ] = None
    liveness_probe: Annotated[
        Optional[Probe],
        Field(
            alias="livenessProbe",
            description=(
                "Periodic probe of container liveness. Container will be restarted if"
                " the probe fails. Cannot be updated. More info:"
                " https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes"
            ),
        ),
    ] = None
    name: Annotated[
        Optional[str],
        Field(
            description=(
                "Name of the container specified as a DNS_LABEL. Each container in a"
                " pod must have a unique name (DNS_LABEL). Cannot be updated."
            )
        ),
    ] = None
    ports: Annotated[
        Optional[List[ContainerPort]],
        Field(
            description=(
                "List of ports to expose from the container. Not specifying a port here"
                " DOES NOT prevent that port from being exposed. Any port which is"
                ' listening on the default "0.0.0.0" address inside a container will be'
                " accessible from the network. Modifying this array with strategic"
                " merge patch may corrupt the data. For more information See"
                " https://github.com/kubernetes/kubernetes/issues/108255. Cannot be"
                " updated."
            )
        ),
    ] = None
    readiness_probe: Annotated[
        Optional[Probe],
        Field(
            alias="readinessProbe",
            description=(
                "Periodic probe of container service readiness. Container will be"
                " removed from service endpoints if the probe fails. Cannot be updated."
                " More info:"
                " https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes"
            ),
        ),
    ] = None
    resize_policy: Annotated[
        Optional[List[ContainerResizePolicy]],
        Field(
            alias="resizePolicy",
            description="Resources resize policy for the container.",
        ),
    ] = None
    resources: Annotated[
        Optional[ResourceRequirements],
        Field(
            description=(
                "Compute Resources required by this container. Cannot be updated. More"
                " info:"
                " https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/"
            )
        ),
    ] = None
    restart_policy: Annotated[
        Optional[str],
        Field(
            alias="restartPolicy",
            description=(
                "RestartPolicy defines the restart behavior of individual containers in"
                " a pod. This field may only be set for init containers, and the only"
                ' allowed value is "Always". For non-init containers or when this field'
                " is not specified, the restart behavior is defined by the Pod's"
                " restart policy and the container type. Setting the RestartPolicy as"
                ' "Always" for the init container will have the following effect: this'
                " init container will be continually restarted on exit until all"
                " regular containers have terminated. Once all regular containers have"
                ' completed, all init containers with restartPolicy "Always" will be'
                " shut down. This lifecycle differs from normal init containers and is"
                ' often referred to as a "sidecar" container. Although this init'
                " container still starts in the init container sequence, it does not"
                " wait for the container to complete before proceeding to the next init"
                " container. Instead, the next init container starts immediately after"
                " this init container is started, or after any startupProbe has"
                " successfully completed."
            ),
        ),
    ] = None
    security_context: Annotated[
        Optional[SecurityContext],
        Field(
            alias="securityContext",
            description=(
                "SecurityContext defines the security options the container should be"
                " run with. If set, the fields of SecurityContext override the"
                " equivalent fields of PodSecurityContext. More info:"
                " https://kubernetes.io/docs/tasks/configure-pod-container/security-context/"
            ),
        ),
    ] = None
    startup_probe: Annotated[
        Optional[Probe],
        Field(
            alias="startupProbe",
            description=(
                "StartupProbe indicates that the Pod has successfully initialized. If"
                " specified, no other probes are executed until this completes"
                " successfully. If this probe fails, the Pod will be restarted, just as"
                " if the livenessProbe failed. This can be used to provide different"
                " probe parameters at the beginning of a Pod's lifecycle, when it might"
                " take a long time to load data or warm a cache, than during"
                " steady-state operation. This cannot be updated. More info:"
                " https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes"
            ),
        ),
    ] = None
    stdin: Annotated[
        Optional[bool],
        Field(
            description=(
                "Whether this container should allocate a buffer for stdin in the"
                " container runtime. If this is not set, reads from stdin in the"
                " container will always result in EOF. Default is false."
            )
        ),
    ] = None
    stdin_once: Annotated[
        Optional[bool],
        Field(
            alias="stdinOnce",
            description=(
                "Whether the container runtime should close the stdin channel after it"
                " has been opened by a single attach. When stdin is true the stdin"
                " stream will remain open across multiple attach sessions. If stdinOnce"
                " is set to true, stdin is opened on container start, is empty until"
                " the first client attaches to stdin, and then remains open and accepts"
                " data until the client disconnects, at which time stdin is closed and"
                " remains closed until the container is restarted. If this flag is"
                " false, a container processes that reads from stdin will never receive"
                " an EOF. Default is false"
            ),
        ),
    ] = None
    termination_message_path: Annotated[
        Optional[str],
        Field(
            alias="terminationMessagePath",
            description=(
                "Optional: Path at which the file to which the container's termination"
                " message will be written is mounted into the container's filesystem."
                " Message written is intended to be brief final status, such as an"
                " assertion failure message. Will be truncated by the node if greater"
                " than 4096 bytes. The total message length across all containers will"
                " be limited to 12kb. Defaults to /dev/termination-log. Cannot be"
                " updated."
            ),
        ),
    ] = None
    termination_message_policy: Annotated[
        Optional[str],
        Field(
            alias="terminationMessagePolicy",
            description=(
                "Indicate how the termination message should be populated. File will"
                " use the contents of terminationMessagePath to populate the container"
                " status message on both success and failure. FallbackToLogsOnError"
                " will use the last chunk of container log output if the termination"
                " message file is empty and the container exited with an error. The log"
                " output is limited to 2048 bytes or 80 lines, whichever is smaller."
                " Defaults to File. Cannot be updated."
            ),
        ),
    ] = None
    tty: Annotated[
        Optional[bool],
        Field(
            description=(
                "Whether this container should allocate a TTY for itself, also requires"
                " 'stdin' to be true. Default is false."
            )
        ),
    ] = None
    volume_devices: Annotated[
        Optional[List[VolumeDevice]],
        Field(
            alias="volumeDevices",
            description=("volumeDevices is the list of block devices to be used by the container."),
        ),
    ] = None
    volume_mounts: Annotated[
        Optional[List[VolumeMount]],
        Field(
            alias="volumeMounts",
            description=("Pod volumes to mount into the container's filesystem. Cannot be updated."),
        ),
    ] = None
    working_dir: Annotated[
        Optional[str],
        Field(
            alias="workingDir",
            description=(
                "Container's working directory. If not specified, the container"
                " runtime's default will be used, which might be configured in the"
                " container image. Cannot be updated."
            ),
        ),
    ] = None


class PodAffinity(BaseModel):
    preferred_during_scheduling_ignored_during_execution: Annotated[
        Optional[List[WeightedPodAffinityTerm]],
        Field(
            alias="preferredDuringSchedulingIgnoredDuringExecution",
            description=(
                "The scheduler will prefer to schedule pods to nodes that satisfy the"
                " affinity expressions specified by this field, but it may choose a"
                " node that violates one or more of the expressions. The node that is"
                " most preferred is the one with the greatest sum of weights, i.e. for"
                " each node that meets all of the scheduling requirements (resource"
                " request, requiredDuringScheduling affinity expressions, etc.),"
                " compute a sum by iterating through the elements of this field and"
                ' adding "weight" to the sum if the node has pods which matches the'
                " corresponding podAffinityTerm; the node(s) with the highest sum are"
                " the most preferred."
            ),
        ),
    ] = None
    required_during_scheduling_ignored_during_execution: Annotated[
        Optional[List[PodAffinityTerm]],
        Field(
            alias="requiredDuringSchedulingIgnoredDuringExecution",
            description=(
                "If the affinity requirements specified by this field are not met at"
                " scheduling time, the pod will not be scheduled onto the node. If the"
                " affinity requirements specified by this field cease to be met at some"
                " point during pod execution (e.g. due to a pod label update), the"
                " system may or may not try to eventually evict the pod from its node."
                " When there are multiple elements, the lists of nodes corresponding to"
                " each podAffinityTerm are intersected, i.e. all terms must be"
                " satisfied."
            ),
        ),
    ] = None


class PodAntiAffinity(BaseModel):
    preferred_during_scheduling_ignored_during_execution: Annotated[
        Optional[List[WeightedPodAffinityTerm]],
        Field(
            alias="preferredDuringSchedulingIgnoredDuringExecution",
            description=(
                "The scheduler will prefer to schedule pods to nodes that satisfy the"
                " anti-affinity expressions specified by this field, but it may choose"
                " a node that violates one or more of the expressions. The node that is"
                " most preferred is the one with the greatest sum of weights, i.e. for"
                " each node that meets all of the scheduling requirements (resource"
                " request, requiredDuringScheduling anti-affinity expressions, etc.),"
                " compute a sum by iterating through the elements of this field and"
                ' adding "weight" to the sum if the node has pods which matches the'
                " corresponding podAffinityTerm; the node(s) with the highest sum are"
                " the most preferred."
            ),
        ),
    ] = None
    required_during_scheduling_ignored_during_execution: Annotated[
        Optional[List[PodAffinityTerm]],
        Field(
            alias="requiredDuringSchedulingIgnoredDuringExecution",
            description=(
                "If the anti-affinity requirements specified by this field are not met"
                " at scheduling time, the pod will not be scheduled onto the node. If"
                " the anti-affinity requirements specified by this field cease to be"
                " met at some point during pod execution (e.g. due to a pod label"
                " update), the system may or may not try to eventually evict the pod"
                " from its node. When there are multiple elements, the lists of nodes"
                " corresponding to each podAffinityTerm are intersected, i.e. all terms"
                " must be satisfied."
            ),
        ),
    ] = None


class ProjectedVolumeSource(BaseModel):
    default_mode: Annotated[
        Optional[int],
        Field(
            alias="defaultMode",
            description=(
                "defaultMode are the mode bits used to set permissions on created files"
                " by default. Must be an octal value between 0000 and 0777 or a decimal"
                " value between 0 and 511. YAML accepts both octal and decimal values,"
                " JSON requires decimal values for mode bits. Directories within the"
                " path are not affected by this setting. This might be in conflict with"
                " other options that affect the file mode, like fsGroup, and the result"
                " can be other mode bits set."
            ),
        ),
    ] = None
    sources: Annotated[
        Optional[List[VolumeProjection]],
        Field(description="sources is the list of volume projections"),
    ] = None


class Affinity(BaseModel):
    node_affinity: Annotated[
        Optional[NodeAffinity],
        Field(
            alias="nodeAffinity",
            description="Describes node affinity scheduling rules for the pod.",
        ),
    ] = None
    pod_affinity: Annotated[
        Optional[PodAffinity],
        Field(
            alias="podAffinity",
            description=(
                "Describes pod affinity scheduling rules (e.g. co-locate this pod in"
                " the same node, zone, etc. as some other pod(s))."
            ),
        ),
    ] = None
    pod_anti_affinity: Annotated[
        Optional[PodAntiAffinity],
        Field(
            alias="podAntiAffinity",
            description=(
                "Describes pod anti-affinity scheduling rules (e.g. avoid putting this"
                " pod in the same node, zone, etc. as some other pod(s))."
            ),
        ),
    ] = None


class Volume(BaseModel):
    aws_elastic_block_store: Annotated[
        Optional[AWSElasticBlockStoreVolumeSource],
        Field(
            alias="awsElasticBlockStore",
            description=(
                "awsElasticBlockStore represents an AWS Disk resource that is attached"
                " to a kubelet's host machine and then exposed to the pod. More info:"
                " https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore"
            ),
        ),
    ] = None
    azure_disk: Annotated[
        Optional[AzureDiskVolumeSource],
        Field(
            alias="azureDisk",
            description=("azureDisk represents an Azure Data Disk mount on the host and bind mount to the pod."),
        ),
    ] = None
    azure_file: Annotated[
        Optional[AzureFileVolumeSource],
        Field(
            alias="azureFile",
            description=("azureFile represents an Azure File Service mount on the host and bind mount to the pod."),
        ),
    ] = None
    cephfs: Annotated[
        Optional[CephFSVolumeSource],
        Field(description=("cephFS represents a Ceph FS mount on the host that shares a pod's lifetime")),
    ] = None
    cinder: Annotated[
        Optional[CinderVolumeSource],
        Field(
            description=(
                "cinder represents a cinder volume attached and mounted on kubelets"
                " host machine. More info:"
                " https://examples.k8s.io/mysql-cinder-pd/README.md"
            )
        ),
    ] = None
    config_map: Annotated[
        Optional[ConfigMapVolumeSource],
        Field(
            alias="configMap",
            description=("configMap represents a configMap that should populate this volume"),
        ),
    ] = None
    csi: Annotated[
        Optional[CSIVolumeSource],
        Field(
            description=(
                "csi (Container Storage Interface) represents ephemeral storage that is"
                " handled by certain external CSI drivers (Beta feature)."
            )
        ),
    ] = None
    downward_api: Annotated[
        Optional[DownwardAPIVolumeSource],
        Field(
            alias="downwardAPI",
            description=("downwardAPI represents downward API about the pod that should populate this volume"),
        ),
    ] = None
    empty_dir: Annotated[
        Optional[EmptyDirVolumeSource],
        Field(
            alias="emptyDir",
            description=(
                "emptyDir represents a temporary directory that shares a pod's"
                " lifetime. More info:"
                " https://kubernetes.io/docs/concepts/storage/volumes#emptydir"
            ),
        ),
    ] = None
    ephemeral: Annotated[
        Optional[EphemeralVolumeSource],
        Field(
            description=(
                "ephemeral represents a volume that is handled by a cluster storage"
                " driver. The volume's lifecycle is tied to the pod that defines it -"
                " it will be created before the pod starts, and deleted when the pod is"
                " removed.\n\nUse this if: a) the volume is only needed while the pod"
                " runs, b) features of normal volumes like restoring from snapshot or"
                " capacity\n   tracking are needed,\nc) the storage driver is specified"
                " through a storage class, and d) the storage driver supports dynamic"
                " volume provisioning through\n   a PersistentVolumeClaim (see"
                " EphemeralVolumeSource for more\n   information on the connection"
                " between this volume type\n   and PersistentVolumeClaim).\n\nUse"
                " PersistentVolumeClaim or one of the vendor-specific APIs for volumes"
                " that persist for longer than the lifecycle of an individual"
                " pod.\n\nUse CSI for light-weight local ephemeral volumes if the CSI"
                " driver is meant to be used that way - see the documentation of the"
                " driver for more information.\n\nA pod can use both types of ephemeral"
                " volumes and persistent volumes at the same time."
            )
        ),
    ] = None
    fc: Annotated[
        Optional[FCVolumeSource],
        Field(
            description=(
                "fc represents a Fibre Channel resource that is attached to a kubelet's"
                " host machine and then exposed to the pod."
            )
        ),
    ] = None
    flex_volume: Annotated[
        Optional[FlexVolumeSource],
        Field(
            alias="flexVolume",
            description=(
                "flexVolume represents a generic volume resource that is"
                " provisioned/attached using an exec based plugin."
            ),
        ),
    ] = None
    flocker: Annotated[
        Optional[FlockerVolumeSource],
        Field(
            description=(
                "flocker represents a Flocker volume attached to a kubelet's host"
                " machine. This depends on the Flocker control service being running"
            )
        ),
    ] = None
    gce_persistent_disk: Annotated[
        Optional[GCEPersistentDiskVolumeSource],
        Field(
            alias="gcePersistentDisk",
            description=(
                "gcePersistentDisk represents a GCE Disk resource that is attached to a"
                " kubelet's host machine and then exposed to the pod. More info:"
                " https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk"
            ),
        ),
    ] = None
    git_repo: Annotated[
        Optional[GitRepoVolumeSource],
        Field(
            alias="gitRepo",
            description=(
                "gitRepo represents a git repository at a particular revision."
                " DEPRECATED: GitRepo is deprecated. To provision a container with a"
                " git repo, mount an EmptyDir into an InitContainer that clones the"
                " repo using git, then mount the EmptyDir into the Pod's container."
            ),
        ),
    ] = None
    glusterfs: Annotated[
        Optional[GlusterfsVolumeSource],
        Field(
            description=(
                "glusterfs represents a Glusterfs mount on the host that shares a pod's"
                " lifetime. More info:"
                " https://examples.k8s.io/volumes/glusterfs/README.md"
            )
        ),
    ] = None
    host_path: Annotated[
        Optional[HostPathVolumeSource],
        Field(
            alias="hostPath",
            description=(
                "hostPath represents a pre-existing file or directory on the host"
                " machine that is directly exposed to the container. This is generally"
                " used for system agents or other privileged things that are allowed to"
                " see the host machine. Most containers will NOT need this. More info:"
                " https://kubernetes.io/docs/concepts/storage/volumes#hostpath"
            ),
        ),
    ] = None
    iscsi: Annotated[
        Optional[ISCSIVolumeSource],
        Field(
            description=(
                "iscsi represents an ISCSI Disk resource that is attached to a"
                " kubelet's host machine and then exposed to the pod. More info:"
                " https://examples.k8s.io/volumes/iscsi/README.md"
            )
        ),
    ] = None
    name: Annotated[
        str,
        Field(
            description=(
                "name of the volume. Must be a DNS_LABEL and unique within the pod."
                " More info:"
                " https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names"
            )
        ),
    ]
    nfs: Annotated[
        Optional[NFSVolumeSource],
        Field(
            description=(
                "nfs represents an NFS mount on the host that shares a pod's lifetime"
                " More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs"
            )
        ),
    ] = None
    persistent_volume_claim: Annotated[
        Optional[PersistentVolumeClaimVolumeSource],
        Field(
            alias="persistentVolumeClaim",
            description=(
                "persistentVolumeClaimVolumeSource represents a reference to a"
                " PersistentVolumeClaim in the same namespace. More info:"
                " https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims"
            ),
        ),
    ] = None
    photon_persistent_disk: Annotated[
        Optional[PhotonPersistentDiskVolumeSource],
        Field(
            alias="photonPersistentDisk",
            description=(
                "photonPersistentDisk represents a PhotonController persistent disk"
                " attached and mounted on kubelets host machine"
            ),
        ),
    ] = None
    portworx_volume: Annotated[
        Optional[PortworxVolumeSource],
        Field(
            alias="portworxVolume",
            description=("portworxVolume represents a portworx volume attached and mounted on kubelets host machine"),
        ),
    ] = None
    projected: Annotated[
        Optional[ProjectedVolumeSource],
        Field(description=("projected items for all in one resources secrets, configmaps, and downward API")),
    ] = None
    quobyte: Annotated[
        Optional[QuobyteVolumeSource],
        Field(description=("quobyte represents a Quobyte mount on the host that shares a pod's lifetime")),
    ] = None
    rbd: Annotated[
        Optional[RBDVolumeSource],
        Field(
            description=(
                "rbd represents a Rados Block Device mount on the host that shares a"
                " pod's lifetime. More info:"
                " https://examples.k8s.io/volumes/rbd/README.md"
            )
        ),
    ] = None
    scale_io: Annotated[
        Optional[ScaleIOVolumeSource],
        Field(
            alias="scaleIO",
            description=("scaleIO represents a ScaleIO persistent volume attached and mounted on Kubernetes nodes."),
        ),
    ] = None
    secret: Annotated[
        Optional[SecretVolumeSource],
        Field(
            description=(
                "secret represents a secret that should populate this volume. More"
                " info: https://kubernetes.io/docs/concepts/storage/volumes#secret"
            )
        ),
    ] = None
    storageos: Annotated[
        Optional[StorageOSVolumeSource],
        Field(description=("storageOS represents a StorageOS volume attached and mounted on Kubernetes nodes.")),
    ] = None
    vsphere_volume: Annotated[
        Optional[VsphereVirtualDiskVolumeSource],
        Field(
            alias="vsphereVolume",
            description=("vsphereVolume represents a vSphere volume attached and mounted on kubelets host machine"),
        ),
    ] = None
