# generated by datamodel-codegen:
#   filename:  argo-workflows-3.6.2.json

from __future__ import annotations

from typing import Annotated, Dict, List, Optional

from hera.shared._pydantic import BaseModel, Field

from ...k8s.api.core import v1 as v1_1
from ...k8s.apimachinery.pkg.apis.meta import v1


class AMQPConsumeConfig(BaseModel):
    auto_ack: Annotated[
        Optional[bool],
        Field(
            alias="autoAck",
            title=(
                "AutoAck when true, the server will acknowledge deliveries to this"
                " consumer prior to writing\nthe delivery to the network\n+optional"
            ),
        ),
    ] = None
    consumer_tag: Annotated[
        Optional[str],
        Field(
            alias="consumerTag",
            title=("ConsumerTag is the identity of the consumer included in every delivery\n+optional"),
        ),
    ] = None
    exclusive: Annotated[
        Optional[bool],
        Field(
            title=(
                "Exclusive when true, the server will ensure that this is the sole consumer from this queue\n+optional"
            )
        ),
    ] = None
    no_local: Annotated[
        Optional[bool],
        Field(
            alias="noLocal",
            title="NoLocal flag is not supported by RabbitMQ\n+optional",
        ),
    ] = None
    no_wait: Annotated[
        Optional[bool],
        Field(
            alias="noWait",
            title=(
                "NowWait when true, do not wait for the server to confirm the request"
                " and immediately begin deliveries\n+optional"
            ),
        ),
    ] = None


class AMQPExchangeDeclareConfig(BaseModel):
    auto_delete: Annotated[
        Optional[bool],
        Field(
            alias="autoDelete",
            title=("AutoDelete removes the exchange when no bindings are active\n+optional"),
        ),
    ] = None
    durable: Annotated[
        Optional[bool],
        Field(title="Durable keeps the exchange also after the server restarts\n+optional"),
    ] = None
    internal: Annotated[
        Optional[bool],
        Field(title="Internal when true does not accept publishings\n+optional"),
    ] = None
    no_wait: Annotated[
        Optional[bool],
        Field(
            alias="noWait",
            title=("NowWait when true does not wait for a confirmation from the server\n+optional"),
        ),
    ] = None


class EventSourceFilter(BaseModel):
    expression: Optional[str] = None


class AMQPQueueBindConfig(BaseModel):
    no_wait: Annotated[
        Optional[bool],
        Field(
            alias="noWait",
            title=(
                "NowWait false and the queue could not be bound, the channel will be closed with an error\n+optional"
            ),
        ),
    ] = None


class AMQPQueueDeclareConfig(BaseModel):
    arguments: Annotated[
        Optional[str],
        Field(
            title=(
                'Arguments of a queue (also known as "x-arguments") used for optional features and plugins\n+optional'
            )
        ),
    ] = None
    auto_delete: Annotated[
        Optional[bool],
        Field(
            alias="autoDelete",
            title=("AutoDelete removes the queue when no consumers are active\n+optional"),
        ),
    ] = None
    durable: Annotated[
        Optional[bool],
        Field(title="Durable keeps the queue also after the server restarts\n+optional"),
    ] = None
    exclusive: Annotated[
        Optional[bool],
        Field(
            title=(
                "Exclusive sets the queues to be accessible only by the connection that"
                " declares them and will be\ndeleted wgen the connection"
                " closes\n+optional"
            )
        ),
    ] = None
    name: Annotated[
        Optional[str],
        Field(title=("Name of the queue. If empty the server auto-generates a unique name for this queue\n+optional")),
    ] = None
    no_wait: Annotated[
        Optional[bool],
        Field(
            alias="noWait",
            title=("NowWait when true, the queue assumes to be declared on the server\n+optional"),
        ),
    ] = None


class Amount(BaseModel):
    value: Optional[str] = None


class FileArtifact(BaseModel):
    path: Optional[str] = None


class Resource(BaseModel):
    value: Optional[str] = None


class URLArtifact(BaseModel):
    path: Annotated[Optional[str], Field(title="Path is the complete URL")] = None
    verify_cert: Annotated[
        Optional[bool],
        Field(
            alias="verifyCert",
            title="VerifyCert decides whether the connection is secure or not",
        ),
    ] = None


class Int64OrString(BaseModel):
    int64_val: Annotated[Optional[str], Field(alias="int64Val")] = None
    str_val: Annotated[Optional[str], Field(alias="strVal")] = None
    type: Optional[str] = None


class BitbucketRepository(BaseModel):
    owner: Annotated[Optional[str], Field(title="Owner is the owner of the repository")] = None
    repository_slug: Annotated[
        Optional[str],
        Field(
            alias="repositorySlug",
            title=(
                "RepositorySlug is a URL-friendly version of a repository name,"
                " automatically generated by Bitbucket for use in the URL"
            ),
        ),
    ] = None


class BitbucketServerRepository(BaseModel):
    project_key: Annotated[
        Optional[str],
        Field(
            alias="projectKey",
            title=("ProjectKey is the key of project for which integration needs to set up"),
        ),
    ] = None
    repository_slug: Annotated[
        Optional[str],
        Field(
            alias="repositorySlug",
            title=("RepositorySlug is the slug of the repository for which integration needs to set up"),
        ),
    ] = None


class CatchupConfiguration(BaseModel):
    enabled: Annotated[
        Optional[bool],
        Field(title=("Enabled enables to triggered the missed schedule when eventsource restarts")),
    ] = None
    max_duration: Annotated[
        Optional[str],
        Field(alias="maxDuration", title="MaxDuration holds max catchup duration"),
    ] = None


class ConditionsResetByTime(BaseModel):
    cron: Annotated[
        Optional[str],
        Field(title=("Cron is a cron-like expression. For reference, see: https://en.wikipedia.org/wiki/Cron")),
    ] = None
    timezone: Annotated[Optional[str], Field(title="+optional")] = None


class ConfigMapPersistence(BaseModel):
    create_if_not_exist: Annotated[
        Optional[bool],
        Field(
            alias="createIfNotExist",
            title="CreateIfNotExist will create configmap if it doesn't exists",
        ),
    ] = None
    name: Annotated[Optional[str], Field(title="Name of the configmap")] = None


class DataFilter(BaseModel):
    comparator: Annotated[
        Optional[str],
        Field(
            description=(
                "Comparator compares the event data with a user given value.\nCan be"
                ' ">=", ">", "=", "!=", "<", or "<=".\nIs optional, and if left blank'
                ' treated as equality "=".'
            )
        ),
    ] = None
    path: Annotated[
        Optional[str],
        Field(
            description=(
                "Path is the JSONPath of the event's (JSON decoded) data key\nPath is a"
                " series of keys separated by a dot. A key may contain wildcard"
                " characters '*' and '?'.\nTo access an array value use the index as"
                " the key. The dot and wildcard characters can be escaped with"
                " '\\\\'.\nSee https://github.com/tidwall/gjson#path-syntax for more"
                " information on how to use this."
            )
        ),
    ] = None
    template: Annotated[
        Optional[str],
        Field(
            title=(
                "Template is a go-template for extracting a string from the event's"
                " data.\nA Template is evaluated with provided path, type and"
                " value.\nThe templating follows the standard go-template syntax as"
                " well as sprig's extra functions.\nSee"
                " https://pkg.go.dev/text/template and"
                " https://masterminds.github.io/sprig/"
            )
        ),
    ] = None
    type: Annotated[Optional[str], Field(title="Type contains the JSON type of the data")] = None
    value: Annotated[
        Optional[List[str]],
        Field(
            title=(
                "Value is the allowed string values for this key\nBooleans are passed"
                " using strconv.ParseBool()\nNumbers are parsed using as float64 using"
                " strconv.ParseFloat()\nStrings are taken as is\nNils this value is"
                " ignored"
            )
        ),
    ] = None


class EventDependencyTransformer(BaseModel):
    jq: Annotated[
        Optional[str],
        Field(title="JQ holds the jq command applied for transformation\n+optional"),
    ] = None
    script: Annotated[
        Optional[str],
        Field(title="Script refers to a Lua script used to transform the event\n+optional"),
    ] = None


class TimeFilter(BaseModel):
    start: Annotated[
        Optional[str],
        Field(
            description=(
                "Start is the beginning of a time window in UTC.\nBefore this time,"
                " events for this dependency are ignored.\nFormat is hh:mm:ss."
            )
        ),
    ] = None
    stop: Annotated[
        Optional[str],
        Field(
            description=(
                "Stop is the end of a time window in UTC.\nAfter or equal to this time,"
                " events for this dependency are ignored and\nFormat is hh:mm:ss.\nIf"
                " it is smaller than Start, it is treated as next day of Start\n(e.g.:"
                " 22:00:00-01:00:00 means 22:00:00-25:00:00)."
            )
        ),
    ] = None


class WatchPathConfig(BaseModel):
    directory: Annotated[Optional[str], Field(title="Directory to watch for events")] = None
    path: Annotated[
        Optional[str],
        Field(title=("Path is relative path of object to watch with respect to the directory")),
    ] = None
    path_regexp: Annotated[
        Optional[str],
        Field(
            alias="pathRegexp",
            title=("PathRegexp is regexp of relative path of object to watch with respect to the directory"),
        ),
    ] = None


class GitRemoteConfig(BaseModel):
    name: Annotated[Optional[str], Field(description="Name of the remote to fetch from.")] = None
    urls: Annotated[
        Optional[List[str]],
        Field(
            description=(
                "URLs the URLs of a remote repository. It must be non-empty. Fetch"
                " will\nalways use the first URL, while push will use all of them."
            )
        ),
    ] = None


class KafkaConsumerGroup(BaseModel):
    group_name: Annotated[
        Optional[str],
        Field(alias="groupName", title="The name for the consumer group to use"),
    ] = None
    oldest: Annotated[
        Optional[bool],
        Field(
            title=(
                "When starting up a new group do we want to start from the oldest event"
                " (true) or the newest event (false), defaults to false\n+optional"
            )
        ),
    ] = None
    rebalance_strategy: Annotated[
        Optional[str],
        Field(
            alias="rebalanceStrategy",
            title=("Rebalance strategy can be one of: sticky, roundrobin, range. Range is the default.\n+optional"),
        ),
    ] = None


class LogTrigger(BaseModel):
    interval_seconds: Annotated[
        Optional[str],
        Field(
            alias="intervalSeconds",
            title=(
                "Only print messages every interval. Useful to prevent logging too much"
                " data for busy events.\n+optional"
            ),
        ),
    ] = None


class Metadata(BaseModel):
    annotations: Optional[Dict[str, str]] = None
    labels: Optional[Dict[str, str]] = None


class OwnedRepositories(BaseModel):
    names: Annotated[Optional[List[str]], Field(title="Repository names")] = None
    owner: Annotated[Optional[str], Field(title="Organization or user name")] = None


class PayloadField(BaseModel):
    name: Annotated[
        Optional[str],
        Field(description="Name acts as key that holds the value at the path."),
    ] = None
    path: Annotated[
        Optional[str],
        Field(
            description=(
                "Path is the JSONPath of the event's (JSON decoded) data key\nPath is a"
                " series of keys separated by a dot. A key may contain wildcard"
                " characters '*' and '?'.\nTo access an array value use the index as"
                " the key. The dot and wildcard characters can be escaped with"
                " '\\\\'.\nSee https://github.com/tidwall/gjson#path-syntax for more"
                " information on how to use this."
            )
        ),
    ] = None


class RateLimit(BaseModel):
    requests_per_unit: Annotated[Optional[int], Field(alias="requestsPerUnit")] = None
    unit: Annotated[Optional[str], Field(title="Defaults to Second")] = None


class S3Bucket(BaseModel):
    key: Optional[str] = None
    name: Optional[str] = None


class S3Filter(BaseModel):
    prefix: Optional[str] = None
    suffix: Optional[str] = None


class Selector(BaseModel):
    key: Annotated[Optional[str], Field(title="Key name")] = None
    operation: Annotated[
        Optional[str],
        Field(
            title=(
                "Supported operations like ==, != etc.\nDefaults to ==.\nRefer"
                " https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors"
                " for more io.argoproj.workflow.v1alpha1.\n+optional"
            )
        ),
    ] = None
    value: Annotated[Optional[str], Field(title="Value")] = None


class SlackSender(BaseModel):
    icon: Annotated[
        Optional[str],
        Field(
            title=(
                "Icon is the Slack application's icon, e.g. :robot_face: or https://example.com/image.png\n+optional"
            )
        ),
    ] = None
    username: Annotated[
        Optional[str],
        Field(title="Username is the Slack application's username\n+optional"),
    ] = None


class SlackThread(BaseModel):
    broadcast_message_to_channel: Annotated[
        Optional[bool],
        Field(
            alias="broadcastMessageToChannel",
            title=(
                "BroadcastMessageToChannel allows to also broadcast the message from"
                " the thread to the channel\n+optional"
            ),
        ),
    ] = None
    message_aggregation_key: Annotated[
        Optional[str],
        Field(
            alias="messageAggregationKey",
            title=("MessageAggregationKey allows to aggregate the messages to a thread by some key.\n+optional"),
        ),
    ] = None


class StatusPolicy(BaseModel):
    allow: Optional[List[int]] = None


class StorageGridFilter(BaseModel):
    prefix: Optional[str] = None
    suffix: Optional[str] = None


class TriggerParameterSource(BaseModel):
    context_key: Annotated[
        Optional[str],
        Field(
            alias="contextKey",
            description=(
                "ContextKey is the JSONPath of the event's (JSON decoded) context"
                " key\nContextKey is a series of keys separated by a dot. A key may"
                " contain wildcard characters '*' and '?'.\nTo access an array value"
                " use the index as the key. The dot and wildcard characters can be"
                " escaped with '\\\\'.\nSee"
                " https://github.com/tidwall/gjson#path-syntax for more information on"
                " how to use this."
            ),
        ),
    ] = None
    context_template: Annotated[
        Optional[str],
        Field(
            alias="contextTemplate",
            title=(
                "ContextTemplate is a go-template for extracting a string from the"
                " event's context.\nIf a ContextTemplate is provided with a ContextKey,"
                " the template will be evaluated first and fallback to the"
                " ContextKey.\nThe templating follows the standard go-template syntax"
                " as well as sprig's extra functions.\nSee"
                " https://pkg.go.dev/text/template and"
                " https://masterminds.github.io/sprig/"
            ),
        ),
    ] = None
    data_key: Annotated[
        Optional[str],
        Field(
            alias="dataKey",
            description=(
                "DataKey is the JSONPath of the event's (JSON decoded) data"
                " key\nDataKey is a series of keys separated by a dot. A key may"
                " contain wildcard characters '*' and '?'.\nTo access an array value"
                " use the index as the key. The dot and wildcard characters can be"
                " escaped with '\\\\'.\nSee"
                " https://github.com/tidwall/gjson#path-syntax for more information on"
                " how to use this."
            ),
        ),
    ] = None
    data_template: Annotated[
        Optional[str],
        Field(
            alias="dataTemplate",
            title=(
                "DataTemplate is a go-template for extracting a string from the event's"
                " data.\nIf a DataTemplate is provided with a DataKey, the template"
                " will be evaluated first and fallback to the DataKey.\nThe templating"
                " follows the standard go-template syntax as well as sprig's extra"
                " functions.\nSee https://pkg.go.dev/text/template and"
                " https://masterminds.github.io/sprig/"
            ),
        ),
    ] = None
    dependency_name: Annotated[
        Optional[str],
        Field(
            alias="dependencyName",
            description=(
                "DependencyName refers to the name of the dependency. The event which"
                " is stored for this dependency is used as payload\nfor the"
                " parameterization. Make sure to refer to one of the dependencies you"
                " have defined under Dependencies list."
            ),
        ),
    ] = None
    use_raw_data: Annotated[
        Optional[bool],
        Field(
            alias="useRawData",
            title=(
                "UseRawData indicates if the value in an event at data key should be"
                " used without converting to string.\nWhen true, a number, boolean,"
                " json or string parameter may be extracted. When the field is"
                " unspecified, or explicitly\nfalse, the behavior is to turn the"
                " extracted field into a string. (e.g. when set to true, the"
                " parameter\n123 will resolve to the numerical type, but when false, or"
                ' not provided, the string "123" will be resolved)\n+optional'
            ),
        ),
    ] = None
    value: Annotated[
        Optional[str],
        Field(
            description=(
                "Value is the default literal value to use for this parameter"
                " source\nThis is only used if the DataKey is invalid.\nIf the DataKey"
                " is invalid and this is not defined, this param source will produce an"
                " error."
            )
        ),
    ] = None


class Condition(BaseModel):
    last_transition_time: Annotated[
        Optional[v1.Time],
        Field(
            alias="lastTransitionTime",
            title=("Last time the condition transitioned from one status to another.\n+optional"),
        ),
    ] = None
    message: Annotated[
        Optional[str],
        Field(title=("Human-readable message indicating details about last transition.\n+optional")),
    ] = None
    reason: Annotated[
        Optional[str],
        Field(
            title=(
                "Unique, this should be a short, machine understandable string that"
                " gives the reason\nfor condition's last transition. For example,"
                ' "ImageNotFound"\n+optional'
            )
        ),
    ] = None
    status: Annotated[
        Optional[str],
        Field(title="Condition status, True, False or Unknown.\n+required"),
    ] = None
    type: Annotated[Optional[str], Field(title="Condition type.\n+required")] = None


class EventContext(BaseModel):
    datacontenttype: Annotated[
        Optional[str],
        Field(description=("DataContentType - A MIME (RFC2046) string describing the media type of `data`.")),
    ] = None
    id: Annotated[
        Optional[str],
        Field(description=("ID of the event; must be non-empty and unique within the scope of the producer.")),
    ] = None
    source: Annotated[
        Optional[str],
        Field(description="Source - A URI describing the event producer."),
    ] = None
    specversion: Annotated[
        Optional[str],
        Field(
            description=(
                "SpecVersion - The version of the CloudEvents specification used by the io.argoproj.workflow.v1alpha1."
            )
        ),
    ] = None
    subject: Annotated[
        Optional[str],
        Field(title=("Subject - The subject of the event in the context of the event producer")),
    ] = None
    time: Annotated[
        Optional[v1.Time],
        Field(description="Time - A Timestamp when the event happened."),
    ] = None
    type: Annotated[
        Optional[str],
        Field(description="Type - The type of the occurrence which has happened."),
    ] = None


class ResourceFilter(BaseModel):
    after_start: Annotated[
        Optional[bool],
        Field(
            alias="afterStart",
            title=("If the resource is created after the start time then the event is treated as valid.\n+optional"),
        ),
    ] = None
    created_by: Annotated[
        Optional[v1.Time],
        Field(
            alias="createdBy",
            title=("If resource is created before the specified time then the event is treated as valid.\n+optional"),
        ),
    ] = None
    fields: Annotated[
        Optional[List[Selector]],
        Field(
            title=(
                "Fields provide field filters similar to K8s field selector\n(see"
                " https://kubernetes.io/docs/concepts/overview/working-with-objects/field-selectors/).\nUnlike"
                " K8s field selector, it supports arbitrary fileds like"
                ' "spec.serviceAccountName",\nand the value could be a string or a'
                ' regex.\nSame as K8s field selector, operator "=", "==" and "!=" are'
                " supported.\n+optional"
            )
        ),
    ] = None
    labels: Annotated[
        Optional[List[Selector]],
        Field(
            title=(
                "Labels provide listing options to K8s API to watch resource/s.\nRefer"
                " https://kubernetes.io/docs/concepts/overview/working-with-objects/label-selectors/"
                " for more io.argoproj.workflow.v1alpha1.\nUnlike K8s field selector,"
                " multiple values are passed as comma separated values instead of list"
                " of values.\nEg: value: value1,value2.\nSame as K8s label selector,"
                ' operator "=", "==", "!=", "exists", "!", "notin", "in", "gt" and'
                ' "lt"\nare supported\n+optional'
            )
        ),
    ] = None
    prefix: Annotated[
        Optional[str],
        Field(title="Prefix filter is applied on the resource name.\n+optional"),
    ] = None


class AzureEventsHubEventSource(BaseModel):
    filter: Annotated[Optional[EventSourceFilter], Field(title="Filter\n+optional")] = None
    fqdn: Annotated[
        Optional[str],
        Field(
            title=(
                "FQDN of the EventHubs namespace you created\nMore info at"
                " https://docs.microsoft.com/en-us/azure/event-hubs/event-hubs-get-connection-string"
            )
        ),
    ] = None
    hub_name: Annotated[Optional[str], Field(alias="hubName", title="Event Hub path/name")] = None
    metadata: Annotated[
        Optional[Dict[str, str]],
        Field(
            title=("Metadata holds the user defined metadata which will passed along the event payload.\n+optional")
        ),
    ] = None
    shared_access_key: Annotated[
        Optional[v1_1.SecretKeySelector],
        Field(
            alias="sharedAccessKey",
            title="SharedAccessKey is the generated value of the key",
        ),
    ] = None
    shared_access_key_name: Annotated[
        Optional[v1_1.SecretKeySelector],
        Field(
            alias="sharedAccessKeyName",
            title=("SharedAccessKeyName is the name you chose for your application's SAS keys"),
        ),
    ] = None


class AzureQueueStorageEventSource(BaseModel):
    connection_string: Annotated[
        Optional[v1_1.SecretKeySelector],
        Field(
            alias="connectionString",
            title=(
                "ConnectionString is the connection string to access Azure Queue"
                " Storage. If this fields is not provided\nit will try to access via"
                " Azure AD with StorageAccountName.\n+optional"
            ),
        ),
    ] = None
    decode_message: Annotated[
        Optional[bool],
        Field(
            alias="decodeMessage",
            title=(
                "DecodeMessage specifies if all the messages should be base64"
                " decoded.\nIf set to true the decoding is done before the evaluation"
                " of JSONBody\n+optional"
            ),
        ),
    ] = None
    dlq: Annotated[
        Optional[bool],
        Field(
            title=(
                "DLQ specifies if a dead-letter queue is configured for messages that"
                " can't be processed successfully.\nIf set to true, messages with"
                " invalid payload won't be acknowledged to allow to forward them"
                " farther to the dead-letter queue.\nThe default value is"
                " false.\n+optional"
            )
        ),
    ] = None
    filter: Annotated[Optional[EventSourceFilter], Field(title="Filter\n+optional")] = None
    json_body: Annotated[
        Optional[bool],
        Field(
            alias="jsonBody",
            title=("JSONBody specifies that all event body payload coming from this\nsource will be JSON\n+optional"),
        ),
    ] = None
    metadata: Annotated[
        Optional[Dict[str, str]],
        Field(
            title=("Metadata holds the user defined metadata which will passed along the event payload.\n+optional")
        ),
    ] = None
    queue_name: Annotated[
        Optional[str],
        Field(alias="queueName", title="QueueName is the name of the queue"),
    ] = None
    storage_account_name: Annotated[
        Optional[str],
        Field(
            alias="storageAccountName",
            title=(
                "StorageAccountName is the name of the storage account where the queue"
                " is. This field is necessary to\naccess via Azure AD (managed"
                " identity) and it is ignored if ConnectionString is set.\n+optional"
            ),
        ),
    ] = None
    wait_time_in_seconds: Annotated[
        Optional[int],
        Field(
            alias="waitTimeInSeconds",
            title=(
                "WaitTimeInSeconds is the duration (in seconds) for which the event"
                " source waits between empty results from the queue.\nThe default value"
                " is 3 seconds.\n+optional"
            ),
        ),
    ] = None


class BasicAuth(BaseModel):
    password: Annotated[
        Optional[v1_1.SecretKeySelector],
        Field(
            description=("Password refers to the Kubernetes secret that holds the password required for basic auth.")
        ),
    ] = None
    username: Annotated[
        Optional[v1_1.SecretKeySelector],
        Field(
            description=("Username refers to the Kubernetes secret that holds the username required for basic auth.")
        ),
    ] = None


class BitbucketBasicAuth(BaseModel):
    password: Annotated[
        Optional[v1_1.SecretKeySelector],
        Field(description="Password refers to the K8s secret that holds the password."),
    ] = None
    username: Annotated[
        Optional[v1_1.SecretKeySelector],
        Field(description="Username refers to the K8s secret that holds the username."),
    ] = None


class GenericEventSource(BaseModel):
    auth_secret: Annotated[
        Optional[v1_1.SecretKeySelector],
        Field(
            alias="authSecret",
            title=("AuthSecret holds a secret selector that contains a bearer token for authentication\n+optional"),
        ),
    ] = None
    config: Annotated[Optional[str], Field(title="Config is the event source configuration")] = None
    filter: Annotated[Optional[EventSourceFilter], Field(title="Filter\n+optional")] = None
    insecure: Annotated[Optional[bool], Field(description="Insecure determines the type of connection.")] = None
    json_body: Annotated[
        Optional[bool],
        Field(
            alias="jsonBody",
            title=("JSONBody specifies that all event body payload coming from this\nsource will be JSON\n+optional"),
        ),
    ] = None
    metadata: Annotated[
        Optional[Dict[str, str]],
        Field(
            title=("Metadata holds the user defined metadata which will passed along the event payload.\n+optional")
        ),
    ] = None
    url: Annotated[
        Optional[str],
        Field(description="URL of the gRPC server that implements the event source."),
    ] = None


class GitCreds(BaseModel):
    password: Optional[v1_1.SecretKeySelector] = None
    username: Optional[v1_1.SecretKeySelector] = None


class GithubAppCreds(BaseModel):
    app_id: Annotated[
        Optional[str],
        Field(
            alias="appID",
            title="AppID refers to the GitHub App ID for the application you created",
        ),
    ] = None
    installation_id: Annotated[
        Optional[str],
        Field(
            alias="installationID",
            title=("InstallationID refers to the Installation ID of the GitHub app you created and installed"),
        ),
    ] = None
    private_key: Annotated[
        Optional[v1_1.SecretKeySelector],
        Field(
            alias="privateKey",
            title=("PrivateKey refers to a K8s secret containing the GitHub app private key"),
        ),
    ] = None


class PubSubEventSource(BaseModel):
    credential_secret: Annotated[
        Optional[v1_1.SecretKeySelector],
        Field(
            alias="credentialSecret",
            title=(
                "CredentialSecret references to the secret that contains JSON"
                " credentials to access GCP.\nIf it is missing, it implicitly uses"
                " Workload Identity to"
                " access.\nhttps://cloud.google.com/kubernetes-engine/docs/how-to/workload-identity\n+optional"
            ),
        ),
    ] = None
    delete_subscription_on_finish: Annotated[
        Optional[bool],
        Field(
            alias="deleteSubscriptionOnFinish",
            title=(
                "DeleteSubscriptionOnFinish determines whether to delete the GCP PubSub"
                " subscription once the event source is stopped.\n+optional"
            ),
        ),
    ] = None
    filter: Annotated[Optional[EventSourceFilter], Field(title="Filter\n+optional")] = None
    json_body: Annotated[
        Optional[bool],
        Field(
            alias="jsonBody",
            title=("JSONBody specifies that all event body payload coming from this\nsource will be JSON\n+optional"),
        ),
    ] = None
    metadata: Annotated[
        Optional[Dict[str, str]],
        Field(
            title=("Metadata holds the user defined metadata which will passed along the event payload.\n+optional")
        ),
    ] = None
    project_id: Annotated[
        Optional[str],
        Field(
            alias="projectID",
            title=(
                "ProjectID is GCP project ID for the subscription.\nRequired if you run"
                " Argo Events outside of GKE/GCE.\n(otherwise, the default value is its"
                " project)\n+optional"
            ),
        ),
    ] = None
    subscription_id: Annotated[
        Optional[str],
        Field(
            alias="subscriptionID",
            title=(
                "SubscriptionID is ID of subscription.\nRequired if you use existing"
                " subscription.\nThe default value will be auto generated hash based on"
                " this eventsource setting, so the subscription\nmight be recreated"
                " every time you update the setting, which has a possibility of event"
                " loss.\n+optional"
            ),
        ),
    ] = None
    topic: Annotated[
        Optional[str],
        Field(
            title=(
                "Topic to which the subscription should belongs.\nRequired if you want"
                " the eventsource to create a new subscription.\nIf you specify this"
                " field along with an existing subscription,\nit will be verified"
                " whether it actually belongs to the specified topic.\n+optional"
            )
        ),
    ] = None
    topic_project_id: Annotated[
        Optional[str],
        Field(
            alias="topicProjectID",
            title=("TopicProjectID is GCP project ID for the topic.\nBy default, it is same as ProjectID.\n+optional"),
        ),
    ] = None


class SASLConfig(BaseModel):
    mechanism: Annotated[
        Optional[str],
        Field(
            title=(
                "SASLMechanism is the name of the enabled SASL mechanism.\nPossible"
                " values: OAUTHBEARER, PLAIN (defaults to PLAIN).\n+optional"
            )
        ),
    ] = None
    password_secret: Annotated[
        Optional[v1_1.SecretKeySelector],
        Field(alias="passwordSecret", title="Password for SASL/PLAIN authentication"),
    ] = None
    user_secret: Annotated[
        Optional[v1_1.SecretKeySelector],
        Field(
            alias="userSecret",
            title=(
                "User is the authentication identity (authcid) to present for\nSASL/PLAIN or SASL/SCRAM authentication"
            ),
        ),
    ] = None


class SQSEventSource(BaseModel):
    access_key: Annotated[
        Optional[v1_1.SecretKeySelector],
        Field(
            alias="accessKey",
            title="AccessKey refers K8s secret containing aws access key",
        ),
    ] = None
    dlq: Annotated[
        Optional[bool],
        Field(
            title=(
                "DLQ specifies if a dead-letter queue is configured for messages that"
                " can't be processed successfully.\nIf set to true, messages with"
                " invalid payload won't be acknowledged to allow to forward them"
                " farther to the dead-letter queue.\nThe default value is"
                " false.\n+optional"
            )
        ),
    ] = None
    endpoint: Annotated[
        Optional[str],
        Field(
            title=("Endpoint configures connection to a specific SQS endpoint instead of Amazons servers\n+optional")
        ),
    ] = None
    filter: Annotated[Optional[EventSourceFilter], Field(title="Filter\n+optional")] = None
    json_body: Annotated[
        Optional[bool],
        Field(
            alias="jsonBody",
            title=("JSONBody specifies that all event body payload coming from this\nsource will be JSON\n+optional"),
        ),
    ] = None
    metadata: Annotated[
        Optional[Dict[str, str]],
        Field(
            title=("Metadata holds the user defined metadata which will passed along the event payload.\n+optional")
        ),
    ] = None
    queue: Annotated[Optional[str], Field(title="Queue is AWS SQS queue to listen to for messages")] = None
    queue_account_id: Annotated[
        Optional[str],
        Field(
            alias="queueAccountId",
            title=("QueueAccountID is the ID of the account that created the queue to monitor\n+optional"),
        ),
    ] = None
    region: Annotated[Optional[str], Field(title="Region is AWS region")] = None
    role_arn: Annotated[
        Optional[str],
        Field(
            alias="roleARN",
            title=("RoleARN is the Amazon Resource Name (ARN) of the role to assume.\n+optional"),
        ),
    ] = None
    secret_key: Annotated[
        Optional[v1_1.SecretKeySelector],
        Field(
            alias="secretKey",
            title="SecretKey refers K8s secret containing aws secret key",
        ),
    ] = None
    session_token: Annotated[
        Optional[v1_1.SecretKeySelector],
        Field(
            alias="sessionToken",
            title=(
                "SessionToken refers to K8s secret containing AWS temporary credentials(STS) session token\n+optional"
            ),
        ),
    ] = None
    wait_time_seconds: Annotated[
        Optional[str],
        Field(
            alias="waitTimeSeconds",
            description=(
                "WaitTimeSeconds is The duration (in seconds) for which the call waits"
                " for a message to arrive\nin the queue before returning."
            ),
        ),
    ] = None


class TLSConfig(BaseModel):
    ca_cert_secret: Annotated[
        Optional[v1_1.SecretKeySelector],
        Field(
            alias="caCertSecret",
            title="CACertSecret refers to the secret that contains the CA cert",
        ),
    ] = None
    client_cert_secret: Annotated[
        Optional[v1_1.SecretKeySelector],
        Field(
            alias="clientCertSecret",
            title="ClientCertSecret refers to the secret that contains the client cert",
        ),
    ] = None
    client_key_secret: Annotated[
        Optional[v1_1.SecretKeySelector],
        Field(
            alias="clientKeySecret",
            title="ClientKeySecret refers to the secret that contains the client key",
        ),
    ] = None
    insecure_skip_verify: Annotated[
        Optional[bool],
        Field(
            alias="insecureSkipVerify",
            title=(
                "If true, skips creation of TLSConfig with certs and creates an empty"
                " TLSConfig. (Defaults to false)\n+optional"
            ),
        ),
    ] = None


class WebhookContext(BaseModel):
    auth_secret: Annotated[
        Optional[v1_1.SecretKeySelector],
        Field(
            alias="authSecret",
            title=("AuthSecret holds a secret selector that contains a bearer token for authentication\n+optional"),
        ),
    ] = None
    endpoint: Annotated[Optional[str], Field(title="REST API endpoint")] = None
    max_payload_size: Annotated[
        Optional[str],
        Field(
            alias="maxPayloadSize",
            title=(
                "MaxPayloadSize is the maximum webhook payload size that the server"
                " will accept.\nRequests exceeding that limit will be rejected with"
                ' "request too large" response.\nDefault value: 1048576'
                " (1MB).\n+optional"
            ),
        ),
    ] = None
    metadata: Annotated[
        Optional[Dict[str, str]],
        Field(
            title=("Metadata holds the user defined metadata which will passed along the event payload.\n+optional")
        ),
    ] = None
    method: Annotated[
        Optional[str],
        Field(
            title=(
                "Method is HTTP request method that indicates the desired action to be"
                " performed for a given resource.\nSee RFC7231 Hypertext Transfer"
                " Protocol (HTTP/1.1): Semantics and Content"
            )
        ),
    ] = None
    port: Annotated[
        Optional[str],
        Field(description="Port on which HTTP server is listening for incoming events."),
    ] = None
    server_cert_secret: Annotated[
        Optional[v1_1.SecretKeySelector],
        Field(
            alias="serverCertSecret",
            description="ServerCertPath refers the file that contains the cert.",
        ),
    ] = None
    server_key_secret: Annotated[
        Optional[v1_1.SecretKeySelector],
        Field(
            alias="serverKeySecret",
            title="ServerKeyPath refers the file that contains private key",
        ),
    ] = None
    url: Annotated[Optional[str], Field(description="URL is the url of the server.")] = None


class ValueFromSource(BaseModel):
    config_map_key_ref: Annotated[Optional[v1_1.ConfigMapKeySelector], Field(alias="configMapKeyRef")] = None
    secret_key_ref: Annotated[Optional[v1_1.SecretKeySelector], Field(alias="secretKeyRef")] = None


class Backoff(BaseModel):
    duration: Annotated[
        Optional[Int64OrString],
        Field(title=('The initial duration in nanoseconds or strings like "1s", "3m"\n+optional')),
    ] = None
    factor: Annotated[
        Optional[Amount],
        Field(title="Duration is multiplied by factor each iteration\n+optional"),
    ] = None
    jitter: Annotated[
        Optional[Amount],
        Field(title="The amount of jitter applied each iteration\n+optional"),
    ] = None
    steps: Annotated[Optional[int], Field(title="Exit with error after this many steps\n+optional")] = None


class ConditionsResetCriteria(BaseModel):
    by_time: Annotated[
        Optional[ConditionsResetByTime],
        Field(
            alias="byTime",
            title=("Schedule is a cron-like expression. For reference, see: https://en.wikipedia.org/wiki/Cron"),
        ),
    ] = None


class EventPersistence(BaseModel):
    catchup: Annotated[
        Optional[CatchupConfiguration],
        Field(title=("Catchup enables to triggered the missed schedule when eventsource restarts")),
    ] = None
    config_map: Annotated[
        Optional[ConfigMapPersistence],
        Field(alias="configMap", title="ConfigMap holds configmap details for persistence"),
    ] = None


class FileEventSource(BaseModel):
    event_type: Annotated[
        Optional[str],
        Field(
            alias="eventType",
            title=(
                "Type of file operations to watch\nRefer"
                " https://github.com/fsnotify/fsnotify/blob/master/fsnotify.go for more"
                " information"
            ),
        ),
    ] = None
    filter: Annotated[Optional[EventSourceFilter], Field(title="Filter\n+optional")] = None
    metadata: Annotated[
        Optional[Dict[str, str]],
        Field(
            title=("Metadata holds the user defined metadata which will passed along the event payload.\n+optional")
        ),
    ] = None
    polling: Annotated[Optional[bool], Field(title="Use polling instead of inotify")] = None
    watch_path_config: Annotated[
        Optional[WatchPathConfig],
        Field(
            alias="watchPathConfig",
            title="WatchPathConfig contains configuration about the file path to watch",
        ),
    ] = None


class HDFSEventSource(BaseModel):
    addresses: Optional[List[str]] = None
    check_interval: Annotated[
        Optional[str],
        Field(
            alias="checkInterval",
            title=(
                "CheckInterval is a string that describes an interval duration to check"
                " the directory state, e.g. 1s, 30m, 2h... (defaults to 1m)"
            ),
        ),
    ] = None
    filter: Annotated[Optional[EventSourceFilter], Field(title="Filter\n+optional")] = None
    hdfs_user: Annotated[
        Optional[str],
        Field(
            alias="hdfsUser",
            description=(
                "HDFSUser is the user to access HDFS file system.\nIt is ignored if either ccache or keytab is used."
            ),
        ),
    ] = None
    krb_c_cache_secret: Annotated[
        Optional[v1_1.SecretKeySelector],
        Field(
            alias="krbCCacheSecret",
            description=(
                "KrbCCacheSecret is the secret selector for Kerberos ccache\nEither"
                " ccache or keytab can be set to use Kerberos."
            ),
        ),
    ] = None
    krb_config_config_map: Annotated[
        Optional[v1_1.ConfigMapKeySelector],
        Field(
            alias="krbConfigConfigMap",
            description=(
                "KrbConfig is the configmap selector for Kerberos config as string\nIt"
                " must be set if either ccache or keytab is used."
            ),
        ),
    ] = None
    krb_keytab_secret: Annotated[
        Optional[v1_1.SecretKeySelector],
        Field(
            alias="krbKeytabSecret",
            description=(
                "KrbKeytabSecret is the secret selector for Kerberos keytab\nEither"
                " ccache or keytab can be set to use Kerberos."
            ),
        ),
    ] = None
    krb_realm: Annotated[
        Optional[str],
        Field(
            alias="krbRealm",
            description=(
                "KrbRealm is the Kerberos realm used with Kerberos keytab\nIt must be set if keytab is used."
            ),
        ),
    ] = None
    krb_service_principal_name: Annotated[
        Optional[str],
        Field(
            alias="krbServicePrincipalName",
            description=(
                "KrbServicePrincipalName is the principal name of Kerberos service\nIt"
                " must be set if either ccache or keytab is used."
            ),
        ),
    ] = None
    krb_username: Annotated[
        Optional[str],
        Field(
            alias="krbUsername",
            description=(
                "KrbUsername is the Kerberos username used with Kerberos keytab\nIt must be set if keytab is used."
            ),
        ),
    ] = None
    metadata: Annotated[
        Optional[Dict[str, str]],
        Field(
            title=("Metadata holds the user defined metadata which will passed along the event payload.\n+optional")
        ),
    ] = None
    type: Annotated[Optional[str], Field(title="Type of file operations to watch")] = None
    watch_path_config: Annotated[Optional[WatchPathConfig], Field(alias="watchPathConfig")] = None


class SFTPEventSource(BaseModel):
    address: Annotated[Optional[v1_1.SecretKeySelector], Field(description="Address sftp address.")] = None
    event_type: Annotated[
        Optional[str],
        Field(
            alias="eventType",
            title=(
                "Type of file operations to watch\nRefer"
                " https://github.com/fsnotify/fsnotify/blob/master/fsnotify.go for more"
                " information"
            ),
        ),
    ] = None
    filter: Annotated[Optional[EventSourceFilter], Field(title="Filter\n+optional")] = None
    metadata: Annotated[
        Optional[Dict[str, str]],
        Field(
            title=("Metadata holds the user defined metadata which will passed along the event payload.\n+optional")
        ),
    ] = None
    password: Annotated[
        Optional[v1_1.SecretKeySelector],
        Field(description="Password required for authentication if any."),
    ] = None
    poll_interval_duration: Annotated[
        Optional[str],
        Field(
            alias="pollIntervalDuration",
            title=(
                "PollIntervalDuration the interval at which to poll the SFTP server\ndefaults to 10 seconds\n+optional"
            ),
        ),
    ] = None
    ssh_key_secret: Annotated[
        Optional[v1_1.SecretKeySelector],
        Field(
            alias="sshKeySecret",
            title="SSHKeySecret refers to the secret that contains SSH key",
        ),
    ] = None
    username: Annotated[
        Optional[v1_1.SecretKeySelector],
        Field(description="Username required for authentication if any."),
    ] = None
    watch_path_config: Annotated[
        Optional[WatchPathConfig],
        Field(
            alias="watchPathConfig",
            title="WatchPathConfig contains configuration about the file path to watch",
        ),
    ] = None


class S3Artifact(BaseModel):
    access_key: Annotated[Optional[v1_1.SecretKeySelector], Field(alias="accessKey")] = None
    bucket: Optional[S3Bucket] = None
    ca_certificate: Annotated[Optional[v1_1.SecretKeySelector], Field(alias="caCertificate")] = None
    endpoint: Optional[str] = None
    events: Optional[List[str]] = None
    filter: Optional[S3Filter] = None
    insecure: Optional[bool] = None
    metadata: Optional[Dict[str, str]] = None
    region: Optional[str] = None
    secret_key: Annotated[Optional[v1_1.SecretKeySelector], Field(alias="secretKey")] = None


class TriggerParameter(BaseModel):
    dest: Annotated[
        Optional[str],
        Field(
            description=(
                "Dest is the JSONPath of a resource key.\nA path is a series of keys"
                " separated by a dot. The colon character can be escaped with '.'\nThe"
                " -1 key can be used to append a value to an existing array.\nSee"
                " https://github.com/tidwall/sjson#path-syntax for more information"
                " about how this is used."
            )
        ),
    ] = None
    operation: Annotated[
        Optional[str],
        Field(
            description=(
                "Operation is what to do with the existing value at Dest, whether"
                " to\n'prepend', 'overwrite', or 'append' it."
            )
        ),
    ] = None
    src: Annotated[
        Optional[TriggerParameterSource],
        Field(title=("Src contains a source reference to the value of the parameter from a dependency")),
    ] = None


class ResourceEventSource(BaseModel):
    event_types: Annotated[
        Optional[List[str]],
        Field(
            alias="eventTypes",
            description=(
                "EventTypes is the list of event type to watch.\nPossible values are - ADD, UPDATE and DELETE."
            ),
        ),
    ] = None
    filter: Annotated[
        Optional[ResourceFilter],
        Field(
            title=(
                "Filter is applied on the metadata of the resource\nIf you apply"
                " filter, then the internal event informer will only monitor objects"
                " that pass the filter.\n+optional"
            )
        ),
    ] = None
    group_version_resource: Annotated[
        Optional[v1.GroupVersionResource],
        Field(alias="groupVersionResource", title="Group of the resource"),
    ] = None
    metadata: Annotated[
        Optional[Dict[str, str]],
        Field(
            title=("Metadata holds the user defined metadata which will passed along the event payload.\n+optional")
        ),
    ] = None
    namespace: Annotated[Optional[str], Field(title="Namespace where resource is deployed")] = None


class NATSAuth(BaseModel):
    basic: Annotated[
        Optional[BasicAuth],
        Field(title="Baisc auth with username and password\n+optional"),
    ] = None
    credential: Annotated[
        Optional[v1_1.SecretKeySelector],
        Field(title="credential used to connect\n+optional"),
    ] = None
    nkey: Annotated[Optional[v1_1.SecretKeySelector], Field(title="NKey used to connect\n+optional")] = None
    token: Annotated[
        Optional[v1_1.SecretKeySelector],
        Field(title="Token used to connect\n+optional"),
    ] = None


class SchemaRegistryConfig(BaseModel):
    auth: Annotated[
        Optional[BasicAuth],
        Field(title="+optional\nSchemaRegistry - basic authentication"),
    ] = None
    schema_id: Annotated[Optional[int], Field(alias="schemaId", title="Schema ID")] = None
    url: Annotated[Optional[str], Field(description="Schema Registry URL.")] = None


class BitbucketAuth(BaseModel):
    basic: Annotated[
        Optional[BitbucketBasicAuth],
        Field(title="Basic is BasicAuth auth strategy.\n+optional"),
    ] = None
    oauth_token: Annotated[
        Optional[v1_1.SecretKeySelector],
        Field(
            alias="oauthToken",
            title=("OAuthToken refers to the K8s secret that holds the OAuth Bearer token.\n+optional"),
        ),
    ] = None


class GitArtifact(BaseModel):
    branch: Annotated[Optional[str], Field(title="Branch to use to pull trigger resource\n+optional")] = None
    clone_directory: Annotated[
        Optional[str],
        Field(
            alias="cloneDirectory",
            description=(
                "Directory to clone the repository. We clone complete directory because"
                " GitArtifact is not limited to any specific Git service"
                " providers.\nHence we don't use any specific git provider client."
            ),
        ),
    ] = None
    creds: Annotated[
        Optional[GitCreds],
        Field(title="Creds contain reference to git username and password\n+optional"),
    ] = None
    file_path: Annotated[
        Optional[str],
        Field(
            alias="filePath",
            title="Path to file that contains trigger resource definition",
        ),
    ] = None
    insecure_ignore_host_key: Annotated[
        Optional[bool],
        Field(alias="insecureIgnoreHostKey", title="Whether to ignore host key\n+optional"),
    ] = None
    ref: Annotated[
        Optional[str],
        Field(title=("Ref to use to pull trigger resource. Will result in a shallow clone and\nfetch.\n+optional")),
    ] = None
    remote: Annotated[
        Optional[GitRemoteConfig],
        Field(
            title=(
                "Remote to manage set of tracked repositories. Defaults to"
                ' "origin".\nRefer https://git-scm.com/docs/git-remote\n+optional'
            )
        ),
    ] = None
    ssh_key_secret: Annotated[
        Optional[v1_1.SecretKeySelector],
        Field(
            alias="sshKeySecret",
            title="SSHKeySecret refers to the secret that contains SSH key",
        ),
    ] = None
    tag: Annotated[Optional[str], Field(title="Tag to use to pull trigger resource\n+optional")] = None
    url: Annotated[Optional[str], Field(title="Git URL")] = None


class AzureServiceBusEventSource(BaseModel):
    connection_string: Annotated[
        Optional[v1_1.SecretKeySelector],
        Field(
            alias="connectionString",
            title=(
                "ConnectionString is the connection string for the Azure Service Bus."
                " If this fields is not provided\nit will try to access via Azure AD"
                " with DefaultAzureCredential and FullyQualifiedNamespace.\n+optional"
            ),
        ),
    ] = None
    filter: Annotated[Optional[EventSourceFilter], Field(title="Filter\n+optional")] = None
    fully_qualified_namespace: Annotated[
        Optional[str],
        Field(
            alias="fullyQualifiedNamespace",
            title=(
                "FullyQualifiedNamespace is the Service Bus namespace name (ex:"
                " myservicebus.servicebus.windows.net). This field is necessary"
                " to\naccess via Azure AD (managed identity) and it is ignored if"
                " ConnectionString is set.\n+optional"
            ),
        ),
    ] = None
    json_body: Annotated[
        Optional[bool],
        Field(
            alias="jsonBody",
            title=("JSONBody specifies that all event body payload coming from this\nsource will be JSON\n+optional"),
        ),
    ] = None
    metadata: Annotated[
        Optional[Dict[str, str]],
        Field(
            title=("Metadata holds the user defined metadata which will passed along the event payload.\n+optional")
        ),
    ] = None
    queue_name: Annotated[
        Optional[str],
        Field(
            alias="queueName",
            title="QueueName is the name of the Azure Service Bus Queue",
        ),
    ] = None
    subscription_name: Annotated[
        Optional[str],
        Field(
            alias="subscriptionName",
            title=("SubscriptionName is the name of the Azure Service Bus Topic Subscription"),
        ),
    ] = None
    tls: Annotated[
        Optional[TLSConfig],
        Field(title="TLS configuration for the service bus client\n+optional"),
    ] = None
    topic_name: Annotated[
        Optional[str],
        Field(
            alias="topicName",
            title="TopicName is the name of the Azure Service Bus Topic",
        ),
    ] = None


class AzureServiceBusTrigger(BaseModel):
    connection_string: Annotated[
        Optional[v1_1.SecretKeySelector],
        Field(
            alias="connectionString",
            title="ConnectionString is the connection string for the Azure Service Bus",
        ),
    ] = None
    parameters: Annotated[
        Optional[List[TriggerParameter]],
        Field(
            title=(
                "Parameters is the list of key-value extracted from event's payload"
                " that are applied to\nthe trigger resource.\n+optional"
            )
        ),
    ] = None
    payload: Annotated[
        Optional[List[TriggerParameter]],
        Field(
            description=(
                "Payload is the list of key-value extracted from an event payload to construct the request payload."
            )
        ),
    ] = None
    queue_name: Annotated[
        Optional[str],
        Field(
            alias="queueName",
            title="QueueName is the name of the Azure Service Bus Queue",
        ),
    ] = None
    subscription_name: Annotated[
        Optional[str],
        Field(
            alias="subscriptionName",
            title=("SubscriptionName is the name of the Azure Service Bus Topic Subscription"),
        ),
    ] = None
    tls: Annotated[
        Optional[TLSConfig],
        Field(title="TLS configuration for the service bus client\n+optional"),
    ] = None
    topic_name: Annotated[
        Optional[str],
        Field(
            alias="topicName",
            title="TopicName is the name of the Azure Service Bus Topic",
        ),
    ] = None


class NATSTrigger(BaseModel):
    parameters: Optional[List[TriggerParameter]] = None
    payload: Optional[List[TriggerParameter]] = None
    subject: Annotated[Optional[str], Field(description="Name of the subject to put message on.")] = None
    tls: Annotated[
        Optional[TLSConfig],
        Field(title="TLS configuration for the NATS producer.\n+optional"),
    ] = None
    url: Annotated[Optional[str], Field(description="URL of the NATS cluster.")] = None


class RedisEventSource(BaseModel):
    channels: Optional[List[str]] = None
    db: Annotated[
        Optional[int],
        Field(title="DB to use. If not specified, default DB 0 will be used.\n+optional"),
    ] = None
    filter: Annotated[Optional[EventSourceFilter], Field(title="Filter\n+optional")] = None
    host_address: Annotated[
        Optional[str],
        Field(
            alias="hostAddress",
            title="HostAddress refers to the address of the Redis host/server",
        ),
    ] = None
    json_body: Annotated[
        Optional[bool],
        Field(
            alias="jsonBody",
            title=("JSONBody specifies that all event body payload coming from this\nsource will be JSON\n+optional"),
        ),
    ] = None
    metadata: Annotated[
        Optional[Dict[str, str]],
        Field(
            title=("Metadata holds the user defined metadata which will passed along the event payload.\n+optional")
        ),
    ] = None
    namespace: Annotated[
        Optional[str],
        Field(
            title=(
                "Namespace to use to retrieve the password from. It should only be"
                " specified if password is declared\n+optional"
            )
        ),
    ] = None
    password: Annotated[
        Optional[v1_1.SecretKeySelector],
        Field(title="Password required for authentication if any.\n+optional"),
    ] = None
    tls: Annotated[
        Optional[TLSConfig],
        Field(title="TLS configuration for the redis client.\n+optional"),
    ] = None
    username: Annotated[
        Optional[str],
        Field(title="Username required for ACL style authentication if any.\n+optional"),
    ] = None


class RedisStreamEventSource(BaseModel):
    consumer_group: Annotated[
        Optional[str],
        Field(
            alias="consumerGroup",
            title=(
                "ConsumerGroup refers to the Redis stream consumer group that will"
                " be\ncreated on all redis streams. Messages are read through this"
                " group. Defaults to 'argo-events-cg'\n+optional"
            ),
        ),
    ] = None
    db: Annotated[
        Optional[int],
        Field(title="DB to use. If not specified, default DB 0 will be used.\n+optional"),
    ] = None
    filter: Annotated[Optional[EventSourceFilter], Field(title="Filter\n+optional")] = None
    host_address: Annotated[
        Optional[str],
        Field(
            alias="hostAddress",
            title=("HostAddress refers to the address of the Redis host/server (master instance)"),
        ),
    ] = None
    max_msg_count_per_read: Annotated[
        Optional[int],
        Field(
            alias="maxMsgCountPerRead",
            title=(
                "MaxMsgCountPerRead holds the maximum number of messages per stream"
                " that will be read in each XREADGROUP of all streams\nExample: if"
                " there are 2 streams and MaxMsgCountPerRead=10, then each XREADGROUP"
                " may read upto a total of 20 messages.\nSame as COUNT option in"
                " XREADGROUP(https://redis.io/topics/streams-intro). Defaults to"
                " 10\n+optional"
            ),
        ),
    ] = None
    metadata: Annotated[
        Optional[Dict[str, str]],
        Field(
            title=("Metadata holds the user defined metadata which will passed along the event payload.\n+optional")
        ),
    ] = None
    password: Annotated[
        Optional[v1_1.SecretKeySelector],
        Field(title="Password required for authentication if any.\n+optional"),
    ] = None
    streams: Annotated[
        Optional[List[str]],
        Field(
            description=(
                "Streams to look for entries. XREADGROUP is used on all streams using a single consumer group."
            )
        ),
    ] = None
    tls: Annotated[
        Optional[TLSConfig],
        Field(title="TLS configuration for the redis client.\n+optional"),
    ] = None
    username: Annotated[
        Optional[str],
        Field(title="Username required for ACL style authentication if any.\n+optional"),
    ] = None


class BitbucketServerEventSource(BaseModel):
    access_token: Annotated[
        Optional[v1_1.SecretKeySelector],
        Field(
            alias="accessToken",
            title=("AccessToken is reference to K8s secret which holds the bitbucket api access information"),
        ),
    ] = None
    bitbucketserver_base_url: Annotated[
        Optional[str],
        Field(
            alias="bitbucketserverBaseURL",
            title=("BitbucketServerBaseURL is the base URL for API requests to a custom endpoint"),
        ),
    ] = None
    delete_hook_on_finish: Annotated[
        Optional[bool],
        Field(
            alias="deleteHookOnFinish",
            title=(
                "DeleteHookOnFinish determines whether to delete the Bitbucket Server"
                " hook for the project once the event source is stopped.\n+optional"
            ),
        ),
    ] = None
    events: Annotated[
        Optional[List[str]],
        Field(
            title=(
                "Events are bitbucket event to listen to.\nRefer"
                " https://confluence.atlassian.com/bitbucketserver/event-payload-938025882.html"
            )
        ),
    ] = None
    filter: Annotated[Optional[EventSourceFilter], Field(title="Filter\n+optional")] = None
    metadata: Annotated[
        Optional[Dict[str, str]],
        Field(
            title=("Metadata holds the user defined metadata which will passed along the event payload.\n+optional")
        ),
    ] = None
    project_key: Annotated[
        Optional[str],
        Field(
            alias="projectKey",
            title=(
                "DeprecatedProjectKey is the key of project for which integration needs"
                " to set up\nDeprecated: use Repositories instead. Will be unsupported"
                " in v1.8\n+optional"
            ),
        ),
    ] = None
    repositories: Annotated[
        Optional[List[BitbucketServerRepository]],
        Field(title=("Repositories holds a list of repositories for which integration needs to set up\n+optional")),
    ] = None
    repository_slug: Annotated[
        Optional[str],
        Field(
            alias="repositorySlug",
            title=(
                "DeprecatedRepositorySlug is the slug of the repository for which"
                " integration needs to set up\nDeprecated: use Repositories instead."
                " Will be unsupported in v1.8\n+optional"
            ),
        ),
    ] = None
    tls: Annotated[
        Optional[TLSConfig],
        Field(title="TLS configuration for the bitbucketserver client.\n+optional"),
    ] = None
    webhook: Annotated[
        Optional[WebhookContext],
        Field(title="Webhook holds configuration to run a http server"),
    ] = None
    webhook_secret: Annotated[
        Optional[v1_1.SecretKeySelector],
        Field(
            alias="webhookSecret",
            title=(
                "WebhookSecret is reference to K8s secret which holds the bitbucket"
                " webhook secret (for HMAC validation)"
            ),
        ),
    ] = None


class GerritEventSource(BaseModel):
    auth: Annotated[
        Optional[BasicAuth],
        Field(title="Auth hosts secret selectors for username and password\n+optional"),
    ] = None
    delete_hook_on_finish: Annotated[
        Optional[bool],
        Field(
            alias="deleteHookOnFinish",
            title=(
                "DeleteHookOnFinish determines whether to delete the Gerrit hook for"
                " the project once the event source is stopped.\n+optional"
            ),
        ),
    ] = None
    events: Annotated[
        Optional[List[str]],
        Field(
            title=(
                "Events are gerrit event to listen to.\nRefer"
                " https://gerrit-review.googlesource.com/Documentation/cmd-stream-events.html#events"
            )
        ),
    ] = None
    filter: Annotated[Optional[EventSourceFilter], Field(title="Filter\n+optional")] = None
    gerrit_base_url: Annotated[
        Optional[str],
        Field(
            alias="gerritBaseURL",
            title="GerritBaseURL is the base URL for API requests to a custom endpoint",
        ),
    ] = None
    hook_name: Annotated[
        Optional[str],
        Field(alias="hookName", title="HookName is the name of the webhook"),
    ] = None
    metadata: Annotated[
        Optional[Dict[str, str]],
        Field(
            title=("Metadata holds the user defined metadata which will passed along the event payload.\n+optional")
        ),
    ] = None
    projects: Annotated[
        Optional[List[str]],
        Field(description='List of project namespace paths like "whynowy/test".'),
    ] = None
    ssl_verify: Annotated[
        Optional[bool],
        Field(alias="sslVerify", title="SslVerify to enable ssl verification\n+optional"),
    ] = None
    webhook: Annotated[
        Optional[WebhookContext],
        Field(title="Webhook holds configuration to run a http server"),
    ] = None


class GithubEventSource(BaseModel):
    active: Annotated[
        Optional[bool],
        Field(
            title=(
                "Active refers to status of the webhook for event"
                " deliveries.\nhttps://developer.github.com/webhooks/creating/#active\n+optional"
            )
        ),
    ] = None
    api_token: Annotated[
        Optional[v1_1.SecretKeySelector],
        Field(
            alias="apiToken",
            title=("APIToken refers to a K8s secret containing github api token\n+optional"),
        ),
    ] = None
    content_type: Annotated[
        Optional[str],
        Field(alias="contentType", title="ContentType of the event delivery"),
    ] = None
    delete_hook_on_finish: Annotated[
        Optional[bool],
        Field(
            alias="deleteHookOnFinish",
            title=(
                "DeleteHookOnFinish determines whether to delete the GitHub hook for"
                " the repository once the event source is stopped.\n+optional"
            ),
        ),
    ] = None
    events: Annotated[
        Optional[List[str]],
        Field(title=("Events refer to Github events to which the event source will subscribe")),
    ] = None
    filter: Annotated[Optional[EventSourceFilter], Field(title="Filter\n+optional")] = None
    github_app: Annotated[
        Optional[GithubAppCreds],
        Field(
            alias="githubApp",
            title="GitHubApp holds the GitHub app credentials\n+optional",
        ),
    ] = None
    github_base_url: Annotated[
        Optional[str],
        Field(
            alias="githubBaseURL",
            title="GitHub base URL (for GitHub Enterprise)\n+optional",
        ),
    ] = None
    github_upload_url: Annotated[
        Optional[str],
        Field(
            alias="githubUploadURL",
            title="GitHub upload URL (for GitHub Enterprise)\n+optional",
        ),
    ] = None
    id: Annotated[
        Optional[str],
        Field(
            title=("Id is the webhook's id\nDeprecated: This is not used at all, will be removed in v1.6\n+optional")
        ),
    ] = None
    insecure: Annotated[Optional[bool], Field(title="Insecure tls verification")] = None
    metadata: Annotated[
        Optional[Dict[str, str]],
        Field(
            title=("Metadata holds the user defined metadata which will passed along the event payload.\n+optional")
        ),
    ] = None
    organizations: Annotated[
        Optional[List[str]],
        Field(
            description=(
                "Organizations holds the names of organizations (used for organization"
                " level webhooks). Not required if Repositories is set."
            )
        ),
    ] = None
    owner: Annotated[
        Optional[str],
        Field(
            title=(
                "DeprecatedOwner refers to GitHub owner name i.e. argoproj\nDeprecated:"
                " use Repositories instead. Will be unsupported in v 1.6\n+optional"
            )
        ),
    ] = None
    repositories: Annotated[
        Optional[List[OwnedRepositories]],
        Field(
            description=(
                "Repositories holds the information of repositories, which uses repo"
                " owner as the key,\nand list of repo names as the value. Not required"
                " if Organizations is set."
            )
        ),
    ] = None
    repository: Annotated[
        Optional[str],
        Field(
            title=(
                "DeprecatedRepository refers to GitHub repo name i.e."
                " argo-events\nDeprecated: use Repositories instead. Will be"
                " unsupported in v 1.6\n+optional"
            )
        ),
    ] = None
    webhook: Annotated[
        Optional[WebhookContext],
        Field(title="Webhook refers to the configuration required to run a http server"),
    ] = None
    webhook_secret: Annotated[
        Optional[v1_1.SecretKeySelector],
        Field(
            alias="webhookSecret",
            title=(
                "WebhookSecret refers to K8s secret containing GitHub webhook"
                " secret\nhttps://developer.github.com/webhooks/securing/\n+optional"
            ),
        ),
    ] = None


class GitlabEventSource(BaseModel):
    access_token: Annotated[
        Optional[v1_1.SecretKeySelector],
        Field(
            alias="accessToken",
            title=("AccessToken references to k8 secret which holds the gitlab api access information"),
        ),
    ] = None
    delete_hook_on_finish: Annotated[
        Optional[bool],
        Field(
            alias="deleteHookOnFinish",
            title=(
                "DeleteHookOnFinish determines whether to delete the GitLab hook for"
                " the project once the event source is stopped.\n+optional"
            ),
        ),
    ] = None
    enable_ssl_verification: Annotated[
        Optional[bool],
        Field(
            alias="enableSSLVerification",
            title="EnableSSLVerification to enable ssl verification\n+optional",
        ),
    ] = None
    events: Annotated[
        Optional[List[str]],
        Field(
            description=(
                "Events are gitlab event to listen to.\nRefer"
                " https://github.com/xanzy/go-gitlab/blob/bf34eca5d13a9f4c3f501d8a97b8ac226d55e4d9/projects.go#L794."
            )
        ),
    ] = None
    filter: Annotated[Optional[EventSourceFilter], Field(title="Filter\n+optional")] = None
    gitlab_base_url: Annotated[
        Optional[str],
        Field(
            alias="gitlabBaseURL",
            title="GitlabBaseURL is the base URL for API requests to a custom endpoint",
        ),
    ] = None
    groups: Annotated[
        Optional[List[str]],
        Field(
            title=(
                'List of group IDs or group name like "test".\nGroup level hook'
                " available in Premium and Ultimate Gitlab.\n+optional"
            )
        ),
    ] = None
    metadata: Annotated[
        Optional[Dict[str, str]],
        Field(
            title=("Metadata holds the user defined metadata which will passed along the event payload.\n+optional")
        ),
    ] = None
    project_id: Annotated[
        Optional[str],
        Field(
            alias="projectID",
            title=(
                "DeprecatedProjectID is the id of project for which integration needs"
                " to setup\nDeprecated: use Projects instead. Will be unsupported in v"
                " 1.7\n+optional"
            ),
        ),
    ] = None
    projects: Annotated[
        Optional[List[str]],
        Field(
            title=(
                'List of project IDs or project namespace paths like "whynowy/test".'
                " Projects and groups cannot be empty at the same time.\n+optional"
            )
        ),
    ] = None
    secret_token: Annotated[
        Optional[v1_1.SecretKeySelector],
        Field(
            alias="secretToken",
            title=("SecretToken references to k8 secret which holds the Secret Token used by webhook config"),
        ),
    ] = None
    webhook: Annotated[
        Optional[WebhookContext],
        Field(title="Webhook holds configuration to run a http server"),
    ] = None


class SNSEventSource(BaseModel):
    access_key: Annotated[
        Optional[v1_1.SecretKeySelector],
        Field(
            alias="accessKey",
            title="AccessKey refers K8s secret containing aws access key",
        ),
    ] = None
    endpoint: Annotated[
        Optional[str],
        Field(
            title=("Endpoint configures connection to a specific SNS endpoint instead of Amazons servers\n+optional")
        ),
    ] = None
    filter: Annotated[Optional[EventSourceFilter], Field(title="Filter\n+optional")] = None
    metadata: Annotated[
        Optional[Dict[str, str]],
        Field(
            title=("Metadata holds the user defined metadata which will passed along the event payload.\n+optional")
        ),
    ] = None
    region: Annotated[Optional[str], Field(title="Region is AWS region")] = None
    role_arn: Annotated[
        Optional[str],
        Field(
            alias="roleARN",
            title=("RoleARN is the Amazon Resource Name (ARN) of the role to assume.\n+optional"),
        ),
    ] = None
    secret_key: Annotated[
        Optional[v1_1.SecretKeySelector],
        Field(
            alias="secretKey",
            title="SecretKey refers K8s secret containing aws secret key",
        ),
    ] = None
    topic_arn: Annotated[Optional[str], Field(alias="topicArn", title="TopicArn")] = None
    validate_signature: Annotated[
        Optional[bool],
        Field(
            alias="validateSignature",
            title=("ValidateSignature is boolean that can be set to true for SNS signature verification\n+optional"),
        ),
    ] = None
    webhook: Annotated[Optional[WebhookContext], Field(title="Webhook configuration for http server")] = None


class SlackEventSource(BaseModel):
    filter: Annotated[Optional[EventSourceFilter], Field(title="Filter\n+optional")] = None
    metadata: Annotated[
        Optional[Dict[str, str]],
        Field(
            title=("Metadata holds the user defined metadata which will passed along the event payload.\n+optional")
        ),
    ] = None
    signing_secret: Annotated[
        Optional[v1_1.SecretKeySelector],
        Field(alias="signingSecret", title="Slack App signing secret"),
    ] = None
    token: Annotated[
        Optional[v1_1.SecretKeySelector],
        Field(title="Token for URL verification handshake"),
    ] = None
    webhook: Annotated[
        Optional[WebhookContext],
        Field(title="Webhook holds configuration for a REST endpoint"),
    ] = None


class StorageGridEventSource(BaseModel):
    api_url: Annotated[
        Optional[str],
        Field(alias="apiURL", description="APIURL is the url of the storagegrid api."),
    ] = None
    auth_token: Annotated[
        Optional[v1_1.SecretKeySelector],
        Field(alias="authToken", title="Auth token for storagegrid api"),
    ] = None
    bucket: Annotated[
        Optional[str],
        Field(description="Name of the bucket to register notifications for."),
    ] = None
    events: Optional[List[str]] = None
    filter: Annotated[
        Optional[StorageGridFilter],
        Field(description="Filter on object key which caused the notification."),
    ] = None
    metadata: Annotated[
        Optional[Dict[str, str]],
        Field(
            title=("Metadata holds the user defined metadata which will passed along the event payload.\n+optional")
        ),
    ] = None
    region: Annotated[Optional[str], Field(title="S3 region.\nDefaults to us-east-1\n+optional")] = None
    topic_arn: Annotated[Optional[str], Field(alias="topicArn", title="TopicArn")] = None
    webhook: Annotated[
        Optional[WebhookContext],
        Field(title="Webhook holds configuration for a REST endpoint"),
    ] = None


class StripeEventSource(BaseModel):
    api_key: Annotated[
        Optional[v1_1.SecretKeySelector],
        Field(
            alias="apiKey",
            title=(
                "APIKey refers to K8s secret that holds Stripe API key. Used only if"
                " CreateWebhook is enabled.\n+optional"
            ),
        ),
    ] = None
    create_webhook: Annotated[
        Optional[bool],
        Field(
            alias="createWebhook",
            title=("CreateWebhook if specified creates a new webhook programmatically.\n+optional"),
        ),
    ] = None
    event_filter: Annotated[
        Optional[List[str]],
        Field(
            alias="eventFilter",
            title=(
                "EventFilter describes the type of events to listen to. If not"
                " specified, all types of events will be processed.\nMore info at"
                " https://stripe.com/docs/api/events/list\n+optional"
            ),
        ),
    ] = None
    metadata: Annotated[
        Optional[Dict[str, str]],
        Field(
            title=("Metadata holds the user defined metadata which will passed along the event payload.\n+optional")
        ),
    ] = None
    webhook: Annotated[
        Optional[WebhookContext],
        Field(title="Webhook holds configuration for a REST endpoint"),
    ] = None


class WebhookEventSource(BaseModel):
    filter: Annotated[Optional[EventSourceFilter], Field(title="Filter\n+optional")] = None
    webhook_context: Annotated[Optional[WebhookContext], Field(alias="webhookContext")] = None


class SecureHeader(BaseModel):
    name: Optional[str] = None
    value_from: Annotated[
        Optional[ValueFromSource],
        Field(
            alias="valueFrom",
            title="Values can be read from either secrets or configmaps",
        ),
    ] = None


class AMQPEventSource(BaseModel):
    auth: Annotated[
        Optional[BasicAuth],
        Field(title="Auth hosts secret selectors for username and password\n+optional"),
    ] = None
    connection_backoff: Annotated[
        Optional[Backoff],
        Field(
            alias="connectionBackoff",
            title="Backoff holds parameters applied to connection.\n+optional",
        ),
    ] = None
    consume: Annotated[
        Optional[AMQPConsumeConfig],
        Field(
            title=(
                "Consume holds the configuration to immediately starts delivering"
                " queued messages\nFor more information, visit"
                " https://pkg.go.dev/github.com/rabbitmq/amqp091-go#Channel.Consume\n+optional"
            )
        ),
    ] = None
    exchange_declare: Annotated[
        Optional[AMQPExchangeDeclareConfig],
        Field(
            alias="exchangeDeclare",
            title=(
                "ExchangeDeclare holds the configuration for the exchange on the"
                " server\nFor more information, visit"
                " https://pkg.go.dev/github.com/rabbitmq/amqp091-go#Channel.ExchangeDeclare\n+optional"
            ),
        ),
    ] = None
    exchange_name: Annotated[
        Optional[str],
        Field(
            alias="exchangeName",
            title=(
                "ExchangeName is the exchange name\nFor more information, visit"
                " https://www.rabbitmq.com/tutorials/amqp-concepts.html"
            ),
        ),
    ] = None
    exchange_type: Annotated[
        Optional[str],
        Field(alias="exchangeType", title="ExchangeType is rabbitmq exchange type"),
    ] = None
    filter: Annotated[Optional[EventSourceFilter], Field(title="Filter\n+optional")] = None
    json_body: Annotated[
        Optional[bool],
        Field(
            alias="jsonBody",
            title=("JSONBody specifies that all event body payload coming from this\nsource will be JSON\n+optional"),
        ),
    ] = None
    metadata: Annotated[
        Optional[Dict[str, str]],
        Field(
            title=("Metadata holds the user defined metadata which will passed along the event payload.\n+optional")
        ),
    ] = None
    queue_bind: Annotated[
        Optional[AMQPQueueBindConfig],
        Field(
            alias="queueBind",
            title=(
                "QueueBind holds the configuration that binds an exchange to a queue so"
                " that publishings to the\nexchange will be routed to the queue when"
                " the publishing routing key matches the binding routing key\nFor more"
                " information, visit"
                " https://pkg.go.dev/github.com/rabbitmq/amqp091-go#Channel.QueueBind\n+optional"
            ),
        ),
    ] = None
    queue_declare: Annotated[
        Optional[AMQPQueueDeclareConfig],
        Field(
            alias="queueDeclare",
            title=(
                "QueueDeclare holds the configuration of a queue to hold messages and"
                " deliver to consumers.\nDeclaring creates a queue if it doesn't"
                " already exist, or ensures that an existing queue matches\nthe same"
                " parameters\nFor more information, visit"
                " https://pkg.go.dev/github.com/rabbitmq/amqp091-go#Channel.QueueDeclare\n+optional"
            ),
        ),
    ] = None
    routing_key: Annotated[Optional[str], Field(alias="routingKey", title="Routing key for bindings")] = None
    tls: Annotated[
        Optional[TLSConfig],
        Field(title="TLS configuration for the amqp client.\n+optional"),
    ] = None
    url: Annotated[Optional[str], Field(title="URL for rabbitmq service")] = None
    url_secret: Annotated[
        Optional[v1_1.SecretKeySelector],
        Field(
            alias="urlSecret",
            title="URLSecret is secret reference for rabbitmq service URL",
        ),
    ] = None


class EmitterEventSource(BaseModel):
    broker: Annotated[Optional[str], Field(description="Broker URI to connect to.")] = None
    channel_key: Annotated[
        Optional[str],
        Field(alias="channelKey", title="ChannelKey refers to the channel key"),
    ] = None
    channel_name: Annotated[
        Optional[str],
        Field(alias="channelName", title="ChannelName refers to the channel name"),
    ] = None
    connection_backoff: Annotated[
        Optional[Backoff],
        Field(
            alias="connectionBackoff",
            title="Backoff holds parameters applied to connection.\n+optional",
        ),
    ] = None
    filter: Annotated[Optional[EventSourceFilter], Field(title="Filter\n+optional")] = None
    json_body: Annotated[
        Optional[bool],
        Field(
            alias="jsonBody",
            title=("JSONBody specifies that all event body payload coming from this\nsource will be JSON\n+optional"),
        ),
    ] = None
    metadata: Annotated[
        Optional[Dict[str, str]],
        Field(
            title=("Metadata holds the user defined metadata which will passed along the event payload.\n+optional")
        ),
    ] = None
    password: Annotated[
        Optional[v1_1.SecretKeySelector],
        Field(title="Password to use to connect to broker\n+optional"),
    ] = None
    tls: Annotated[
        Optional[TLSConfig],
        Field(title="TLS configuration for the emitter client.\n+optional"),
    ] = None
    username: Annotated[
        Optional[v1_1.SecretKeySelector],
        Field(title="Username to use to connect to broker\n+optional"),
    ] = None


class K8SResourcePolicy(BaseModel):
    backoff: Annotated[Optional[Backoff], Field(title="Backoff before checking resource state")] = None
    error_on_backoff_timeout: Annotated[
        Optional[bool],
        Field(
            alias="errorOnBackoffTimeout",
            title=(
                "ErrorOnBackoffTimeout determines whether sensor should transition to"
                " error state if the trigger policy is unable to determine\nthe state"
                " of the resource"
            ),
        ),
    ] = None
    labels: Annotated[
        Optional[Dict[str, str]],
        Field(title="Labels required to identify whether a resource is in success state"),
    ] = None


class KafkaEventSource(BaseModel):
    config: Annotated[
        Optional[str],
        Field(
            description=(
                "Yaml format Sarama config for Kafka connection.\nIt follows the struct"
                " of sarama.Config. See"
                " https://github.com/IBM/sarama/blob/main/config.go\ne.g.\n\nconsumer:\n"
                "  fetch:\n    min: 1\nnet:\n  MaxOpenRequests: 5\n\n+optional"
            )
        ),
    ] = None
    connection_backoff: Annotated[
        Optional[Backoff],
        Field(
            alias="connectionBackoff",
            description="Backoff holds parameters applied to connection.",
        ),
    ] = None
    consumer_group: Annotated[
        Optional[KafkaConsumerGroup],
        Field(alias="consumerGroup", title="Consumer group for kafka client\n+optional"),
    ] = None
    filter: Annotated[Optional[EventSourceFilter], Field(title="Filter\n+optional")] = None
    json_body: Annotated[
        Optional[bool],
        Field(
            alias="jsonBody",
            title=("JSONBody specifies that all event body payload coming from this\nsource will be JSON\n+optional"),
        ),
    ] = None
    limit_events_per_second: Annotated[
        Optional[str],
        Field(
            alias="limitEventsPerSecond",
            title=("Sets a limit on how many events get read from kafka per second.\n+optional"),
        ),
    ] = None
    metadata: Annotated[
        Optional[Dict[str, str]],
        Field(
            title=("Metadata holds the user defined metadata which will passed along the event payload.\n+optional")
        ),
    ] = None
    partition: Annotated[Optional[str], Field(title="Partition name\n+optional")] = None
    sasl: Annotated[
        Optional[SASLConfig],
        Field(title="SASL configuration for the kafka client\n+optional"),
    ] = None
    tls: Annotated[
        Optional[TLSConfig],
        Field(title="TLS configuration for the kafka client.\n+optional"),
    ] = None
    topic: Annotated[Optional[str], Field(title="Topic name")] = None
    url: Annotated[
        Optional[str],
        Field(title="URL to kafka cluster, multiple URLs separated by comma"),
    ] = None
    version: Annotated[
        Optional[str],
        Field(
            title=(
                "Specify what kafka version is being connected to enables certain"
                " features in sarama, defaults to 1.0.0\n+optional"
            )
        ),
    ] = None


class MQTTEventSource(BaseModel):
    auth: Annotated[
        Optional[BasicAuth],
        Field(title="Auth hosts secret selectors for username and password\n+optional"),
    ] = None
    client_id: Annotated[Optional[str], Field(alias="clientId", title="ClientID is the id of the client")] = None
    connection_backoff: Annotated[
        Optional[Backoff],
        Field(
            alias="connectionBackoff",
            description="ConnectionBackoff holds backoff applied to connection.",
        ),
    ] = None
    filter: Annotated[Optional[EventSourceFilter], Field(title="Filter\n+optional")] = None
    json_body: Annotated[
        Optional[bool],
        Field(
            alias="jsonBody",
            title=("JSONBody specifies that all event body payload coming from this\nsource will be JSON\n+optional"),
        ),
    ] = None
    metadata: Annotated[
        Optional[Dict[str, str]],
        Field(
            title=("Metadata holds the user defined metadata which will passed along the event payload.\n+optional")
        ),
    ] = None
    tls: Annotated[
        Optional[TLSConfig],
        Field(title="TLS configuration for the mqtt client.\n+optional"),
    ] = None
    topic: Annotated[Optional[str], Field(title="Topic name")] = None
    url: Annotated[Optional[str], Field(title="URL to connect to broker")] = None


class NSQEventSource(BaseModel):
    channel: Annotated[Optional[str], Field(title="Channel used for subscription")] = None
    connection_backoff: Annotated[
        Optional[Backoff],
        Field(
            alias="connectionBackoff",
            title="Backoff holds parameters applied to connection.\n+optional",
        ),
    ] = None
    filter: Annotated[Optional[EventSourceFilter], Field(title="Filter\n+optional")] = None
    host_address: Annotated[
        Optional[str],
        Field(
            alias="hostAddress",
            title="HostAddress is the address of the host for NSQ lookup",
        ),
    ] = None
    json_body: Annotated[
        Optional[bool],
        Field(
            alias="jsonBody",
            title=("JSONBody specifies that all event body payload coming from this\nsource will be JSON\n+optional"),
        ),
    ] = None
    metadata: Annotated[
        Optional[Dict[str, str]],
        Field(
            title=("Metadata holds the user defined metadata which will passed along the event payload.\n+optional")
        ),
    ] = None
    tls: Annotated[
        Optional[TLSConfig],
        Field(title="TLS configuration for the nsq client.\n+optional"),
    ] = None
    topic: Annotated[Optional[str], Field(description="Topic to subscribe to.")] = None


class PulsarEventSource(BaseModel):
    auth_athenz_params: Annotated[
        Optional[Dict[str, str]],
        Field(
            alias="authAthenzParams",
            title=(
                "Authentication athenz parameters for the pulsar client.\nRefer"
                " https://github.com/apache/pulsar-client-go/blob/master/pulsar/auth/athenz.go\nEither"
                " token or athenz can be set to use auth.\n+optional"
            ),
        ),
    ] = None
    auth_athenz_secret: Annotated[
        Optional[v1_1.SecretKeySelector],
        Field(
            alias="authAthenzSecret",
            title=(
                "Authentication athenz privateKey secret for the pulsar"
                " client.\nAuthAthenzSecret must be set if AuthAthenzParams is"
                " used.\n+optional"
            ),
        ),
    ] = None
    auth_token_secret: Annotated[
        Optional[v1_1.SecretKeySelector],
        Field(
            alias="authTokenSecret",
            title=(
                "Authentication token for the pulsar client.\nEither token or athenz"
                " can be set to use auth.\n+optional"
            ),
        ),
    ] = None
    connection_backoff: Annotated[
        Optional[Backoff],
        Field(
            alias="connectionBackoff",
            title="Backoff holds parameters applied to connection.\n+optional",
        ),
    ] = None
    filter: Annotated[Optional[EventSourceFilter], Field(title="Filter\n+optional")] = None
    json_body: Annotated[
        Optional[bool],
        Field(
            alias="jsonBody",
            title=("JSONBody specifies that all event body payload coming from this\nsource will be JSON\n+optional"),
        ),
    ] = None
    metadata: Annotated[
        Optional[Dict[str, str]],
        Field(
            title=("Metadata holds the user defined metadata which will passed along the event payload.\n+optional")
        ),
    ] = None
    tls: Annotated[
        Optional[TLSConfig],
        Field(title="TLS configuration for the pulsar client.\n+optional"),
    ] = None
    tls_allow_insecure_connection: Annotated[
        Optional[bool],
        Field(
            alias="tlsAllowInsecureConnection",
            title=("Whether the Pulsar client accept untrusted TLS certificate from broker.\n+optional"),
        ),
    ] = None
    tls_trust_certs_secret: Annotated[
        Optional[v1_1.SecretKeySelector],
        Field(
            alias="tlsTrustCertsSecret",
            title="Trusted TLS certificate secret.\n+optional",
        ),
    ] = None
    tls_validate_hostname: Annotated[
        Optional[bool],
        Field(
            alias="tlsValidateHostname",
            title=("Whether the Pulsar client verify the validity of the host name from broker.\n+optional"),
        ),
    ] = None
    topics: Annotated[
        Optional[List[str]],
        Field(title="Name of the topics to subscribe to.\n+required"),
    ] = None
    type: Annotated[
        Optional[str],
        Field(
            title=(
                'Type of the subscription.\nOnly "exclusive" and "shared" is'
                " supported.\nDefaults to exclusive.\n+optional"
            )
        ),
    ] = None
    url: Annotated[
        Optional[str],
        Field(title="Configure the service URL for the Pulsar service.\n+required"),
    ] = None


class PulsarTrigger(BaseModel):
    auth_athenz_params: Annotated[
        Optional[Dict[str, str]],
        Field(
            alias="authAthenzParams",
            title=(
                "Authentication athenz parameters for the pulsar client.\nRefer"
                " https://github.com/apache/pulsar-client-go/blob/master/pulsar/auth/athenz.go\nEither"
                " token or athenz can be set to use auth.\n+optional"
            ),
        ),
    ] = None
    auth_athenz_secret: Annotated[
        Optional[v1_1.SecretKeySelector],
        Field(
            alias="authAthenzSecret",
            title=(
                "Authentication athenz privateKey secret for the pulsar"
                " client.\nAuthAthenzSecret must be set if AuthAthenzParams is"
                " used.\n+optional"
            ),
        ),
    ] = None
    auth_token_secret: Annotated[
        Optional[v1_1.SecretKeySelector],
        Field(
            alias="authTokenSecret",
            title=(
                "Authentication token for the pulsar client.\nEither token or athenz"
                " can be set to use auth.\n+optional"
            ),
        ),
    ] = None
    connection_backoff: Annotated[
        Optional[Backoff],
        Field(
            alias="connectionBackoff",
            title="Backoff holds parameters applied to connection.\n+optional",
        ),
    ] = None
    parameters: Annotated[
        Optional[List[TriggerParameter]],
        Field(description=("Parameters is the list of parameters that is applied to resolved Kafka trigger object.")),
    ] = None
    payload: Annotated[
        Optional[List[TriggerParameter]],
        Field(
            description=(
                "Payload is the list of key-value extracted from an event payload to construct the request payload."
            )
        ),
    ] = None
    tls: Annotated[
        Optional[TLSConfig],
        Field(title="TLS configuration for the pulsar client.\n+optional"),
    ] = None
    tls_allow_insecure_connection: Annotated[
        Optional[bool],
        Field(
            alias="tlsAllowInsecureConnection",
            title=("Whether the Pulsar client accept untrusted TLS certificate from broker.\n+optional"),
        ),
    ] = None
    tls_trust_certs_secret: Annotated[
        Optional[v1_1.SecretKeySelector],
        Field(
            alias="tlsTrustCertsSecret",
            title="Trusted TLS certificate secret.\n+optional",
        ),
    ] = None
    tls_validate_hostname: Annotated[
        Optional[bool],
        Field(
            alias="tlsValidateHostname",
            title=("Whether the Pulsar client verify the validity of the host name from broker.\n+optional"),
        ),
    ] = None
    topic: Annotated[
        Optional[str],
        Field(title=("Name of the topic.\nSee https://pulsar.apache.org/docs/en/concepts-messaging/")),
    ] = None
    url: Annotated[
        Optional[str],
        Field(title="Configure the service URL for the Pulsar service.\n+required"),
    ] = None


class CalendarEventSource(BaseModel):
    exclusion_dates: Annotated[
        Optional[List[str]],
        Field(
            alias="exclusionDates",
            description=("ExclusionDates defines the list of DATE-TIME exceptions for recurring events."),
        ),
    ] = None
    filter: Annotated[Optional[EventSourceFilter], Field(title="Filter\n+optional")] = None
    interval: Annotated[
        Optional[str],
        Field(title=("Interval is a string that describes an interval duration, e.g. 1s, 30m, 2h...\n+optional")),
    ] = None
    metadata: Annotated[
        Optional[Dict[str, str]],
        Field(
            title=("Metadata holds the user defined metadata which will passed along the event payload.\n+optional")
        ),
    ] = None
    persistence: Annotated[
        Optional[EventPersistence],
        Field(title="Persistence hold the configuration for event persistence"),
    ] = None
    schedule: Annotated[
        Optional[str],
        Field(
            title=(
                "Schedule is a cron-like expression. For reference, see: https://en.wikipedia.org/wiki/Cron\n+optional"
            )
        ),
    ] = None
    timezone: Annotated[Optional[str], Field(title="Timezone in which to run the schedule\n+optional")] = None


class NATSEventsSource(BaseModel):
    auth: Annotated[Optional[NATSAuth], Field(title="Auth information\n+optional")] = None
    connection_backoff: Annotated[
        Optional[Backoff],
        Field(
            alias="connectionBackoff",
            description="ConnectionBackoff holds backoff applied to connection.",
        ),
    ] = None
    filter: Annotated[Optional[EventSourceFilter], Field(title="Filter\n+optional")] = None
    json_body: Annotated[
        Optional[bool],
        Field(
            alias="jsonBody",
            title=("JSONBody specifies that all event body payload coming from this\nsource will be JSON\n+optional"),
        ),
    ] = None
    metadata: Annotated[
        Optional[Dict[str, str]],
        Field(
            title=("Metadata holds the user defined metadata which will passed along the event payload.\n+optional")
        ),
    ] = None
    subject: Annotated[
        Optional[str],
        Field(title=("Subject holds the name of the subject onto which messages are published")),
    ] = None
    tls: Annotated[
        Optional[TLSConfig],
        Field(title="TLS configuration for the nats client.\n+optional"),
    ] = None
    url: Annotated[Optional[str], Field(title="URL to connect to NATS cluster")] = None


class KafkaTrigger(BaseModel):
    compress: Annotated[
        Optional[bool],
        Field(
            title=(
                "Compress determines whether to compress message or not.\nDefaults to"
                " false.\nIf set to true, compresses message using snappy"
                " compression.\n+optional"
            )
        ),
    ] = None
    flush_frequency: Annotated[
        Optional[int],
        Field(
            alias="flushFrequency",
            title=(
                "FlushFrequency refers to the frequency in milliseconds to flush"
                " batches.\nDefaults to 500 milliseconds.\n+optional"
            ),
        ),
    ] = None
    parameters: Annotated[
        Optional[List[TriggerParameter]],
        Field(description=("Parameters is the list of parameters that is applied to resolved Kafka trigger object.")),
    ] = None
    partition: Annotated[Optional[int], Field(title="+optional\nDEPRECATED")] = None
    partitioning_key: Annotated[
        Optional[str],
        Field(
            alias="partitioningKey",
            description=("The partitioning key for the messages put on the Kafka topic.\n+optional."),
        ),
    ] = None
    payload: Annotated[
        Optional[List[TriggerParameter]],
        Field(
            description=(
                "Payload is the list of key-value extracted from an event payload to construct the request payload."
            )
        ),
    ] = None
    required_acks: Annotated[
        Optional[int],
        Field(
            alias="requiredAcks",
            description=(
                "RequiredAcks used in producer to tell the broker how many replica"
                " acknowledgements\nDefaults to 1 (Only wait for the leader to"
                " ack).\n+optional."
            ),
        ),
    ] = None
    sasl: Annotated[
        Optional[SASLConfig],
        Field(title="SASL configuration for the kafka client\n+optional"),
    ] = None
    schema_registry: Annotated[
        Optional[SchemaRegistryConfig],
        Field(
            alias="schemaRegistry",
            title=("Schema Registry configuration to producer message with avro format\n+optional"),
        ),
    ] = None
    tls: Annotated[
        Optional[TLSConfig],
        Field(title="TLS configuration for the Kafka producer.\n+optional"),
    ] = None
    topic: Annotated[
        Optional[str],
        Field(title=("Name of the topic.\nMore info at https://kafka.apache.org/documentation/#intro_topics")),
    ] = None
    url: Annotated[
        Optional[str],
        Field(description="URL of the Kafka broker, multiple URLs separated by comma."),
    ] = None
    version: Annotated[
        Optional[str],
        Field(
            title=(
                "Specify what kafka version is being connected to enables certain"
                " features in sarama, defaults to 1.0.0\n+optional"
            )
        ),
    ] = None


class BitbucketEventSource(BaseModel):
    auth: Annotated[
        Optional[BitbucketAuth],
        Field(description="Auth information required to connect to Bitbucket."),
    ] = None
    delete_hook_on_finish: Annotated[
        Optional[bool],
        Field(
            alias="deleteHookOnFinish",
            title=(
                "DeleteHookOnFinish determines whether to delete the defined Bitbucket"
                " hook once the event source is stopped.\n+optional"
            ),
        ),
    ] = None
    events: Annotated[Optional[List[str]], Field(description="Events this webhook is subscribed to.")] = None
    filter: Annotated[Optional[EventSourceFilter], Field(title="Filter\n+optional")] = None
    metadata: Annotated[
        Optional[Dict[str, str]],
        Field(
            title=("Metadata holds the user defined metadata which will be passed along the event payload.\n+optional")
        ),
    ] = None
    owner: Annotated[
        Optional[str],
        Field(
            title=(
                "DeprecatedOwner is the owner of the repository.\nDeprecated: use"
                " Repositories instead. Will be unsupported in v1.9\n+optional"
            )
        ),
    ] = None
    project_key: Annotated[
        Optional[str],
        Field(
            alias="projectKey",
            title=(
                "DeprecatedProjectKey is the key of the project to which the repository"
                " relates\nDeprecated: use Repositories instead. Will be unsupported in"
                " v1.9\n+optional"
            ),
        ),
    ] = None
    repositories: Annotated[
        Optional[List[BitbucketRepository]],
        Field(title=("Repositories holds a list of repositories for which integration needs to set up\n+optional")),
    ] = None
    repository_slug: Annotated[
        Optional[str],
        Field(
            alias="repositorySlug",
            title=(
                "DeprecatedRepositorySlug is a URL-friendly version of a repository"
                " name, automatically generated by Bitbucket for use in the"
                " URL\nDeprecated: use Repositories instead. Will be unsupported in"
                " v1.9\n+optional"
            ),
        ),
    ] = None
    webhook: Annotated[
        Optional[WebhookContext],
        Field(title="Webhook refers to the configuration required to run an http server"),
    ] = None


class ArtifactLocation(BaseModel):
    configmap: Annotated[
        Optional[v1_1.ConfigMapKeySelector],
        Field(title="Configmap that stores the artifact"),
    ] = None
    file: Annotated[
        Optional[FileArtifact],
        Field(title="File artifact is artifact stored in a file"),
    ] = None
    git: Annotated[Optional[GitArtifact], Field(title="Git repository hosting the artifact")] = None
    inline: Annotated[
        Optional[str],
        Field(title="Inline artifact is embedded in sensor spec as a string"),
    ] = None
    resource: Annotated[Optional[Resource], Field(title="Resource is generic template for K8s resource")] = None
    s3: Annotated[Optional[S3Artifact], Field(title="S3 compliant artifact")] = None
    url: Annotated[Optional[URLArtifact], Field(title="URL to fetch the artifact from")] = None


class TriggerPolicy(BaseModel):
    k8s: Annotated[
        Optional[K8SResourcePolicy],
        Field(
            title=(
                "K8SResourcePolicy refers to the policy used to check the state of K8s"
                " based triggers using using labels"
            )
        ),
    ] = None
    status: Annotated[
        Optional[StatusPolicy],
        Field(title=("Status refers to the policy used to check the state of the trigger using response status")),
    ] = None


class ArgoWorkflowTrigger(BaseModel):
    args: Annotated[
        Optional[List[str]],
        Field(title="Args is the list of arguments to pass to the argo CLI"),
    ] = None
    operation: Annotated[
        Optional[str],
        Field(
            title=(
                "Operation refers to the type of operation performed on the argo"
                " workflow resource.\nDefault value is Submit.\n+optional"
            )
        ),
    ] = None
    parameters: Annotated[
        Optional[List[TriggerParameter]],
        Field(title=("Parameters is the list of parameters to pass to resolved Argo Workflow object")),
    ] = None
    source: Annotated[Optional[ArtifactLocation], Field(title="Source of the K8s resource file(s)")] = None


class StandardK8STrigger(BaseModel):
    live_object: Annotated[
        Optional[bool],
        Field(
            alias="liveObject",
            title=(
                "LiveObject specifies whether the resource should be directly fetched"
                " from K8s instead\nof being marshaled from the resource artifact. If"
                " set to true, the resource artifact\nmust contain the information"
                " required to uniquely identify the resource in the cluster,\nthat is,"
                ' you must specify "apiVersion", "kind" as well as "name" and'
                ' "namespace" meta\ndata.\nOnly valid for operation type'
                " `update`\n+optional"
            ),
        ),
    ] = None
    operation: Annotated[
        Optional[str],
        Field(
            title=(
                "Operation refers to the type of operation performed on the k8s"
                " resource.\nDefault value is Create.\n+optional"
            )
        ),
    ] = None
    parameters: Annotated[
        Optional[List[TriggerParameter]],
        Field(description=("Parameters is the list of parameters that is applied to resolved K8s trigger object.")),
    ] = None
    patch_strategy: Annotated[
        Optional[str],
        Field(
            alias="patchStrategy",
            title=(
                "PatchStrategy controls the K8s object patching strategy when the"
                " trigger operation is specified as patch.\npossible"
                ' values:\n"application/json-patch+json"\n"application/merge-patch+json"\n"application/strategic-merge-patch+json"\n"application/apply-patch+yaml".\nDefaults'
                ' to "application/merge-patch+json"\n+optional'
            ),
        ),
    ] = None
    source: Annotated[Optional[ArtifactLocation], Field(title="Source of the K8s resource file(s)")] = None


class Service(BaseModel):
    cluster_ip: Annotated[
        Optional[str],
        Field(
            alias="clusterIP",
            title=(
                "clusterIP is the IP address of the service and is usually"
                " assigned\nrandomly by the master. If an address is specified manually"
                " and is not in\nuse by others, it will be allocated to the service;"
                " otherwise, creation\nof the service will fail. This field can not be"
                ' changed through updates.\nValid values are "None", empty string (""),'
                ' or a valid IP address. "None"\ncan be specified for headless services'
                " when proxying is not required.\nMore info:"
                " https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies\n+optional"
            ),
        ),
    ] = None
    ports: Annotated[
        Optional[List[v1_1.ServicePort]],
        Field(
            title=(
                "The list of ports that are exposed by this ClusterIP"
                " service.\n+patchMergeKey=port\n+patchStrategy=merge\n+listType=map\n+listMapKey=port\n+listMapKey=protocol"
            )
        ),
    ] = None


class Status(BaseModel):
    conditions: Annotated[
        Optional[List[Condition]],
        Field(
            title=(
                "Conditions are the latest available observations of a resource's"
                " current state.\n+optional\n+patchMergeKey=type\n+patchStrategy=merge"
            )
        ),
    ] = None


class ExprFilter(BaseModel):
    expr: Annotated[
        Optional[str],
        Field(description=("Expr refers to the expression that determines the outcome of the filter.")),
    ] = None
    fields: Annotated[
        Optional[List[PayloadField]],
        Field(description=("Fields refers to set of keys that refer to the paths within event payload.")),
    ] = None


class AWSLambdaTrigger(BaseModel):
    access_key: Annotated[
        Optional[v1_1.SecretKeySelector],
        Field(
            alias="accessKey",
            title="AccessKey refers K8s secret containing aws access key\n+optional",
        ),
    ] = None
    function_name: Annotated[
        Optional[str],
        Field(
            alias="functionName",
            description="FunctionName refers to the name of the function to invoke.",
        ),
    ] = None
    invocation_type: Annotated[
        Optional[str],
        Field(
            alias="invocationType",
            description=(
                "Choose from the following options.\n\n   * RequestResponse (default) -"
                " Invoke the function synchronously. Keep\n   the connection open until"
                " the function returns a response or times out.\n   The API response"
                " includes the function response and additional data.\n\n   * Event -"
                " Invoke the function asynchronously. Send events that fail multiple\n "
                "  times to the function's dead-letter queue (if it's configured). The"
                " API\n   response only includes a status code.\n\n   * DryRun -"
                " Validate parameter values and verify that the user or role\n   has"
                " permission to invoke the function.\n+optional"
            ),
        ),
    ] = None
    parameters: Annotated[
        Optional[List[TriggerParameter]],
        Field(
            title=(
                "Parameters is the list of key-value extracted from event's payload"
                " that are applied to\nthe trigger resource.\n+optional"
            )
        ),
    ] = None
    payload: Annotated[
        Optional[List[TriggerParameter]],
        Field(
            description=(
                "Payload is the list of key-value extracted from an event payload to construct the request payload."
            )
        ),
    ] = None
    region: Annotated[Optional[str], Field(title="Region is AWS region")] = None
    role_arn: Annotated[
        Optional[str],
        Field(
            alias="roleARN",
            title=("RoleARN is the Amazon Resource Name (ARN) of the role to assume.\n+optional"),
        ),
    ] = None
    secret_key: Annotated[
        Optional[v1_1.SecretKeySelector],
        Field(
            alias="secretKey",
            title="SecretKey refers K8s secret containing aws secret key\n+optional",
        ),
    ] = None


class AzureEventHubsTrigger(BaseModel):
    fqdn: Annotated[
        Optional[str],
        Field(
            title=(
                "FQDN refers to the namespace dns of Azure Event Hubs to be used i.e."
                " <namespace>.servicebus.windows.net"
            )
        ),
    ] = None
    hub_name: Annotated[
        Optional[str],
        Field(
            alias="hubName",
            title="HubName refers to the Azure Event Hub to send events to",
        ),
    ] = None
    parameters: Annotated[
        Optional[List[TriggerParameter]],
        Field(
            title=(
                "Parameters is the list of key-value extracted from event's payload"
                " that are applied to\nthe trigger resource.\n+optional"
            )
        ),
    ] = None
    payload: Annotated[
        Optional[List[TriggerParameter]],
        Field(
            description=(
                "Payload is the list of key-value extracted from an event payload to construct the request payload."
            )
        ),
    ] = None
    shared_access_key: Annotated[
        Optional[v1_1.SecretKeySelector],
        Field(
            alias="sharedAccessKey",
            title=("SharedAccessKey refers to a K8s secret containing the primary key for the"),
        ),
    ] = None
    shared_access_key_name: Annotated[
        Optional[v1_1.SecretKeySelector],
        Field(
            alias="sharedAccessKeyName",
            title="SharedAccessKeyName refers to the name of the Shared Access Key",
        ),
    ] = None


class CustomTrigger(BaseModel):
    cert_secret: Annotated[
        Optional[v1_1.SecretKeySelector],
        Field(
            alias="certSecret",
            description=(
                "CertSecret refers to the secret that contains cert for secure"
                " connection between sensor and custom trigger gRPC server."
            ),
        ),
    ] = None
    parameters: Annotated[
        Optional[List[TriggerParameter]],
        Field(
            description=(
                "Parameters is the list of parameters that is applied to resolved custom trigger trigger object."
            )
        ),
    ] = None
    payload: Annotated[
        Optional[List[TriggerParameter]],
        Field(
            description=(
                "Payload is the list of key-value extracted from an event payload to construct the request payload."
            )
        ),
    ] = None
    secure: Annotated[
        Optional[bool],
        Field(title=("Secure refers to type of the connection between sensor to custom trigger gRPC")),
    ] = None
    server_name_override: Annotated[
        Optional[str],
        Field(
            alias="serverNameOverride",
            description=(
                "ServerNameOverride for the secure connection between sensor and custom trigger gRPC server."
            ),
        ),
    ] = None
    server_url: Annotated[
        Optional[str],
        Field(
            alias="serverURL",
            title=("ServerURL is the url of the gRPC server that executes custom trigger"),
        ),
    ] = None
    spec: Annotated[
        Optional[Dict[str, str]],
        Field(
            description=(
                "Spec is the custom trigger resource specification that custom trigger"
                " gRPC server knows how to interpret."
            )
        ),
    ] = None


class EmailTrigger(BaseModel):
    body: Annotated[
        Optional[str],
        Field(title="Body refers to the body/content of the email send.\n+optional"),
    ] = None
    from_: Annotated[
        Optional[str],
        Field(
            alias="from",
            title=("From refers to the address from which the email is send from.\n+optional"),
        ),
    ] = None
    host: Annotated[
        Optional[str],
        Field(description="Host refers to the smtp host url to which email is send."),
    ] = None
    parameters: Annotated[
        Optional[List[TriggerParameter]],
        Field(
            title=(
                "Parameters is the list of key-value extracted from event's payload"
                " that are applied to\nthe trigger resource.\n+optional"
            )
        ),
    ] = None
    port: Annotated[
        Optional[int],
        Field(title=("Port refers to the smtp server port to which email is send.\nDefaults to 0.\n+optional")),
    ] = None
    smtp_password: Annotated[
        Optional[v1_1.SecretKeySelector],
        Field(
            alias="smtpPassword",
            title=(
                "SMTPPassword refers to the Kubernetes secret that holds the smtp"
                " password used to connect to smtp server.\n+optional"
            ),
        ),
    ] = None
    subject: Annotated[
        Optional[str],
        Field(title="Subject refers to the subject line for the email send.\n+optional"),
    ] = None
    to: Annotated[
        Optional[List[str]],
        Field(title=("To refers to the email addresses to which the emails are send.\n+optional")),
    ] = None
    username: Annotated[
        Optional[str],
        Field(title=("Username refers to the username used to connect to the smtp server.\n+optional")),
    ] = None


class OpenWhiskTrigger(BaseModel):
    action_name: Annotated[
        Optional[str],
        Field(alias="actionName", description="Name of the action/function."),
    ] = None
    auth_token: Annotated[
        Optional[v1_1.SecretKeySelector],
        Field(alias="authToken", title="AuthToken for authentication.\n+optional"),
    ] = None
    host: Annotated[Optional[str], Field(description="Host URL of the OpenWhisk.")] = None
    namespace: Annotated[
        Optional[str],
        Field(description='Namespace for the action.\nDefaults to "_".\n+optional.'),
    ] = None
    parameters: Annotated[
        Optional[List[TriggerParameter]],
        Field(
            title=(
                "Parameters is the list of key-value extracted from event's payload"
                " that are applied to\nthe trigger resource.\n+optional"
            )
        ),
    ] = None
    payload: Annotated[
        Optional[List[TriggerParameter]],
        Field(
            description=(
                "Payload is the list of key-value extracted from an event payload to construct the request payload."
            )
        ),
    ] = None
    version: Annotated[Optional[str], Field(title="Version for the API.\nDefaults to v1.\n+optional")] = None


class EventSourceStatus(BaseModel):
    status: Optional[Status] = None


class SensorStatus(BaseModel):
    status: Optional[Status] = None


class SlackTrigger(BaseModel):
    attachments: Annotated[
        Optional[str],
        Field(
            title=(
                "Attachments is a JSON format string that represents an array of Slack"
                " attachments according to the attachments API:"
                " https://api.slack.com/reference/messaging/attachments .\n+optional"
            )
        ),
    ] = None
    blocks: Annotated[
        Optional[str],
        Field(
            title=(
                "Blocks is a JSON format string that represents an array of Slack"
                " blocks according to the blocks API:"
                " https://api.slack.com/reference/block-kit/blocks .\n+optional"
            )
        ),
    ] = None
    channel: Annotated[
        Optional[str],
        Field(title=("Channel refers to which Slack channel to send Slack message.\n+optional")),
    ] = None
    message: Annotated[
        Optional[str],
        Field(title=("Message refers to the message to send to the Slack channel.\n+optional")),
    ] = None
    parameters: Annotated[
        Optional[List[TriggerParameter]],
        Field(
            title=(
                "Parameters is the list of key-value extracted from event's payload"
                " that are applied to\nthe trigger resource.\n+optional"
            )
        ),
    ] = None
    sender: Annotated[
        Optional[SlackSender],
        Field(
            title=(
                "Sender refers to additional configuration of the Slack application that sends the message.\n+optional"
            )
        ),
    ] = None
    slack_token: Annotated[
        Optional[v1_1.SecretKeySelector],
        Field(
            alias="slackToken",
            description=(
                "SlackToken refers to the Kubernetes secret that holds the slack token required to send messages."
            ),
        ),
    ] = None
    thread: Annotated[
        Optional[SlackThread],
        Field(title=("Thread refers to additional options for sending messages to a Slack thread.\n+optional")),
    ] = None


class EventDependencyFilter(BaseModel):
    context: Annotated[Optional[EventContext], Field(title="Context filter constraints")] = None
    data: Annotated[
        Optional[List[DataFilter]],
        Field(title="Data filter constraints with escalation"),
    ] = None
    data_logical_operator: Annotated[
        Optional[str],
        Field(
            alias="dataLogicalOperator",
            description=(
                "DataLogicalOperator defines how multiple Data filters (if defined) are"
                " evaluated together.\nAvailable values: and (&&), or (||)\nIs optional"
                " and if left blank treated as and (&&)."
            ),
        ),
    ] = None
    expr_logical_operator: Annotated[
        Optional[str],
        Field(
            alias="exprLogicalOperator",
            description=(
                "ExprLogicalOperator defines how multiple Exprs filters (if defined)"
                " are evaluated together.\nAvailable values: and (&&), or (||)\nIs"
                " optional and if left blank treated as and (&&)."
            ),
        ),
    ] = None
    exprs: Annotated[
        Optional[List[ExprFilter]],
        Field(description=("Exprs contains the list of expressions evaluated against the event payload.")),
    ] = None
    script: Annotated[
        Optional[str],
        Field(
            description=(
                "Script refers to a Lua script evaluated to determine the validity of"
                " an io.argoproj.workflow.v1alpha1."
            )
        ),
    ] = None
    time: Annotated[Optional[TimeFilter], Field(title="Time filter on the event with escalation")] = None


class HTTPTrigger(BaseModel):
    basic_auth: Annotated[
        Optional[BasicAuth],
        Field(
            alias="basicAuth",
            title="BasicAuth configuration for the http request.\n+optional",
        ),
    ] = None
    headers: Annotated[
        Optional[Dict[str, str]],
        Field(title="Headers for the HTTP request.\n+optional"),
    ] = None
    method: Annotated[
        Optional[str],
        Field(
            title=(
                "Method refers to the type of the HTTP request.\nRefer"
                " https://golang.org/src/net/http/method.go for more"
                " io.argoproj.workflow.v1alpha1.\nDefault value is POST.\n+optional"
            )
        ),
    ] = None
    parameters: Annotated[
        Optional[List[TriggerParameter]],
        Field(
            description=(
                "Parameters is the list of key-value extracted from event's payload"
                " that are applied to\nthe HTTP trigger resource."
            )
        ),
    ] = None
    payload: Optional[List[TriggerParameter]] = None
    secure_headers: Annotated[
        Optional[List[SecureHeader]],
        Field(
            alias="secureHeaders",
            title=("Secure Headers stored in Kubernetes Secrets for the HTTP requests.\n+optional"),
        ),
    ] = None
    timeout: Annotated[
        Optional[str],
        Field(
            title=("Timeout refers to the HTTP request timeout in seconds.\nDefault value is 60 seconds.\n+optional")
        ),
    ] = None
    tls: Annotated[
        Optional[TLSConfig],
        Field(title="TLS configuration for the HTTP client.\n+optional"),
    ] = None
    url: Annotated[
        Optional[str],
        Field(description="URL refers to the URL to send HTTP request to."),
    ] = None


class EventDependency(BaseModel):
    event_name: Annotated[
        Optional[str],
        Field(alias="eventName", title="EventName is the name of the event"),
    ] = None
    event_source_name: Annotated[
        Optional[str],
        Field(
            alias="eventSourceName",
            title="EventSourceName is the name of EventSource that Sensor depends on",
        ),
    ] = None
    filters: Annotated[
        Optional[EventDependencyFilter],
        Field(
            title=(
                "Filters and rules governing toleration of success and constraints on the context and data of an event"
            )
        ),
    ] = None
    filters_logical_operator: Annotated[
        Optional[str],
        Field(
            alias="filtersLogicalOperator",
            description=(
                "FiltersLogicalOperator defines how different filters are evaluated"
                " together.\nAvailable values: and (&&), or (||)\nIs optional and if"
                " left blank treated as and (&&)."
            ),
        ),
    ] = None
    name: Annotated[Optional[str], Field(title="Name is a unique name of this dependency")] = None
    transform: Annotated[
        Optional[EventDependencyTransformer],
        Field(title="Transform transforms the event data"),
    ] = None


class TriggerTemplate(BaseModel):
    argo_workflow: Annotated[
        Optional[ArgoWorkflowTrigger],
        Field(
            alias="argoWorkflow",
            title=(
                "ArgoWorkflow refers to the trigger that can perform various operations"
                " on an Argo io.argoproj.workflow.v1alpha1.\n+optional"
            ),
        ),
    ] = None
    aws_lambda: Annotated[
        Optional[AWSLambdaTrigger],
        Field(
            alias="awsLambda",
            title=(
                "AWSLambda refers to the trigger designed to invoke AWS Lambda function"
                " with with on-the-fly constructable payload.\n+optional"
            ),
        ),
    ] = None
    azure_event_hubs: Annotated[
        Optional[AzureEventHubsTrigger],
        Field(
            alias="azureEventHubs",
            title=("AzureEventHubs refers to the trigger send an event to an Azure Event Hub.\n+optional"),
        ),
    ] = None
    azure_service_bus: Annotated[
        Optional[AzureServiceBusTrigger],
        Field(
            alias="azureServiceBus",
            title=("AzureServiceBus refers to the trigger designed to place messages on Azure Service Bus\n+optional"),
        ),
    ] = None
    conditions: Annotated[
        Optional[str],
        Field(
            title=(
                "Conditions is the conditions to execute the trigger.\nFor example:"
                ' "(dep01 || dep02) && dep04"\n+optional'
            )
        ),
    ] = None
    conditions_reset: Annotated[
        Optional[List[ConditionsResetCriteria]],
        Field(alias="conditionsReset", title="Criteria to reset the conditons\n+optional"),
    ] = None
    custom: Annotated[
        Optional[CustomTrigger],
        Field(
            title=(
                "CustomTrigger refers to the trigger designed to connect to a gRPC"
                " trigger server and execute a custom trigger.\n+optional"
            )
        ),
    ] = None
    email: Annotated[
        Optional[EmailTrigger],
        Field(title=("Email refers to the trigger designed to send an email notification\n+optional")),
    ] = None
    http: Annotated[
        Optional[HTTPTrigger],
        Field(
            title=(
                "HTTP refers to the trigger designed to dispatch a HTTP request with"
                " on-the-fly constructable payload.\n+optional"
            )
        ),
    ] = None
    k8s: Annotated[
        Optional[StandardK8STrigger],
        Field(
            title=(
                "StandardK8STrigger refers to the trigger designed to create or update"
                " a generic Kubernetes resource.\n+optional"
            )
        ),
    ] = None
    kafka: Annotated[
        Optional[KafkaTrigger],
        Field(description=("Kafka refers to the trigger designed to place messages on Kafka topic.\n+optional.")),
    ] = None
    log: Annotated[
        Optional[LogTrigger],
        Field(
            title=("Log refers to the trigger designed to invoke log the io.argoproj.workflow.v1alpha1.\n+optional")
        ),
    ] = None
    name: Annotated[Optional[str], Field(description="Name is a unique name of the action to take.")] = None
    nats: Annotated[
        Optional[NATSTrigger],
        Field(description=("NATS refers to the trigger designed to place message on NATS subject.\n+optional.")),
    ] = None
    open_whisk: Annotated[
        Optional[OpenWhiskTrigger],
        Field(
            alias="openWhisk",
            title=("OpenWhisk refers to the trigger designed to invoke OpenWhisk action.\n+optional"),
        ),
    ] = None
    pulsar: Annotated[
        Optional[PulsarTrigger],
        Field(title=("Pulsar refers to the trigger designed to place messages on Pulsar topic.\n+optional")),
    ] = None
    slack: Annotated[
        Optional[SlackTrigger],
        Field(title=("Slack refers to the trigger designed to send slack notification message.\n+optional")),
    ] = None


class Trigger(BaseModel):
    at_least_once: Annotated[
        Optional[bool],
        Field(
            alias="atLeastOnce",
            title=(
                "AtLeastOnce determines the trigger execution semantics.\nDefaults to"
                " false. Trigger execution will use at-most-once semantics.\nIf set to"
                " true, Trigger execution will switch to at-least-once"
                " semantics.\n+kubebuilder:default=false\n+optional"
            ),
        ),
    ] = None
    parameters: Annotated[
        Optional[List[TriggerParameter]],
        Field(title=("Parameters is the list of parameters applied to the trigger template definition")),
    ] = None
    policy: Annotated[
        Optional[TriggerPolicy],
        Field(title=("Policy to configure backoff and execution criteria for the trigger\n+optional")),
    ] = None
    rate_limit: Annotated[
        Optional[RateLimit],
        Field(alias="rateLimit", title="Rate limit, default unit is Second\n+optional"),
    ] = None
    retry_strategy: Annotated[
        Optional[Backoff],
        Field(
            alias="retryStrategy",
            title="Retry strategy, defaults to no retry\n+optional",
        ),
    ] = None
    template: Annotated[
        Optional[TriggerTemplate],
        Field(description="Template describes the trigger specification."),
    ] = None


class Template(BaseModel):
    affinity: Annotated[
        Optional[v1_1.Affinity],
        Field(title="If specified, the pod's scheduling constraints\n+optional"),
    ] = None
    container: Annotated[
        Optional[v1_1.Container],
        Field(title=("Container is the main container image to run in the sensor pod\n+optional")),
    ] = None
    image_pull_secrets: Annotated[
        Optional[List[v1_1.LocalObjectReference]],
        Field(
            alias="imagePullSecrets",
            title=(
                "ImagePullSecrets is an optional list of references to secrets in the"
                " same namespace to use for pulling any of the images used by this"
                " PodSpec.\nIf specified, these secrets will be passed to individual"
                " puller implementations for them to use. For example,\nin the case of"
                " docker, only DockerConfig type secrets are honored.\nMore info:"
                " https://kubernetes.io/docs/concepts/containers/images#specifying-imagepullsecrets-on-a-pod\n+optional\n+patchMergeKey=name\n+patchStrategy=merge"
            ),
        ),
    ] = None
    metadata: Annotated[
        Optional[Metadata],
        Field(title="Metadata sets the pods's metadata, i.e. annotations and labels"),
    ] = None
    node_selector: Annotated[
        Optional[Dict[str, str]],
        Field(
            alias="nodeSelector",
            title=(
                "NodeSelector is a selector which must be true for the pod to fit on a"
                " node.\nSelector which must match a node's labels for the pod to be"
                " scheduled on that node.\nMore info:"
                " https://kubernetes.io/docs/concepts/configuration/assign-pod-node/\n+optional"
            ),
        ),
    ] = None
    priority: Annotated[
        Optional[int],
        Field(
            title=(
                "The priority value. Various system components use this field to find"
                " the\npriority of the EventSource pod. When Priority Admission"
                " Controller is enabled,\nit prevents users from setting this field."
                " The admission controller populates\nthis field from"
                " PriorityClassName.\nThe higher the value, the higher the"
                " priority.\nMore info:"
                " https://kubernetes.io/docs/concepts/configuration/pod-priority-preemption/\n+optional"
            )
        ),
    ] = None
    priority_class_name: Annotated[
        Optional[str],
        Field(
            alias="priorityClassName",
            title=(
                "If specified, indicates the EventSource pod's priority."
                ' "system-node-critical"\nand "system-cluster-critical" are two special'
                " keywords which indicate the\nhighest priorities with the former being"
                " the highest priority. Any other\nname must be defined by creating a"
                " PriorityClass object with that name.\nIf not specified, the pod"
                " priority will be default or zero if there is no\ndefault.\nMore info:"
                " https://kubernetes.io/docs/concepts/configuration/pod-priority-preemption/\n+optional"
            ),
        ),
    ] = None
    security_context: Annotated[
        Optional[v1_1.PodSecurityContext],
        Field(
            alias="securityContext",
            title=(
                "SecurityContext holds pod-level security attributes and common"
                " container settings.\nOptional: Defaults to empty.  See type"
                " description for default values of each field.\n+optional"
            ),
        ),
    ] = None
    service_account_name: Annotated[
        Optional[str],
        Field(
            alias="serviceAccountName",
            title=(
                "ServiceAccountName is the name of the ServiceAccount to use to run"
                " sensor pod.\nMore info:"
                " https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/\n+optional"
            ),
        ),
    ] = None
    tolerations: Annotated[
        Optional[List[v1_1.Toleration]],
        Field(title="If specified, the pod's tolerations.\n+optional"),
    ] = None
    volumes: Annotated[
        Optional[List[v1_1.Volume]],
        Field(
            title=(
                "Volumes is a list of volumes that can be mounted by containers in a"
                " io.argoproj.workflow.v1alpha1.\n+patchStrategy=merge\n+patchMergeKey=name\n+optional"
            )
        ),
    ] = None


class EventSourceSpec(BaseModel):
    amqp: Annotated[Optional[Dict[str, AMQPEventSource]], Field(title="AMQP event sources")] = None
    azure_events_hub: Annotated[
        Optional[Dict[str, AzureEventsHubEventSource]],
        Field(alias="azureEventsHub", title="AzureEventsHub event sources"),
    ] = None
    azure_queue_storage: Annotated[
        Optional[Dict[str, AzureQueueStorageEventSource]],
        Field(alias="azureQueueStorage", title="AzureQueueStorage event source"),
    ] = None
    azure_service_bus: Annotated[
        Optional[Dict[str, AzureServiceBusEventSource]],
        Field(alias="azureServiceBus", title="Azure Service Bus event source"),
    ] = None
    bitbucket: Annotated[
        Optional[Dict[str, BitbucketEventSource]],
        Field(title="Bitbucket event sources"),
    ] = None
    bitbucketserver: Annotated[
        Optional[Dict[str, BitbucketServerEventSource]],
        Field(title="Bitbucket Server event sources"),
    ] = None
    calendar: Annotated[Optional[Dict[str, CalendarEventSource]], Field(title="Calendar event sources")] = None
    emitter: Annotated[Optional[Dict[str, EmitterEventSource]], Field(title="Emitter event source")] = None
    event_bus_name: Annotated[
        Optional[str],
        Field(
            alias="eventBusName",
            title=('EventBusName references to a EventBus name. By default the value is "default"'),
        ),
    ] = None
    file: Annotated[Optional[Dict[str, FileEventSource]], Field(title="File event sources")] = None
    generic: Annotated[Optional[Dict[str, GenericEventSource]], Field(title="Generic event source")] = None
    gerrit: Annotated[Optional[Dict[str, GerritEventSource]], Field(title="Gerrit event source")] = None
    github: Annotated[Optional[Dict[str, GithubEventSource]], Field(title="Github event sources")] = None
    gitlab: Annotated[Optional[Dict[str, GitlabEventSource]], Field(title="Gitlab event sources")] = None
    hdfs: Annotated[Optional[Dict[str, HDFSEventSource]], Field(title="HDFS event sources")] = None
    kafka: Annotated[Optional[Dict[str, KafkaEventSource]], Field(title="Kafka event sources")] = None
    minio: Annotated[Optional[Dict[str, S3Artifact]], Field(title="Minio event sources")] = None
    mqtt: Annotated[Optional[Dict[str, MQTTEventSource]], Field(title="MQTT event sources")] = None
    nats: Annotated[Optional[Dict[str, NATSEventsSource]], Field(title="NATS event sources")] = None
    nsq: Annotated[Optional[Dict[str, NSQEventSource]], Field(title="NSQ event source")] = None
    pub_sub: Annotated[
        Optional[Dict[str, PubSubEventSource]],
        Field(alias="pubSub", title="PubSub event sources"),
    ] = None
    pulsar: Annotated[Optional[Dict[str, PulsarEventSource]], Field(title="Pulsar event source")] = None
    redis: Annotated[Optional[Dict[str, RedisEventSource]], Field(title="Redis event source")] = None
    redis_stream: Annotated[
        Optional[Dict[str, RedisStreamEventSource]],
        Field(alias="redisStream", title="Redis stream source"),
    ] = None
    replicas: Annotated[Optional[int], Field(title="Replicas is the event source deployment replicas")] = None
    resource: Annotated[Optional[Dict[str, ResourceEventSource]], Field(title="Resource event sources")] = None
    service: Annotated[
        Optional[Service],
        Field(title=("Service is the specifications of the service to expose the event source\n+optional")),
    ] = None
    sftp: Annotated[Optional[Dict[str, SFTPEventSource]], Field(title="SFTP event sources")] = None
    slack: Annotated[Optional[Dict[str, SlackEventSource]], Field(title="Slack event sources")] = None
    sns: Annotated[Optional[Dict[str, SNSEventSource]], Field(title="SNS event sources")] = None
    sqs: Annotated[Optional[Dict[str, SQSEventSource]], Field(title="SQS event sources")] = None
    storage_grid: Annotated[
        Optional[Dict[str, StorageGridEventSource]],
        Field(alias="storageGrid", title="StorageGrid event sources"),
    ] = None
    stripe: Annotated[Optional[Dict[str, StripeEventSource]], Field(title="Stripe event sources")] = None
    template: Annotated[
        Optional[Template],
        Field(title="Template is the pod specification for the event source\n+optional"),
    ] = None
    webhook: Annotated[Optional[Dict[str, WebhookEventSource]], Field(title="Webhook event sources")] = None


class SensorSpec(BaseModel):
    dependencies: Annotated[
        Optional[List[EventDependency]],
        Field(description=("Dependencies is a list of the events that this sensor is dependent on.")),
    ] = None
    error_on_failed_round: Annotated[
        Optional[bool],
        Field(
            alias="errorOnFailedRound",
            description=(
                "ErrorOnFailedRound if set to true, marks sensor state as `error` if"
                " the previous trigger round fails.\nOnce sensor state is set to"
                " `error`, no further triggers will be processed."
            ),
        ),
    ] = None
    event_bus_name: Annotated[
        Optional[str],
        Field(
            alias="eventBusName",
            title=('EventBusName references to a EventBus name. By default the value is "default"'),
        ),
    ] = None
    logging_fields: Annotated[
        Optional[Dict[str, str]],
        Field(
            alias="loggingFields",
            title=("LoggingFields add additional key-value pairs when logging happens\n+optional"),
        ),
    ] = None
    replicas: Annotated[Optional[int], Field(title="Replicas is the sensor deployment replicas")] = None
    revision_history_limit: Annotated[
        Optional[int],
        Field(
            alias="revisionHistoryLimit",
            title=("RevisionHistoryLimit specifies how many old deployment revisions to retain\n+optional"),
        ),
    ] = None
    template: Annotated[
        Optional[Template],
        Field(title="Template is the pod specification for the sensor\n+optional"),
    ] = None
    triggers: Annotated[
        Optional[List[Trigger]],
        Field(
            description=(
                "Triggers is a list of the things that this sensor evokes. These are the outputs from this sensor."
            )
        ),
    ] = None


class EventSource(BaseModel):
    metadata: Optional[v1.ObjectMeta] = None
    spec: Optional[EventSourceSpec] = None
    status: Annotated[Optional[EventSourceStatus], Field(title="+optional")] = None


class Sensor(BaseModel):
    metadata: Optional[v1.ObjectMeta] = None
    spec: Optional[SensorSpec] = None
    status: Annotated[Optional[SensorStatus], Field(title="+optional")] = None


class EventSourceList(BaseModel):
    items: Optional[List[EventSource]] = None
    metadata: Optional[v1.ListMeta] = None


class SensorList(BaseModel):
    items: Optional[List[Sensor]] = None
    metadata: Optional[v1.ListMeta] = None
