# pylint: disable=C0115, C0103, C0301

from __future__ import annotations

from enum import Enum
from typing import Annotated, Optional

from pydantic import BaseModel, Field, RootModel

from vdb.lib.cve_model.common import (
    AttackComplexityType,
    AttackRequirementsType,
    AttackVectorType,
    AutomatableType,
    CiaRequirementType,
    CriticalScoreType,
    CriticalSeverityType,
    ExploitMaturityType,
    HighScoreType,
    HighSeverityType,
    LowScoreType,
    LowSeverityType,
    MediumScoreType,
    MediumSeverityType,
    ModifiedAttackComplexityType,
    ModifiedAttackRequirementsType,
    ModifiedAttackVectorType,
    ModifiedPrivilegesRequiredType,
    ModifiedSubCType,
    ModifiedSubIaType,
    ModifiedUserInteractionType,
    ModifiedVulnCiaType,
    NoneScoreType,
    NoneSeverityType,
    PrivilegesRequiredType,
    ProviderUrgencyType,
    RecoveryType,
    SafetyType,
    ScoreType,
    SeverityType,
    SubCiaType,
    UserInteractionType,
    ValueDensityType,
    VulnCiaType,
    VulnerabilityResponseEffortType,
)


class Version(Enum):
    field_4_0 = "4.0"


class Field0(BaseModel):
    environmentalScore: Optional[NoneScoreType] = None
    environmentalSeverity: Optional[NoneSeverityType] = None


class Field0Model(BaseModel):
    environmentalScore: Optional[LowScoreType] = None
    environmentalSeverity: Optional[LowSeverityType] = None


class Field0Model1(BaseModel):
    environmentalScore: Optional[MediumScoreType] = None
    environmentalSeverity: Optional[MediumSeverityType] = None


class Field0Model2(BaseModel):
    environmentalScore: Optional[HighScoreType] = None
    environmentalSeverity: Optional[HighSeverityType] = None


class Field0Model3(BaseModel):
    environmentalScore: Optional[CriticalScoreType] = None
    environmentalSeverity: Optional[CriticalSeverityType] = None


class Field0Model4(BaseModel):
    version: Annotated[Version, Field(description="CVSS Version")]
    vectorString: Annotated[
        str,
        Field(
            pattern="^CVSS:4[.]0/AV:[NALP]/AC:[LH]/AT:[NP]/PR:[NLH]/UI:[NPA]/VC:[HLN]/VI:[HLN]/VA:[HLN]/SC:[HLN]/SI:[HLN]/SA:[HLN](/E:[XAPU])?(/CR:[XHML])?(/IR:[XHML])?(/AR:[XHML])?(/MAV:[XNALP])?(/MAC:[XLH])?(/MAT:[XNP])?(/MPR:[XNLH])?(/MUI:[XNPA])?(/MVC:[XNLH])?(/MVI:[XNLH])?(/MVA:[XNLH])?(/MSC:[XNLH])?(/MSI:[XNLHS])?(/MSA:[XNLHS])?(/S:[XNP])?(/AU:[XNY])?(/R:[XAUI])?(/V:[XDC])?(/RE:[XLMH])?(/U:(X|Clear|Green|Amber|Red))?$"
        ),
    ]
    baseScore: ScoreType
    baseSeverity: SeverityType
    attackVector: Optional[AttackVectorType] = None
    attackComplexity: Optional[AttackComplexityType] = None
    attackRequirements: Optional[AttackRequirementsType] = None
    privilegesRequired: Optional[PrivilegesRequiredType] = None
    userInteraction: Optional[UserInteractionType] = None
    vulnConfidentialityImpact: Optional[VulnCiaType] = None
    vulnIntegrityImpact: Optional[VulnCiaType] = None
    vulnAvailabilityImpact: Optional[VulnCiaType] = None
    subConfidentialityImpact: Optional[SubCiaType] = None
    subIntegrityImpact: Optional[SubCiaType] = None
    subAvailabilityImpact: Optional[SubCiaType] = None
    exploitMaturity: Optional[ExploitMaturityType] = "NOT_DEFINED"
    confidentialityRequirement: Optional[CiaRequirementType] = "NOT_DEFINED"
    integrityRequirement: Optional[CiaRequirementType] = "NOT_DEFINED"
    availabilityRequirement: Optional[CiaRequirementType] = "NOT_DEFINED"
    modifiedAttackVector: Optional[ModifiedAttackVectorType] = "NOT_DEFINED"
    modifiedAttackComplexity: Optional[ModifiedAttackComplexityType] = "NOT_DEFINED"
    modifiedAttackRequirements: Optional[ModifiedAttackRequirementsType] = "NOT_DEFINED"
    modifiedPrivilegesRequired: Optional[ModifiedPrivilegesRequiredType] = "NOT_DEFINED"
    modifiedUserInteraction: Optional[ModifiedUserInteractionType] = "NOT_DEFINED"
    modifiedVulnConfidentialityImpact: Optional[ModifiedVulnCiaType] = "NOT_DEFINED"
    modifiedVulnIntegrityImpact: Optional[ModifiedVulnCiaType] = "NOT_DEFINED"
    modifiedVulnAvailabilityImpact: Optional[ModifiedVulnCiaType] = "NOT_DEFINED"
    modifiedSubConfidentialityImpact: Optional[ModifiedSubCType] = "NOT_DEFINED"
    modifiedSubIntegrityImpact: Optional[ModifiedSubIaType] = "NOT_DEFINED"
    modifiedSubAvailabilityImpact: Optional[ModifiedSubIaType] = "NOT_DEFINED"
    Safety: Optional[SafetyType] = "NOT_DEFINED"
    Automatable: Optional[AutomatableType] = "NOT_DEFINED"
    Recovery: Optional[RecoveryType] = "NOT_DEFINED"
    valueDensity: Optional[ValueDensityType] = "NOT_DEFINED"
    vulnerabilityResponseEffort: Optional[VulnerabilityResponseEffortType] = (
        "NOT_DEFINED"
    )
    providerUrgency: Optional[ProviderUrgencyType] = "NOT_DEFINED"


class Field0Model5(Field0, Field0Model4):
    version: Annotated[Version, Field(description="CVSS Version")]
    vectorString: Annotated[
        str,
        Field(
            pattern="^CVSS:4[.]0/AV:[NALP]/AC:[LH]/AT:[NP]/PR:[NLH]/UI:[NPA]/VC:[HLN]/VI:[HLN]/VA:[HLN]/SC:[HLN]/SI:[HLN]/SA:[HLN](/E:[XAPU])?(/CR:[XHML])?(/IR:[XHML])?(/AR:[XHML])?(/MAV:[XNALP])?(/MAC:[XLH])?(/MAT:[XNP])?(/MPR:[XNLH])?(/MUI:[XNPA])?(/MVC:[XNLH])?(/MVI:[XNLH])?(/MVA:[XNLH])?(/MSC:[XNLH])?(/MSI:[XNLHS])?(/MSA:[XNLHS])?(/S:[XNP])?(/AU:[XNY])?(/R:[XAUI])?(/V:[XDC])?(/RE:[XLMH])?(/U:(X|Clear|Green|Amber|Red))?$"
        ),
    ]
    baseScore: ScoreType
    baseSeverity: SeverityType
    attackVector: Optional[AttackVectorType] = None
    attackComplexity: Optional[AttackComplexityType] = None
    attackRequirements: Optional[AttackRequirementsType] = None
    privilegesRequired: Optional[PrivilegesRequiredType] = None
    userInteraction: Optional[UserInteractionType] = None
    vulnConfidentialityImpact: Optional[VulnCiaType] = None
    vulnIntegrityImpact: Optional[VulnCiaType] = None
    vulnAvailabilityImpact: Optional[VulnCiaType] = None
    subConfidentialityImpact: Optional[SubCiaType] = None
    subIntegrityImpact: Optional[SubCiaType] = None
    subAvailabilityImpact: Optional[SubCiaType] = None
    exploitMaturity: Optional[ExploitMaturityType] = "NOT_DEFINED"
    confidentialityRequirement: Optional[CiaRequirementType] = "NOT_DEFINED"
    integrityRequirement: Optional[CiaRequirementType] = "NOT_DEFINED"
    availabilityRequirement: Optional[CiaRequirementType] = "NOT_DEFINED"
    modifiedAttackVector: Optional[ModifiedAttackVectorType] = "NOT_DEFINED"
    modifiedAttackComplexity: Optional[ModifiedAttackComplexityType] = "NOT_DEFINED"
    modifiedAttackRequirements: Optional[ModifiedAttackRequirementsType] = "NOT_DEFINED"
    modifiedPrivilegesRequired: Optional[ModifiedPrivilegesRequiredType] = "NOT_DEFINED"
    modifiedUserInteraction: Optional[ModifiedUserInteractionType] = "NOT_DEFINED"
    modifiedVulnConfidentialityImpact: Optional[ModifiedVulnCiaType] = "NOT_DEFINED"
    modifiedVulnIntegrityImpact: Optional[ModifiedVulnCiaType] = "NOT_DEFINED"
    modifiedVulnAvailabilityImpact: Optional[ModifiedVulnCiaType] = "NOT_DEFINED"
    modifiedSubConfidentialityImpact: Optional[ModifiedSubCType] = "NOT_DEFINED"
    modifiedSubIntegrityImpact: Optional[ModifiedSubIaType] = "NOT_DEFINED"
    modifiedSubAvailabilityImpact: Optional[ModifiedSubIaType] = "NOT_DEFINED"
    Safety: Optional[SafetyType] = "NOT_DEFINED"
    Automatable: Optional[AutomatableType] = "NOT_DEFINED"
    Recovery: Optional[RecoveryType] = "NOT_DEFINED"
    valueDensity: Optional[ValueDensityType] = "NOT_DEFINED"
    vulnerabilityResponseEffort: Optional[VulnerabilityResponseEffortType] = (
        "NOT_DEFINED"
    )
    providerUrgency: Optional[ProviderUrgencyType] = "NOT_DEFINED"


class Field0Model6(RootModel[Field0Model5]):
    root: Annotated[
        Field0Model5,
        Field(title="JSON Schema for Common Vulnerability Scoring System version 4.0"),
    ]
