# pylint: disable=C0115, C0103, C0301

from __future__ import annotations

from enum import Enum
from typing import Annotated, Optional

from pydantic import BaseModel, Field

from vdb.lib.cve_model.common import (
    AttackComplexityType,
    AttackVectorTypeModel,
    CiaRequirementType,
    CiaType,
    ConfidenceType,
    ExploitCodeMaturityType,
    ModifiedAttackComplexityType,
    ModifiedAttackVectorTypeModel,
    ModifiedCiaType,
    ModifiedPrivilegesRequiredType,
    ModifiedScopeType,
    ModifiedUserInteractionTypeModel,
    PrivilegesRequiredType,
    RemediationLevelType,
    ScopeType,
    ScoreTypeModel,
    SeverityType,
    UserInteractionTypeModel,
)


class Version(Enum):
    field_3_1 = "3.1"


class Version1Model(Enum):
    field_3_0 = "3.0"


class Field1(BaseModel):
    version: Annotated[Version, Field(description="CVSS Version")]
    vectorString: Annotated[
        str,
        Field(
            pattern="^CVSS:3[.]1/((AV:[NALP]|AC:[LH]|PR:[NLH]|UI:[NR]|S:[UC]|[CIA]:[NLH]|E:[XUPFH]|RL:[XOTWU]|RC:[XURC]|[CIA]R:[XLMH]|MAV:[XNALP]|MAC:[XLH]|MPR:[XNLH]|MUI:[XNR]|MS:[XUC]|M[CIA]:[XNLH])/)*(AV:[NALP]|AC:[LH]|PR:[NLH]|UI:[NR]|S:[UC]|[CIA]:[NLH]|E:[XUPFH]|RL:[XOTWU]|RC:[XURC]|[CIA]R:[XLMH]|MAV:[XNALP]|MAC:[XLH]|MPR:[XNLH]|MUI:[XNR]|MS:[XUC]|M[CIA]:[XNLH])$"
        ),
    ]
    attackVector: Optional[AttackVectorTypeModel] = None
    attackComplexity: Optional[AttackComplexityType] = None
    privilegesRequired: Optional[PrivilegesRequiredType] = None
    userInteraction: Optional[UserInteractionTypeModel] = None
    scope: Optional[ScopeType] = None
    confidentialityImpact: Optional[CiaType] = None
    integrityImpact: Optional[CiaType] = None
    availabilityImpact: Optional[CiaType] = None
    baseScore: ScoreTypeModel
    baseSeverity: SeverityType
    exploitCodeMaturity: Optional[ExploitCodeMaturityType] = None
    remediationLevel: Optional[RemediationLevelType] = None
    reportConfidence: Optional[ConfidenceType] = None
    temporalScore: Optional[ScoreTypeModel] = None
    temporalSeverity: Optional[SeverityType] = None
    confidentialityRequirement: Optional[CiaRequirementType] = "NOT_DEFINED"
    integrityRequirement: Optional[CiaRequirementType] = "NOT_DEFINED"
    availabilityRequirement: Optional[CiaRequirementType] = "NOT_DEFINED"
    modifiedAttackVector: Optional[ModifiedAttackVectorTypeModel] = None
    modifiedAttackComplexity: Optional[ModifiedAttackComplexityType] = "NOT_DEFINED"
    modifiedPrivilegesRequired: Optional[ModifiedPrivilegesRequiredType] = "NOT_DEFINED"
    modifiedUserInteraction: Optional[ModifiedUserInteractionTypeModel] = None
    modifiedScope: Optional[ModifiedScopeType] = None
    modifiedConfidentialityImpact: Optional[ModifiedCiaType] = None
    modifiedIntegrityImpact: Optional[ModifiedCiaType] = None
    modifiedAvailabilityImpact: Optional[ModifiedCiaType] = None
    environmentalScore: Optional[ScoreTypeModel] = None
    environmentalSeverity: Optional[SeverityType] = None


class Field0(BaseModel):
    version: Annotated[Version1Model, Field(description="CVSS Version")]
    vectorString: Annotated[
        str,
        Field(
            pattern="^CVSS:3[.]0/((AV:[NALP]|AC:[LH]|PR:[UNLH]|UI:[NR]|S:[UC]|[CIA]:[NLH]|E:[XUPFH]|RL:[XOTWU]|RC:[XURC]|[CIA]R:[XLMH]|MAV:[XNALP]|MAC:[XLH]|MPR:[XUNLH]|MUI:[XNR]|MS:[XUC]|M[CIA]:[XNLH])/)*(AV:[NALP]|AC:[LH]|PR:[UNLH]|UI:[NR]|S:[UC]|[CIA]:[NLH]|E:[XUPFH]|RL:[XOTWU]|RC:[XURC]|[CIA]R:[XLMH]|MAV:[XNALP]|MAC:[XLH]|MPR:[XUNLH]|MUI:[XNR]|MS:[XUC]|M[CIA]:[XNLH])$"
        ),
    ]
    attackVector: Optional[AttackVectorTypeModel] = None
    attackComplexity: Optional[AttackComplexityType] = None
    privilegesRequired: Optional[PrivilegesRequiredType] = None
    userInteraction: Optional[UserInteractionTypeModel] = None
    scope: Optional[ScopeType] = None
    confidentialityImpact: Optional[CiaType] = None
    integrityImpact: Optional[CiaType] = None
    availabilityImpact: Optional[CiaType] = None
    baseScore: ScoreTypeModel
    baseSeverity: SeverityType
    exploitCodeMaturity: Optional[ExploitCodeMaturityType] = None
    remediationLevel: Optional[RemediationLevelType] = None
    reportConfidence: Optional[ConfidenceType] = None
    temporalScore: Optional[ScoreTypeModel] = None
    temporalSeverity: Optional[SeverityType] = None
    confidentialityRequirement: Optional[CiaRequirementType] = "NOT_DEFINED"
    integrityRequirement: Optional[CiaRequirementType] = "NOT_DEFINED"
    availabilityRequirement: Optional[CiaRequirementType] = "NOT_DEFINED"
    modifiedAttackVector: Optional[ModifiedAttackVectorTypeModel] = None
    modifiedAttackComplexity: Optional[ModifiedAttackComplexityType] = "NOT_DEFINED"
    modifiedPrivilegesRequired: Optional[ModifiedPrivilegesRequiredType] = "NOT_DEFINED"
    modifiedUserInteraction: Optional[ModifiedUserInteractionTypeModel] = None
    modifiedScope: Optional[ModifiedScopeType] = None
    modifiedConfidentialityImpact: Optional[ModifiedCiaType] = None
    modifiedIntegrityImpact: Optional[ModifiedCiaType] = None
    modifiedAvailabilityImpact: Optional[ModifiedCiaType] = None
    environmentalScore: Optional[ScoreTypeModel] = None
    environmentalSeverity: Optional[SeverityType] = None
