# pylint: disable=C0115, C0103, C0301

from __future__ import annotations

from enum import Enum
from typing import Annotated, Optional

from pydantic import BaseModel, Field

from vdb.lib.cve_model.common import (
    AccessComplexityType,
    AccessVectorType,
    AuthenticationType,
    CiaRequirementType,
    CiaTypeModel,
    CollateralDamagePotentialType,
    ExploitabilityType,
    RemediationLevelType,
    ReportConfidenceType,
    ScoreTypeModel,
    TargetDistributionType,
)


class Version(Enum):
    field_2_0 = "2.0"


class Field0(BaseModel):
    version: Annotated[Version, Field(description="CVSS Version")]
    vectorString: Annotated[
        str,
        Field(
            pattern="^((AV:[NAL]|AC:[LMH]|Au:[MSN]|[CIA]:[NPC]|E:(U|POC|F|H|ND)|RL:(OF|TF|W|U|ND)|RC:(UC|UR|C|ND)|CDP:(N|L|LM|MH|H|ND)|TD:(N|L|M|H|ND)|[CIA]R:(L|M|H|ND))/)*(AV:[NAL]|AC:[LMH]|Au:[MSN]|[CIA]:[NPC]|E:(U|POC|F|H|ND)|RL:(OF|TF|W|U|ND)|RC:(UC|UR|C|ND)|CDP:(N|L|LM|MH|H|ND)|TD:(N|L|M|H|ND)|[CIA]R:(L|M|H|ND))$"
        ),
    ]
    accessVector: Optional[AccessVectorType] = None
    accessComplexity: Optional[AccessComplexityType] = None
    authentication: Optional[AuthenticationType] = None
    confidentialityImpact: Optional[CiaTypeModel] = None
    integrityImpact: Optional[CiaTypeModel] = None
    availabilityImpact: Optional[CiaTypeModel] = None
    baseScore: ScoreTypeModel
    exploitability: Optional[ExploitabilityType] = None
    remediationLevel: Optional[RemediationLevelType] = None
    reportConfidence: Optional[ReportConfidenceType] = None
    temporalScore: Optional[ScoreTypeModel] = None
    collateralDamagePotential: Optional[CollateralDamagePotentialType] = None
    targetDistribution: Optional[TargetDistributionType] = None
    confidentialityRequirement: Optional[CiaRequirementType] = "NOT_DEFINED"
    integrityRequirement: Optional[CiaRequirementType] = "NOT_DEFINED"
    availabilityRequirement: Optional[CiaRequirementType] = "NOT_DEFINED"
    environmentalScore: Optional[ScoreTypeModel] = None
