# pylint: disable=C0115, C0103, C0301

from enum import Enum
from typing import Annotated, Literal

from pydantic import Field, RootModel


class AttackVectorType(Enum):
    NETWORK = "NETWORK"
    ADJACENT = "ADJACENT"
    LOCAL = "LOCAL"
    PHYSICAL = "PHYSICAL"


class ModifiedAttackVectorType(Enum):
    NETWORK = "NETWORK"
    ADJACENT = "ADJACENT"
    LOCAL = "LOCAL"
    PHYSICAL = "PHYSICAL"
    NOT_DEFINED = "NOT_DEFINED"


class AttackComplexityType(Enum):
    HIGH = "HIGH"
    LOW = "LOW"


class ModifiedAttackComplexityType(Enum):
    HIGH = "HIGH"
    LOW = "LOW"
    NOT_DEFINED = "NOT_DEFINED"


class AttackRequirementsType(Enum):
    NONE = "NONE"
    PRESENT = "PRESENT"


class ModifiedAttackRequirementsType(Enum):
    NONE = "NONE"
    PRESENT = "PRESENT"
    NOT_DEFINED = "NOT_DEFINED"


class PrivilegesRequiredType(Enum):
    HIGH = "HIGH"
    LOW = "LOW"
    NONE = "NONE"


class ModifiedPrivilegesRequiredType(Enum):
    HIGH = "HIGH"
    LOW = "LOW"
    NONE = "NONE"
    NOT_DEFINED = "NOT_DEFINED"


class UserInteractionType(Enum):
    NONE = "NONE"
    PASSIVE = "PASSIVE"
    ACTIVE = "ACTIVE"


class ModifiedUserInteractionType(Enum):
    NONE = "NONE"
    PASSIVE = "PASSIVE"
    ACTIVE = "ACTIVE"
    NOT_DEFINED = "NOT_DEFINED"


class VulnCiaType(Enum):
    NONE = "NONE"
    LOW = "LOW"
    HIGH = "HIGH"


class ModifiedVulnCiaType(Enum):
    NONE = "NONE"
    LOW = "LOW"
    HIGH = "HIGH"
    NOT_DEFINED = "NOT_DEFINED"


class SubCiaType(Enum):
    NONE = "NONE"
    LOW = "LOW"
    HIGH = "HIGH"


class ModifiedSubCType(Enum):
    NONE = "NONE"
    LOW = "LOW"
    HIGH = "HIGH"
    NOT_DEFINED = "NOT_DEFINED"


class ModifiedSubIaType(Enum):
    NONE = "NONE"
    LOW = "LOW"
    HIGH = "HIGH"
    SAFETY = "SAFETY"
    NOT_DEFINED = "NOT_DEFINED"


class ExploitMaturityType(Enum):
    UNREPORTED = "UNREPORTED"
    PROOF_OF_CONCEPT = "PROOF_OF_CONCEPT"
    ATTACKED = "ATTACKED"
    NOT_DEFINED = "NOT_DEFINED"


class CiaRequirementType(Enum):
    LOW = "LOW"
    MEDIUM = "MEDIUM"
    HIGH = "HIGH"
    NOT_DEFINED = "NOT_DEFINED"


class SafetyType(Enum):
    NEGLIGIBLE = "NEGLIGIBLE"
    PRESENT = "PRESENT"
    NOT_DEFINED = "NOT_DEFINED"


class AutomatableType(Enum):
    NO = "NO"
    YES = "YES"
    NOT_DEFINED = "NOT_DEFINED"


class RecoveryType(Enum):
    AUTOMATIC = "AUTOMATIC"
    USER = "USER"
    IRRECOVERABLE = "IRRECOVERABLE"
    NOT_DEFINED = "NOT_DEFINED"


class ValueDensityType(Enum):
    DIFFUSE = "DIFFUSE"
    CONCENTRATED = "CONCENTRATED"
    NOT_DEFINED = "NOT_DEFINED"


class VulnerabilityResponseEffortType(Enum):
    LOW = "LOW"
    MODERATE = "MODERATE"
    HIGH = "HIGH"
    NOT_DEFINED = "NOT_DEFINED"


class ProviderUrgencyType(Enum):
    CLEAR = "CLEAR"
    GREEN = "GREEN"
    AMBER = "AMBER"
    RED = "RED"
    NOT_DEFINED = "NOT_DEFINED"


class ScoreType(Enum):
    number_0_0 = 0.0
    number_0_1 = 0.1
    number_0_2 = 0.2
    number_0_3 = 0.3
    number_0_4 = 0.4
    number_0_5 = 0.5
    number_0_6 = 0.6
    number_0_7 = 0.7
    number_0_8 = 0.8
    number_0_9 = 0.9
    number_1_0 = 1.0
    number_1_1 = 1.1
    number_1_2 = 1.2
    number_1_3 = 1.3
    number_1_4 = 1.4
    number_1_5 = 1.5
    number_1_6 = 1.6
    number_1_7 = 1.7
    number_1_8 = 1.8
    number_1_9 = 1.9
    number_2_0 = 2.0
    number_2_1 = 2.1
    number_2_2 = 2.2
    number_2_3 = 2.3
    number_2_4 = 2.4
    number_2_5 = 2.5
    number_2_6 = 2.6
    number_2_7 = 2.7
    number_2_8 = 2.8
    number_2_9 = 2.9
    number_3_0 = 3.0
    number_3_1 = 3.1
    number_3_2 = 3.2
    number_3_3 = 3.3
    number_3_4 = 3.4
    number_3_5 = 3.5
    number_3_6 = 3.6
    number_3_7 = 3.7
    number_3_8 = 3.8
    number_3_9 = 3.9
    number_4_0 = 4.0
    number_4_1 = 4.1
    number_4_2 = 4.2
    number_4_3 = 4.3
    number_4_4 = 4.4
    number_4_5 = 4.5
    number_4_6 = 4.6
    number_4_7 = 4.7
    number_4_8 = 4.8
    number_4_9 = 4.9
    number_5_0 = 5.0
    number_5_1 = 5.1
    number_5_2 = 5.2
    number_5_3 = 5.3
    number_5_4 = 5.4
    number_5_5 = 5.5
    number_5_6 = 5.6
    number_5_7 = 5.7
    number_5_8 = 5.8
    number_5_9 = 5.9
    number_6_0 = 6.0
    number_6_1 = 6.1
    number_6_2 = 6.2
    number_6_3 = 6.3
    number_6_4 = 6.4
    number_6_5 = 6.5
    number_6_6 = 6.6
    number_6_7 = 6.7
    number_6_8 = 6.8
    number_6_9 = 6.9
    number_7_0 = 7.0
    number_7_1 = 7.1
    number_7_2 = 7.2
    number_7_3 = 7.3
    number_7_4 = 7.4
    number_7_5 = 7.5
    number_7_6 = 7.6
    number_7_7 = 7.7
    number_7_8 = 7.8
    number_7_9 = 7.9
    number_8_0 = 8.0
    number_8_1 = 8.1
    number_8_2 = 8.2
    number_8_3 = 8.3
    number_8_4 = 8.4
    number_8_5 = 8.5
    number_8_6 = 8.6
    number_8_7 = 8.7
    number_8_8 = 8.8
    number_8_9 = 8.9
    number_9_0 = 9.0
    number_9_1 = 9.1
    number_9_2 = 9.2
    number_9_3 = 9.3
    number_9_4 = 9.4
    number_9_5 = 9.5
    number_9_6 = 9.6
    number_9_7 = 9.7
    number_9_8 = 9.8
    number_9_9 = 9.9
    number_10_0 = 10.0


class NoneScoreType(RootModel[float]):
    root: Annotated[float, Field(ge=0.0, le=0.0)]


class LowScoreType(Enum):
    number_0_1 = 0.1
    number_0_2 = 0.2
    number_0_3 = 0.3
    number_0_4 = 0.4
    number_0_5 = 0.5
    number_0_6 = 0.6
    number_0_7 = 0.7
    number_0_8 = 0.8
    number_0_9 = 0.9
    number_1_0 = 1.0
    number_1_1 = 1.1
    number_1_2 = 1.2
    number_1_3 = 1.3
    number_1_4 = 1.4
    number_1_5 = 1.5
    number_1_6 = 1.6
    number_1_7 = 1.7
    number_1_8 = 1.8
    number_1_9 = 1.9
    number_2_0 = 2.0
    number_2_1 = 2.1
    number_2_2 = 2.2
    number_2_3 = 2.3
    number_2_4 = 2.4
    number_2_5 = 2.5
    number_2_6 = 2.6
    number_2_7 = 2.7
    number_2_8 = 2.8
    number_2_9 = 2.9
    number_3_0 = 3.0
    number_3_1 = 3.1
    number_3_2 = 3.2
    number_3_3 = 3.3
    number_3_4 = 3.4
    number_3_5 = 3.5
    number_3_6 = 3.6
    number_3_7 = 3.7
    number_3_8 = 3.8
    number_3_9 = 3.9


class MediumScoreType(Enum):
    number_4_0 = 4.0
    number_4_1 = 4.1
    number_4_2 = 4.2
    number_4_3 = 4.3
    number_4_4 = 4.4
    number_4_5 = 4.5
    number_4_6 = 4.6
    number_4_7 = 4.7
    number_4_8 = 4.8
    number_4_9 = 4.9
    number_5_0 = 5.0
    number_5_1 = 5.1
    number_5_2 = 5.2
    number_5_3 = 5.3
    number_5_4 = 5.4
    number_5_5 = 5.5
    number_5_6 = 5.6
    number_5_7 = 5.7
    number_5_8 = 5.8
    number_5_9 = 5.9
    number_6_0 = 6.0
    number_6_1 = 6.1
    number_6_2 = 6.2
    number_6_3 = 6.3
    number_6_4 = 6.4
    number_6_5 = 6.5
    number_6_6 = 6.6
    number_6_7 = 6.7
    number_6_8 = 6.8
    number_6_9 = 6.9


class HighScoreType(Enum):
    number_7_0 = 7.0
    number_7_1 = 7.1
    number_7_2 = 7.2
    number_7_3 = 7.3
    number_7_4 = 7.4
    number_7_5 = 7.5
    number_7_6 = 7.6
    number_7_7 = 7.7
    number_7_8 = 7.8
    number_7_9 = 7.9
    number_8_0 = 8.0
    number_8_1 = 8.1
    number_8_2 = 8.2
    number_8_3 = 8.3
    number_8_4 = 8.4
    number_8_5 = 8.5
    number_8_6 = 8.6
    number_8_7 = 8.7
    number_8_8 = 8.8
    number_8_9 = 8.9


class CriticalScoreType(Enum):
    number_9_0 = 9.0
    number_9_1 = 9.1
    number_9_2 = 9.2
    number_9_3 = 9.3
    number_9_4 = 9.4
    number_9_5 = 9.5
    number_9_6 = 9.6
    number_9_7 = 9.7
    number_9_8 = 9.8
    number_9_9 = 9.9
    number_10_0 = 10.0


class SeverityType(Enum):
    NONE = "NONE"
    LOW = "LOW"
    MEDIUM = "MEDIUM"
    HIGH = "HIGH"
    CRITICAL = "CRITICAL"


class NoneSeverityType(RootModel[Literal["NONE"]]):
    root: Literal["NONE"]


class LowSeverityType(RootModel[Literal["LOW"]]):
    root: Literal["LOW"]


class MediumSeverityType(RootModel[Literal["MEDIUM"]]):
    root: Literal["MEDIUM"]


class HighSeverityType(RootModel[Literal["HIGH"]]):
    root: Literal["HIGH"]


class CriticalSeverityType(RootModel[Literal["CRITICAL"]]):
    root: Literal["CRITICAL"]


class AttackVectorTypeModel(Enum):
    NETWORK = "NETWORK"
    ADJACENT_NETWORK = "ADJACENT_NETWORK"
    LOCAL = "LOCAL"
    PHYSICAL = "PHYSICAL"


class ModifiedAttackVectorTypeModel(Enum):
    NETWORK = "NETWORK"
    ADJACENT_NETWORK = "ADJACENT_NETWORK"
    LOCAL = "LOCAL"
    PHYSICAL = "PHYSICAL"
    NOT_DEFINED = "NOT_DEFINED"


class UserInteractionTypeModel(Enum):
    NONE = "NONE"
    REQUIRED = "REQUIRED"


class ModifiedUserInteractionTypeModel(Enum):
    NONE = "NONE"
    REQUIRED = "REQUIRED"
    NOT_DEFINED = "NOT_DEFINED"


class ScopeType(Enum):
    UNCHANGED = "UNCHANGED"
    CHANGED = "CHANGED"


class ModifiedScopeType(Enum):
    UNCHANGED = "UNCHANGED"
    CHANGED = "CHANGED"
    NOT_DEFINED = "NOT_DEFINED"


class CiaType(Enum):
    NONE = "NONE"
    LOW = "LOW"
    HIGH = "HIGH"


class ModifiedCiaType(Enum):
    NONE = "NONE"
    LOW = "LOW"
    HIGH = "HIGH"
    NOT_DEFINED = "NOT_DEFINED"


class ExploitCodeMaturityType(Enum):
    UNPROVEN = "UNPROVEN"
    PROOF_OF_CONCEPT = "PROOF_OF_CONCEPT"
    FUNCTIONAL = "FUNCTIONAL"
    HIGH = "HIGH"
    NOT_DEFINED = "NOT_DEFINED"


class RemediationLevelType(Enum):
    OFFICIAL_FIX = "OFFICIAL_FIX"
    TEMPORARY_FIX = "TEMPORARY_FIX"
    WORKAROUND = "WORKAROUND"
    UNAVAILABLE = "UNAVAILABLE"
    NOT_DEFINED = "NOT_DEFINED"


class ConfidenceType(Enum):
    UNKNOWN = "UNKNOWN"
    REASONABLE = "REASONABLE"
    CONFIRMED = "CONFIRMED"
    NOT_DEFINED = "NOT_DEFINED"


class ScoreTypeModel(RootModel[float]):
    root: Annotated[float, Field(ge=0.0, le=10.0)]


class AccessVectorType(Enum):
    NETWORK = "NETWORK"
    ADJACENT_NETWORK = "ADJACENT_NETWORK"
    LOCAL = "LOCAL"


class AccessComplexityType(Enum):
    HIGH = "HIGH"
    MEDIUM = "MEDIUM"
    LOW = "LOW"


class AuthenticationType(Enum):
    MULTIPLE = "MULTIPLE"
    SINGLE = "SINGLE"
    NONE = "NONE"


class CiaTypeModel(Enum):
    NONE = "NONE"
    PARTIAL = "PARTIAL"
    COMPLETE = "COMPLETE"


class ExploitabilityType(Enum):
    UNPROVEN = "UNPROVEN"
    PROOF_OF_CONCEPT = "PROOF_OF_CONCEPT"
    FUNCTIONAL = "FUNCTIONAL"
    HIGH = "HIGH"
    NOT_DEFINED = "NOT_DEFINED"


class ReportConfidenceType(Enum):
    UNCONFIRMED = "UNCONFIRMED"
    UNCORROBORATED = "UNCORROBORATED"
    CONFIRMED = "CONFIRMED"
    NOT_DEFINED = "NOT_DEFINED"


class CollateralDamagePotentialType(Enum):
    NONE = "NONE"
    LOW = "LOW"
    LOW_MEDIUM = "LOW_MEDIUM"
    MEDIUM_HIGH = "MEDIUM_HIGH"
    HIGH = "HIGH"
    NOT_DEFINED = "NOT_DEFINED"


class TargetDistributionType(Enum):
    NONE = "NONE"
    LOW = "LOW"
    MEDIUM = "MEDIUM"
    HIGH = "HIGH"
    NOT_DEFINED = "NOT_DEFINED"
