from typing import Dict, TypedDict

from waypoint.enum import Game


class MapEntry(TypedDict):
    game: Game
    map: str


map_ids: Dict[int, MapEntry] = {
    0: {"game": Game.HALO_CE, "map": "Pillar Of Autumn"},
    1: {"game": Game.HALO_CE, "map": "Halo"},
    2: {"game": Game.HALO_CE, "map": "Truth And Reconciliation"},
    3: {"game": Game.HALO_CE, "map": "Silent Cartographer"},
    4: {"game": Game.HALO_CE, "map": "Assault On The Control Room"},
    5: {"game": Game.HALO_CE, "map": "343 Guilty Spark"},
    6: {"game": Game.HALO_CE, "map": "The Library"},
    7: {"game": Game.HALO_CE, "map": "Two Betrayals"},
    8: {"game": Game.HALO_CE, "map": "Keyes"},
    9: {"game": Game.HALO_CE, "map": "The Maw"},
    10: {"game": Game.HALO_CE, "map": "Battle Creek"},
    11: {"game": Game.HALO_CE, "map": "Sidewinder"},
    12: {"game": Game.HALO_CE, "map": "Damnation"},
    13: {"game": Game.HALO_CE, "map": "Rat Race"},
    14: {"game": Game.HALO_CE, "map": "Prisoner"},
    15: {"game": Game.HALO_CE, "map": "Hang Em High"},
    16: {"game": Game.HALO_CE, "map": "Chill Out"},
    17: {"game": Game.HALO_CE, "map": "Derelict"},
    18: {"game": Game.HALO_CE, "map": "Boarding Action"},
    19: {"game": Game.HALO_CE, "map": "Chiron"},
    20: {"game": Game.HALO_CE, "map": "Blood Gulch"},
    21: {"game": Game.HALO_CE, "map": "Wizard"},
    22: {"game": Game.HALO_CE, "map": "Longest"},
    23: {"game": Game.HALO_CE, "map": "Death Island"},
    24: {"game": Game.HALO_CE, "map": "Danger Canyon"},
    25: {"game": Game.HALO_CE, "map": "Infinity"},
    26: {"game": Game.HALO_CE, "map": "Timberland"},
    27: {"game": Game.HALO_CE, "map": "Ice Fields"},
    28: {"game": Game.HALO_CE, "map": "Gephyrophobia"},
    29: {"game": Game.HALO_2, "map": "The Heretic"},
    30: {"game": Game.HALO_2, "map": "The Armory"},
    31: {"game": Game.HALO_2, "map": "Cairo Station"},
    32: {"game": Game.HALO_2, "map": "Outskirts"},
    33: {"game": Game.HALO_2, "map": "Metropolis"},
    34: {"game": Game.HALO_2, "map": "The Arbiter"},
    35: {"game": Game.HALO_2, "map": "The Oracle"},
    36: {"game": Game.HALO_2, "map": "Delta Halo"},
    37: {"game": Game.HALO_2, "map": "Regret"},
    38: {"game": Game.HALO_2, "map": "Sacred Icon"},
    39: {"game": Game.HALO_2, "map": "Quarantine Zone"},
    40: {"game": Game.HALO_2, "map": "Gravemind"},
    41: {"game": Game.HALO_2, "map": "Uprising"},
    42: {"game": Game.HALO_2, "map": "High Charity"},
    43: {"game": Game.HALO_2, "map": "The Great Journey"},
    44: {"game": Game.HALO_2, "map": "Lockout"},
    45: {"game": Game.HALO_2, "map": "Ascension"},
    46: {"game": Game.HALO_2, "map": "Midship"},
    47: {"game": Game.HALO_2, "map": "Ivory Tower"},
    48: {"game": Game.HALO_2, "map": "Beaver Creek"},
    49: {"game": Game.HALO_2, "map": "Burial Mounds"},
    50: {"game": Game.HALO_2, "map": "Colossus"},
    51: {"game": Game.HALO_2, "map": "Zanzibar"},
    52: {"game": Game.HALO_2, "map": "Coagulation"},
    53: {"game": Game.HALO_2, "map": "Headlong"},
    54: {"game": Game.HALO_2, "map": "Waterworks"},
    55: {"game": Game.HALO_2, "map": "Foundation"},
    56: {"game": Game.HALO_2, "map": "Containment"},
    57: {"game": Game.HALO_2, "map": "Warlock"},
    58: {"game": Game.HALO_2, "map": "Sanctuary"},
    59: {"game": Game.HALO_2, "map": "Turf"},
    60: {"game": Game.HALO_2, "map": "Backwash"},
    61: {"game": Game.HALO_2, "map": "Elongation"},
    62: {"game": Game.HALO_2, "map": "Gemini"},
    63: {"game": Game.HALO_2, "map": "Relic"},
    64: {"game": Game.HALO_2, "map": "Terminal"},
    65: {"game": Game.HALO_2, "map": "Desolation"},
    66: {"game": Game.HALO_2, "map": "Tombstone"},
    67: {"game": Game.HALO_2, "map": "District"},
    68: {"game": Game.HALO_2, "map": "Uplift"},
    69: {"game": Game.HALO_3, "map": "Arrival"},
    70: {"game": Game.HALO_3, "map": "Sierra 117"},
    71: {"game": Game.HALO_3, "map": "Crows Nest"},
    72: {"game": Game.HALO_3, "map": "Tsavo Highway"},
    73: {"game": Game.HALO_3, "map": "The Storm"},
    74: {"game": Game.HALO_3, "map": "Floodgate"},
    75: {"game": Game.HALO_3, "map": "The Ark"},
    76: {"game": Game.HALO_3, "map": "The Covenant"},
    77: {"game": Game.HALO_3, "map": "Cortana"},
    78: {"game": Game.HALO_3, "map": "Halo"},
    79: {"game": Game.HALO_3, "map": "Construct"},
    80: {"game": Game.HALO_3, "map": "Epitaph"},
    81: {"game": Game.HALO_3, "map": "Guardian"},
    82: {"game": Game.HALO_3, "map": "High Ground"},
    83: {"game": Game.HALO_3, "map": "Isolation"},
    84: {"game": Game.HALO_3, "map": "Last Resort"},
    85: {"game": Game.HALO_3, "map": "Narrows"},
    86: {"game": Game.HALO_3, "map": "Sandtrap"},
    87: {"game": Game.HALO_3, "map": "Snowbound"},
    88: {"game": Game.HALO_3, "map": "The Pit"},
    89: {"game": Game.HALO_3, "map": "Valhalla"},
    90: {"game": Game.HALO_3, "map": "Foundry"},
    91: {"game": Game.HALO_3, "map": "Rats Nest"},
    92: {"game": Game.HALO_3, "map": "Standoff"},
    93: {"game": Game.HALO_3, "map": "Avalanche"},
    94: {"game": Game.HALO_3, "map": "Blackout"},
    95: {"game": Game.HALO_3, "map": "Ghost Town"},
    96: {"game": Game.HALO_3, "map": "Cold Storage"},
    97: {"game": Game.HALO_3, "map": "Assembly"},
    98: {"game": Game.HALO_3, "map": "Orbital"},
    99: {"game": Game.HALO_3, "map": "Sandbox"},
    100: {"game": Game.HALO_3, "map": "Citadel"},
    101: {"game": Game.HALO_3, "map": "Heretic"},
    102: {"game": Game.HALO_3, "map": "Longshore"},
    103: {"game": Game.HALO_4, "map": "Prologue"},
    104: {"game": Game.HALO_4, "map": "Dawn"},
    105: {"game": Game.HALO_4, "map": "Requiem"},
    106: {"game": Game.HALO_4, "map": "Forerunner"},
    107: {"game": Game.HALO_4, "map": "Infinity"},
    108: {"game": Game.HALO_4, "map": "Reclaimer"},
    109: {"game": Game.HALO_4, "map": "Shutdown"},
    110: {"game": Game.HALO_4, "map": "Composer"},
    111: {"game": Game.HALO_4, "map": "Midnight"},
    112: {"game": Game.HALO_4, "map": "Epilogue"},
    113: {"game": Game.HALO_4, "map": "Multiplayer First Donotuse Or Remove"},
    114: {"game": Game.HALO_4, "map": "Adrift"},
    115: {"game": Game.HALO_4, "map": "Abandon"},
    116: {"game": Game.HALO_4, "map": "Complex"},
    117: {"game": Game.HALO_4, "map": "Exile"},
    118: {"game": Game.HALO_4, "map": "Haven"},
    119: {"game": Game.HALO_4, "map": "Longbow"},
    120: {"game": Game.HALO_4, "map": "Meltdown"},
    121: {"game": Game.HALO_4, "map": "Ragnarok"},
    122: {"game": Game.HALO_4, "map": "Solace"},
    123: {"game": Game.HALO_4, "map": "Vortex"},
    124: {"game": Game.HALO_4, "map": "Ravine"},
    125: {"game": Game.HALO_4, "map": "Impact"},
    126: {"game": Game.HALO_4, "map": "Erosion"},
    127: {"game": Game.HALO_4, "map": "Forge Island"},
    128: {"game": Game.HALO_4, "map": "Wreckage"},
    129: {"game": Game.HALO_4, "map": "Harvest"},
    130: {"game": Game.HALO_4, "map": "Shatter"},
    131: {"game": Game.HALO_4, "map": "Landfall"},
    132: {"game": Game.HALO_4, "map": "Monolith"},
    133: {"game": Game.HALO_4, "map": "Skyline"},
    134: {"game": Game.HALO_4, "map": "Daybreak"},
    135: {"game": Game.HALO_4, "map": "Outcast"},
    136: {"game": Game.HALO_4, "map": "Perdition"},
    137: {"game": Game.HALO_4, "map": "Pitfall"},
    138: {"game": Game.HALO_4, "map": "Vertigo"},
    139: {"game": Game.HALO_4, "map": "Spartan Ops First Donotuse Or Remove"},
    140: {"game": Game.HALO_4, "map": "Ff Chopperbowl"},
    141: {"game": Game.HALO_4, "map": "Ff Sniperalley"},
    142: {"game": Game.HALO_4, "map": "Ff Fortsw"},
    143: {"game": Game.HALO_4, "map": "Ff Temple"},
    144: {"game": Game.HALO_4, "map": "Ff Scurve"},
    145: {"game": Game.HALO_4, "map": "Ff Courtyard"},
    146: {"game": Game.HALO_4, "map": "Ff Complex"},
    147: {"game": Game.HALO_4, "map": "Ff Valhalla"},
    148: {"game": Game.HALO_4, "map": "Ff Factory"},
    149: {"game": Game.HALO_4, "map": "Ff Mezzanie"},
    150: {"game": Game.HALO_4, "map": "Ff Caverns"},
    151: {"game": Game.HALO_4, "map": "Ff Vortex"},
    152: {"game": Game.HALO_4, "map": "Ff Breach"},
    153: {"game": Game.HALO_4, "map": "Ff Hillside"},
    154: {"game": Game.HALO_4, "map": "Ff Engine"},
    155: {"game": Game.HALO_2_ANNIVERSARY, "map": "Lockout"},
    156: {"game": Game.HALO_2_ANNIVERSARY, "map": "Ascension"},
    157: {"game": Game.HALO_2_ANNIVERSARY, "map": "Zanzibar"},
    158: {"game": Game.HALO_2_ANNIVERSARY, "map": "Coagulation"},
    159: {"game": Game.HALO_2_ANNIVERSARY, "map": "Warlock"},
    160: {"game": Game.HALO_2_ANNIVERSARY, "map": "Sanctuary"},
    161: {"game": Game.HALO_2_ANNIVERSARY, "map": "Forge Skybox01"},
    162: {"game": Game.HALO_2_ANNIVERSARY, "map": "Forge Skybox02"},
    163: {"game": Game.HALO_2_ANNIVERSARY, "map": "Forge Skybox03"},
    164: {"game": Game.HALO_3, "map": "Extracredit First Donotuse Or Remove"},
    165: {"game": Game.HALO_3, "map": "Epilogue"},
    177: {"game": Game.HALO_2_ANNIVERSARY, "map": "Relic"},
    178: {"game": Game.HALO_REACH, "map": "Noble Actual"},
    179: {"game": Game.HALO_REACH, "map": "Winter Contingency"},
    180: {"game": Game.HALO_REACH, "map": "Oni Sword Base"},
    181: {"game": Game.HALO_REACH, "map": "Nightfall"},
    182: {"game": Game.HALO_REACH, "map": "Tip Of The Spear"},
    183: {"game": Game.HALO_REACH, "map": "Long Night Of Solace"},
    184: {"game": Game.HALO_REACH, "map": "Exodus"},
    185: {"game": Game.HALO_REACH, "map": "New Alexandria"},
    186: {"game": Game.HALO_REACH, "map": "The Package"},
    187: {"game": Game.HALO_REACH, "map": "The Pillar Of Autumn"},
    188: {"game": Game.HALO_REACH, "map": "The Pillar Of Autumn Credits"},
    189: {"game": Game.HALO_REACH, "map": "Lone Wolf"},
    190: {"game": Game.HALO_REACH, "map": "Boardwalk"},
    191: {"game": Game.HALO_REACH, "map": "Boneyard"},
    192: {"game": Game.HALO_REACH, "map": "Countdown"},
    193: {"game": Game.HALO_REACH, "map": "Powerhouse"},
    194: {"game": Game.HALO_REACH, "map": "Reflection"},
    195: {"game": Game.HALO_REACH, "map": "Spire"},
    196: {"game": Game.HALO_REACH, "map": "Sword Base"},
    197: {"game": Game.HALO_REACH, "map": "Zealot"},
    198: {"game": Game.HALO_REACH, "map": "Anchor 9"},
    199: {"game": Game.HALO_REACH, "map": "Breakpoint"},
    200: {"game": Game.HALO_REACH, "map": "Tempest"},
    201: {"game": Game.HALO_REACH, "map": "Condemned"},
    202: {"game": Game.HALO_REACH, "map": "Highlands"},
    203: {"game": Game.HALO_REACH, "map": "Battle Canyon"},
    204: {"game": Game.HALO_REACH, "map": "Penance"},
    205: {"game": Game.HALO_REACH, "map": "Ridgeline"},
    206: {"game": Game.HALO_REACH, "map": "Solitary"},
    207: {"game": Game.HALO_REACH, "map": "High Noon"},
    208: {"game": Game.HALO_REACH, "map": "Breakneck"},
    209: {"game": Game.HALO_REACH, "map": "Forge World"},
    210: {"game": Game.HALO_REACH, "map": "Beachhead"},
    211: {"game": Game.HALO_REACH, "map": "Corvette"},
    212: {"game": Game.HALO_REACH, "map": "Courtyard"},
    213: {"game": Game.HALO_REACH, "map": "Glacier"},
    214: {"game": Game.HALO_REACH, "map": "Holdout"},
    215: {"game": Game.HALO_REACH, "map": "Outpost"},
    216: {"game": Game.HALO_REACH, "map": "Overlook"},
    217: {"game": Game.HALO_REACH, "map": "Waterfront"},
    218: {"game": Game.HALO_REACH, "map": "Unearthed"},
    219: {"game": Game.HALO_REACH, "map": "Installation 04"},
    220: {"game": Game.HALO_3, "map": "S3D Waterfall"},
    221: {"game": Game.HALO_3, "map": "S3D Edge"},
}
