"use strict";
/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.isArn = void 0;
/**
 * Check whether the given string matches the SecretsManager ARN format.
 * arn:aws:secretsmanager:<Region>:<AccountId>:secret:OptionalPath/SecretName-6RandomCharacters
 * Reference:
 *   https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_iam-permissions.html#iam-resources
 * @param value
 */
function isArn(value) {
    return value.match(/arn:aws(?:-us-gov|-cn)?:secretsmanager:[-a-z0-9]*:[0-9]*:secret:.+/)?.length === 1;
}
exports.isArn = isArn;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidmFsaWRhdGlvbi5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInZhbGlkYXRpb24udHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IjtBQUFBOzs7R0FHRzs7O0FBRUg7Ozs7OztHQU1HO0FBQ0gsU0FBZ0IsS0FBSyxDQUFDLEtBQWE7SUFDakMsT0FBTyxLQUFLLENBQUMsS0FBSyxDQUFDLG9FQUFvRSxDQUFDLEVBQUUsTUFBTSxLQUFLLENBQUMsQ0FBQztBQUN6RyxDQUFDO0FBRkQsc0JBRUMiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqIENvcHlyaWdodCBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuICogU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiAqL1xuXG4vKipcbiAqIENoZWNrIHdoZXRoZXIgdGhlIGdpdmVuIHN0cmluZyBtYXRjaGVzIHRoZSBTZWNyZXRzTWFuYWdlciBBUk4gZm9ybWF0LlxuICogYXJuOmF3czpzZWNyZXRzbWFuYWdlcjo8UmVnaW9uPjo8QWNjb3VudElkPjpzZWNyZXQ6T3B0aW9uYWxQYXRoL1NlY3JldE5hbWUtNlJhbmRvbUNoYXJhY3RlcnNcbiAqIFJlZmVyZW5jZTpcbiAqICAgaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3NlY3JldHNtYW5hZ2VyL2xhdGVzdC91c2VyZ3VpZGUvcmVmZXJlbmNlX2lhbS1wZXJtaXNzaW9ucy5odG1sI2lhbS1yZXNvdXJjZXNcbiAqIEBwYXJhbSB2YWx1ZVxuICovXG5leHBvcnQgZnVuY3Rpb24gaXNBcm4odmFsdWU6IHN0cmluZyk6IGJvb2xlYW4ge1xuICByZXR1cm4gdmFsdWUubWF0Y2goL2Fybjphd3MoPzotdXMtZ292fC1jbik/OnNlY3JldHNtYW5hZ2VyOlstYS16MC05XSo6WzAtOV0qOnNlY3JldDouKy8pPy5sZW5ndGggPT09IDE7XG59XG4iXX0=