"use strict";
/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.readCertificateData = void 0;
const secret_1 = require("./secret");
/**
 * Retrieve certificate data from the Secret with the given ARN.
 * @param arn ARN of the Secret containing the certificate
 * @param client An instance of the SecretsManager class
 */
async function readCertificateData(arn, client) {
    const data = await secret_1.Secret.fromArn(arn, client).getValue();
    if (Buffer.isBuffer(data) || !/BEGIN CERTIFICATE/.test(data)) {
        throw new Error(`Certificate Secret (${arn}) must contain a Certificate in PEM format.`);
    }
    return data;
}
exports.readCertificateData = readCertificateData;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicmVhZC1jZXJ0aWZpY2F0ZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInJlYWQtY2VydGlmaWNhdGUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IjtBQUFBOzs7R0FHRzs7O0FBSUgscUNBQWtDO0FBRWxDOzs7O0dBSUc7QUFDSSxLQUFLLFVBQVUsbUJBQW1CLENBQUMsR0FBVyxFQUFFLE1BQXNCO0lBQzNFLE1BQU0sSUFBSSxHQUFHLE1BQU0sZUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLEVBQUUsTUFBTSxDQUFDLENBQUMsUUFBUSxFQUFFLENBQUM7SUFDMUQsSUFBSSxNQUFNLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsbUJBQW1CLENBQUMsSUFBSSxDQUFDLElBQWMsQ0FBQyxFQUFFO1FBQ3RFLE1BQU0sSUFBSSxLQUFLLENBQUMsdUJBQXVCLEdBQUcsNkNBQTZDLENBQUMsQ0FBQztLQUMxRjtJQUNELE9BQU8sSUFBYyxDQUFDO0FBQ3hCLENBQUM7QUFORCxrREFNQyIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogQ29weXJpZ2h0IEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG4gKiBTUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuICovXG5cbi8vIGVzbGludC1kaXNhYmxlLW5leHQtbGluZSBpbXBvcnQvbm8tZXh0cmFuZW91cy1kZXBlbmRlbmNpZXNcbmltcG9ydCB7IFNlY3JldHNNYW5hZ2VyIH0gZnJvbSAnYXdzLXNkayc7XG5pbXBvcnQgeyBTZWNyZXQgfSBmcm9tICcuL3NlY3JldCc7XG5cbi8qKlxuICogUmV0cmlldmUgY2VydGlmaWNhdGUgZGF0YSBmcm9tIHRoZSBTZWNyZXQgd2l0aCB0aGUgZ2l2ZW4gQVJOLlxuICogQHBhcmFtIGFybiBBUk4gb2YgdGhlIFNlY3JldCBjb250YWluaW5nIHRoZSBjZXJ0aWZpY2F0ZVxuICogQHBhcmFtIGNsaWVudCBBbiBpbnN0YW5jZSBvZiB0aGUgU2VjcmV0c01hbmFnZXIgY2xhc3NcbiAqL1xuZXhwb3J0IGFzeW5jIGZ1bmN0aW9uIHJlYWRDZXJ0aWZpY2F0ZURhdGEoYXJuOiBzdHJpbmcsIGNsaWVudDogU2VjcmV0c01hbmFnZXIpOiBQcm9taXNlPHN0cmluZz4ge1xuICBjb25zdCBkYXRhID0gYXdhaXQgU2VjcmV0LmZyb21Bcm4oYXJuLCBjbGllbnQpLmdldFZhbHVlKCk7XG4gIGlmIChCdWZmZXIuaXNCdWZmZXIoZGF0YSkgfHwgIS9CRUdJTiBDRVJUSUZJQ0FURS8udGVzdChkYXRhIGFzIHN0cmluZykpIHtcbiAgICB0aHJvdyBuZXcgRXJyb3IoYENlcnRpZmljYXRlIFNlY3JldCAoJHthcm59KSBtdXN0IGNvbnRhaW4gYSBDZXJ0aWZpY2F0ZSBpbiBQRU0gZm9ybWF0LmApO1xuICB9XG4gIHJldHVybiBkYXRhIGFzIHN0cmluZztcbn1cbiJdfQ==