"use strict";
/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.isArn = void 0;
/**
 * Check whether the given string matches the KMS ARN format.
 * arn:aws:kms:<Region>?:<AccountId>?:key/<UUID>
 * Reference:
 *   https://docs.aws.amazon.com/kms/latest/developerguide/find-cmk-id-arn.html#find-cmk-arn-api
 */
function isArn(value) {
    return value.match(/arn:aws(?:-us-gov|-cn)?:kms:[-a-z0-9]*:[0-9]*:key\/[-a-f0-9]+/)?.length === 1;
}
exports.isArn = isArn;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidmFsaWRhdGlvbi5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInZhbGlkYXRpb24udHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IjtBQUFBOzs7R0FHRzs7O0FBRUg7Ozs7O0dBS0c7QUFDSCxTQUFnQixLQUFLLENBQUMsS0FBYTtJQUNqQyxPQUFPLEtBQUssQ0FBQyxLQUFLLENBQUMsK0RBQStELENBQUMsRUFBRSxNQUFNLEtBQUssQ0FBQyxDQUFDO0FBQ3BHLENBQUM7QUFGRCxzQkFFQyIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogQ29weXJpZ2h0IEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG4gKiBTUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuICovXG5cbi8qKlxuICogQ2hlY2sgd2hldGhlciB0aGUgZ2l2ZW4gc3RyaW5nIG1hdGNoZXMgdGhlIEtNUyBBUk4gZm9ybWF0LlxuICogYXJuOmF3czprbXM6PFJlZ2lvbj4/OjxBY2NvdW50SWQ+PzprZXkvPFVVSUQ+XG4gKiBSZWZlcmVuY2U6XG4gKiAgIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9rbXMvbGF0ZXN0L2RldmVsb3Blcmd1aWRlL2ZpbmQtY21rLWlkLWFybi5odG1sI2ZpbmQtY21rLWFybi1hcGlcbiAqL1xuZXhwb3J0IGZ1bmN0aW9uIGlzQXJuKHZhbHVlOiBzdHJpbmcpOiBib29sZWFuIHtcbiAgcmV0dXJuIHZhbHVlLm1hdGNoKC9hcm46YXdzKD86LXVzLWdvdnwtY24pPzprbXM6Wy1hLXowLTldKjpbMC05XSo6a2V5XFwvWy1hLWYwLTldKy8pPy5sZW5ndGggPT09IDE7XG59XG4iXX0=