/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
import { LambdaContext } from '../lib/aws-lambda';
import { CfnRequestEvent, SimpleCustomResource } from '../lib/custom-resource';
import { ThinkboxEcrProvider } from '../lib/ecr-provider';
/**
 * The input to this Custom Resource
 */
export interface ThinkboxEcrProviderResourceProperties {
    /**
     * A random string that forces the Lambda to run again and obtain the latest ECR.
     */
    readonly ForceRun?: string;
}
/**
 * Output of this Custom Resource.
 */
export interface ThinkboxEcrProviderResourceOutput {
    /**
     * The URI prefix of the ECR repositories containing Deadline container images published by AWS Thinkbox. This can be
     * suffixed with the recipe name to get a Deadline image's complete ECR repository URI.
     */
    readonly EcrURIPrefix: string;
}
/**
 * This custom resource will parse and return the base ECR ARN or URI containing Thinkbox published Docker Images.
 * A global ECR base URI is returned.
 */
export declare class ThinkboxEcrProviderResource extends SimpleCustomResource {
    readonly ecrProvider: ThinkboxEcrProvider;
    constructor();
    /**
     * @inheritdoc
     */
    validateInput(data: object): boolean;
    /**
     * @inheritdoc
     */
    doCreate(_physicalId: string, _resourceProperties: ThinkboxEcrProviderResourceProperties): Promise<ThinkboxEcrProviderResourceOutput>;
    /**
     * @inheritdoc
     */
    doDelete(_physicalId: string, _resourceProperties: ThinkboxEcrProviderResourceProperties): Promise<void>;
    private isEcrProviderResourceProperties;
}
/**
 * The handler used to provide the installer links for the requested version
 */
export declare function handler(event: CfnRequestEvent, context: LambdaContext): Promise<string>;
