/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
import { IPatchVersion } from './version-ref';
/**
  * This class is reposonsible to do basic operations on version format.
  */
export declare class Version implements IPatchVersion {
    /**
     * This variable holds the value for minimum supported deadline version.
     */
    static readonly MINIMUM_SUPPORTED_DEADLINE_VERSION: Version;
    /**
     * The minimum Deadline version required to enable Deadline Secrets Management.
     */
    static readonly MINIMUM_SECRETS_MANAGEMENT_VERSION: Version;
    /**
     * This method parses the input string and returns the version object.
     *
     * @param version version string to parse
     */
    static parse(version: string): Version;
    /**
     * This method validates the given string for a sequence '.' separated numbers.
     *
     * @param version the string to be validated.
     *
     * @returns true if the format is correct, else false.
     */
    private static validateVersionFormat;
    /**
     * Numeric components of version.
     */
    private readonly components;
    /**
     * @inheritdoc
     */
    get majorVersion(): number;
    /**
     * @inheritdoc
     */
    get minorVersion(): number;
    /**
     * @inheritdoc
     */
    get releaseVersion(): number;
    /**
     * @inheritdoc
     */
    get patchVersion(): number;
    constructor(components: number[]);
    /**
     * This method compares two version strings
     *
     * @param version
     *
     * @returns true if this version is greater than the provided version;
     * false if this version is less than or equal to the provided verison.
     */
    isGreaterThan(version: Version): boolean;
    /**
     * This method compares two version strings
     *
     * @param version
     *
     * @returns true if this version is less than the provided version;
     * false if this version is greater than or equal to the provided verison.
     */
    isLessThan(version: Version): boolean;
    /**
     * This method compares two version strings
     *
     * @param version
     *
     * @returns true if this version is equal to the provided version;
     * false otherwise.
     */
    isEqual(version: Version): boolean;
    /**
     * The method returns the version components in dot separated string format.
     */
    toString(): string;
    /**
     * @inheritdoc
     */
    get versionString(): string;
    /**
     * This method compares 2 versions.
     *
     * @param version version to compare
     *
     * @returns negative value if this version is less than the provided version;
     * 0 if both the versions are equal;
     * positive value if this version is greater than the provided verison.
     */
    private compare;
}
