"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ThinkboxDockerRecipes = exports.ThinkboxManagedDeadlineDockerRecipes = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_ecs_1 = require("@aws-cdk/aws-ecs");
const aws_s3_assets_1 = require("@aws-cdk/aws-s3-assets");
const core_1 = require("@aws-cdk/core");
const _1 = require(".");
/**
 * An enum that is associated with AWS Thinkbox managed recipes that are available in the stage manifest.
 */
var ThinkboxManagedDeadlineDockerRecipes;
(function (ThinkboxManagedDeadlineDockerRecipes) {
    /**
     * The Docker Image Asset for the Remote Connection Server.
     */
    ThinkboxManagedDeadlineDockerRecipes["REMOTE_CONNECTION_SERVER"] = "rcs";
    /**
     * The Docker Image Asset for the License Forwarder.
     */
    ThinkboxManagedDeadlineDockerRecipes["LICENSE_FORWARDER"] = "license-forwarder";
})(ThinkboxManagedDeadlineDockerRecipes = exports.ThinkboxManagedDeadlineDockerRecipes || (exports.ThinkboxManagedDeadlineDockerRecipes = {}));
/**
 * An API for interacting with staged Deadline Docker recipes provided by AWS Thinkbox.
 *
 * This provides container images as required by RFDK's Deadline constructs such as
 *
 * * {@link @aws-rfdk/deadline#RenderQueue}
 * * {@link @aws-rfdk/deadline#UsageBasedLicensing}
 *
 * @example Construct a RenderQueue
 *
 * import { App, Stack, Vpc } from '@aws-rfdk/core';
 * import { RenderQueue, Repository, ThinkboxDockerRecipes } from '@aws-rfdk/deadline';
 * const app = new App();
 * const stack = new Stack(app, 'Stack');
 * const vpc = new Vpc(app, stack);
 * const recipes = new ThinkboxDockerRecipes(stack, 'Recipes', {
 *   path: '/path/to/staged/recipes'
 * });
 * const repository = new Repository(stack, 'Repository', {
 *   vpc,
 *   version: recipes.version
 * });
 *
 * const renderQueue = new RenderQueue(stack, 'RenderQueue', {
 *   images: recipes.renderQueueImages,
 *   // ...
 * });
 */
class ThinkboxDockerRecipes extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.stage = props.stage;
        for (const recipe of [ThinkboxManagedDeadlineDockerRecipes.REMOTE_CONNECTION_SERVER, ThinkboxManagedDeadlineDockerRecipes.LICENSE_FORWARDER]) {
            if (!props.stage.manifest.recipes[recipe]) {
                throw new Error(`Could not find ${recipe} recipe`);
            }
        }
        this.remoteConnectionServer = props.stage.imageFromRecipe(this, 'RemoteConnectionServer', ThinkboxManagedDeadlineDockerRecipes.REMOTE_CONNECTION_SERVER.toString());
        this.licenseForwarder = props.stage.imageFromRecipe(this, 'LicenseForwarder', ThinkboxManagedDeadlineDockerRecipes.LICENSE_FORWARDER.toString());
        this.renderQueueImages = {
            remoteConnectionServer: aws_ecs_1.ContainerImage.fromDockerImageAsset(this.remoteConnectionServer),
        };
        this.ublImages = {
            licenseForwarder: aws_ecs_1.ContainerImage.fromDockerImageAsset(this.licenseForwarder),
        };
    }
    get version() {
        if (!this.versionInstance) {
            const version = _1.Version.parse(this.stage.manifest.version);
            const self = this;
            this.versionInstance = {
                isLessThan: (other) => version.isLessThan(other),
                linuxFullVersionString: () => this.stage.manifest.version,
                linuxInstallers: {
                    get client() {
                        let assetNode = self.node.tryFindChild('ClientInstallerAsset');
                        let asset;
                        /* istanbul ignore else */
                        if (!assetNode) {
                            asset = new aws_s3_assets_1.Asset(self, 'ClientInstallerAsset', {
                                path: self.stage.clientInstallerPath,
                            });
                        }
                        else if (assetNode instanceof aws_s3_assets_1.Asset) {
                            asset = assetNode;
                        }
                        else {
                            throw new Error(`Node "${assetNode?.node.path}" is not an S3 Asset`);
                        }
                        return {
                            objectKey: asset.s3ObjectKey,
                            s3Bucket: asset.bucket,
                        };
                    },
                    repository: this.stage.getVersion(this, 'VersionQuery').linuxInstallers.repository,
                    patchVersion: version.patchVersion,
                },
                majorVersion: version.majorVersion,
                minorVersion: version.minorVersion,
                releaseVersion: version.releaseVersion,
                versionString: version.versionString,
            };
        }
        return this.versionInstance;
    }
}
exports.ThinkboxDockerRecipes = ThinkboxDockerRecipes;
_a = JSII_RTTI_SYMBOL_1;
ThinkboxDockerRecipes[_a] = { fqn: "aws-rfdk.deadline.ThinkboxDockerRecipes", version: "0.42.0" };
//# sourceMappingURL=data:application/json;base64,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