"use strict";
/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.SpotFleetRequestType = exports.SpotFleetResourceType = exports.SpotFleetAllocationStrategy = void 0;
/**
 * The allocation strategy for the Spot Instances in your Spot Fleet
 * determines how it fulfills your Spot Fleet request from the possible
 * Spot Instance pools represented by its launch specifications.
 * See https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-configuration-strategies.html#ec2-fleet-allocation-strategy
 */
var SpotFleetAllocationStrategy;
(function (SpotFleetAllocationStrategy) {
    /**
     * Spot Fleet launches instances from the Spot Instance pools with the lowest price.
     */
    SpotFleetAllocationStrategy["LOWEST_PRICE"] = "lowestPrice";
    /**
     * Spot Fleet launches instances from all the Spot Instance pools that you specify.
     */
    SpotFleetAllocationStrategy["DIVERSIFIED"] = "diversified";
    /**
     * Spot Fleet launches instances from Spot Instance pools with optimal capacity for the number of instances that are launching.
     */
    SpotFleetAllocationStrategy["CAPACITY_OPTIMIZED"] = "capacityOptimized";
})(SpotFleetAllocationStrategy = exports.SpotFleetAllocationStrategy || (exports.SpotFleetAllocationStrategy = {}));
/**
 * Resource types that presently support tag on create.
 */
var SpotFleetResourceType;
(function (SpotFleetResourceType) {
    /**
     * EC2 Instances.
     */
    SpotFleetResourceType["INSTANCE"] = "instance";
    /**
     * Spot fleet requests.
     */
    SpotFleetResourceType["SPOT_FLEET_REQUEST"] = "spot-fleet-request";
})(SpotFleetResourceType = exports.SpotFleetResourceType || (exports.SpotFleetResourceType = {}));
/**
 * The type of request. Indicates whether the Spot Fleet only requests the target capacity or also attempts to maintain it.
 * Only 'maintain' is currently supported.
 */
var SpotFleetRequestType;
(function (SpotFleetRequestType) {
    /**
     * The Spot Fleet maintains the target capacity.
     * The Spot Fleet places the required requests to meet capacity and automatically replenishes any interrupted instances.
     */
    SpotFleetRequestType["MAINTAIN"] = "maintain";
})(SpotFleetRequestType = exports.SpotFleetRequestType || (exports.SpotFleetRequestType = {}));
//# sourceMappingURL=data:application/json;base64,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