"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SessionManagerHelper = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
const aws_iam_1 = require("@aws-cdk/aws-iam");
/**
 * This is a helper class meant to make it easier to use the AWS Systems Manager Session Manager
 * with any EC2 Instances or AutoScalingGroups. Once enabled, the Session Manager can be used to
 * connect to an EC2 Instance through the AWS Console and open a shell session in the browser.
 *
 * Note that in order for the Session Manager to work, you will need an AMI that has the SSM-Agent
 * installed and set to run at startup. The Amazon Linux 2 and Amazon provided Windows Server AMI's
 * have this configured by default.
 *
 * More details about the AWS Systems Manager Session Manager can be found here:
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/session-manager.html
 */
class SessionManagerHelper {
    /**
     * Grants the permissions required to enable Session Manager for the provided IGrantable.
     */
    static grantPermissionsTo(grantable) {
        grantable.grantPrincipal.addToPrincipalPolicy(new aws_iam_1.PolicyStatement({
            actions: [
                'ssmmessages:CreateControlChannel',
                'ssmmessages:CreateDataChannel',
                'ssmmessages:OpenControlChannel',
                'ssmmessages:OpenDataChannel',
                'ssm:UpdateInstanceInformation',
            ],
            resources: ['*'],
        }));
    }
}
exports.SessionManagerHelper = SessionManagerHelper;
_a = JSII_RTTI_SYMBOL_1;
SessionManagerHelper[_a] = { fqn: "aws-rfdk.SessionManagerHelper", version: "0.42.0" };
//# sourceMappingURL=data:application/json;base64,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