"use strict";
/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.MountPermissions = void 0;
/**
 * Permission mode under which the filesystem is mounted.
 */
var MountPermissions;
(function (MountPermissions) {
    /**
     * Mount the filesystem as read-only.
     */
    MountPermissions["READONLY"] = "readonly";
    /**
     * Mount the filesystem as read-write.
     */
    MountPermissions["READWRITE"] = "readwrite";
})(MountPermissions = exports.MountPermissions || (exports.MountPermissions = {}));
//# sourceMappingURL=data:application/json;base64,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