"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudWatchConfigBuilder = exports.TimeZone = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
const core_1 = require("@aws-cdk/core");
/**
 * Enum to describe the time zone property
 */
var TimeZone;
(function (TimeZone) {
    /**
     * The Local time zone
     */
    TimeZone["LOCAL"] = "Local";
    /**
     * The UTC time zone
     */
    TimeZone["UTC"] = "UTC";
})(TimeZone = exports.TimeZone || (exports.TimeZone = {}));
/**
 * Class that can build a CloudWatch Agent configuration.
 */
class CloudWatchConfigBuilder {
    /**
     * Constructs
     */
    constructor(logFlushInterval = CloudWatchConfigBuilder.DEFAULT_FLUSH_INTERVAL) {
        this.cloudWatchFileList = [];
        this.logFlushInterval = logFlushInterval;
    }
    /**
     * This method adds the log file path and its associated log group and log stream properties to the list
     * of files which needs to be streamed to cloud watch logs.
     *
     * @param logGroupName - string for the log group name
     * @param logStreamPrefix - string for the log stream prefix. The actual stream name will be appended by instance id
     * @param logFilePath - local file path which needs to be streamed
     * @param timeZone -  the time zone to use when putting timestamps on log events
     */
    addLogsCollectList(logGroupName, logStreamPrefix, logFilePath, timeZone = CloudWatchConfigBuilder.DEFAULT_LOG_TIMEZONE) {
        this.cloudWatchFileList.push({
            log_group_name: logGroupName,
            log_stream_name: logStreamPrefix + '-' + CloudWatchConfigBuilder.CLOUDWATCH_CONFIG_INSTANCE_ID_VARIABLE,
            file_path: logFilePath,
            timezone: timeZone,
        });
    }
    /**
     * The method generates the configuration for log file streaming to be added
     * to CloudWatch Agent Configuration File.
     */
    generateCloudWatchConfiguration() {
        const cloudWatchConfig = {
            logs: {
                logs_collected: {
                    files: {
                        collect_list: this.cloudWatchFileList,
                    },
                },
                log_stream_name: CloudWatchConfigBuilder.DEFAULT_STREAM_NAME
                    + '-'
                    + CloudWatchConfigBuilder.CLOUDWATCH_CONFIG_INSTANCE_ID_VARIABLE,
                force_flush_interval: this.logFlushInterval.toSeconds(),
            },
        };
        return JSON.stringify(cloudWatchConfig);
    }
}
exports.CloudWatchConfigBuilder = CloudWatchConfigBuilder;
_a = JSII_RTTI_SYMBOL_1;
CloudWatchConfigBuilder[_a] = { fqn: "aws-rfdk.CloudWatchConfigBuilder", version: "0.42.0" };
CloudWatchConfigBuilder.DEFAULT_STREAM_NAME = 'DefaultLogStream';
CloudWatchConfigBuilder.DEFAULT_FLUSH_INTERVAL = core_1.Duration.seconds(60);
CloudWatchConfigBuilder.DEFAULT_LOG_TIMEZONE = TimeZone.LOCAL;
CloudWatchConfigBuilder.CLOUDWATCH_CONFIG_INSTANCE_ID_VARIABLE = '{instance_id}';
//# sourceMappingURL=data:application/json;base64,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