"""
Minimal example showing the use of the AutoCompleteMode.
"""
import logging
logging.basicConfig(level=logging.DEBUG)
import sys

from qtpy import QtWidgets
from pyqodeng.core.api import CodeEdit
from pyqodeng.core.backend import server
from pyqodeng.core.modes import AutoCompleteMode


if __name__ == '__main__':
    app = QtWidgets.QApplication(sys.argv)
    editor = CodeEdit()
    editor.backend.start(server.__file__)
    editor.resize(800, 600)
    print(editor.modes.append(AutoCompleteMode()))
    editor.appendPlainText(
        'Press one of these keys to test auto completion: ", \', (, {, [\n')
    editor.show()
    app.exec_()
    editor.close()
    del editor
    del app
