"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegTesting = void 0;
const _1 = require("./");
const cdk = require("@aws-cdk/core");
const sns = require("@aws-cdk/aws-sns");
class IntegTesting {
    constructor() {
        const app = new cdk.App();
        const envJP = {
            region: 'ap-northeast-1',
            account: process.env.CDK_DEFAULT_ACCOUNT,
        };
        const envUS = {
            region: 'us-west-2',
            account: process.env.CDK_DEFAULT_ACCOUNT,
        };
        // first stack in JP
        const stackJP = new cdk.Stack(app, 'demo-stack-jp', { env: envJP });
        const topic = new sns.Topic(stackJP, 'Topic');
        new cdk.CfnOutput(stackJP, 'TopicName', { value: topic.topicName });
        // second stack in US
        const stackUS = new cdk.Stack(app, 'demo-stack-us', { env: envUS });
        // ensure the dependency
        stackUS.addDependency(stackJP);
        // get the stackJP stack outputs from stackUS
        const outputs = new _1.StackOutputs(stackUS, 'Outputs', { stack: stackJP });
        const remoteOutputValue = outputs.getAttString('TopicName');
        // the value should be exactly the same with the output value of `TopicName`
        new cdk.CfnOutput(stackUS, 'RemoteTopicName', { value: remoteOutputValue });
        this.stack = [stackJP, stackUS];
    }
}
exports.IntegTesting = IntegTesting;
// run the integ testing
new IntegTesting();
//# sourceMappingURL=data:application/json;base64,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