"use strict";
// Copyright (c) wangsijie
// Distributed under the terms of the Modified BSD License.
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const base_1 = require("@jupyter-widgets/base");
const react_1 = __importDefault(require("react"));
const react_dom_1 = __importDefault(require("react-dom"));
const quiz_1 = __importDefault(require("@boyuai/quiz"));
const version_1 = require("./version");
// Import the CSS
require("../css/widget.css");
class QuizModel extends base_1.DOMWidgetModel {
    defaults() {
        return Object.assign(Object.assign({}, super.defaults()), { _model_name: QuizModel.model_name, _model_module: QuizModel.model_module, _model_module_version: QuizModel.model_module_version, _view_name: QuizModel.view_name, _view_module: QuizModel.view_module, _view_module_version: QuizModel.view_module_version, value: [], quizId: '' });
    }
}
exports.QuizModel = QuizModel;
QuizModel.serializers = Object.assign({}, base_1.DOMWidgetModel.serializers);
QuizModel.model_name = 'QuizModel';
QuizModel.model_module = version_1.MODULE_NAME;
QuizModel.model_module_version = version_1.MODULE_VERSION;
QuizModel.view_name = 'QuizView'; // Set to null if no view
QuizModel.view_module = version_1.MODULE_NAME; // Set to null if no view
QuizModel.view_module_version = version_1.MODULE_VERSION;
class QuizView extends base_1.DOMWidgetView {
    render() {
        if (!document.getElementById('katex-css')) {
            const link = document.createElement('link');
            link.id = 'katex-css';
            link.rel = 'stylesheet';
            link.href = 'https://cdn.jsdelivr.net/npm/katex/dist/katex.min.css';
            document.head.appendChild(link);
        }
        this.el.htmlContent = '';
        this.initReact();
    }
    initReact() {
        const value = this.model.get('value');
        const id = this.model.get('quiz_id');
        if (!id) {
            this.el.textContent = 'quizId必须指定';
            return;
        }
        const userValue = window[`__ipyquiz_${id}_value`];
        const _handleSubmit = window[`__ipyquiz_${id}_submit`];
        const handleSubmit = (answers, rightCount) => {
            if (typeof _handleSubmit === 'function') {
                _handleSubmit(answers, rightCount, value);
            }
        };
        react_dom_1.default.render(react_1.default.createElement("div", null,
            react_1.default.createElement(quiz_1.default, { questions: value, values: userValue, onSubmit: handleSubmit })), this.el);
    }
}
exports.QuizView = QuizView;
//# sourceMappingURL=widget.js.map