# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from . import _utilities, _tables

__all__ = ['Organization']


class Organization(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 logo: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 twitter: Optional[pulumi.Input[str]] = None,
                 website: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Provides a resource to manage organization resource in Packet.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_packet as packet

        # Create a new Project
        tf_organization1 = packet.Organization("tfOrganization1",
            description="quux",
            name="foobar")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Description string.
        :param pulumi.Input[str] logo: Logo URL.
        :param pulumi.Input[str] name: The name of the Organization.
        :param pulumi.Input[str] twitter: Twitter handle.
        :param pulumi.Input[str] website: Website link.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['description'] = description
            __props__['logo'] = logo
            if name is None:
                raise TypeError("Missing required property 'name'")
            __props__['name'] = name
            __props__['twitter'] = twitter
            __props__['website'] = website
            __props__['created'] = None
            __props__['updated'] = None
        super(Organization, __self__).__init__(
            'packet:index/organization:Organization',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            logo: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            twitter: Optional[pulumi.Input[str]] = None,
            updated: Optional[pulumi.Input[str]] = None,
            website: Optional[pulumi.Input[str]] = None) -> 'Organization':
        """
        Get an existing Organization resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Description string.
        :param pulumi.Input[str] logo: Logo URL.
        :param pulumi.Input[str] name: The name of the Organization.
        :param pulumi.Input[str] twitter: Twitter handle.
        :param pulumi.Input[str] website: Website link.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["created"] = created
        __props__["description"] = description
        __props__["logo"] = logo
        __props__["name"] = name
        __props__["twitter"] = twitter
        __props__["updated"] = updated
        __props__["website"] = website
        return Organization(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def created(self) -> pulumi.Output[str]:
        return pulumi.get(self, "created")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description string.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def logo(self) -> pulumi.Output[Optional[str]]:
        """
        Logo URL.
        """
        return pulumi.get(self, "logo")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the Organization.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def twitter(self) -> pulumi.Output[Optional[str]]:
        """
        Twitter handle.
        """
        return pulumi.get(self, "twitter")

    @property
    @pulumi.getter
    def updated(self) -> pulumi.Output[str]:
        return pulumi.get(self, "updated")

    @property
    @pulumi.getter
    def website(self) -> pulumi.Output[Optional[str]]:
        """
        Website link.
        """
        return pulumi.get(self, "website")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

