from enum import Enum
from select import POLLIN, POLLPRI, POLLOUT, POLLERR, POLLHUP, POLLRDHUP, POLLNVAL


class HttpMethods(Enum):
    GET = "GET"
    POST = "POST"
    PUT = "PUT"
    PATCH = "PATCH"
    DELETE = "DELETE"
    HEAD = "HEAD"
    OPTIONS = "OPTIONS"
    TRACE = "TRACE"


class PollMaskGroups:
    READ_SIMPLE = [POLLIN]

    READ_COMPLEX = [POLLIN | POLLPRI]

    READ_WRITES = [POLLIN | POLLOUT, POLLIN | POLLPRI | POLLOUT]

    ALL_READS = READ_SIMPLE + READ_COMPLEX + READ_WRITES

    WRITE_SIMPLE = [POLLOUT]

    READ_WRITE_SIMPLE = READ_SIMPLE + WRITE_SIMPLE

    ERROR = [POLLERR]

    HANGUPS = [POLLHUP, POLLRDHUP, POLLHUP | POLLRDHUP]

    INVAL = [POLLNVAL]

    BADS = ERROR + HANGUPS + INVAL


default_ssl_cert = """-----BEGIN CERTIFICATE-----
MIIFkzCCA3ugAwIBAgIUJQ20JuBcaJ+LC5VSmeSusm5GDFUwDQYJKoZIhvcNAQEL
BQAwWTELMAkGA1UEBhMCQVUxEzARBgNVBAgMClNvbWUtU3RhdGUxITAfBgNVBAoM
GEludGVybmV0IFdpZGdpdHMgUHR5IEx0ZDESMBAGA1UEAwwJbG9jYWxob3N0MB4X
DTE4MTAxMzAwNDgzMloXDTE5MTAxMzAwNDgzMlowWTELMAkGA1UEBhMCQVUxEzAR
BgNVBAgMClNvbWUtU3RhdGUxITAfBgNVBAoMGEludGVybmV0IFdpZGdpdHMgUHR5
IEx0ZDESMBAGA1UEAwwJbG9jYWxob3N0MIICIjANBgkqhkiG9w0BAQEFAAOCAg8A
MIICCgKCAgEAw6IN4BV5/O2TC9444O1ecOb1FVD+Y52u/PHmUYCW7Rybo3vHzPGU
qLUQwFBP2xkNYiU+k/3A9AgxRkt5fJbtNEuiNnuzISpWKGtECX5Us87O+Bb/+N9E
IrKpj7/fuJ1YDIaw0Uxkig+5tjmrPUcz+z959phAuHcMkPfRx0wBSO1dlk5ZtcwU
C80X2P1FLy0/BPntIG1Ho2HunujoK7ZRf369IS7EcrW/kbsdzMoS9H7E8IUGX1Qd
JBHqet0MvAv89Yt4pWMXpFdMnxx4om6/5jyVvoxl8bMRwjJfk72sE3a1UjMcUKmd
GbcqCgsWcKbq7MrK7Fc41wuQpaHb7teBXPPeEaogIif68lJ7tDuU4eHfaocsg30O
ITcFovsqprKUtGMT3kLNMNZ9oSMrN9Oq+4023NQBmXxC5DMHbcRy03konuLllmhB
NPlpkUmXuc32rzwgn4o0edg9cSd3mp6Q49u8KRp9KmvbQxZ0QhaCz2z0sOVXOqOB
ccuEJ7KBh7TacgL3I9k5wqnbQQLW1ekOOM6lkPQO9Nbu5VGi5FwFdwgFX5WzmpFG
EbGKyqCOyi8JeAYysX3g5XPX4alnLsFGkjSRV2L9QGYTKnz1Izf35UM6ulw+tZ5z
QJf1jrFCMeyC+Yw7CJQLUJsvKbI+GpmQNLbPC5vS0mgH1mM3TekfSdcCAwEAAaNT
MFEwHQYDVR0OBBYEFAAbiamJ0zEQdy/c+Kh+P71T17/DMB8GA1UdIwQYMBaAFAAb
iamJ0zEQdy/c+Kh+P71T17/DMA8GA1UdEwEB/wQFMAMBAf8wDQYJKoZIhvcNAQEL
BQADggIBAGJ46U97HVaPvlAKQEC83rnzfrqiT050ZsySgmAWZVMHTgBnbVe5jGKG
EGKGc+bi6TxexTmHi1jpTlyCSJNLvJWfQb/KPm+5ma4z5cC07Okkajgmkn/U8UFd
HFAarkt3m+GYjIo5Aw63vcOTJ2IhPPlWIr5F/wNfRn9M5mVo3Q5uFz6ZCVNsm0Z9
ntbAfQMoV+kZ2sivsoO/DVwjCj465oECzMpELCdKL+yO11jgwjbJE9qaouOyD84a
BtapJrb0I1wqtk3RhdBuYnALhbb8km62cVR/csr8s7wZDXx10wBlGlEbhTjd59SU
IzjckZwoeGK0ZGFx45E3QMocCc7/xuQxX7DmbcjpiTwkJIGF/bXTKc06O/tr3/bn
i6oKKLIf0nv21yLMekWxc2pdZrtHxsGWgIkrX2Tl9JlyPwwljUbFrJD1av1u+S5D
akr6kTeCA1/bGoupz1AkWUVK+HSMECdoFlr6qYgvPR+cp2ySOkybRQel49TOI2Ms
j4L/tKhLjVr3sCoHFMXqkyzAZHiFkyB+l19ZxibhiXH/XuD0qmmHl1no9nSNqHJ/
vqtZg33+ZOSIDv3/DNceue0/XPrNhY5wZS+RJfPxsEbc2YaWlqgMq/FFvOAgQF2q
e213og3k2vLbHNPoMvKoZzuI9Ik8cEgBLIE3tB6y1nFqrp8SMoLG
-----END CERTIFICATE-----"""
