"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Rule = exports.RuleProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const iot_generated_1 = require("./iot.generated");
Object.defineProperty(exports, "RuleProperty", { enumerable: true, get: function () { return iot_generated_1.RosRule; } });
/**
 * A ROS resource type:  `ALIYUN::IOT::Rule`
 */
class Rule extends ros.Resource {
    /**
     * Create a new `ALIYUN::IOT::Rule`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosRule = new iot_generated_1.RosRule(this, id, {
            topicType: props.topicType,
            iotInstanceId: props.iotInstanceId,
            resourceGroupId: props.resourceGroupId,
            shortTopic: props.shortTopic,
            select: props.select,
            dataType: props.dataType,
            ruleDesc: props.ruleDesc,
            where: props.where,
            productKey: props.productKey,
            name: props.name,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosRule;
        this.attrDataType = rosRule.attrDataType;
        this.attrIotInstanceId = rosRule.attrIotInstanceId;
        this.attrName = rosRule.attrName;
        this.attrProductKey = rosRule.attrProductKey;
        this.attrResourceGroupId = rosRule.attrResourceGroupId;
        this.attrRuleDesc = rosRule.attrRuleDesc;
        this.attrRuleId = rosRule.attrRuleId;
        this.attrSelect = rosRule.attrSelect;
        this.attrShortTopic = rosRule.attrShortTopic;
        this.attrTopicType = rosRule.attrTopicType;
        this.attrWhere = rosRule.attrWhere;
    }
}
exports.Rule = Rule;
//# sourceMappingURL=data:application/json;base64,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