"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProductTopic = exports.ProductTopicProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const iot_generated_1 = require("./iot.generated");
Object.defineProperty(exports, "ProductTopicProperty", { enumerable: true, get: function () { return iot_generated_1.RosProductTopic; } });
/**
 * A ROS resource type:  `ALIYUN::IOT::ProductTopic`
 */
class ProductTopic extends ros.Resource {
    /**
     * Create a new `ALIYUN::IOT::ProductTopic`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosProductTopic = new iot_generated_1.RosProductTopic(this, id, {
            desc: props.desc,
            iotInstanceId: props.iotInstanceId,
            topicShortName: props.topicShortName,
            operation: props.operation,
            productKey: props.productKey,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosProductTopic;
        this.attrTopicId = rosProductTopic.attrTopicId;
    }
}
exports.ProductTopic = ProductTopic;
//# sourceMappingURL=data:application/json;base64,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