"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Product = exports.ProductProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const iot_generated_1 = require("./iot.generated");
Object.defineProperty(exports, "ProductProperty", { enumerable: true, get: function () { return iot_generated_1.RosProduct; } });
/**
 * A ROS resource type:  `ALIYUN::IOT::Product`
 */
class Product extends ros.Resource {
    /**
     * Create a new `ALIYUN::IOT::Product`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosProduct = new iot_generated_1.RosProduct(this, id, {
            publishAuto: props.publishAuto,
            description: props.description,
            iotInstanceId: props.iotInstanceId,
            productName: props.productName,
            resourceGroupId: props.resourceGroupId,
            aliyunCommodityCode: props.aliyunCommodityCode,
            categoryKey: props.categoryKey,
            protocolType: props.protocolType,
            id2: props.id2,
            nodeType: props.nodeType,
            dataFormat: props.dataFormat,
            authType: props.authType,
            joinPermissionId: props.joinPermissionId,
            netType: props.netType,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosProduct;
        this.attrIotInstanceId = rosProduct.attrIotInstanceId;
        this.attrProductKey = rosProduct.attrProductKey;
    }
}
exports.Product = Product;
//# sourceMappingURL=data:application/json;base64,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